<?php
$pageTitle = "Admin Dashboard";
include 'header.php';
require 'config.php';

// Check if admin is logged in
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header("Location: login.php");
    exit();
}

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Retrieve dynamic counts from the database

// Count total blogs from the "blogs" table
$query_blogs = $conn->query("SELECT COUNT(*) as total FROM blogs");
$row_blogs = $query_blogs->fetch(PDO::FETCH_ASSOC);
$total_blogs = $row_blogs['total'];

// Count total users from the "users" table
$query_users = $conn->query("SELECT COUNT(*) as total FROM users");
$row_users = $query_users->fetch(PDO::FETCH_ASSOC);
$total_users = $row_users['total'];

// Count total deposits from the "crypto_withdrawal" table (successful transactions)
$query_deposits = $conn->query("SELECT COUNT(*) as total FROM crypto_withdrawal");
$row_deposits = $query_deposits->fetch(PDO::FETCH_ASSOC);
$total_deposits = $row_deposits['total'];

// Count total payments from the "payments" table (payments received)
$query_payments = $conn->query("SELECT COUNT(*) as total FROM payments");
$row_payments = $query_payments->fetch(PDO::FETCH_ASSOC);
$total_payments = $row_payments['total'];
?>

<style>
    body {
        font-family: Arial, sans-serif;
        background-color: #f5f5f5;
        margin: 0;
        padding: 20px;
        line-height: 1.6;
        color: #333;
    }
    
    .container {
        max-width: 1200px;
        margin: 0 auto;
        background: white;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 0 20px rgba(0,0,0,0.1);
    }
    
    h1, h2 {
        color: #2c3e50;
        margin-bottom: 20px;
    }
    
    h1 {
        text-align: center;
        font-size: 2.5em;
        margin-bottom: 30px;
        border-bottom: 3px solid #3498db;
        padding-bottom: 10px;
    }
    
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 20px;
        margin-bottom: 40px;
    }
    
    .stat-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 25px;
        border-radius: 10px;
        text-align: center;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        transform: translateY(0);
        transition: transform 0.3s ease;
    }
    
    .stat-card:hover {
        transform: translateY(-5px);
    }
    
    .stat-card h3 {
        margin: 0 0 10px 0;
        font-size: 1.2em;
        opacity: 0.9;
    }
    
    .stat-card .number {
        font-size: 2.5em;
        font-weight: bold;
        margin: 0;
    }
    
    .form-section {
        background: #f8f9fa;
        padding: 30px;
        border-radius: 10px;
        margin-bottom: 40px;
        border-left: 5px solid #3498db;
    }
    
    .form-group {
        margin-bottom: 20px;
    }
    
    label {
        display: block;
        margin-bottom: 8px;
        font-weight: bold;
        color: #2c3e50;
    }
    
    input[type="text"], textarea, input[type="file"] {
        width: 100%;
        padding: 12px;
        border: 2px solid #ddd;
        border-radius: 5px;
        font-size: 16px;
        transition: border-color 0.3s ease;
        box-sizing: border-box;
    }
    
    input[type="text"]:focus, textarea:focus {
        outline: none;
        border-color: #3498db;
        box-shadow: 0 0 5px rgba(52, 152, 219, 0.3);
    }
    
    textarea {
        resize: vertical;
        min-height: 120px;
    }
    
    button {
        background: linear-gradient(135deg, #3498db, #2980b9);
        color: white;
        padding: 15px 30px;
        border: none;
        border-radius: 5px;
        font-size: 16px;
        font-weight: bold;
        cursor: pointer;
        transition: background 0.3s ease, transform 0.2s ease;
    }
    
    button:hover {
        background: linear-gradient(135deg, #2980b9, #21618c);
        transform: translateY(-2px);
    }
    
    .blogs-section {
        margin-top: 40px;
    }
    
    .slider-container {
        position: relative;
        overflow: hidden;
        border-radius: 10px;
        background: #f8f9fa;
        padding: 20px;
    }
    
    .slider-track {
        display: flex;
        gap: 20px;
        overflow-x: auto;
        padding-bottom: 10px;
        scroll-behavior: smooth;
    }
    
    .slider-track::-webkit-scrollbar {
        height: 8px;
    }
    
    .slider-track::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
    }
    
    .slider-track::-webkit-scrollbar-thumb {
        background: #888;
        border-radius: 10px;
    }
    
    .slider-track::-webkit-scrollbar-thumb:hover {
        background: #555;
    }
    
    .blog-card {
        flex: 0 0 300px;
        background: white;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        position: relative;
        transition: transform 0.3s ease;
    }
    
    .blog-card:hover {
        transform: translateY(-5px);
    }
    
    .blog-image {
        width: 100%;
        height: 200px;
        background-size: cover;
        background-position: center;
        background-color: #ddd;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #666;
    }
    
    .blog-content {
        padding: 20px;
    }
    
    .blog-title {
        font-size: 1.2em;
        font-weight: bold;
        margin: 0 0 10px 0;
        color: #2c3e50;
    }
    
    .blog-description {
        color: #666;
        font-size: 0.9em;
        line-height: 1.4;
        margin: 0;
    }
    
    .blog-actions {
        padding: 15px 20px;
        background: #f8f9fa;
        display: flex;
        gap: 15px;
        border-top: 1px solid #eee;
    }
    
    .blog-actions a {
        text-decoration: none;
        padding: 5px 10px;
        border-radius: 3px;
        font-size: 0.9em;
        transition: background 0.3s ease;
    }
    
    .edit-btn {
        color: #3498db;
        background: rgba(52, 152, 219, 0.1);
    }
    
    .edit-btn:hover {
        background: rgba(52, 152, 219, 0.2);
    }
    
    .delete-btn {
        color: #e74c3c;
        background: rgba(231, 76, 60, 0.1);
    }
    
    .delete-btn:hover {
        background: rgba(231, 76, 60, 0.2);
    }
    
    .slider-nav {
        display: flex;
        justify-content: center;
        gap: 10px;
        margin-top: 20px;
    }
    
    .slider-btn {
        background: #3498db;
        color: white;
        border: none;
        padding: 10px 15px;
        border-radius: 5px;
        cursor: pointer;
        font-size: 18px;
        transition: background 0.3s ease;
    }
    
    .slider-btn:hover {
        background: #2980b9;
    }
    
    @media (max-width: 768px) {
        .container {
            padding: 20px;
        }
        
        .stats-grid {
            grid-template-columns: 1fr;
        }
        
        .blog-card {
            flex: 0 0 280px;
        }
        
        h1 {
            font-size: 2em;
        }
    }
</style>

<div class="container">
    <h1>Admin Dashboard</h1>
    
    <!-- DASHBOARD STATISTICS -->
    <section>
        <h2>Dashboard Overview</h2>
        <div class="stats-grid">
            <div class="stat-card">
                <h3>Total Blogs</h3>
                <p class="number"><?php echo $total_blogs; ?></p>
            </div>
            <div class="stat-card">
                <h3>Total Users</h3>
                <p class="number"><?php echo $total_users; ?></p>
            </div>
            <div class="stat-card">
                <h3>Total Deposits</h3>
                <p class="number"><?php echo $total_deposits; ?></p>
            </div>
            <div class="stat-card">
                <h3>Total Payments</h3>
                <p class="number"><?php echo $total_payments; ?></p>
            </div>
        </div>
    </section>

    <!-- ADD BLOG FORM -->
    <section class="form-section">
        <h2>Create a New Blog</h2>
        <form action="process_blog.php" method="POST" enctype="multipart/form-data">
            <div class="form-group">
                <label for="blog-title">Blog Title</label>
                <input type="text" id="blog-title" name="title" placeholder="Enter Blog Title" required>
            </div>
            <div class="form-group">
                <label for="blog-content">Content</label>
                <textarea id="blog-content" name="content" placeholder="Write your blog content here" required></textarea>
            </div>
            <div class="form-group">
                <label for="blog-image">Upload Image</label>
                <input type="file" id="blog-image" name="image" accept="image/*" required>
            </div>
            <button type="submit" name="submit">Add Blog</button>
        </form>
    </section>

    <!-- BLOG POSTS SECTION -->
    <section class="blogs-section">
        <h2>Blog Posts</h2>
        <div class="slider-container">
            <div class="slider-track" id="blogSlider">
                <?php
                // Fetch blog entries from the "blogs" table
                $result = $conn->query("SELECT * FROM blogs ORDER BY created_at DESC");
                if ($result && $result->rowCount() > 0):
                    while ($row = $result->fetch(PDO::FETCH_ASSOC)):
                        // Build the image path (assuming the file name is stored in 'image_url')
                        $image_path = 'all_blogs/' . basename($row['image_url']);
                ?>
                <div class="blog-card">
                    <div class="blog-image" style="background-image: url('<?= htmlspecialchars($image_path) ?>');">
                        <?php if (!file_exists($image_path)): ?>
                            No Image Available
                        <?php endif; ?>
                    </div>
                    <div class="blog-content">
                        <h3 class="blog-title"><?= htmlspecialchars($row['title']) ?></h3>
                        <p class="blog-description"><?= htmlspecialchars(substr($row['content'], 0, 100)) ?>...</p>
                    </div>
                    <div class="blog-actions">
                        <a href="edit_blog.php?id=<?= $row['id'] ?>" class="edit-btn">✏️ Edit</a>
                        <a href="process_blog.php?delete=<?= $row['id'] ?>" class="delete-btn" onclick="return confirm('Are you sure you want to delete this blog?')">🗑️ Delete</a>
                    </div>
                </div>
                <?php 
                    endwhile;
                else:
                ?>
                <div style="text-align: center; color: #666; padding: 40px;">
                    <p>No blogs found. Create your first blog post!</p>
                </div>
                <?php endif; ?>
            </div>
            
            <!-- SLIDER NAVIGATION -->
            <div class="slider-nav">
                <button class="slider-btn" onclick="scrollSlider(-300)">←</button>
                <button class="slider-btn" onclick="scrollSlider(300)">→</button>
            </div>
        </div>
    </section>
</div>

<script>
    function scrollSlider(direction) {
        const slider = document.getElementById('blogSlider');
        slider.scrollBy({ left: direction, behavior: 'smooth' });
    }
    
    // Add smooth scrolling behavior
    document.getElementById('blogSlider').addEventListener('wheel', function(e) {
        if (e.deltaX !== 0) return;
        e.preventDefault();
        this.scrollLeft += e.deltaY;
    });
</script>

<?php include 'footer.php'; ?>