<?php
// Enable error reporting for debugging (remove or adjust in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Start the session at the very beginning
session_start();

/*-------------------------------------------------
  INLINE PDO DATABASE CONNECTION
-------------------------------------------------*/
$host     = 'localhost';
$dbname   = 'wptlgmnb_dbp'; // Replace with your database name
$username = 'wptlgmnb_userp'; // Replace with your database username
$password = 'Qliox4ITygj6Vh4V'; // Replace with your database password
$charset  = 'utf8';

$dsn = "mysql:host=$host;dbname=$dbname;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION, // Throw exceptions on errors
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,       // Fetch associative arrays
    PDO::ATTR_EMULATE_PREPARES   => false,                  // Use real prepared statements
];

try {
    $conn = new PDO($dsn, $username, $password, $options);
    // Optional: echo "Database connection established successfully.";
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

/*-------------------------------------------------
  CONFIGURATION & INITIALIZATION
-------------------------------------------------*/
// reCAPTCHA configuration
$recaptcha_site_key   = '6LeO7lcrAAAAAB1V_K_7Fk5aRtnE0UUkUkgq1cIh';
$recaptcha_secret_key = '6LeS6V4rAAAAAGwCkZKCDuIjsPaeJaHWHN_x-apB';

// Initialize variables
$message = "";
$form_data = [
    'name'    => '',
    'email'   => '',
    'country' => '',
    'phone'   => ''
];

// Debug function to log errors
function debug_log($msg, $is_error = true) {
    error_log($msg);
    if (isset($_SESSION['debug_mode']) && $_SESSION['debug_mode']) {
        echo "<div class='alert alert-danger'>Debug: " . htmlspecialchars($msg) . "</div>";
    }
}

// (Optional) Check database connection – already handled above
if (!isset($conn) || !$conn) {
    debug_log("Database connection failed");
    $message = "<div class='alert alert-danger'>Registration failed: Database connection error. Please try again later.</div>";
}

/*-------------------------------------------------
  ENSURE USERS TABLE EXISTS
-------------------------------------------------*/
try {
    $check_table = "SHOW TABLES LIKE 'users'";
    $stmt = $conn->prepare($check_table);
    $stmt->execute();
    $table_exists = $stmt->rowCount() > 0;
    
    if (!$table_exists) {
        // Create the table if it doesn't exist
        $create_table = "CREATE TABLE users (
            id INT AUTO_INCREMENT PRIMARY KEY,
            email VARCHAR(255) UNIQUE NOT NULL,
            password VARCHAR(255) NOT NULL,
            name VARCHAR(255) NOT NULL,
            country VARCHAR(100),
            phone VARCHAR(20),
            profile_pic VARCHAR(255),
            status VARCHAR(20) DEFAULT 'active',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            update_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )";
        $conn->exec($create_table);
        debug_log("Created users table", false);
    }
} catch (PDOException $e) {
    debug_log("Table check/creation error: " . $e->getMessage());
    // Continue execution or halt if critical
}

/*-------------------------------------------------
  PROCESS REGISTRATION FORM (ON POST)
-------------------------------------------------*/
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Save form data for repopulation in case of errors
    foreach (['name', 'email', 'country', 'phone'] as $field) {
        if (isset($_POST[$field])) {
            $form_data[$field] = $_POST[$field];
        }
    }

    // CSRF token check
    if (!isset($_POST['csrf_token']) || !isset($_SESSION['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        debug_log("CSRF token validation failed");
        $message = "<div class='alert alert-danger'>Security validation failed. Please try again.</div>";
    } else {
        // Verify reCAPTCHA
        if (!isset($_POST['g-recaptcha-response']) || empty($_POST['g-recaptcha-response'])) {
            $message = "<div class='alert alert-danger'>Please complete the security verification.</div>";
        } else {
            $recaptcha_response = $_POST['g-recaptcha-response'];
            $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
            $recaptcha_data = [
                'secret'   => $recaptcha_secret_key,
                'response' => $recaptcha_response,
                'remoteip' => $_SERVER['REMOTE_ADDR']
            ];
            $recaptcha_options = [
                'http' => [
                    'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                    'method'  => 'POST',
                    'content' => http_build_query($recaptcha_data)
                ]
            ];
            try {
                $recaptcha_context = stream_context_create($recaptcha_options);
                $recaptcha_result = file_get_contents($recaptcha_url, false, $recaptcha_context);
                if ($recaptcha_result === false) {
                    throw new Exception("Failed to connect to reCAPTCHA service");
                }
                $recaptcha_json = json_decode($recaptcha_result, true);
                if (!isset($recaptcha_json['success']) || !$recaptcha_json['success']) {
                    debug_log("reCAPTCHA verification failed: " . print_r($recaptcha_json, true));
                    $message = "<div class='alert alert-danger'>Security verification failed. Please try again.</div>";
                } else {
                    // reCAPTCHA passed; sanitize and validate inputs
                    $email = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
                    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                        $message = "<div class='alert alert-danger'>Invalid email format.</div>";
                    } else {
                        $password_input   = isset($_POST['password']) ? $_POST['password'] : '';
                        $confirm_password = isset($_POST['confirm_password']) ? $_POST['confirm_password'] : '';
                        $name             = isset($_POST['name']) ? htmlspecialchars(trim($_POST['name'])) : '';
                        $country          = isset($_POST['country']) ? htmlspecialchars($_POST['country']) : '';
                        $phone            = isset($_POST['phone']) ? htmlspecialchars(trim($_POST['phone'])) : '';
                        $profile_pic      = 'https://primemarketspro.com/session/favicon.png';

                        // Check required fields and password rules
                        if (empty($name) || empty($password_input) || empty($confirm_password)) {
                            $message = "<div class='alert alert-danger'>All required fields must be filled.</div>";
                        } elseif (strlen($password_input) < 8) {
                            $message = "<div class='alert alert-danger'>Password must be at least 8 characters long.</div>";
                        } elseif ($password_input !== $confirm_password) {
                            $message = "<div class='alert alert-danger'>Passwords do not match.</div>";
                        } else {
                            try {
                                // Check if the email already exists
                                $query = "SELECT id FROM users WHERE email = :email";
                                $stmt = $conn->prepare($query);
                                $stmt->bindValue(':email', $email, PDO::PARAM_STR);
                                $stmt->execute();

                                if ($stmt->rowCount() > 0) {
                                    $message = "<div class='alert alert-danger'>Email already exists.</div>";
                                } else {
                                    // Hash the password with a cost parameter
                                    $password = password_hash($password_input, PASSWORD_DEFAULT, ['cost' => 12]);

                                    // Begin transaction and insert the new user
                                    $conn->beginTransaction();
                                    $query = "INSERT INTO users (email, password, name, country, phone, profile_pic) 
                                              VALUES (:email, :password, :name, :country, :phone, :profile_pic)";
                                    $stmt = $conn->prepare($query);
                                    $stmt->bindValue(':email', $email, PDO::PARAM_STR);
                                    $stmt->bindValue(':password', $password, PDO::PARAM_STR);
                                    $stmt->bindValue(':name', $name, PDO::PARAM_STR);
                                    $stmt->bindValue(':country', $country, PDO::PARAM_STR);
                                    $stmt->bindValue(':phone', $phone, PDO::PARAM_STR);
                                    $stmt->bindValue(':profile_pic', $profile_pic, PDO::PARAM_STR);
                                    $stmt->execute();
                                    $conn->commit();

                                    // Set session variables for the new user
                                    $user_id = $conn->lastInsertId();
                                    $_SESSION['user_email'] = $email;
                                    $_SESSION['user_id']    = $user_id;
                                    $_SESSION['user_name']  = $name;

                                    // Generate a new CSRF token for future requests
                                    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));

                                    // Set a success message and redirect to the login page
                                    $_SESSION['success_message'] = "<div class='alert alert-success'>Account created successfully. Kindly login.</div>";
                                    header('Location: login.php');
                                    exit();
                                }
                            } catch (PDOException $e) {
                                // Roll back transaction if an error occurs
                                if ($conn->inTransaction()) {
                                    $conn->rollBack();
                                }
                                debug_log("Registration error: " . $e->getMessage());
                                $message = "<div class='alert alert-danger'>Registration failed: " .
                                    (strpos($e->getMessage(), 'Duplicate entry') !== false ? "Email already exists." : "Database error. Please try again later.") . "</div>";
                            } catch (Exception $e) {
                                debug_log("General error: " . $e->getMessage());
                                $message = "<div class='alert alert-danger'>Registration failed: " . $e->getMessage() . "</div>";
                            }
                        }
                    }
                }
            } catch (Exception $e) {
                debug_log("reCAPTCHA error: " . $e->getMessage());
                $message = "<div class='alert alert-danger'>Security verification failed. Please try again.</div>";
            }
        }
    }
}

/*-------------------------------------------------
  CSRF TOKEN & HELPER FUNCTION
-------------------------------------------------*/
// Generate a CSRF token if one is not already set
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$csrf_token = $_SESSION['csrf_token'];

// Function to safely output form values
function get_form_value($key) {
    global $form_data;
    return isset($form_data[$key]) ? htmlspecialchars($form_data[$key]) : '';
}

/*-------------------------------------------------
  TOGGLE DEBUG MODE VIA URL (optional, remove in production)
-------------------------------------------------*/
if (isset($_GET['debug']) && $_GET['debug'] == 'on') {
    $_SESSION['debug_mode'] = true;
} elseif (isset($_GET['debug']) && $_GET['debug'] == 'off') {
    $_SESSION['debug_mode'] = false;
}
?>
