<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Crypto Signal Platform</title>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.7.1/chart.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js"></script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css" rel="stylesheet">
  <style>
    :root {
      --primary-purple: #8a2be2;
      --light-purple: #9f55e9;
      --dark-purple: #6a1cb7;
      --order-book-bg: rgba(138, 43, 226, 0.05);
    }
    
    .bg-custom-purple {
      background-color: var(--primary-purple);
    }
    
    .text-custom-purple {
      color: var(--primary-purple);
    }
    
    .border-custom-purple {
      border-color: var(--primary-purple);
    }
    
    .hover-custom-purple:hover {
      background-color: var(--light-purple);
    }
    
    .signal-low {
      background: linear-gradient(to right, #ff4d4d, #ffcc00);
    }
    
    .signal-medium {
      background: linear-gradient(to right, #ffcc00, #33cc33);
    }
    
    .signal-high {
      background: linear-gradient(to right, #33cc33, #009900);
    }
    
    .range-slider {
      -webkit-appearance: none;
      height: 8px;
      border-radius: 4px;
      background: linear-gradient(to right, #ff4d4d, #ffcc00, #33cc33, #009900);
      outline: none;
    }
    
    .range-slider::-webkit-slider-thumb {
      -webkit-appearance: none;
      appearance: none;
      width: 24px;
      height: 24px;
      border-radius: 50%;
      background: white;
      border: 3px solid var(--primary-purple);
      cursor: pointer;
      box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    }
    
    .range-slider::-moz-range-thumb {
      width: 24px;
      height: 24px;
      border-radius: 50%;
      background: white;
      border: 3px solid var(--primary-purple);
      cursor: pointer;
      box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    }
    
    .order-book-row {
      transition: all 0.3s ease;
    }
    
    .order-book-buy {
      background-color: rgba(0, 200, 5, 0.1);
    }
    
    .order-book-sell {
      background-color: rgba(255, 0, 0, 0.1);
    }
    
    .signal-pulse {
      animation: signal-pulse 2s infinite;
    }
    
    @keyframes signal-pulse {
      0% {
        box-shadow: 0 0 0 0 rgba(138, 43, 226, 0.7);
      }
      70% {
        box-shadow: 0 0 0 10px rgba(138, 43, 226, 0);
      }
      100% {
        box-shadow: 0 0 0 0 rgba(138, 43, 226, 0);
      }
    }
    
    .testimonial-card {
      height: 300px;
    }
    
    .slick-dots li button:before {
      color: var(--primary-purple);
    }
    
    .slick-prev:before, .slick-next:before {
      color: var(--primary-purple);
    }
    
    /* Live order book animation */
    .flash-green {
      animation: flashGreen 0.5s;
    }
    
    .flash-red {
      animation: flashRed 0.5s;
    }
    
    @keyframes flashGreen {
      0% { background-color: rgba(0, 200, 5, 0.5); }
      100% { background-color: rgba(0, 200, 5, 0.1); }
    }
    
    @keyframes flashRed {
      0% { background-color: rgba(255, 0, 0, 0.5); }
      100% { background-color: rgba(255, 0, 0, 0.1); }
    }
    
    .notification {
      position: fixed;
      top: 20px;
      right: 20px;
      z-index: 9999;
      max-width: 350px;
      border-radius: 8px;
      overflow: hidden;
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
      transform: translateX(400px);
      transition: transform 0.5s ease;
    }
    
    .notification.show {
      transform: translateX(0);
    }
    
    .market-tab {
      cursor: pointer;
      padding: 0.5rem 1rem;
      border-radius: 0.5rem;
      transition: all 0.3s ease;
    }
    
    .market-tab.active {
      background-color: var(--primary-purple);
      color: white;
    }

    .countdown-timer {
      display: flex;
      justify-content: center;
      gap: 10px;
      margin: 20px 0;
    }

    .countdown-item {
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    .countdown-value {
      background-color: var(--primary-purple);
      color: white;
      font-size: 24px;
      font-weight: bold;
      border-radius: 8px;
      width: 60px;
      height: 60px;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .countdown-label {
      font-size: 12px;
      color: #666;
      margin-top: 5px;
    }

    .step-content {
      min-height: 500px;
    }

    .qr-container {
      display: flex;
      justify-content: center;
      margin: 20px 0;
    }

    .copy-address {
      cursor: pointer;
      transition: all 0.2s ease;
    }

    .copy-address:hover {
      color: var(--primary-purple);
    }

    .copy-success {
      animation: fadeInOut 2s;
    }

    @keyframes fadeInOut {
      0% { opacity: 0; }
      20% { opacity: 1; }
      80% { opacity: 1; }
      100% { opacity: 0; }
    }

    .testimonial-slider {
      padding: 20px 40px;
    }
  </style>
</head>
<body class="bg-gray-50 min-h-screen">
  <nav class="bg-custom-purple text-white p-4 shadow-lg sticky top-0 z-50">
    <div class="container mx-auto flex justify-between items-center">
      <div class="text-2xl font-bold animate__animated animate__fadeInLeft flex items-center">
        <i class="fas fa-signal mr-2"></i>
        CryptoSignals
      </div>
      <div class="flex space-x-4 items-center">
        <button id="alert-button" class="bg-white text-custom-purple px-3 py-1 rounded-full flex items-center mr-2 hover:bg-gray-100">
          <i class="fas fa-bell mr-1"></i>
          <span id="alert-count" class="bg-red-500 text-white text-xs rounded-full h-5 w-5 flex items-center justify-center">3</span>
        </button>
        <button class="bg-white text-custom-purple px-4 py-2 rounded-lg font-medium hover:bg-gray-100 animate__animated animate__fadeInRight">
          <i class="fas fa-user mr-1"></i> Login
        </button>
      </div>
    </div>
  </nav>

  <div id="notifications-container"></div>

  <main class="container mx-auto p-4 mt-4">





    <!-- Multi-step form -->
    <div class="bg-white rounded-lg shadow-xl p-6 mb-8 animate__animated animate__fadeIn">
      <!-- Step indicators -->
      <div class="flex justify-between mb-8">
        <div class="step-indicator active flex flex-col items-center">
          <div class="w-10 h-10 bg-custom-purple text-white rounded-full flex items-center justify-center font-bold">1</div>
          <div class="mt-2 text-custom-purple font-medium">Select Signal</div>
        </div>
        <div class="h-0.5 bg-gray-300 w-1/3 self-center step-connector"></div>
        <div class="step-indicator flex flex-col items-center">
          <div id="step2-indicator" class="w-10 h-10 bg-gray-300 text-gray-600 rounded-full flex items-center justify-center font-bold">2</div>
          <div class="mt-2 text-gray-500 font-medium">Choose Payment</div>
        </div>
        <div class="h-0.5 bg-gray-300 w-1/3 self-center step-connector"></div>
        <div class="step-indicator flex flex-col items-center">
          <div id="step3-indicator" class="w-10 h-10 bg-gray-300 text-gray-600 rounded-full flex items-center justify-center font-bold">3</div>
          <div class="mt-2 text-gray-500 font-medium">Complete Payment</div>
        </div>
      </div>

      <!-- Step 1: Signal Selection -->
      <div id="step1" class="step-content animate__animated animate__fadeIn">
        <h2 class="text-2xl font-bold text-gray-800 mb-6">Select Your Signal Level</h2>
        
        <div class="mb-8">
          <label for="signal-range" class="block text-lg font-medium text-gray-700 mb-2">Signal Strength (1-100)</label>
          <div class="flex items-center">
            <input type="range" min="1" max="100" value="50" class="range-slider w-full h-2 rounded-lg appearance-none cursor-pointer" id="signal-range">
            <span id="signal-value" class="ml-4 px-4 py-2 bg-custom-purple text-white rounded-lg font-bold min-w-[60px] text-center">50</span>
          </div>
          <div class="flex justify-between text-xs text-gray-500 mt-1">
            <span class="text-red-500">Basic</span>
            <span class="text-yellow-500">Standard</span>
            <span class="text-green-500">Premium</span>
            <span class="text-green-700">Elite</span>
          </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
          <div class="mb-8">
            <label class="block text-lg font-medium text-gray-700 mb-2">Signal Price</label>
            <div id="price-display" class="text-3xl font-bold text-custom-purple">$25,000 USD</div>
            <p class="text-sm text-gray-500 mt-1">Price scales with signal strength</p>
          </div>
          
          <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
            <div id="signal-quality-indicator" class="mb-4">
              <div class="text-lg font-medium text-gray-700 mb-2">Signal Quality</div>
              <div class="w-full h-3 bg-gray-200 rounded-full overflow-hidden">
                <div id="signal-quality-bar" class="h-full signal-medium" style="width: 50%"></div>
              </div>
            </div>
            
            <div class="flex items-center justify-between text-sm">
              <div class="flex items-center">
                <div class="w-3 h-3 rounded-full bg-red-500 mr-1"></div>
                <span>Low Accuracy</span>
              </div>
              <div class="flex items-center">
                <div class="w-3 h-3 rounded-full bg-yellow-500 mr-1"></div>
                <span>Medium</span>
              </div>
              <div class="flex items-center">
                <div class="w-3 h-3 rounded-full bg-green-500 mr-1"></div>
                <span>High Precision</span>
              </div>
            </div>
          </div>
        </div>

        <div class="mb-8">
          <h3 class="text-lg font-medium text-gray-700 mb-4">Signal Features:</h3>
          <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div class="flex items-start">
              <i class="fas fa-check-circle text-green-500 mr-2 mt-1"></i>
              <span>Real-time market analysis</span>
            </div>
            <div class="flex items-start">
              <i class="fas fa-check-circle text-green-500 mr-2 mt-1"></i>
              <span>AI-powered trade recommendations</span>
            </div>
            <div class="flex items-start">
              <i class="fas fa-check-circle text-green-500 mr-2 mt-1"></i>
              <span>Entry and exit points</span>
            </div>
            <div class="flex items-start">
              <i class="fas fa-check-circle text-green-500 mr-2 mt-1"></i>
              <span>Risk management strategies</span>
            </div>
            <div id="advanced-feature" class="flex items-start opacity-50">
              <i class="fas fa-check-circle text-green-500 mr-2 mt-1"></i>
              <span>Advanced pattern recognition</span>
            </div>
            <div id="premium-feature" class="flex items-start opacity-50">
              <i class="fas fa-check-circle text-green-500 mr-2 mt-1"></i>
              <span>Expert analyst consultation</span>
            </div>
            <div id="elite-feature-1" class="flex items-start opacity-50">
              <i class="fas fa-check-circle text-green-500 mr-2 mt-1"></i>
              <span>Automated trading bot integration</span>
            </div>
            <div id="elite-feature-2" class="flex items-start opacity-50">
              <i class="fas fa-check-circle text-green-500 mr-2 mt-1"></i>
              <span>Premium Discord community access</span>
            </div>
          </div>
        </div>

        <button id="next-to-payment" class="bg-custom-purple hover-custom-purple text-white font-bold py-3 px-6 rounded-lg w-full transition duration-300 animate__animated animate__pulse animate__infinite flex items-center justify-center">
          <i class="fas fa-arrow-right mr-2"></i>
          Continue to Payment
        </button>
      </div>

      <!-- Step 2: Payment Selection -->
      <div id="step2" class="step-content hidden animate__animated">
        <h2 class="text-2xl font-bold text-gray-800 mb-6">Choose Payment Method</h2>
        
        <div class="mb-8">
          <label class="block text-lg font-medium text-gray-700 mb-2">Selected Signal Level</label>
          <div class="flex justify-between items-center p-4 bg-gray-50 rounded-lg border border-gray-200">
            <div>
              <span class="text-gray-700">Signal Strength:</span>
              <span id="selected-signal" class="font-bold text-custom-purple ml-2">50</span>
            </div>
            <div>
              <span class="text-gray-700">Price:</span>
              <span id="selected-price" class="font-bold text-custom-purple ml-2">$25,000 USD</span>
            </div>
          </div>
        </div>

        <div class="mb-8">
          <label class="block text-lg font-medium text-gray-700 mb-4">Select Cryptocurrency</label>
          <div class="relative">
            <select id="crypto-select" class="block appearance-none w-full bg-white border border-gray-300 hover:border-custom-purple text-gray-700 py-3 px-4 pr-8 rounded-lg leading-tight focus:outline-none focus:bg-white focus:border-custom-purple cursor-pointer">
              <option value="bitcoin" data-logo="₿" data-name="Bitcoin (BTC)" data-price="84487.69">
                <i class="fab fa-bitcoin"></i> Bitcoin (BTC)
              </option>
              <option value="ethereum" data-logo="Ξ" data-name="Ethereum (ETH)" data-price="1587.59">
                <i class="fab fa-ethereum"></i> Ethereum (ETH)
              </option>
              <option value="usdt-erc20" data-logo="₮" data-name="USDT (ERC20)" data-price="1.00">
                USDT (ERC20)
              </option>
              <option value="usdt-trc20" data-logo="₮" data-name="USDT (TRC20)" data-price="1.00">
                USDT (TRC20)
              </option>
              <option value="solana" data-logo="◎" data-name="Solana (SOL)" data-price="125.47">
                Solana (SOL)
              </option>
              <option value="cardano" data-logo="₳" data-name="Cardano (ADA)" data-price="0.45">
                Cardano (ADA)
              </option>
              <option value="bnb" data-logo="BNB" data-name="BNB" data-price="578.32">
                BNB
              </option>
              <option value="dogecoin" data-logo="Ð" data-name="Dogecoin (DOGE)" data-price="0.12">
                Dogecoin (DOGE)
              </option>
            </select>
            <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-700">
              <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/>
              </svg>
            </div>
          </div>
        </div>

        <div class="mb-8 p-4 bg-gray-<div class="mb-8 p-4 bg-gray-50 rounded-lg border border-gray-200">
          <div class="flex justify-between items-center mb-2">
            <span class="text-gray-700">Current Price:</span>
            <span id="crypto-price" class="font-bold text-custom-purple animate__animated animate__flash">$84,487.69</span>
          </div>
          <div class="flex justify-between items-center">
            <span class="text-gray-700">Amount to Pay:</span>
            <span id="crypto-amount" class="font-bold text-custom-purple">0.2959 BTC</span>
          </div>
        </div>

        <div class="flex space-x-4">
          <button id="back-to-signal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-3 px-6 rounded-lg w-1/3 transition duration-300 flex items-center justify-center">
            <i class="fas fa-arrow-left mr-2"></i>
            Back
          </button>
          <button id="next-to-checkout" class="bg-custom-purple hover-custom-purple text-white font-bold py-3 px-6 rounded-lg w-2/3 transition duration-300 animate__animated animate__pulse animate__infinite flex items-center justify-center">
            <i class="fas fa-credit-card mr-2"></i>
            Proceed to Checkout
          </button>
        </div>
      </div>

      <!-- Step 3: Checkout -->
      <div id="step3" class="step-content hidden animate__animated">
        <h2 class="text-2xl font-bold text-gray-800 mb-6">Complete Your Payment</h2>
        
        <div class="mb-6 p-4 bg-yellow-50 border border-yellow-200 rounded-lg text-yellow-800">
          <div class="flex items-start">
            <i class="fas fa-exclamation-circle text-yellow-600 mr-2 mt-1"></i>
            <div>
              <p class="font-bold mb-1">Payment Instructions</p>
              <p>Please send the exact amount to the address below. This payment address will expire in 15 minutes.</p>
            </div>
          </div>
        </div>
        
        <div class="countdown-timer">
          <div class="countdown-item">
            <div class="countdown-value" id="countdown-minutes">15</div>
            <div class="countdown-label">Minutes</div>
          </div>
          <div class="countdown-item">
            <div class="countdown-value" id="countdown-seconds">00</div>
            <div class="countdown-label">Seconds</div>
          </div>
        </div>
        
        <div class="mb-8">
          <div class="flex justify-between items-center mb-2">
            <div>
              <span class="text-gray-700">Payment Method:</span>
              <span id="payment-method" class="font-semibold text-custom-purple ml-2">Bitcoin (BTC)</span>
            </div>
            <div>
              <span class="text-gray-700">Signal Strength:</span>
              <span id="checkout-signal" class="font-semibold text-custom-purple ml-2">50</span>
            </div>
          </div>
          <div class="flex justify-between items-center">
            <div>
              <span class="text-gray-700">Total Price:</span>
              <span id="checkout-price" class="font-semibold text-custom-purple ml-2">$25,000 USD</span>
            </div>
            <div>
              <span class="text-gray-700">Amount:</span>
              <span id="checkout-amount" class="font-semibold text-custom-purple ml-2">0.2959 BTC</span>
            </div>
          </div>
        </div>
        
        <div class="mb-6 text-center">
          <div class="qr-container">
            <div id="qrcode" class="p-4 bg-white rounded-lg border border-gray-200"></div>
          </div>
          <div class="mt-4">
            <p class="text-gray-500 text-sm mb-2">Send exactly the amount shown to this address:</p>
            <div class="relative">
              <input id="wallet-address" type="text" readonly class="w-full p-3 pr-12 bg-gray-50 border border-gray-300 rounded-lg" value="bc1qxy2kgdygjrsqtzq2n0yrf2493p83kkfjhx0wlh">
              <button id="copy-address" class="absolute right-3 top-3 copy-address">
                <i class="far fa-copy"></i>
              </button>
              <span id="copy-success" class="absolute -top-8 left-1/2 transform -translate-x-1/2 bg-gray-800 text-white text-xs px-2 py-1 rounded opacity-0">Copied!</span>
            </div>
          </div>
        </div>
        
        <div class="mb-8 p-4 bg-gray-50 rounded-lg border border-gray-200">
          <h3 class="text-lg font-medium text-gray-700 mb-4 flex items-center">
            <i class="fas fa-check-circle text-custom-purple mr-2"></i>
            Payment Status
          </h3>
          <div class="flex flex-col space-y-2">
            <div class="flex items-center">
              <div class="w-6 h-6 rounded-full bg-green-500 text-white flex items-center justify-center mr-3">
                <i class="fas fa-check text-xs"></i>
              </div>
              <span>Creating payment request</span>
            </div>
            <div class="flex items-center">
              <div class="w-6 h-6 rounded-full bg-green-500 text-white flex items-center justify-center mr-3">
                <i class="fas fa-check text-xs"></i>
              </div>
              <span>Generating wallet address</span>
            </div>
            <div class="flex items-center" id="waiting-payment">
              <div class="w-6 h-6 rounded-full bg-yellow-500 text-white flex items-center justify-center mr-3">
                <i class="fas fa-clock text-xs"></i>
              </div>
              <span>Waiting for payment</span>
            </div>
            <div class="flex items-center opacity-50" id="confirming-payment">
              <div class="w-6 h-6 rounded-full bg-gray-300 text-gray-600 flex items-center justify-center mr-3">
                <i class="fas fa-spinner text-xs"></i>
              </div>
              <span>Confirming transaction</span>
            </div>
            <div class="flex items-center opacity-50" id="signal-delivery">
              <div class="w-6 h-6 rounded-full bg-gray-300 text-gray-600 flex items-center justify-center mr-3">
                <i class="fas fa-paper-plane text-xs"></i>
              </div>
              <span>Delivering signal package</span>
            </div>
          </div>
        </div>
        
        <div class="flex space-x-4">
          <button id="back-to-crypto" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-3 px-6 rounded-lg w-1/3 transition duration-300 flex items-center justify-center">
            <i class="fas fa-arrow-left mr-2"></i>
            Back
          </button>
          <button id="simulate-payment" class="bg-green-600 hover:bg-green-700 text-white font-bold py-3 px-6 rounded-lg w-2/3 transition duration-300 flex items-center justify-center">
            <i class="fas fa-bolt mr-2"></i>
            Simulate Payment (Demo)
          </button>
        </div>
      </div>
    </div>


    <div class="max-w-6xl mx-auto">
      <!-- Live Trading Chart with Signal Indicators -->
      <div class="bg-white rounded-lg shadow-xl p-6 mb-8 animate__animated animate__fadeIn">
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6">
          <div>
            <h2 class="text-2xl font-bold text-gray-800 flex items-center">
              <i class="fas fa-chart-line mr-2 text-custom-purple"></i>
              Live Trading Charts
            </h2>
            <p class="text-gray-600">Real-time market data with AI signal indicators</p>
          </div>
          <div class="flex mt-4 md:mt-0 space-x-2">
            <div class="market-tab active" data-timeframe="1h">1H</div>
            <div class="market-tab" data-timeframe="4h">4H</div>
            <div class="market-tab" data-timeframe="1d">1D</div>
            <div class="market-tab" data-timeframe="1w">1W</div>
          </div>
        </div>
        
        <div class="flex flex-col xl:flex-row space-y-8 xl:space-y-0 xl:space-x-8">
          <div class="flex-grow">
            <div class="flex items-center mb-4 space-x-4">
              <div class="flex items-center">
                <img src="/api/placeholder/32/32" alt="BTC" class="rounded-full mr-2" />
                <span class="font-bold text-xl">BTC/USDT</span>
              </div>
              <div class="text-xl font-bold">$84,487.69</div>
              <div class="text-red-500">-0.5%</div>
            </div>
            
            <div class="relative h-96 mb-4">
              <canvas id="tradingChart" class="w-full h-full"></canvas>
            </div>
            
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
              <div class="bg-gray-50 p-3 rounded-lg border border-gray-200">
                <div class="text-xs text-gray-500">24h High</div>
                <div class="text-base font-bold text-gray-800">$85,472.54</div>
              </div>
              <div class="bg-gray-50 p-3 rounded-lg border border-gray-200">
                <div class="text-xs text-gray-500">24h Low</div>
                <div class="text-base font-bold text-gray-800">$83,954.10</div>
              </div>
              <div class="bg-gray-50 p-3 rounded-lg border border-gray-200">
                <div class="text-xs text-gray-500">24h Volume</div>
                <div class="text-base font-bold text-gray-800">$12.9B</div>
              </div>
              <div class="bg-gray-50 p-3 rounded-lg border border-gray-200">
                <div class="text-xs text-gray-500">Market Cap</div>
                <div class="text-base font-bold text-gray-800">$1.67T</div>
              </div>
            </div>
          </div>
          
          <div class="w-full xl:w-80 bg-gray-50 rounded-lg p-4 border border-gray-200">
            <h3 class="text-lg font-bold mb-4 flex items-center">
              <i class="fas fa-book mr-2 text-custom-purple"></i>
              Order Book
            </h3>
            
            <div class="mb-2 flex justify-between text-sm text-gray-500">
              <span>Price (USDT)</span>
              <span>Amount (BTC)</span>
              <span>Total</span>
            </div>
            
            <!-- Sell orders (descending) -->
            <div id="sell-orders" class="mb-4 max-h-36 overflow-y-auto">
              <!-- Dynamically generated sell orders will go here -->
            </div>
            
            <!-- Current price indicator -->
            <div class="flex justify-between items-center py-2 px-1 mb-2 bg-custom-purple bg-opacity-10 rounded">
              <i class="fas fa-arrow-down text-red-500"></i>
              <span class="text-base font-bold">$84,487.69</span>
              <i class="fas fa-arrow-up text-green-500"></i>
            </div>
            
            <!-- Buy orders (descending) -->
            <div id="buy-orders" class="max-h-36 overflow-y-auto">
              <!-- Dynamically generated buy orders will go here -->
            </div>
          </div>
        </div>
      </div>

      <!-- Signal Indicator Card -->
      <div class="bg-white rounded-lg shadow-xl p-6 mb-8 animate__animated animate__fadeInUp">
        <div class="flex justify-between items-center mb-6">
          <div>
            <h2 class="text-2xl font-bold text-gray-800 flex items-center">
              <i class="fas fa-bolt mr-2 text-custom-purple"></i>
              Signal Strength Indicator
            </h2>
            <p class="text-gray-600">Current market signals powered by AI analysis</p>
          </div>
          <div class="signal-pulse bg-green-500 text-white px-4 py-2 rounded-lg flex items-center">
            <i class="fas fa-chart-line mr-2"></i>
            <span>STRONG BUY</span>
          </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
          <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
            <div class="flex justify-between items-center mb-2">
              <div class="font-medium text-gray-700">Short-term (1h)</div>
              <div class="text-green-500 font-bold">BUY</div>
            </div>
            <div class="w-full bg-gray-200 rounded-full h-2.5">
              <div class="bg-green-500 h-2.5 rounded-full" style="width: 85%"></div>
            </div>
            <div class="flex justify-between text-xs text-gray-500 mt-1">
              <span>SELL</span>
              <span>NEUTRAL</span>
              <span>BUY</span>
            </div>
          </div>
          
          <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
            <div class="flex justify-between items-center mb-2">
              <div class="font-medium text-gray-700">Mid-term (1d)</div>
              <div class="text-green-500 font-bold">BUY</div>
            </div>
            <div class="w-full bg-gray-200 rounded-full h-2.5">
              <div class="bg-green-500 h-2.5 rounded-full" style="width: 75%"></div>
            </div>
            <div class="flex justify-between text-xs text-gray-500 mt-1">
              <span>SELL</span>
              <span>NEUTRAL</span>
              <span>BUY</span>
            </div>
          </div>
          
          <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
            <div class="flex justify-between items-center mb-2">
              <div class="font-medium text-gray-700">Long-term (1w)</div>
              <div class="text-yellow-500 font-bold">NEUTRAL</div>
            </div>
            <div class="w-full bg-gray-200 rounded-full h-2.5">
              <div class="bg-yellow-500 h-2.5 rounded-full" style="width: 55%"></div>
            </div>
            <div class="flex justify-between text-xs text-gray-500 mt-1">
              <span>SELL</span>
              <span>NEUTRAL</span>
              <span>BUY</span>
            </div>
          </div>
        </div>
        
        <div class="bg-gray-50 p-6 rounded-lg border border-gray-200 mb-6">
          <h3 class="text-lg font-bold mb-4 flex items-center">
            <i class="fas fa-robot mr-2 text-custom-purple"></i>
            AI Signal Analysis
          </h3>
          <p class="text-gray-700 mb-4">Based on 42 technical indicators and market sentiment analysis, our AI predicts a <span class="font-bold text-green-500">strong bullish movement</span> in the next 24-48 hours. Key resistance level at $86,500.</p>
          
          <div class="flex flex-wrap items-center gap-2">
            <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">RSI: 62</span>
            <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">MACD: Bullish</span>
            <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">MA: Above 200</span>
            <span class="bg-yellow-100 text-yellow-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Stoch: Neutral</span>
            <span class="bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">Bollinger: Upper Band</span>
          </div>
        </div>
      </div>

      






















































        <!-- Tailwind CSS CDN -->
        <script src="https://cdn.tailwindcss.com"></script>
        <!-- Swiper.js CSS -->
        <link
          rel="stylesheet"
          href="https://unpkg.com/swiper/swiper-bundle.min.css"
        />
        <!-- Font Awesome for star icons -->
        <link
          rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css"
        />
        <style>
          .text-custom-purple {
            color: #6b46c1;
          }
          .bg-custom-purple {
            background-color: #6b46c1;
          }
        </style>
      </head>
      <body class="bg-white text-black font-sans antialiased">
      
        <!-- Testimonials Section -->
        <section class="py-12 px-4">
          <div class="max-w-4xl mx-auto">
            <h2 class="text-2xl font-bold text-gray-800 mb-6 flex items-center">
              <i class="fas fa-star mr-2 text-custom-purple"></i>
              What Our Traders Say
            </h2>
      
            <!-- Swiper -->
            <div class="swiper-container">
              <div class="swiper-wrapper">
      
                <!-- Testimonial 1 -->
                <div class="swiper-slide">
                  <div class="bg-white rounded-lg shadow-xl p-6 mb-8">
                    <div class="flex items-center mb-4">
                      <img src="https://via.placeholder.com/50" class="w-12 h-12 rounded-full mr-4" alt="User">
                      <div>
                        <h4 class="font-bold">Alex Thompson</h4>
                        <div class="flex text-yellow-400">
                          <i class="fas fa-star"></i>
                          <i class="fas fa-star"></i>
                          <i class="fas fa-star"></i>
                          <i class="fas fa-star"></i>
                          <i class="fas fa-star"></i>
                        </div>
                      </div>
                    </div>
                    <p class="text-gray-700">"The signals provided by CryptoSignals have dramatically improved my trading performance. I've seen a 127% increase in my portfolio value over the last 3 months. Their AI analysis is spot-on!"</p>
                    <div class="mt-4 text-custom-purple font-semibold">Professional Trader, 2 years with us</div>
                  </div>
                </div>
      
                <!-- Testimonial 2 -->
                <div class="swiper-slide">
                  <div class="bg-white rounded-lg shadow-xl p-6 mb-8">
                    <div class="flex items-center mb-4">
                      <img src="https://via.placeholder.com/50" class="w-12 h-12 rounded-full mr-4" alt="User">
                      <div>
                        <h4 class="font-bold">Sophia Chen</h4>
                        <div class="flex text-yellow-400">
                          <i class="fas fa-star"></i>
                          <i class="fas fa-star"></i>
                          <i class="fas fa-star"></i>
                          <i class="fas fa-star"></i>
                          <i class="fas fa-star-half-alt"></i>
                        </div>
                      </div>
                    </div>
                    <p class="text-gray-700">"As a beginner in crypto trading, these signals have been a game-changer. The platform is easy to use, and the analysis helps me understand market trends. I've already recovered my investment in just weeks."</p>
                    <div class="mt-4 text-custom-purple font-semibold">Retail Investor, 6 months with us</div>
                  </div>
                </div>
      
                <!-- Testimonial 3 -->
                <div class="swiper-slide">
                  <div class="bg-white rounded-lg shadow-xl p-6 mb-8">
                    <div class="flex items-center mb-4">
                      <img src="https://via.placeholder.com/50" class="w-12 h-12 rounded-full mr-4" alt="User">
                      <div>
                        <h4 class="font-bold">Marco Rodriguez</h4>
                        <div class="flex text-yellow-400">
                          <i class="fas fa-star"></i>
                          <i class="fas fa-star"></i>
                          <i class="fas fa-star"></i>
                          <i class="fas fa-star"></i>
                          <i class="fas fa-star"></i>
                        </div>
                      </div>
                    </div>
                    <p class="text-gray-700">"I've tried several signal services, but CryptoSignals has the best accuracy by far. The Elite signals are worth every penny - I made back the cost on my first trade! Their team is responsive and professional."</p>
                    <div class="mt-4 text-custom-purple font-semibold">Fund Manager, 1 year with us</div>
                  </div>
                </div>
      
              </div>
              <!-- Add Pagination -->
              <div ></div>
            </div>
          </div>
        </section>
      
        <!-- Swiper.js JS -->
        <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
        <script>
          const swiper = new Swiper('.swiper-container', {
            loop: true,
            pagination: {
              el: '.swiper-pagination',
              clickable: true,
            },
          });
        </script>
      </body>
      </html>
      


















      
      
      <!-- FAQ Section -->
      <div class="bg-white rounded-lg shadow-xl p-6 mb-8">
        <h2 class="text-2xl font-bold text-gray-800 mb-6 flex items-center">
          <i class="fas fa-question-circle mr-2 text-custom-purple"></i>
          Frequently Asked Questions
        </h2>
        
        <div class="space-y-4">
          <div class="border border-gray-200 rounded-lg overflow-hidden">
            <button class="faq-question w-full py-4 px-6 text-left font-medium flex justify-between items-center focus:outline-none">
              <span>How accurate are your signals?</span>
              <i class="fas fa-chevron-down transform transition-transform duration-300"></i>
            </button>
            <div class="faq-answer px-6 pb-4 hidden">
              <p class="text-gray-700">Our signals have demonstrated an average accuracy of 87.3% over the past 12 months. We combine AI analysis with expert human oversight to ensure high-quality signals. However, remember that all trading involves risk, and past performance is not indicative of future results.</p>
            </div>
          </div>
          
          <div class="border border-gray-200 rounded-lg overflow-hidden">
            <button class="faq-question w-full py-4 px-6 text-left font-medium flex justify-between items-center focus:outline-none">
              <span>What's included in the signal package?</span>
              <i class="fas fa-chevron-down transform transition-transform duration-300"></i>
            </button>
            <div class="faq-answer px-6 pb-4 hidden">
              <p class="text-gray-700">Each signal package includes entry price ranges, take-profit targets, stop-loss recommendations, timeframe analysis, risk assessment, and fundamental factors affecting the asset. Higher tier signals provide additional features like personalized consultation and trading bot integration.</p>
            </div>
          </div>
          
          <div class="border border-gray-200 rounded-lg overflow-hidden">
            <button class="faq-question w-full py-4 px-6 text-left font-medium flex justify-between items-center focus:outline-none">
              <span>How often are signals sent?</span>
              <i class="fas fa-chevron-down transform transition-transform duration-300"></i>
            </button>
            <div class="faq-answer px-6 pb-4 hidden">
              <p class="text-gray-700">Signal frequency depends on market conditions and opportunities. On average, we send 5-10 high-quality signals per week. We prioritize quality over quantity, focusing only on trades with high probability of success.</p>
            </div>
          </div>
          
          <div class="border border-gray-200 rounded-lg overflow-hidden">
            <button class="faq-question w-full py-4 px-6 text-left font-medium flex justify-between items-center focus:outline-none">
              <span>How do I receive the signals after payment?</span>
              <i class="fas fa-chevron-down transform transition-transform duration-300"></i>
            </button>
            <div class="faq-answer px-6 pb-4 hidden">
              <p class="text-gray-700">After successful payment, you'll receive an email with login credentials to access your dashboard. Signals will be delivered via email, SMS, and our mobile app. You can also integrate with supported trading platforms for automated execution.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>

  <footer class="bg-gray-800 text-white py-12">
    <div class="container mx-auto px-4">
      <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
        <div>
          <h3 class="text-xl font-bold mb-4 flex items-center">
            <i class="fas fa-signal mr-2"></i>
            CryptoSignals
          </h3>
          <p class="text-gray-400 mb-4">Advanced AI-powered trading signals for cryptocurrency markets.</p>
          <div class="flex space-x-4">
            <a href="#" class="text-gray-400 hover:text-white"><i class="fab fa-twitter"></i></a>
            <a href="#" class="text-gray-400 hover:text-white"><i class="fab fa-telegram"></i></a>
            <a href="#" class="text-gray-400 hover:text-white"><i class="fab fa-discord"></i></a>
            <a href="#" class="text-gray-400 hover:text-white"><i class="fab fa-youtube"></i></a>
          </div>
        </div>
        
        <div>
          <h4 class="text-lg font-semibold mb-4">Quick Links</h4>
          <ul class="space-y-2">
            <li><a href="#" class="text-gray-400 hover:text-white">Home</a></li>
            <li><a href="#" class="text-gray-400 hover:text-white">Pricing</a></li>
            <li><a href="#" class="text-gray-400 hover:text-white">Signal Performance</a></li>
            <li><a href="#" class="text-gray-400 hover:text-white">Trading Academy</a></li>
            <li><a href="#" class="text-gray-400 hover:text-white">Contact Us</a></li>
          </ul>
        </div>
        
        <div>
          <h4 class="text-lg font-semibold mb-4">Legal</h4>
          <ul class="space-y-2">
            <li><a href="#" class="text-gray-400 hover:text-white">Terms of Service</a></li>
            <li><a href="#" class="text-gray-400 hover:text-white">Privacy Policy</a></li>
            <li><a href="#" class="text-gray-400 hover:text-white">Risk Disclosure</a></li>
            <li><a href="#" class="text-gray-400 hover:text-white">Refund Policy</a></li>
          </ul>
        </div>
        
        <div>
          <h4 class="text-lg font-semibold mb-4">Newsletter</h4>
          <p class="text-gray-400 mb-4">Subscribe for market updates and exclusive signals.</p>
          <div class="flex">
            <input type="email" placeholder="Your email" class="p-2 w-full rounded-l-lg focus:outline-none text-gray-800">
            <button class="bg-custom-purple hover-custom-purple px-4 py-2 rounded-r-lg">
              <i class="fas fa-paper-plane"></i>
            </button>
          </div>
        </div>
      </div>
      
      <div class="border-t border-gray-700 mt-8 pt-8 text-center text-gray-500">
        <p>&copy; 2025 CryptoSignals. All rights reserved.</p>
        <p class="mt-2 text-sm">Disclaimer: Trading cryptocurrencies involves risk. Past performance does not guarantee future results.</p>
      </div>
    </div>
  </footer>

  <!-- Notification template (hidden) -->
  <div id="notification-template" class="notification bg-white shadow-lg rounded-lg hidden">
    <div class="flex p-4">
      <div class="flex-shrink-0 mr-3">
        <i class="notification-icon fas fa-bell text-custom-purple text-xl"></i>
      </div>
      <div class="flex-grow">
        <h4 class="notification-title font-bold"></h4>
        <p class="notification-message text-gray-600 text-sm"></p>
      </div>
      <button class="notification-close flex-shrink-0 ml-2 text-gray-400 hover:text-gray-600">
        <i class="fas fa-times"></i>
      </button>
    </div>
  </div>

  <script>
    // Initialize trading chart
    document.addEventListener('DOMContentLoaded', function() {
      // Trading chart setup with Chart.js
      const ctx = document.getElementById('tradingChart').getContext('2d');
      
      // Generate random price data for demonstration
      const generatePriceData = (count, basePrice, volatility) => {
        const data = [];
        let price = basePrice;
        
        for (let i = 0; i < count; i++) {
          const change = (Math.random() - 0.5) * volatility;
          price = Math.max(price + change, price * 0.95); // Prevent extreme drops
          data.push(price);
        }
        
        return data;
      };
      
      const timestamps = [];
      const now = new Date();
      for (let i = 120; i >= 0; i--) {
        const time = new Date(now - i * 5 * 60000); // 5-minute intervals
        timestamps.push(time.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' }));
      }
      
      const priceData = generatePriceData(121, 84487.69, 300);
      
      // Create gradient for chart area
      const gradient = ctx.createLinearGradient(0, 0, 0, 300);
      gradient.addColorStop(0, 'rgba(138, 43, 226, 0.4)');
      gradient.addColorStop(1, 'rgba(138, 43, 226, 0)');
      
      const tradingChart = new Chart(ctx, {
        type: 'line',
        data: {
          labels: timestamps,
          datasets: [{
            label: 'BTC/USDT',
            data: priceData,
            borderColor: '#8a2be2',
            borderWidth: 2,
            pointRadius: 0,
            pointHoverRadius: 5,
            pointHoverBackgroundColor: '#8a2be2',
            pointHoverBorderColor: '#ffffff',
            pointHoverBorderWidth: 2,
            tension: 0.4,
            fill: true,
            backgroundColor: gradient
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          interaction: {
            mode: 'index',
            intersect: false,
          },
          plugins: {
            legend: {
              display: false
            },
            tooltip: {
              backgroundColor: 'rgba(255, 255, 255, 0.9)',
              titleColor: '#333',
              bodyColor: '#666',
              borderColor: '#ddd',
              borderWidth: 1,
              padding: 10,
              displayColors: false,
              callbacks: {
                label: function(context) {
                  return `$${context.parsed.y.toFixed(2)}`;
                }
              }
            }
          },
          scales: {
            x: {
              grid: {
                display: false
              },
              ticks: {
                maxRotation: 0,
                autoSkip: true,
                maxTicksLimit: 8
              }
            },
            y: {
              position: 'right',
              grid: {
                color: 'rgba(0, 0, 0, 0.05)'
              },
              ticks: {
                callback: function(value) {
                  return '$' + value.toLocaleString();
                }
              }
            }
          }
        }
      });
      
      // Initialize order book with random data
      function generateOrderBook() {
        const currentPrice = 84487.69;
        const buyOrders = [];
        const sellOrders = [];
        
        let buyPrice = currentPrice;
        let sellPrice = currentPrice;
        
        for (let i = 0; i < 10; i++) {
          buyPrice -= Math.random() * 20 + 5;
          const buyAmount = +(Math.random() * 0.5 + 0.05).toFixed(4);
          buyOrders.push({
            price: buyPrice.toFixed(2),
            amount: buyAmount,
            total: (buyPrice * buyAmount).toFixed(2)
          });
          
          sellPrice += Math.random() * 20 + 5;
          const sellAmount = +(Math.random() * 0.5 + 0.05).toFixed(4);
          sellOrders.push({
            price: sellPrice.toFixed(2),
            amount: sellAmount,
            total: (sellPrice * sellAmount).toFixed(2)
          });
        }
        
        return { buyOrders, sellOrders };
      }
      
      function renderOrderBook() {
        const { buyOrders, sellOrders } = generateOrderBook();
        const buyOrdersElement = document.getElementById('buy-orders');
        const sellOrdersElement = document.getElementById('sell-orders');
        
        buyOrdersElement.innerHTML = '';
        sellOrdersElement.innerHTML = '';
        
        buyOrders.forEach(order => {
          const row = document.createElement('div');
          row.className = 'order-book-row order-book-buy flex justify-between py-1 px-1 text-sm';
          row.innerHTML = `
            <span class="text-green-500 font-medium">$${order.price}</span>
            <span>${order.amount}</span>
            <span>$${order.total}</span>
          `;
          buyOrdersElement.appendChild(row);
        });
        
        // Reverse sell orders to show highest price at bottom
        sellOrders.reverse().forEach(order => {
          const row = document.createElement('div');
          row.className = 'order-book-row order-book-sell flex justify-between py-1 px-1 text-sm';
          row.innerHTML = `
            <span class="text-red-500 font-medium">$${order.price}</span>
            <span>${order.amount}</span>
            <span>$${order.total}</span>
          `;
          sellOrdersElement.appendChild(row);
        });
        
        // Simulate occasional order updates
        setInterval(() => {
          const allRows = document.querySelectorAll('.order-book-row');
          const randomRow = allRows[Math.floor(Math.random() * allRows.length)];
          if (randomRow.classList.contains('order-book-buy')) {
            randomRow.classList.add('flash-green');
            setTimeout(() => {
              randomRow.classList.remove('flash-green');
            }, 500);
          } else {
            randomRow.classList.add('flash-red');
            setTimeout(() => {
              randomRow.classList.remove('flash-red');
            }, 500);
          }
        }, 3000);
      }
      
      renderOrderBook();
      
      // Multi-step form navigation
      const step1 = document.getElementById('step1');
      const step2 = document.getElementById('step2');
      const step3 = document.getElementById('step3');
      const step2Indicator = document.getElementById('step2-indicator');
      const step3Indicator = document.getElementById('step3-indicator');
      
      document.getElementById('next-to-payment').addEventListener('click', () => {
        step1.classList.add('hidden');
        step2.classList.remove('hidden');
        step2.classList.add('animate__fadeIn');
        step2Indicator.classList.remove('bg-gray-300', 'text-gray-600');
        step2Indicator.classList.add('bg-custom-purple', 'text-white');
      });
      
      document.getElementById('back-to-signal').addEventListener('click', () => {
        step2.classList.add('hidden');
        step1.classList.remove('hidden');
        step2Indicator.classList.remove('bg-custom-purple', 'text-white');
        step2Indicator.classList.add('bg-gray-300', 'text-gray-600');
      });
      
      document.getElementById('next-to-checkout').addEventListener('click', () => {
        step2.classList.add('hidden');
        step3.classList.remove('hidden');
        step3.classList.add('animate__fadeIn');
        step3Indicator.classList.remove('bg-gray-300', 'text-gray-600');
        step3Indicator.classList.add('bg-custom-purple', 'text-white');
        
        // Initialize QR code
        new QRCode(document.getElementById("qrcode"), {
          text: "bc1qxy2kgdygjrsqtzq2n0yrf2493p83kkfjhx0wlh",
          width: 128,
          height: 128,
          colorDark : "#8a2be2",
          colorLight : "#ffffff",
          correctLevel : QRCode.CorrectLevel.H
        });
        
        // Initialize countdown timer
        startCountdown(15 * 60); // 15 minutes
      });
      
      document.getElementById('back-to-crypto').addEventListener('click', () => {
        step3.classList.add('hidden');
        step2.classList.remove('hidden');
        step3Indicator.classList.remove('bg-custom-purple', 'text-white');
        step3Indicator.classList.add('bg-gray-300', 'text-gray-600');
      });
      
      // Signal strength slider
      const signalRange = document.getElementById('signal-range');
      const signalValue = document.getElementById('signal-value');
      const priceDisplay = document.getElementById('price-display');
      const signalQualityBar = document.getElementById('signal-quality-bar');
      const advancedFeature = document.getElementById('advanced-feature');
      const premiumFeature = document.getElementById('premium-feature');
      const eliteFeature1 = document.getElementById('elite-feature-1');
      const eliteFeature2 = document.getElementById('elite-feature-2');
      
      signalRange.addEventListener('input', updateSignalStrength);
      
      function updateSignalStrength() {
        const value = signalRange.value;
        signalValue.textContent = value;
        
      // Update price based on signal strength
let price;
if (value <= 0) {
  price = 300;
} else if (value < 25) {
  // From 300 to ~5,800 (300 + 220 * 25)
  price = 300 + (value * 220);
} else if (value < 50) {
  // From ~5,800 to ~16,300 (5800 + 420 * 25)
  price = 5800 + ((value - 25) * 420);
} else if (value < 75) {
  // From ~16,300 to ~31,300 (16300 + 600 * 25)
  price = 16300 + ((value - 50) * 600);
} else if (value <= 100) {
  // From ~31,300 to 50,000 (31300 + 750 * 25)
  price = 31300 + ((value - 75) * 750);
} else {
  // Clamp to max if value exceeds 100
  price = 50000;
}

        
        priceDisplay.textContent = `$${price.toLocaleString()} USD`;
        
        // Update signal quality bar
        signalQualityBar.style.width = `${value}%`;
        if (value < 25) {
          signalQualityBar.className = 'h-full signal-low';
        } else if (value < 50) {
          signalQualityBar.className = 'h-full signal-low';
        } else if (value < 75) {
          signalQualityBar.className = 'h-full signal-medium';
        } else {
          signalQualityBar.className = 'h-full signal-high';
        }
        
        // Update feature availability
        advancedFeature.style.opacity = value >= 25 ? '1' :
        // Update feature availability
advancedFeature.style.opacity = value >= 25 ? '1' : '0.5';
premiumFeature.style.opacity = value >= 50 ? '1' : '0.5';
eliteFeature1.style.opacity = value >= 75 ? '1' : '0.5';
eliteFeature2.style.opacity = value >= 90 ? '1' : '0.5';

// Update checkout information
document.getElementById('checkout-signal').textContent = value;
document.getElementById('checkout-price').textContent = `$${price.toLocaleString()} USD`;

// Update crypto amount based on current price
const btcPrice = 84487.69; // Current price from the display
const btcAmount = (price / btcPrice).toFixed(4);
document.getElementById('crypto-amount').textContent = `${btcAmount} BTC`;
document.getElementById('checkout-amount').textContent = `${btcAmount} BTC`;
}

// Copy wallet address function
document.getElementById('copy-address').addEventListener('click', function() {
  const walletAddress = document.getElementById('wallet-address');
  walletAddress.select();
  document.execCommand('copy');
  
  const copySuccess = document.getElementById('copy-success');
  copySuccess.style.opacity = '1';
  setTimeout(() => {
    copySuccess.style.opacity = '0';
  }, 2000);
});

// Countdown timer function
function startCountdown(seconds) {
  const minutesElement = document.getElementById('countdown-minutes');
  const secondsElement = document.getElementById('countdown-seconds');
  
  let timeLeft = seconds;
  
  const countdownInterval = setInterval(() => {
    const minutes = Math.floor(timeLeft / 60);
    const secs = timeLeft % 60;
    
    minutesElement.textContent = minutes.toString().padStart(2, '0');
    secondsElement.textContent = secs.toString().padStart(2, '0');
    
    if (timeLeft <= 0) {
      clearInterval(countdownInterval);
      showNotification('Payment time expired', 'Please start a new transaction to continue.', 'warning');
    }
    
    timeLeft--;
  }, 1000);
}

// Simulate payment for demo purposes
document.getElementById('simulate-payment').addEventListener('click', function() {
  const waitingPayment = document.getElementById('waiting-payment');
  const confirmingPayment = document.getElementById('confirming-payment');
  const signalDelivery = document.getElementById('signal-delivery');
  
  // Update waiting for payment status
  waitingPayment.querySelector('div').classList.remove('bg-yellow-500');
  waitingPayment.querySelector('div').classList.add('bg-green-500');
  waitingPayment.querySelector('i').classList.remove('fa-clock');
  waitingPayment.querySelector('i').classList.add('fa-check');
  
  showNotification('Payment detected', 'Your transaction has been received and is being processed.', 'success');
  
  // Update confirming transaction status
  setTimeout(() => {
    confirmingPayment.style.opacity = '1';
    confirmingPayment.querySelector('div').classList.remove('bg-gray-300');
    confirmingPayment.querySelector('div').classList.add('bg-yellow-500');
    confirmingPayment.querySelector('i').classList.remove('fa-spinner');
    confirmingPayment.querySelector('i').classList.add('fa-clock');
    
    setTimeout(() => {
      confirmingPayment.querySelector('div').classList.remove('bg-yellow-500');
      confirmingPayment.querySelector('div').classList.add('bg-green-500');
      confirmingPayment.querySelector('i').classList.remove('fa-clock');
      confirmingPayment.querySelector('i').classList.add('fa-check');
      
      showNotification('Payment confirmed', 'Your transaction has been confirmed on the blockchain.', 'success');
      
      // Update signal delivery status
      setTimeout(() => {
        signalDelivery.style.opacity = '1';
        signalDelivery.querySelector('div').classList.remove('bg-gray-300');
        signalDelivery.querySelector('div').classList.add('bg-yellow-500');
        signalDelivery.querySelector('i').classList.remove('fa-paper-plane');
        signalDelivery.querySelector('i').classList.add('fa-clock');
        
        setTimeout(() => {
          signalDelivery.querySelector('div').classList.remove('bg-yellow-500');
          signalDelivery.querySelector('div').classList.add('bg-green-500');
          signalDelivery.querySelector('i').classList.remove('fa-clock');
          signalDelivery.querySelector('i').classList.add('fa-check');
          
          showNotification('Signal delivered', 'Check your email and dashboard for your premium signal package!', 'success');
          
          // Redirect to success page or show success message
          setTimeout(() => {
            window.location.href = 'success.html';
          }, 3000);
        }, 2000);
      }, 1500);
    }, 3000);
  }, 2000);
});

// Display notifications
function showNotification(title, message, type) {
  const template = document.getElementById('notification-template');
  const notification = template.cloneNode(true);
  
  notification.removeAttribute('id');
  notification.classList.remove('hidden');
  
  notification.querySelector('.notification-title').textContent = title;
  notification.querySelector('.notification-message').textContent = message;
  
  const icon = notification.querySelector('.notification-icon');
  icon.classList.remove('fa-bell');
  
  if (type === 'success') {
    icon.classList.add('fa-check-circle');
    icon.classList.add('text-green-500');
  } else if (type === 'warning') {
    icon.classList.add('fa-exclamation-triangle');
    icon.classList.add('text-yellow-500');
  } else if (type === 'error') {
    icon.classList.add('fa-times-circle');
    icon.classList.add('text-red-500');
  }
  
  document.body.appendChild(notification);
  
  // Position notification at the top right
  notification.style.position = 'fixed';
  notification.style.top = '20px';
  notification.style.right = '20px';
  notification.style.zIndex = '9999';
  notification.style.maxWidth = '300px';
  
  // Add animation
  notification.classList.add('animate__animated', 'animate__fadeInRight');
  
  // Remove notification after a delay
  setTimeout(() => {
    notification.classList.remove('animate__fadeInRight');
    notification.classList.add('animate__fadeOutRight');
    setTimeout(() => {
      notification.remove();
    }, 500);
  }, 5000);
  
  // Close notification when clicking the close button
  notification.querySelector('.notification-close').addEventListener('click', () => {
    notification.classList.remove('animate__fadeInRight');
    notification.classList.add('animate__fadeOutRight');
    setTimeout(() => {
      notification.remove();
    }, 500);
  });
}

// Initialize FAQ accordion
const faqQuestions = document.querySelectorAll('.faq-question');
faqQuestions.forEach(question => {
  question.addEventListener('click', () => {
    const answer = question.nextElementSibling;
    const icon = question.querySelector('i');
    
    answer.classList.toggle('hidden');
    icon.classList.toggle('transform');
    icon.classList.toggle('rotate-180');
  });
});

// Show random notifications for marketing effect
setTimeout(() => {
  const notifications = [
    { title: 'New signal released', message: 'BTC long position opened with 3.5x potential ROI', type: 'success' },
    { title: 'Signal target hit', message: 'ETH signal reached Take Profit 2 (+18.7%)', type: 'success' },
    { title: 'Limited time offer', message: '25% discount on Premium signals package ends in 24 hours', type: 'warning' }
  ];
  
  const randomNotification = notifications[Math.floor(Math.random() * notifications.length)];
  showNotification(randomNotification.title, randomNotification.message, randomNotification.type);
}, 10000);

// Initialize the signal strength display on page load
updateSignalStrength();
});
</script>
</html>
</body>