<?php
include 'config.php';

if (isset($_POST['submit'])) {
    // Retrieve form inputs
    $name = $_POST['name'];
    $percentage = $_POST['percentage'];
    $type = $_POST['type'];

    // Image upload for new copy trader
    $target_dir = "copy_trader_images/";
    $uploaded_file_name = basename($_FILES["image"]["name"]);
    $target_file = $target_dir . $uploaded_file_name;

    // Move uploaded file to target directory
    if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
        $image_to_store = $uploaded_file_name;
    } else {
        die("Error uploading the image.");
    }

    // Insert new copy trader record
    $stmt = $conn->prepare("INSERT INTO copy_traders (name, image_url, percentage, type) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssds", $name, $image_to_store, $percentage, $type);
    $stmt->execute();
    $stmt->close();

    header("Location: copytrader.php");
    exit();
}

if (isset($_GET['delete'])) {
    // Delete copy trader record and remove associated image file
    $id_to_delete = intval($_GET['delete']);

    // Fetch the existing image filename to delete from server
    $stmt = $conn->prepare("SELECT image_url FROM copy_traders WHERE id = ?");
    $stmt->bind_param("i", $id_to_delete);
    $stmt->execute();
    $stmt->bind_result($old_image_filename);
    $stmt->fetch();
    $stmt->close();

    // Delete image file from disk, if it exists
    $file_path = "copy_trader_images/" . $old_image_filename;
    if (file_exists($file_path)) {
        unlink($file_path);
    }

    // Delete the database record
    $stmt_del = $conn->prepare("DELETE FROM copy_traders WHERE id = ?");
    $stmt_del->bind_param("i", $id_to_delete);
    $stmt_del->execute();
    $stmt_del->close();

    header("Location: copytrader.php");
    exit();
}

if (isset($_POST['update'])) {
    // Handle update of existing copy trader
    $id = intval($_POST['id']);
    $name = $_POST['name'];
    $percentage = $_POST['percentage'];
    $type = $_POST['type'];

    // Determine whether a new image has been uploaded
    if (!empty($_FILES["image"]["name"])) {
        // Delete old image first
        $stmt = $conn->prepare("SELECT image_url FROM copy_traders WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $stmt->bind_result($existing_image_filename);
        $stmt->fetch();
        $stmt->close();

        $existing_file_path = "copy_trader_images/" . $existing_image_filename;
        if (file_exists($existing_file_path)) {
            unlink($existing_file_path);
        }

        // Upload new image
        $target_dir = "copy_trader_images/";
        $new_uploaded_name = basename($_FILES["image"]["name"]);
        $target_file = $target_dir . $new_uploaded_name;

        if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
            $image_to_store = $new_uploaded_name;
        } else {
            die("Error uploading the new image.");
        }
    } else {
        // No new image uploaded; keep old image filename
        $image_to_store = $_POST['old_image'];
    }

    // Update database record
    $stmt_update = $conn->prepare("UPDATE copy_traders SET name = ?, image_url = ?, percentage = ?, type = ? WHERE id = ?");
    $stmt_update->bind_param("ssdsi", $name, $image_to_store, $percentage, $type, $id);
    $stmt_update->execute();
    $stmt_update->close();

    header("Location: copytrader.php");
    exit();
}
?>
