<?php
include 'config.php';

if (isset($_POST['submit'])) {
    // Retrieve form inputs
    $name = $_POST['name'];
    $percentage = $_POST['percentage'];
    $type = $_POST['type'];
    
    // Image upload for new copy trader
    $target_dir = "copy_trader_images/";
    $uploaded_file_name = basename($_FILES["image"]["name"]);
    $target_file = $target_dir . $uploaded_file_name;
    
    // Move uploaded file to target directory
    if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
        $image_to_store = $uploaded_file_name;
    } else {
        die("Error uploading the image.");
    }
    
    // Insert new copy trader record (PDO syntax)
    $stmt = $conn->prepare("INSERT INTO copy_traders (name, image_url, percentage, type) VALUES (?, ?, ?, ?)");
    $stmt->execute([$name, $image_to_store, $percentage, $type]);
    
    header("Location: copytrade.php");
    exit();
}

if (isset($_GET['delete'])) {
    // Delete copy trader record and remove associated image file
    $id_to_delete = intval($_GET['delete']);
    
    // Fetch the existing image filename to delete from server (PDO syntax)
    $stmt = $conn->prepare("SELECT image_url FROM copy_traders WHERE id = ?");
    $stmt->execute([$id_to_delete]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $old_image_filename = $result['image_url'] ?? '';
    
    // Delete image file from disk, if it exists
    if ($old_image_filename) {
        $file_path = "copy_trader_images/" . $old_image_filename;
        if (file_exists($file_path)) {
            unlink($file_path);
        }
    }
    
    // Delete the database record (PDO syntax)
    $stmt_del = $conn->prepare("DELETE FROM copy_traders WHERE id = ?");
    $stmt_del->execute([$id_to_delete]);
    
    header("Location: copytrade.php");
    exit();
}

if (isset($_POST['update'])) {
    // Handle update of existing copy trader
    $id = intval($_POST['id']);
    $name = $_POST['name'];
    $percentage = $_POST['percentage'];
    $type = $_POST['type'];
    
    // Determine whether a new image has been uploaded
    if (!empty($_FILES["image"]["name"])) {
        // Get old image first (PDO syntax)
        $stmt = $conn->prepare("SELECT image_url FROM copy_traders WHERE id = ?");
        $stmt->execute([$id]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $existing_image_filename = $result['image_url'] ?? '';
        
        // Delete old image
        if ($existing_image_filename) {
            $existing_file_path = "copy_trader_images/" . $existing_image_filename;
            if (file_exists($existing_file_path)) {
                unlink($existing_file_path);
            }
        }
        
        // Upload new image
        $target_dir = "copy_trader_images/";
        $new_uploaded_name = basename($_FILES["image"]["name"]);
        $target_file = $target_dir . $new_uploaded_name;
        
        if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
            $image_to_store = $new_uploaded_name;
        } else {
            die("Error uploading the new image.");
        }
    } else {
        // No new image uploaded; keep old image filename
        $image_to_store = $_POST['old_image'];
    }
    
    // Update database record (PDO syntax)
    $stmt_update = $conn->prepare("UPDATE copy_traders SET name = ?, image_url = ?, percentage = ?, type = ? WHERE id = ?");
    $stmt_update->execute([$name, $image_to_store, $percentage, $type, $id]);
    
    header("Location: copytrade.php");
    exit();
}

// Example of transaction usage with PDO (if needed elsewhere)
/*
try {
    $conn->beginTransaction();  // Note: beginTransaction() not begin_transaction()
    
    // Your database operations here
    
    $conn->commit();
} catch (Exception $e) {
    $conn->rollBack();
    throw $e;
}
*/
?>