<?php
session_start();
require 'config.php';

// Check if admin is logged in
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header("Location: login.php");
    exit();
}

// Verify IP restriction
$stmt = $conn->prepare("SELECT * FROM admins WHERE id = :id LIMIT 1");
$stmt->execute(['id' => $_SESSION['admin_id']]);
$admin = $stmt->fetch(PDO::FETCH_ASSOC);
$current_ip = $_SERVER['REMOTE_ADDR'];
if (!($current_ip !== $admin['ip1'] || $current_ip !== $admin['ip2'])) {
    die("Access denied from this IP address.");
}

if (!isset($_GET['table']) || !isset($_GET['id'])) {
    die('Table or record not specified.');
}

$table = $_GET['table'];
$id    = $_GET['id'];

$stmt = $conn->prepare("DELETE FROM `$table` WHERE id = ?");
$stmt->execute([$id]);

header("Location: manage.php?table=$table");
exit();
?>
