<?php
// header.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require 'config.php';

// Fetch all tables from your database
$tables = [];
try {
    $stmt = $conn->query("SHOW TABLES");
    while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
        $tables[] = $row[0];
    }
} catch (PDOException $e) {
    // In production, log errors instead of displaying
    $tables = [];
}



// Fetch record counts for each table
$tableCounts = [];
foreach ($tables as $table) {
    try {
        $stmt = $conn->query("SELECT COUNT(*) as count FROM `$table`");
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $tableCounts[$table] = $result['count'];
    } catch (PDOException $e) {
        $tableCounts[$table] = 'N/A';
    }
}

// Set a static last updated time for demo purposes
$lastUpdated = "13:15";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= isset($pageTitle) ? $pageTitle : "Admin Panel" ?></title>
  <!-- Favicon -->
  <link rel="icon" type="image/x-icon" href="<img src="data:image/svg+xml;charset=UTF-8,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20viewBox%3D%220%200%20448%20512%22%3E%3C!--!Font%20Awesome%20Free%206.7.2%20by%20%40fontawesome%20-%20https%3A//fontawesome.com%20License%20-%20https%3A//fontawesome.com/license/free%20Copyright%202025%20Fonticons%2C%20Inc.--%3E%3Cpath%20fill%3D%22%23ffffff%22%20d%3D%22M96%20128a128%20128%200%201%200%20256%200A128%20128%200%201%200%2096%20128zm94.5%20200.2l18.6%2031L175.8%20483.1l-36-146.9c-2-8.1-9.8-13.4-17.9-11.3C51.9%20342.4%200%20405.8%200%20481.3c0%2017%2013.8%2030.7%2030.7%2030.7l131.7%200c0%200%200%200%20.1%200l5.5%200%20112%200%205.5%200c0%200%200%200%20.1%200l131.7%200c17%200%2030.7-13.8%2030.7-30.7c0-75.5-51.9-138.9-121.9-156.4c-8.1-2-15.9%203.3-17.9%2011.3l-36%20146.9L238.9%20359.2l18.6-31c6.4-10.7-1.3-24.2-13.7-24.2L224%20304l-19.7%200c-12.4%200-20.1%2013.6-13.7%2024.2z%22/%3E%3C/svg%3E" alt="Logo" class="h-12 w-12">

  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    /* Preloader styles */
    #preloader {
      background: #fff;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      z-index: 9999;
      display: flex;
      align-items: center;
      justify-content: center;
      transition: opacity 0.5s ease;
    }
    #preloader.hidden {
      opacity: 0;
      pointer-events: none;
    }
    /* Mobile nav dropdown transition */
    #mobile-nav {
      transform-origin: top;
      transition: transform 0.3s ease;
    }
    .hidden-scale {
      transform: scaleY(0);
    }
    .visible-scale {
      transform: scaleY(1);
    }
  </style>
</head>
<body class="bg-gray-100">
  <!-- Preloader -->
  <div id="preloader">
    <div class="animate-spin rounded-full h-16 w-16 border-t-4 border-blue-500"></div>
  </div>

  
  

  <script>
    // Preloader fade-out
    window.addEventListener('load', function() {
      const preloader = document.getElementById('preloader');
      preloader.classList.add('hidden');
      setTimeout(() => { preloader.style.display = 'none'; }, 500);
    });

    // Mobile menu toggle functionality
    document.addEventListener('DOMContentLoaded', () => {
      const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
      const mobileNav = document.getElementById('mobile-nav');
      const menuIcon = document.getElementById('menu-icon');

      mobileMenuToggle.addEventListener('click', (e) => {
        e.stopPropagation();
        if (mobileNav.classList.contains('hidden-scale')) {
          mobileNav.classList.remove('hidden-scale');
          mobileNav.classList.add('visible-scale');
          mobileNav.classList.remove('hidden');
          menuIcon.classList.remove('fa-bars');
          menuIcon.classList.add('fa-times');
          mobileMenuToggle.setAttribute('aria-expanded', 'true');
        } else {
          mobileNav.classList.remove('visible-scale');
          mobileNav.classList.add('hidden-scale');
          menuIcon.classList.remove('fa-times');
          menuIcon.classList.add('fa-bars');
          mobileMenuToggle.setAttribute('aria-expanded', 'false');
          setTimeout(() => {
            if (mobileNav.classList.contains('hidden-scale')) {
              mobileNav.classList.add('hidden');
            }
          }, 300);
        }
      });

      // Close mobile nav when clicking outside
      document.addEventListener('click', (e) => {
        if (!mobileNav.contains(e.target) && !mobileMenuToggle.contains(e.target)) {
          if (!mobileNav.classList.contains('hidden-scale')) {
            mobileNav.classList.remove('visible-scale');
            mobileNav.classList.add('hidden-scale');
            menuIcon.classList.remove('fa-times');
            menuIcon.classList.add('fa-bars');
            mobileMenuToggle.setAttribute('aria-expanded', 'false');
            setTimeout(() => {
              if (mobileNav.classList.contains('hidden-scale')) {
                mobileNav.classList.add('hidden');
              }
            }, 300);
          }
        }
      });
    });
  </script>
