<?php
$pageTitle = "Insert Record";
include 'header.php';
require 'config.php';

// Check if admin is logged in
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header("Location: login.php");
    exit();
}

if (!isset($_GET['table'])) {
    die('Table not specified.');
}

$table = $_GET['table'];

// Get columns (including type) except auto_increment fields
$stmt = $conn->prepare("SHOW COLUMNS FROM `$table`");
$stmt->execute();
$columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
$fields = [];
foreach ($columns as $col) {
    if ($col['Extra'] != 'auto_increment') {
        // Save both field name and its type
        $fields[] = ['name' => $col['Field'], 'type' => $col['Type']];
    }
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $values = [];
    $fieldNames = [];
    foreach ($fields as $field) {
        $fieldNames[] = $field['name'];
        // Handle image fields separately
        if (stripos($field['name'], 'image') !== false) {
            if (isset($_FILES[$field['name']]) && $_FILES[$field['name']]['error'] === UPLOAD_ERR_OK) {
                $fileTmpPath = $_FILES[$field['name']]['tmp_name'];
                $fileName = basename($_FILES[$field['name']]['name']);
                // Optionally, sanitize $fileName here
                $dest_path = "../uploads/" . $fileName;
                if (move_uploaded_file($fileTmpPath, $dest_path)) {
                    $values[] = $fileName; // Save only the filename
                } else {
                    $values[] = null;
                }
            } else {
                // If no file was uploaded, use posted value if any, else null.
                $values[] = $_POST[$field['name']] ?? null;
            }
        } else {
            $values[] = $_POST[$field['name']] ?? null;
        }
    }
    $placeholders = rtrim(str_repeat('?,', count($fields)), ',');
    $sql = "INSERT INTO `$table` (" . implode(',', $fieldNames) . ") VALUES ($placeholders)";
    $stmt = $conn->prepare($sql);
    if ($stmt->execute($values)) {
        header("Location: index.php?table=$table");
        exit();
    } else {
        $errorInfo = $stmt->errorInfo();
        $error = "Error inserting record: " . implode(" - ", $errorInfo);
    }
}
?>
<main class="container mx-auto p-8">
  <div class="mb-6">
    <h2 class="text-2xl font-bold">Insert New Record into <?= ucfirst($table) ?></h2>
  </div>
  <?php if ($error): ?>
    <div class="bg-red-100 text-red-700 p-2 rounded mb-4"><?= $error ?></div>
  <?php endif; ?>
  <!-- Form uses multipart/form-data for file uploads -->
  <form method="POST" action="" enctype="multipart/form-data">
    <?php foreach ($fields as $field): ?>
      <div class="mb-4">
        <label class="block text-gray-700"><?= ucfirst($field['name']) ?></label>
        <?php
          // Determine input type based on column type and field name
          $inputType = "text";
          $colType = strtolower($field['type']);
          if (stripos($field['name'], 'image') !== false) {
              // For image fields, use a file input
              echo '<input type="file" name="' . $field['name'] . '" class="mt-1 w-full border rounded p-2">';
          } else {
              if (strpos($colType, 'datetime') !== false || strpos($colType, 'timestamp') !== false) {
                  $inputType = "datetime-local";
              } elseif (strpos($colType, 'date') !== false) {
                  $inputType = "date";
              } elseif (strpos($colType, 'time') !== false && strpos($colType, 'date') === false) {
                  $inputType = "time";
              }
              echo '<input type="' . $inputType . '" name="' . $field['name'] . '" value="' . htmlspecialchars($_POST[$field['name']] ?? '') . '" class="mt-1 w-full border rounded p-2">';
          }
        ?>
      </div>
    <?php endforeach; ?>
    <div class="flex space-x-4">
      <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700">
        <i class="fas fa-plus mr-2"></i>Insert Record
      </button>
      <a href="manage.php?table=<?= $table ?>" class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">
        Cancel
      </a>
    </div>
  </form>
</main>
<?php include 'footer.php'; ?>
