<?php
// Secure session cookie parameters
session_set_cookie_params([
    'lifetime' => 0,
    'path' => '/',
    'domain' => $_SERVER['HTTP_HOST'],
    'secure' => true,
    'httponly' => true,
    'samesite' => 'Lax'
]);
session_start();

// Force HTTPS
if (empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] == "off") {
    $redirect = 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    header('HTTP/1.1 301 Moved Permanently');
    header('Location: ' . $redirect);
    exit();
}

// Set security headers
header("Strict-Transport-Security: max-age=31536000; includeSubDomains; preload");
header("X-Content-Type-Options: nosniff");
header("X-Frame-Options: DENY");
header("X-XSS-Protection: 1; mode=block");

// Continue with your login page logic...
?>
<?php
session_start();
require 'config.php';

// Redirect if already logged in
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in']) {
    header("Location: index.php");
    exit();
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $error = "Both fields are required.";
    } else {
        $stmt = $conn->prepare("SELECT * FROM admins WHERE username = :username LIMIT 1");
        $stmt->execute(['username' => $username]);
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($admin && password_verify($password, $admin['password'])) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_id'] = $admin['id'];
            $_SESSION['admin_username'] = $admin['username'];
            $_SESSION['admin_email'] = $admin['email'];
            header("Location: index.php");
            exit();
        } else {
            $error = "Invalid credentials.";
        }
    }
}

$pageTitle = "Admin Login";
include 'headers.php';
?>
<main class="container mx-auto p-8 flex flex-col items-center">
  <div class="bg-white p-8 rounded shadow-md w-full max-w-md">
    <div class="flex justify-center mb-4">
      <img src="data:image/svg+xml;charset=UTF-8,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20viewBox%3D%220%200%20448%20512%22%3E%3Cpath%20fill%3D%22%23003ca3%22%20d%3D%22M96%20128a128%20128%200%201%200%20256%200A128%20128%200%201%200%2096%20128zm94.5%20200.2l18.6%2031L175.8%20483.1l-36-146.9c-2-8.1-9.8-13.4-17.9-11.3C51.9%20342.4%200%20405.8%200%20481.3c0%2017%2013.8%2030.7%2030.7%2030.7l131.7%200c0%200%200%200%20.1%200l5.5%200%20112%200%205.5%200c0%200%200%200%20.1%200l131.7%200c17%200%2030.7-13.8%2030.7-30.7c0-75.5-51.9-138.9-121.9-156.4c-8.1-2-15.9%203.3-17.9%2011.3l-36%20146.9L238.9%20359.2l18.6-31c6.4-10.7-1.3-24.2-13.7-24.2L224%20304l-19.7%200c-12.4%200-20.1%2013.6-13.7%2024.2z%22/%3E%3C/svg%3E" alt="Logo" class="h-12 w-12">
    </div>
    <h2 class="text-2xl font-bold text-center mb-6">Admin Login</h2>
    <?php if ($error): ?>
      <script>
        Swal.fire({
          icon: 'error',
          title: 'Error',
          text: '<?= $error ?>'
        });
      </script>
      <div class="bg-red-100 text-red-700 p-2 rounded mb-4"><?= $error ?></div>
    <?php endif; ?>
    <form method="POST" action="">
      <div class="mb-4">
        <label class="block text-gray-700">Username</label>
        <input type="text" name="username" class="mt-1 w-full border rounded p-2" required>
      </div>
      <div class="mb-4">
        <label class="block text-gray-700">Password</label>
        <input type="password" name="password" class="mt-1 w-full border rounded p-2" required>
      </div>
      <button type="submit" class="w-full bg-indigo-600 text-white rounded p-2 hover:bg-indigo-700">
        <i class="fas fa-sign-in-alt mr-2"></i>Login
      </button>
    </form>
  </div>
</main>
<?php include 'footer.php'; ?>
