<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Blockchain Explorer Search</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    .crypto-option {
      cursor: pointer;
      padding: 10px;
      border: 2px solid transparent;
      border-radius: 10px;
      text-align: center;
      transition: all 0.3s ease;
    }
    .crypto-option:hover,
    .crypto-option.selected {
      border-color: #007bff;
      background-color: #e0f2ff;
    }
    .crypto-option img {
      width: 40px;
      height: 40px;
      margin-bottom: 5px;
    }
  </style>
  
   <!-- Favicon -->
  <link rel="icon" href="https://primemarketspro.com/session/favicon.png" type="image/x-icon">
</head>
<body class="bg-gray-100">
  <div class="container mx-auto p-6">
    <div class="max-w-md mx-auto bg-white p-6 rounded shadow">
      <h1 class="text-2xl font-bold mb-4 text-center">Blockchain Explorer</h1>
      
      <!-- Display Error Message -->
      <?php if (isset($_GET['error'])): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
          <p><?php echo htmlspecialchars($_GET['error']); ?></p>
        </div>
      <?php endif; ?>

      <form action="blockchain_details.php" method="GET" class="space-y-4">
        <div>
          <label for="transhash" class="block text-gray-700">Transaction Hash</label>
          <input type="text" id="transhash" name="transhash" required placeholder="Enter transaction hash" class="w-full p-2 border border-gray-300 rounded focus:outline-none focus:border-blue-500">
        </div>

        <div>
          <label class="block text-gray-700">Select Network</label>
          <div class="grid grid-cols-4 gap-2 mt-2">
            <div class="crypto-option" data-value="bitcoin">
              <img src="https://primemarketspro.com/cryptos/bitcoin.png" alt="Bitcoin">
              <p class="text-sm">Bitcoin</p>
            </div>
            <div class="crypto-option" data-value="ethereum">
              <img src="https://primemarketspro.com/cryptos/eth.png" alt="Ethereum">
              <p class="text-sm">Ethereum</p>
            </div>
            <div class="crypto-option" data-value="tron">
              <img src="https://primemarketspro.com/cryptos/trx.png" alt="TRON">
              <p class="text-sm">TRON</p>
            </div>
            <div class="crypto-option" data-value="ripple">
              <img src="https://primemarketspro.com/cryptos/xrp.png" alt="Ripple">
              <p class="text-sm">XRP</p>
            </div>
            <div class="crypto-option" data-value="litecoin">
              <img src="https://primemarketspro.com/cryptos/ltc.png" alt="Litecoin">
              <p class="text-sm">Litecoin</p>
            </div>
            <div class="crypto-option" data-value="dogecoin">
              <img src="https://primemarketspro.com/cryptos/doge.png" alt="Dogecoin">
              <p class="text-sm">Dogecoin</p>
            </div>
            <div class="crypto-option" data-value="bitcoin-cash">
              <img src="https://primemarketspro.com/cryptos/bch.png" alt="Bitcoin Cash">
              <p class="text-sm">Bitcoin Cash</p>
            </div>
          </div>
          <input type="hidden" id="network" name="network" required>
        </div>

        <button type="submit" class="w-full bg-blue-600 text-white p-2 rounded hover:bg-blue-700">Search Transaction</button>
      </form>
    </div>
  </div>

  <script>
    document.querySelectorAll('.crypto-option').forEach(option => {
      option.addEventListener('click', function () {
        document.querySelectorAll('.crypto-option').forEach(opt => opt.classList.remove('selected'));
        this.classList.add('selected');
        document.getElementById('network').value = this.dataset.value;
      });
    });
  </script>
</body>
</html>