<?php
// Initialize session if needed
session_start();

// Database connection
function connectDB() {
    $host = "localhost";     // replace with your database host
    $username = "wptlgmnb_userp";    // replace with your database username
    $password = "Qliox4ITygj6Vh4V";    // replace with your database password
    $dbname = "wptlgmnb_dbp";      // replace with your database name

    // Create connection
    $conn = new mysqli($host, $username, $password, $dbname);
    
    // Check connection
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    
    return $conn;
}

// Sanitize input function
function sanitizeInput($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

// Main processing logic
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect and sanitize input
    $transId = isset($_POST['trans']) ? sanitizeInput($_POST['trans']) : '';
    $status = isset($_POST['status']) ? sanitizeInput($_POST['status']) : '';
    
    // Validate input
    if (empty($transId)) {
        die("Error: Transaction ID is required");
    }
    
    // Connect to database
    $conn = connectDB();
    
    // Prepare SQL to check if transaction exists and its status
    $sql = "SELECT * FROM buysignal WHERE transaction_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $transId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        // Transaction found, check status
        $row = $result->fetch_assoc();
        $currentStatus = $row['status']; // Assuming 'status' is the column name
        
        if ($currentStatus == 'complete') {
            // Transaction is confirmed
            $_SESSION['transaction_status'] = 'confirmed';
            $_SESSION['transaction_details'] = $row;
            
            // Close database connection
            $stmt->close();
            $conn->close();
            
            // Redirect to success page
            header("Location: success.php?id=" . urlencode($transId));
            exit();
        } else {
            // Transaction exists but not complete
            $_SESSION['transaction_status'] = 'pending';
            $_SESSION['error_message'] = 'Transaction not yet confirmed. Please wait.';
            
            // Close database connection
            $stmt->close();
            $conn->close();
            
            // Redirect back to waiting page or show message
            header("Location: payment.php?id=" . urlencode($transId) . "&status=waiting");
            exit();
        }
    } else {
        // Transaction not found
        $_SESSION['transaction_status'] = 'not_found';
        $_SESSION['error_message'] = 'Transaction not found. Please check your details.';
        
        // Close database connection
        $stmt->close();
        $conn->close();
        
        // Redirect to error page
        header("Location: payment.php?error=transaction_not_found");
        exit();
    }
} else {
    // Not a POST request
    header("Location: index.php");
    exit();
}
?>