<?php
// Enable error reporting (for development only)
// Remove or disable in production
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in; if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$usd_balance    = isset($userDetails['balance']) ? (float)$userDetails['balance'] : 0.00;
$btc            = isset($userDetails['btc']) ? (float)$userDetails['btc'] : 0.000000;
$eth            = isset($userDetails['eth']) ? (float)$userDetails['eth'] : 0.000000;
$usdt           = isset($userDetails['usdt']) ? (float)$userDetails['usdt'] : 0.000000;
$xrp            = isset($userDetails['xrp']) ? (float)$userDetails['xrp'] : 0.000000;
$doge           = isset($userDetails['doge']) ? (float)$userDetails['doge'] : 0.000000;
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

// Define cache file and cache duration (2 hours)
$cache_file = "doge_price_cache.json";
$cache_duration = 7200; // 2 hours

// Function to fetch DOGE price from CoinGecko API using cURL
function fetch_doge_price() {
    $api_url = "https://api.coingecko.com/api/v3/simple/price?ids=dogecoin&vs_currencies=usd";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Ignore SSL verification issues
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Timeout after 10 seconds
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Ensure response is valid and HTTP status code is 200 (OK)
    if ($http_code == 200 && $response) {
        return json_decode($response, true);
    }
    return false;
}

// Use cache if valid
if (file_exists($cache_file) && (time() - filemtime($cache_file)) < $cache_duration) {
    $data = json_decode(file_get_contents($cache_file), true);
} else {
    // Fetch fresh DOGE price
    $data = fetch_doge_price();

    // Store new price in cache if valid
    if ($data && isset($data['dogecoin']['usd'])) {
        file_put_contents($cache_file, json_encode($data));
    }
}

// Ensure DOGE price is available
$doge_price = $data['dogecoin']['usd'] ?? null;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dogecoin (DOGE) | primemarketspro.com</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
    <link rel="icon" href="https://primemarketspro.com/session/favicon.png" type="image/x-icon">
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <style>
        .doge-bg { background-color: #C2A633; }
        .doge-text { color: #C2A633; }
        .btn-doge {
            background: linear-gradient(135deg, #C2A633 0%, #E6D555 100%);
            color: white;
            transition: all 0.3s;
            border: none;
        }
        .btn-doge:hover {
            background: linear-gradient(135deg, #A8901F 0%, #C2A633 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(194, 166, 51, 0.3);
        }
        .tradingview-widget-container {
            width: 100%;
            min-height: 450px;
        }
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        .progress-bar {
            height: 4px;
            background-color: #e2e8f0;
            border-radius: 2px;
            overflow: hidden;
        }
        .progress-value {
            height: 100%;
            background: linear-gradient(90deg, #C2A633 0%, #E6D555 100%);
            transition: width 0.5s ease;
        }
        .description-collapse {
            max-height: 100px;
            overflow: hidden;
            position: relative;
        }
        .description-collapse::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 40px;
            background: linear-gradient(to top, rgba(255,255,255,1), rgba(255,255,255,0));
        }
        .description-expanded {
            max-height: none;
        }
        .fun-indicator {
            background: linear-gradient(135deg, #C2A633 0%, #E6D555 100%);
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            display: inline-block;
            margin-top: 4px;
        }
        .doge-card {
            background: linear-gradient(135deg, #FFF8E1 0%, #FFFACD 100%);
            border: 2px solid #E6D555;
        }
        .wow-text {
            font-family: 'Comic Sans MS', cursive, sans-serif;
            color: #C2A633;
            font-weight: bold;
        }
        .price-bounce {
            animation: bounce 2s infinite;
        }
        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
            40% { transform: translateY(-10px); }
            60% { transform: translateY(-5px); }
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen p-4">
    <div class="max-w-4xl mx-auto bg-white p-4 md:p-6 rounded-2xl shadow-sm">
        <!-- Header -->
        <header class="flex items-center justify-between mb-8">
            <button onclick="history.back()" class="doge-text p-2 rounded-full hover:bg-gray-100 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                </svg>
            </button>
            <h1 class="text-xl font-semibold text-gray-800 flex items-center">
                <img src="https://primemarketspro.com/cryptos/doge.png" class="w-8 h-8 mr-2" alt="Dogecoin">
                Dogecoin (DOGE)
            </h1>
            <div class="p-2 rounded-full hover:bg-gray-100 transition-colors">
                <div id="connection-status" class="w-3 h-3 rounded-full bg-green-500"></div>
            </div>
        </header>

        <!-- Price Section -->
        <section class="text-center mb-8 fade-in">
            <div class="price-text text-4xl font-bold mb-2 flex items-center justify-center">
                <span id="doge-price" class="text-gray-800">$0.000</span>
                <span id="doge-arrow" class="ml-2"></span>
            </div>
            <div id="doge-change" class="text-lg font-medium text-gray-600">0.00% (24h)</div>
            <div class="fun-indicator">
                🐕 Much Wow, Very Crypto!
            </div>
            <div class="text-sm font-medium text-blue-500 mt-2">
                1 USD ≈ <span id="doge-equivalent" class="text-gray-700">0.00 DOGE</span>
            </div>
            <div class="wow-text text-xs mt-2">Such digital currency. Much decentralized. Wow!</div>
        </section>

       
      <!-- TradingView Widget Section -->
<section class="mb-6" style="width: 100%;">
    <div class="tradingview-widget-container" style="width: 100%; height: 420px;">
        <div class="tradingview-widget-container__widget" style="width: 100%; height: 100%;"></div>
        <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-mini-symbol-overview.js" async>
        {
            "symbol": "BINANCE:DOGEUSD",
            "width": "100%",
            "height": "250",
            "locale": "en",
            "dateRange": "12M",
            "colorTheme": "light",
            "isTransparent": true,
            "autosize": false,
            "largeChartUrl": ""
        }
        </script>
    </div>
</section>


        <!-- Wallet Card -->
        <section class="wallet-card doge-card rounded-xl p-6 mb-8 fade-in">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm">Your DOGE Balance</p>
                    <h2 class="text-2xl font-bold text-gray-800 mt-1">
                        <?php echo number_format($doge, 2); ?> DOGE
                    </h2>
                    <p class="text-gray-600 mt-1">
                        ≈ $<span id="doge-balance-usd"><?php echo number_format($doge * 1.00, 2); // Initial estimate ?></span> USD
                    </p>
                    <p class="wow-text text-xs mt-1">Very balance. Much holdings!</p>
                </div>
                <img src="https://primemarketspro.com/cryptos/doge.png" class="w-12 h-12" alt="Dogecoin">
            </div>
            <div class="mt-4 flex space-x-2">
                <a href="doges.php" class="btn-doge py-3 px-6 rounded-xl text-center font-medium flex-1">
                    <i class="fas fa-arrow-up mr-2"></i>Send
                </a>
                <a href="doger.php" class="btn-doge py-3 px-6 rounded-xl text-center font-medium flex-1">
                    <i class="fas fa-arrow-down mr-2"></i>Receive
                </a>
            </div>
        </section>

        <!-- Market Data -->
        <section class="bg-gray-50 rounded-xl p-6 mb-8 fade-in">
            <h3 class="font-semibold text-gray-800 mb-4">Market Overview</h3>
            <div class="space-y-4 text-sm">
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Market Cap Rank</span>
                        <span id="market-cap-rank">#8</span>
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Market Cap</span>
                        <span id="market-cap">$0</span>
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>24h Volume</span>
                        <span id="volume">$0</span>
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Circulating Supply</span>
                        <span id="supply">0 DOGE</span>
                    </div>
                    <div class="progress-bar mt-1">
                        <div id="supply-progress" class="progress-value" style="width: 100%"></div>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        <span id="circulating-supply">0</span> DOGE in circulation
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Community Status</span>
                        <span id="community-status" class="text-yellow-600 font-medium">Very Active</span>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        Strong meme community support
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Block Time</span>
                        <span id="block-time" class="text-green-600 font-medium">~1 minute</span>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        Average block generation time
                    </div>
                </div>
            </div>
        </section>

        <!-- Fun Facts Info -->
        <section class="bg-yellow-50 border border-yellow-200 rounded-xl p-6 mb-8 fade-in">
            <div class="flex items-start space-x-3">
                <div class="w-8 h-8 bg-yellow-100 rounded-full flex items-center justify-center flex-shrink-0">
                    <span class="text-yellow-600 text-lg">🐕</span>
                </div>
                <div>
                    <h4 class="font-semibold text-yellow-800 mb-1">The People's Cryptocurrency</h4>
                    <p class="text-sm text-yellow-700">
                        Originally created as a joke in 2013, Dogecoin has evolved into a legitimate digital currency with a passionate community. Known for its fun, friendly approach and charitable initiatives.
                    </p>
                    <div class="wow-text text-xs mt-2">Much community. Such generosity. Very moon!</div>
                </div>
            </div>
        </section>

        <!-- About Section -->
        <section class="mb-8 fade-in">
            <div class="flex justify-between items-center mb-4">
                <h3 class="font-semibold text-gray-800">About Dogecoin</h3>
                <button id="toggle-description" class="text-blue-500 text-sm font-medium">Show More</button>
            </div>
            <div id="description-content" class="description-collapse text-gray-600 text-sm leading-relaxed">
                Loading Dogecoin description...
            </div>
        </section>

        <!-- Official Links -->
        <section class="fade-in">
            <h3 class="font-semibold text-gray-800 mb-4">Resources</h3>
            <div class="grid grid-cols-2 gap-3">
                <a href="https://dogecoin.com" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-blue-500 font-medium">Official Website</div>
                </a>
                <a href="https://github.com/dogecoin/dogecoin" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-blue-500 font-medium">Source Code</div>
                </a>
                <a href="https://www.reddit.com/r/dogecoin/" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-blue-500 font-medium">Community</div>
                </a>
                <a href="blockchain_details.php" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-blue-500 font-medium">Block Explorer</div>
                </a>
            </div>
        </section>
    </div>

    <script>
        // DOM Elements
        const dogePriceEl = document.getElementById('doge-price');
        const dogeArrowEl = document.getElementById('doge-arrow');
        const dogeChangeEl = document.getElementById('doge-change');
        const dogeEquivalentEl = document.getElementById('doge-equivalent');
        const dogeBalanceUsdEl = document.getElementById('doge-balance-usd');
        const marketCapEl = document.getElementById('market-cap');
        const volumeEl = document.getElementById('volume');
        const supplyEl = document.getElementById('supply');
        const marketCapRankEl = document.getElementById('market-cap-rank');
        const communityStatusEl = document.getElementById('community-status');
        const blockTimeEl = document.getElementById('block-time');
        const descriptionContentEl = document.getElementById('description-content');
        const toggleDescriptionBtn = document.getElementById('toggle-description');
        const connectionStatusEl = document.getElementById('connection-status');
        const supplyProgressEl = document.getElementById('supply-progress');
        const circulatingSupplyEl = document.getElementById('circulating-supply');

        // User data from PHP
        const userDOGE = <?php echo json_encode($doge); ?>;
        let previousPrice = 0;
        let coinData = {};
        let descriptionExpanded = false;

        // Toggle description
        toggleDescriptionBtn.addEventListener('click', () => {
            descriptionExpanded = !descriptionExpanded;
            descriptionContentEl.classList.toggle('description-collapse', !descriptionExpanded);
            descriptionContentEl.classList.toggle('description-expanded', descriptionExpanded);
            toggleDescriptionBtn.textContent = descriptionExpanded ? 'Show Less' : 'Show More';
        });

        // Format numbers with commas
        function formatNumber(num, decimals = 0) {
            return new Intl.NumberFormat('en-US', {
                minimumFractionDigits: decimals,
                maximumFractionDigits: decimals
            }).format(num);
        }

        // Format currency
        function formatCurrency(amount) {
            return new Intl.NumberFormat('en-US', {
                style: 'currency',
                currency: 'USD',
                minimumFractionDigits: 2,
                maximumFractionDigits: 6
            }).format(amount);
        }

        // Update UI with price data
        function updatePriceUI(price, change) {
            // Update price
            dogePriceEl.textContent = formatCurrency(price);
            
            // Update 24h change
            const changeFixed = change.toFixed(2);
            dogeChangeEl.textContent = `${changeFixed}% (24h)`;
            dogeChangeEl.style.color = change >= 0 ? '#10B981' : '#EF4444';
            
            // Update arrow
            dogeArrowEl.textContent = change >= 0 ? '↑' : '↓';
            dogeArrowEl.style.color = change >= 0 ? '#10B981' : '#EF4444';
            
            // Update equivalent
            const dogeEquivalent = 1 / price;
            dogeEquivalentEl.textContent = dogeEquivalent.toFixed(2) + ' DOGE';
            
            // Update user balance
            const dogeBalanceUSD = userDOGE * price;
            dogeBalanceUsdEl.textContent = formatNumber(dogeBalanceUSD, 2);
            
            // Price change animation with bounce effect
            if (previousPrice && previousPrice !== price) {
                dogePriceEl.classList.remove('text-green-500', 'text-red-500', 'price-bounce');
                void dogePriceEl.offsetWidth; // Trigger reflow
                dogePriceEl.classList.add(price > previousPrice ? 'text-green-500' : 'text-red-500');
                dogePriceEl.classList.add('price-bounce');
                
                setTimeout(() => {
                    dogePriceEl.classList.remove('text-green-500', 'text-red-500', 'price-bounce');
                    dogePriceEl.classList.add('text-gray-800');
                }, 3000);
            }
            
            previousPrice = price;
        }

        // Update market data
        function updateMarketData(data) {
            marketCapEl.textContent = formatCurrency(data.market_data.market_cap.usd);
            volumeEl.textContent = formatCurrency(data.market_data.total_volume.usd);
            supplyEl.textContent = formatNumber(data.market_data.circulating_supply) + ' DOGE';
            marketCapRankEl.textContent = '#' + data.market_cap_rank;
            
            // DOGE has unlimited supply, so always show 100%
            supplyProgressEl.style.width = '100%';
            circulatingSupplyEl.textContent = formatNumber(data.market_data.circulating_supply);
            
            // Fun community status based on volume
            const volume = data.market_data.total_volume.usd;
            if (volume > 1000000000) {
                communityStatusEl.textContent = 'Much Wow!';
                communityStatusEl.className = 'text-yellow-600 font-medium';
            } else if (volume > 500000000) {
                communityStatusEl.textContent = 'Very Active';
                communityStatusEl.className = 'text-green-600 font-medium';
            } else {
                communityStatusEl.textContent = 'Such Community';
                communityStatusEl.className = 'text-blue-600 font-medium';
            }
        }

        // Fetch DOGE data from CoinGecko
        async function fetchDOGEData() {
            try {
                const response = await axios.get('https://api.coingecko.com/api/v3/coins/dogecoin', {
                    params: {
                        localization: false,
                        tickers: false,
                        community_data: false,
                        developer_data: false,
                        sparkline: false
                    },
                    timeout: 10000
                });
                
                coinData = response.data;
                const price = coinData.market_data.current_price.usd;
                const change = coinData.market_data.price_change_percentage_24h;
                
                updatePriceUI(price, change);
                updateMarketData(coinData);
                
                // Update description
                descriptionContentEl.innerHTML = coinData.description.en.replace(/\. /g, '.<br><br>');
                
                connectionStatusEl.style.backgroundColor = '#10B981';
                return true;
            } catch (error) {
                console.error('Error fetching DOGE data:', error);
                connectionStatusEl.style.backgroundColor = '#EF4444';
                return false;
            }
        }

        // Initialize the page
        document.addEventListener('DOMContentLoaded', () => {
            // Initial data fetch
            fetchDOGEData();
            
            // Refresh data every 90 seconds (frequent updates for meme coin)
            setInterval(fetchDOGEData, 90000);
            
            // Animate elements on load
            document.querySelectorAll('.fade-in').forEach((el, i) => {
                el.style.animationDelay = `${i * 0.1}s`;
            });
        });
    </script>
</body>
</html>