<?php
// Enable error reporting (for development only)
// Remove or disable in production
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in; if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$usd_balance    = isset($userDetails['balance']) ? (float)$userDetails['balance'] : 0.00;
$btc            = isset($userDetails['btc']) ? (float)$userDetails['btc'] : 0.000000;
$eth            = isset($userDetails['eth']) ? (float)$userDetails['eth'] : 0.000000;
$usdt           = isset($userDetails['usdt']) ? (float)$userDetails['usdt'] : 0.000000;
$xrp            = isset($userDetails['xrp']) ? (float)$userDetails['xrp'] : 0.000000;
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

// Define cache file and cache duration (6 hours - shorter for stablecoin)
$cache_file = "usdt_price_cache.json";
$cache_duration = 21600; // 6 hours

// Function to fetch USDT price from CoinGecko API using cURL
function fetch_usdt_price() {
    $api_url = "https://api.coingecko.com/api/v3/simple/price?ids=tether&vs_currencies=usd";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Ignore SSL verification issues
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Timeout after 10 seconds
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Ensure response is valid and HTTP status code is 200 (OK)
    if ($http_code == 200 && $response) {
        return json_decode($response, true);
    }
    return false;
}

// Use cache if valid
if (file_exists($cache_file) && (time() - filemtime($cache_file)) < $cache_duration) {
    $data = json_decode(file_get_contents($cache_file), true);
} else {
    // Fetch fresh USDT price
    $data = fetch_usdt_price();

    // Store new price in cache if valid
    if ($data && isset($data['tether']['usd'])) {
        file_put_contents($cache_file, json_encode($data));
    }
}

// Ensure USDT price is available
$usdt_price = $data['tether']['usd'] ?? null;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tether (USDT) | primemarketspro.com</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
    <link rel="icon" href="https://primemarketspro.com/session/favicon.png" type="image/x-icon">
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <style>
        .tether-bg { background-color: #26A17B; }
        .tether-text { color: #26A17B; }
        .btn-tether {
            background-color: #26A17B;
            color: white;
            transition: all 0.2s;
        }
        .btn-tether:hover {
            background-color: #1e8566;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(38, 161, 123, 0.2);
        }
        .tradingview-widget-container {
            width: 100%;
            min-height: 450px;
        }
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        .progress-bar {
            height: 4px;
            background-color: #e2e8f0;
            border-radius: 2px;
            overflow: hidden;
        }
        .progress-value {
            height: 100%;
            background-color: #26A17B;
            transition: width 0.5s ease;
        }
        .description-collapse {
            max-height: 100px;
            overflow: hidden;
            position: relative;
        }
        .description-collapse::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 40px;
            background: linear-gradient(to top, rgba(255,255,255,1), rgba(255,255,255,0));
        }
        .description-expanded {
            max-height: none;
        }
        .stability-indicator {
            background: linear-gradient(135deg, #26A17B 0%, #34D399 100%);
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            display: inline-block;
            margin-top: 4px;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen p-4">
    <div class="max-w-4xl mx-auto bg-white p-4 md:p-6 rounded-2xl shadow-sm">
        <!-- Header -->
        <header class="flex items-center justify-between mb-8">
            <button onclick="history.back()" class="tether-text p-2 rounded-full hover:bg-gray-100 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                </svg>
            </button>
            <h1 class="text-xl font-semibold text-gray-800 flex items-center">
                <img src="https://primemarketspro.com/cryptos/tether.png" class="w-8 h-8 mr-2" alt="Tether">
                Tether (USDT)
            </h1>
            <div class="p-2 rounded-full hover:bg-gray-100 transition-colors">
                <div id="connection-status" class="w-3 h-3 rounded-full bg-green-500"></div>
            </div>
        </header>

        <!-- Price Section -->
        <section class="text-center mb-8 fade-in">
            <div class="price-text text-4xl font-bold mb-2 flex items-center justify-center">
                <span id="usdt-price" class="text-gray-800">$0.000</span>
                <span id="usdt-arrow" class="ml-2"></span>
            </div>
            <div id="usdt-change" class="text-lg font-medium text-gray-600">0.00% (24h)</div>
            <div class="stability-indicator">
                🔒 USD-Pegged Stablecoin
            </div>
            <div class="text-sm font-medium text-blue-500 mt-2">
                1 USD ≈ <span id="usdt-equivalent" class="text-gray-700">1.00 USDT</span>
            </div>
        </section>

     <section class="mb-6" style="width: 100%;">
    <div class="tradingview-widget-container" style="width: 100%; height: 420px;">
        <div class="tradingview-widget-container__widget" style="width: 100%; height: 100%;"></div>
        <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-mini-symbol-overview.js" async>
        {
            "symbol": "BITSTAMP:USDTUSD",
            "width": "100%",
            "height": "250",
            "locale": "en",
            "dateRange": "12M",
            "colorTheme": "light",
            "isTransparent": true,
            "autosize": false,
            "largeChartUrl": ""
        }
        </script>
    </div>
</section>



        <!-- Wallet Card -->
        <section class="wallet-card bg-gradient-to-r from-green-50 to-emerald-50 rounded-xl p-6 mb-8 fade-in">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm">Your USDT Balance</p>
                    <h2 class="text-2xl font-bold text-gray-800 mt-1">
                        <?php echo number_format($usdt, 2); ?> USDT
                    </h2>
                    <p class="text-gray-600 mt-1">
                        ≈ $<span id="usdt-balance-usd"><?php echo number_format($usdt * 1.00, 2); // Initial estimate ?></span> USD
                    </p>
                </div>
                <img src="https://primemarketspro.com/cryptos/tether.png" class="w-12 h-12" alt="Tether">
            </div>
            <div class="mt-4 flex space-x-2">
                <a href="usdtd.php" class="btn-tether py-3 px-6 rounded-xl text-center font-medium flex-1">
                    <i class="fas fa-arrow-up mr-2"></i>Send
                </a>
                <a href="usdtr.php" class="btn-tether py-3 px-6 rounded-xl text-center font-medium flex-1">
                    <i class="fas fa-arrow-down mr-2"></i>Receive
                </a>
            </div>
        </section>

        <!-- Market Data -->
        <section class="bg-gray-50 rounded-xl p-6 mb-8 fade-in">
            <h3 class="font-semibold text-gray-800 mb-4">Market Overview</h3>
            <div class="space-y-4 text-sm">
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Market Cap Rank</span>
                        <span id="market-cap-rank">#3</span>
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Market Cap</span>
                        <span id="market-cap">$0</span>
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>24h Volume</span>
                        <span id="volume">$0</span>
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Circulating Supply</span>
                        <span id="supply">0 USDT</span>
                    </div>
                    <div class="progress-bar mt-1">
                        <div id="supply-progress" class="progress-value" style="width: 100%"></div>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        <span id="circulating-supply">0</span> USDT in circulation
                    </div>
                </div>
                
                <div>
                    <div class="flex justify-between text-gray-600 mb-1">
                        <span>Price Stability</span>
                        <span id="stability-score" class="text-green-600 font-medium">High</span>
                    </div>
                    <div class="text-xs text-gray-500 mt-1">
                        USD-backed stablecoin
                    </div>
                </div>
            </div>
        </section>

        <!-- Stability Info -->
        <section class="bg-green-50 border border-green-200 rounded-xl p-6 mb-8 fade-in">
            <div class="flex items-start space-x-3">
                <div class="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center flex-shrink-0">
                    <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <div>
                    <h4 class="font-semibold text-green-800 mb-1">USD-Pegged Stablecoin</h4>
                    <p class="text-sm text-green-700">
                        USDT is designed to maintain a 1:1 peg with the US Dollar, making it ideal for trading, payments, and storing value without the volatility of other cryptocurrencies.
                    </p>
                </div>
            </div>
        </section>

        <!-- About Section -->
        <section class="mb-8 fade-in">
            <div class="flex justify-between items-center mb-4">
                <h3 class="font-semibold text-gray-800">About Tether</h3>
                <button id="toggle-description" class="text-blue-500 text-sm font-medium">Show More</button>
            </div>
            <div id="description-content" class="description-collapse text-gray-600 text-sm leading-relaxed">
                Loading Tether description...
            </div>
        </section>

        <!-- Official Links -->
        <section class="fade-in">
            <h3 class="font-semibold text-gray-800 mb-4">Resources</h3>
            <div class="grid grid-cols-2 gap-3">
                <a href="https://tether.to" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-blue-500 font-medium">Official Website</div>
                </a>
                <a href="https://github.com/tetherto" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-blue-500 font-medium">Source Code</div>
                </a>
                <a href="https://tether.to/transparency/" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-blue-500 font-medium">Transparency</div>
                </a>
                <a href="blockchain_details.php" target="_blank" class="bg-gray-100 hover:bg-gray-200 rounded-lg p-3 text-center transition-colors">
                    <div class="text-blue-500 font-medium">Block Explorer</div>
                </a>
            </div>
        </section>
    </div>

    <script>
        // DOM Elements
        const usdtPriceEl = document.getElementById('usdt-price');
        const usdtArrowEl = document.getElementById('usdt-arrow');
        const usdtChangeEl = document.getElementById('usdt-change');
        const usdtEquivalentEl = document.getElementById('usdt-equivalent');
        const usdtBalanceUsdEl = document.getElementById('usdt-balance-usd');
        const marketCapEl = document.getElementById('market-cap');
        const volumeEl = document.getElementById('volume');
        const supplyEl = document.getElementById('supply');
        const marketCapRankEl = document.getElementById('market-cap-rank');
        const stabilityScoreEl = document.getElementById('stability-score');
        const descriptionContentEl = document.getElementById('description-content');
        const toggleDescriptionBtn = document.getElementById('toggle-description');
        const connectionStatusEl = document.getElementById('connection-status');
        const supplyProgressEl = document.getElementById('supply-progress');
        const circulatingSupplyEl = document.getElementById('circulating-supply');

        // User data from PHP
        const userUSDT = <?php echo json_encode($usdt); ?>;
        let previousPrice = 0;
        let coinData = {};
        let descriptionExpanded = false;

        // Toggle description
        toggleDescriptionBtn.addEventListener('click', () => {
            descriptionExpanded = !descriptionExpanded;
            descriptionContentEl.classList.toggle('description-collapse', !descriptionExpanded);
            descriptionContentEl.classList.toggle('description-expanded', descriptionExpanded);
            toggleDescriptionBtn.textContent = descriptionExpanded ? 'Show Less' : 'Show More';
        });

        // Format numbers with commas
        function formatNumber(num, decimals = 0) {
            return new Intl.NumberFormat('en-US', {
                minimumFractionDigits: decimals,
                maximumFractionDigits: decimals
            }).format(num);
        }

        // Format currency
        function formatCurrency(amount) {
            return new Intl.NumberFormat('en-US', {
                style: 'currency',
                currency: 'USD',
                minimumFractionDigits: 2,
                maximumFractionDigits: 6
            }).format(amount);
        }

        // Update UI with price data
        function updatePriceUI(price, change) {
            // Update price
            usdtPriceEl.textContent = formatCurrency(price);
            
            // Update 24h change
            const changeFixed = change.toFixed(4); // More precision for stablecoin
            usdtChangeEl.textContent = `${changeFixed}% (24h)`;
            usdtChangeEl.style.color = Math.abs(change) > 0.1 ? (change >= 0 ? '#10B981' : '#EF4444') : '#6B7280';
            
            // Update arrow (more conservative for stablecoin)
            if (Math.abs(change) > 0.05) {
                usdtArrowEl.textContent = change >= 0 ? '↑' : '↓';
                usdtArrowEl.style.color = change >= 0 ? '#10B981' : '#EF4444';
            } else {
                usdtArrowEl.textContent = '→';
                usdtArrowEl.style.color = '#6B7280';
            }
            
            // Update equivalent
            const usdtEquivalent = 1 / price;
            usdtEquivalentEl.textContent = usdtEquivalent.toFixed(4) + ' USDT';
            
            // Update user balance
            const usdtBalanceUSD = userUSDT * price;
            usdtBalanceUsdEl.textContent = formatNumber(usdtBalanceUSD, 2);
            
            // Price change animation (more subtle for stablecoin)
            if (previousPrice && Math.abs(previousPrice - price) > 0.001) {
                usdtPriceEl.classList.remove('text-green-500', 'text-red-500');
                void usdtPriceEl.offsetWidth; // Trigger reflow
                usdtPriceEl.classList.add(price > previousPrice ? 'text-green-500' : 'text-red-500');
                
                setTimeout(() => {
                    usdtPriceEl.classList.remove('text-green-500', 'text-red-500');
                    usdtPriceEl.classList.add('text-gray-800');
                }, 2000);
            }
            
            previousPrice = price;
        }

        // Update market data
        function updateMarketData(data) {
            marketCapEl.textContent = formatCurrency(data.market_data.market_cap.usd);
            volumeEl.textContent = formatCurrency(data.market_data.total_volume.usd);
            supplyEl.textContent = formatNumber(data.market_data.circulating_supply) + ' USDT';
            marketCapRankEl.textContent = '#' + data.market_cap_rank;
            
            // Stability assessment based on price variance
            const price = data.market_data.current_price.usd;
            const change = Math.abs(data.market_data.price_change_percentage_24h);
            
            if (change < 0.1) {
                stabilityScoreEl.textContent = 'Very High';
                stabilityScoreEl.className = 'text-green-600 font-medium';
            } else if (change < 0.5) {
                stabilityScoreEl.textContent = 'High';
                stabilityScoreEl.className = 'text-green-500 font-medium';
            } else if (change < 1.0) {
                stabilityScoreEl.textContent = 'Moderate';
                stabilityScoreEl.className = 'text-yellow-500 font-medium';
            } else {
                stabilityScoreEl.textContent = 'Low';
                stabilityScoreEl.className = 'text-red-500 font-medium';
            }
            
            // Supply is always 100% for USDT (no max supply)
            supplyProgressEl.style.width = '100%';
            circulatingSupplyEl.textContent = formatNumber(data.market_data.circulating_supply);
        }

        // Fetch Tether data from CoinGecko
        async function fetchTetherData() {
            try {
                const response = await axios.get('https://api.coingecko.com/api/v3/coins/tether', {
                    params: {
                        localization: false,
                        tickers: false,
                        community_data: false,
                        developer_data: false,
                        sparkline: false
                    },
                    timeout: 5000
                });
                
                coinData = response.data;
                const price = coinData.market_data.current_price.usd;
                const change = coinData.market_data.price_change_percentage_24h;
                
                updatePriceUI(price, change);
                updateMarketData(coinData);
                
                // Update description
                descriptionContentEl.innerHTML = coinData.description.en.replace(/\. /g, '.<br><br>');
                
                connectionStatusEl.style.backgroundColor = '#10B981';
                return true;
            } catch (error) {
                console.error('Error fetching Tether data:', error);
                connectionStatusEl.style.backgroundColor = '#EF4444';
                return false;
            }
        }

        // Initialize the page
        document.addEventListener('DOMContentLoaded', () => {
            // Initial data fetch
            fetchTetherData();
            
            // Refresh data every 5 minutes (less frequent for stablecoin)
            setInterval(fetchTetherData, 300000);
            
            // Animate elements on load
            document.querySelectorAll('.fade-in').forEach((el, i) => {
                el.style.animationDelay = `${i * 0.1}s`;
            });
        });
    </script>
</body>
</html>