<?php
// get_balance.php
include 'db.php'; // Adjust the path to your DB connection file

session_start(); // Start the session to access the session variables
header('Content-Type: application/json');

try {
    // Check if email is set in session
    if (!isset($_SESSION['email'])) {
        echo json_encode([
            'error' => 'User email not found in session',
            'btc' => 0,
            'eth' => 0,
            'usdt' => 0,
            'xrp' => 0,
            'balance' => '$0.00'
        ]);
        exit;
    }

    // Get the user email from the session
    $user_email = $_SESSION['email'];

    // Query to fetch individual coin values and the total balance
    $query = "SELECT btc, eth, usdt, xrp FROM users WHERE email = :email";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':email', $user_email);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    // If no data found, set default values
    if (!$result) {
        $btc = $eth = $usdt = $xrp = 0;
        $total = 0;
    } else {
        $btc = $result['btc'];
        $eth = $result['eth'];
        $usdt = $result['usdt'];
        $xrp = $result['xrp'];
        $total = $btc + $eth + $usdt + $xrp; // Calculate total balance here
    }

    // Format the total balance as currency
    $formattedTotal = '$' . number_format($total, 2);

    // Return JSON data
    echo json_encode([
        'btc'     => $btc,
        'eth'     => $eth,
        'usdt'    => $usdt,
        'xrp'     => $xrp,
        'balance' => $formattedTotal
    ]);
} catch (PDOException $e) {
    echo json_encode([
        'error' => 'Database error: ' . $e->getMessage(),
        'btc' => 0,
        'eth' => 0,
        'usdt' => 0,
        'xrp' => 0,
        'balance' => '$0.00'
    ]);
}
?>
