<?php 
require_once '../session.php';
include '../db.php'; // Optional: include if you need a DB connection in this header
$currentPage = basename($_SERVER['PHP_SELF']); 
?>

<!-- Font Awesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css" />

<!-- Leaflet JS -->
<script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js"></script>

<!-- Flag Icon CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flag-icon-css@3.5.0/css/flag-icon.min.css" />

<style>
    /* Modern CSS Variables */
    :root {
        --primary-purple: #667eea;
        --primary-purple-dark: #5a67d8;
        --primary-purple-light: #7c3aed;
        --secondary-purple: #764ba2;
        --white: #ffffff;
        --gray-50: #f8fafc;
        --gray-100: #f1f5f9;
        --gray-200: #e2e8f0;
        --gray-300: #cbd5e1;
        --gray-400: #94a3b8;
        --gray-500: #64748b;
        --gray-600: #475569;
        --gray-700: #334155;
        --gray-800: #1e293b;
        --gray-900: #0f172a;
        --success: #10b981;
        --danger: #ef4444;
        --warning: #f59e0b;
        --info: #3b82f6;
        --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
        --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        --shadow-2xl: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
        --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        --border-radius: 12px;
        --border-radius-lg: 16px;
        --border-radius-xl: 20px;
    }

    /* SweetAlert Dark Theme */
    .swal-dark-popup {
        border-radius: 12px !important;
        background: #1a1b23 !important;
    }
    
    .swal-dark-title {
        color: white !important;
        font-size: 24px !important;
        font-weight: bold !important;
    }
    
    .swal-dark-content {
        color: #e2e8f0 !important;
        font-size: 16px !important;
        padding: 0 20px !important;
    }
    
    .swal-dark-button {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
        color: white !important;
        border: none !important;
        padding: 12px 32px !important;
        font-size: 16px !important;
        margin-top: 15px !important;
        border-radius: 8px !important;
        transition: all 0.3s ease !important;
    }
    
    .swal-dark-button:hover {
        transform: translateY(-2px) !important;
        box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4) !important;
    }
    
    .swal-dark-button:focus {
        box-shadow: none !important;
    }
    
    .swal2-icon.swal2-warning {
        border-color: #fbbf24 !important;
        color: #fbbf24 !important;
    }

    /* Map Styles */
    #world-map { 
        height: 12rem; 
        width: 100%; 
        border-radius: 12px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    }
    
    .country-row {
        transition: all 0.3s ease;
        border-radius: 8px;
        margin: 4px 0;
    }
    
    .country-row:hover {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        transform: translateX(5px);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }
    
    .flag-icon.flag-icon-round {
        border-radius: 50%;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
    }

    /* Trading View Widget */
    .tradingview-widget-container {
        height: 500px;
        width: 100%;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    }

    .tradingview-widget-container__widget {
        height: calc(100% - 32px);
        width: 100%;
    }

    /* Enhanced Gradient Backgrounds */
    .gradient-bg {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }
    
    .gradient-bg-alt {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    }
    
    .gradient-bg-success {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    }
    
    .glass-effect {
        background: rgba(255, 255, 255, 0.15);
        backdrop-filter: blur(20px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
    }
    
    .scrollbar-hide {
        -ms-overflow-style: none;
        scrollbar-width: none;
    }
    
    .scrollbar-hide::-webkit-scrollbar {
        display: none;
    }

    /* Enhanced Order Book */
    .order-book-container {
        width: 100%;
        max-width: 600px;
        margin: 0 auto;
        background: linear-gradient(145deg, #ffffff 0%, #f8fafc 100%);
        border-radius: 16px;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        border: 1px solid rgba(255, 255, 255, 0.2);
    }
    
    .order-book-header {
        padding: 20px;
        font-size: 20px;
        font-weight: 700;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .order-book-table {
        width: 100%;
        border-collapse: collapse;
    }
    
    .order-book-table th {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        text-align: right;
        padding: 15px;
        font-size: 13px;
        color: #64748b;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .order-book-table td {
        padding: 12px 15px;
        text-align: right;
        position: relative;
        font-size: 14px;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    
    .sell-row td:first-child {
        color: #ef4444;
        font-weight: 600;
    }
    
    .buy-row td:first-child {
        color: #10b981;
        font-weight: 600;
    }
    
    .order-depth {
        position: absolute;
        top: 0;
        bottom: 0;
        right: 0;
        z-index: 0;
        transition: width 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    }
    
    .sell-depth {
        background: linear-gradient(90deg, transparent 0%, rgba(239, 68, 68, 0.1) 100%);
    }
    
    .buy-depth {
        background: linear-gradient(90deg, transparent 0%, rgba(16, 185, 129, 0.1) 100%);
    }
    
    .order-book-table tr {
        border-bottom: 1px solid #f1f5f9;
        transition: all 0.3s ease;
    }
    
    .order-book-table tr:hover {
        background: rgba(248, 250, 252, 0.5);
        transform: scale(1.01);
    }
    
    .order-book-divider {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        padding: 15px 20px;
        font-size: 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        border-top: 2px solid #e2e8f0;
        border-bottom: 2px solid #e2e8f0;
    }
    
    .last-price {
        font-weight: 700;
        font-size: 18px;
    }
    
    .price-change {
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    }
    
    .price-change.negative {
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        color: #dc2626;
    }
    
    .price-change.positive {
        background: linear-gradient(135deg, #dcfce7 0%, #bbf7d0 100%);
        color: #16a34a;
    }

    /* Enhanced Shimmer Animation */
    @keyframes shimmer {
        0% {
            background-position: -400px 0;
        }
        100% {
            background-position: 400px 0;
        }
    }
    
    .shimmer {
        background: linear-gradient(to right, #f1f5f9 0%, #e2e8f0 50%, #f1f5f9 100%);
        background-size: 800px 104px;
        animation: shimmer 1.5s infinite linear;
        border-radius: 8px;
    }

    /* Enhanced Form Controls */
    .form-control {
        width: 100%;
        padding: 12px 16px;
        margin: 8px 0;
        border: 2px solid #e2e8f0;
        border-radius: 12px;
        background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
        color: #1e293b;
        font-size: 14px;
        transition: all 0.3s ease;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }
    
    .form-control:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        transform: translateY(-2px);
    }
    
    .alert-success {
        color: #16a34a;
        background: linear-gradient(135deg, #dcfce7 0%, #bbf7d0 100%);
        padding: 12px 16px;
        border-radius: 12px;
        border: 1px solid #16a34a;
    }
    
    .alert-danger {
        color: #dc2626;
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        padding: 12px 16px;
        border-radius: 12px;
        border: 1px solid #dc2626;
    }

    /* Enhanced SweetAlert */
    .swal2-confirm {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
        border-radius: 12px !important;
        padding: 12px 32px !important;
        font-weight: 600 !important;
        transition: all 0.3s ease !important;
    }
    
    .swal2-confirm:hover {
        transform: translateY(-2px) !important;
        box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4) !important;
    }
    
    .swal2-input, .swal2-select {
        border-radius: 12px !important;
        border: 2px solid #e2e8f0 !important;
        padding: 12px 16px !important;
    }

    /* Enhanced Animations */
    .cell-update {
        animation: flash-bg 0.6s ease-in-out;
    }
    
    @keyframes flash-bg {
        0%   { background-color: rgba(255, 215, 0, 0.6); }
        50%  { background-color: rgba(255, 215, 0, 0.3); }
        100% { background-color: transparent; }
    }
    
    /* Enhanced Modern Preloader */
    #preloader {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, var(--white) 0%, var(--gray-50) 100%);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        z-index: 9999;
        transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
    }
    
    .loader-container {
        position: relative;
        width: 120px;
        height: 120px;
    }
    
    .loader-ring {
        position: absolute;
        width: 100%;
        height: 100%;
        border: 4px solid var(--gray-200);
        border-radius: 50%;
        border-top: 4px solid var(--primary-purple);
        animation: spin 1.2s cubic-bezier(0.4, 0, 0.2, 1) infinite;
        box-shadow: 0 0 20px rgba(102, 126, 234, 0.3);
    }
    
    .loader-ring:nth-child(2) {
        width: 85%;
        height: 85%;
        top: 7.5%;
        left: 7.5%;
        border-top: 4px solid var(--secondary-purple);
        animation-delay: -0.4s;
        animation-duration: 1s;
    }
    
    .loader-ring:nth-child(3) {
        width: 70%;
        height: 70%;
        top: 15%;
        left: 15%;
        border-top: 4px solid var(--primary-purple-light);
        animation-delay: -0.8s;
        animation-duration: 0.8s;
    }
    
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    .loader-text {
        margin-top: 2.5rem;
        color: var(--gray-700);
        font-size: 1.25rem;
        font-weight: 600;
        letter-spacing: 0.5px;
        text-transform: uppercase;
    }
    
    .loader-progress {
        width: 250px;
        height: 4px;
        background: var(--gray-200);
        border-radius: 20px;
        margin-top: 1.5rem;
        overflow: hidden;
        box-shadow: inset 0 2px 4px rgba(0, 0, 0, 0.1);
    }
    
    .loader-progress-bar {
        height: 100%;
        background: linear-gradient(90deg, var(--primary-purple) 0%, var(--secondary-purple) 100%);
        border-radius: 20px;
        animation: progress 2.5s cubic-bezier(0.4, 0, 0.2, 1);
        transform: translateX(-100%);
        box-shadow: 0 0 10px rgba(102, 126, 234, 0.5);
    }
    
    @keyframes progress {
        0% { transform: translateX(-100%); }
        100% { transform: translateX(0%); }
    }
    
    /* Enhanced Header Styles */
    #main-header {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        border-bottom: 1px solid var(--gray-200);
        box-shadow: var(--shadow-sm);
        z-index: 1000;
        transition: var(--transition);
    }
    
    #main-header.scrolled {
        background: rgba(255, 255, 255, 0.98);
        box-shadow: var(--shadow-xl);
        border-bottom: 1px solid var(--gray-300);
    }
    
    .header-container {
        max-width: 1400px;
        margin: 0 auto;
        padding: 0 1.5rem;
    }
    
    .header-content {
        display: flex;
        justify-content: space-between;
        align-items: center;
        height: 80px;
    }
    
    /* Enhanced Logo Section */
    .logo-section {
        display: flex;
        align-items: center;
    }
    
    .logo-container {
        display: flex;
        align-items: center;
        padding: 10px 20px;
        background: linear-gradient(135deg, var(--primary-purple) 0%, var(--secondary-purple) 100%);
        border-radius: var(--border-radius);
        transition: var(--transition);
        text-decoration: none;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        position: relative;
        overflow: hidden;
    }
    
    .logo-container::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
        transition: left 0.5s;
    }
    
    .logo-container:hover::before {
        left: 100%;
    }
    
    .logo-container:hover {
        background: linear-gradient(135deg, var(--primary-purple-dark) 0%, var(--primary-purple-light) 100%);
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
    }
    
    .logo-container img {
        height: 36px;
        width: auto;
        filter: drop-shadow(0 2px 4px rgba(0, 0, 0, 0.1));
    }
    
    .logo-text {
        color: var(--white);
        font-weight: 800;
        font-size: 1.8rem;
        margin-left: 12px;
        text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }
    
    /* Enhanced Navigation */
    .nav-section {
        display: flex;
        align-items: center;
        margin-left: 3rem;
    }
    
    .nav-menu {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        list-style: none;
        margin: 0;
        padding: 0;
    }
    
    .nav-link {
        display: flex;
        align-items: center;
        gap: 8px;
        padding: 12px 18px;
        color: var(--gray-600);
        text-decoration: none;
        border-radius: var(--border-radius);
        font-weight: 500;
        font-size: 0.95rem;
        transition: var(--transition);
        position: relative;
        overflow: hidden;
    }
    
    .nav-link::before {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        width: 0;
        height: 2px;
        background: linear-gradient(90deg, var(--primary-purple), var(--secondary-purple));
        transition: all 0.3s ease;
        transform: translateX(-50%);
    }
    
    .nav-link:hover::before {
        width: 80%;
    }
    
    .nav-link:hover {
        color: var(--primary-purple);
        background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
        transform: translateY(-1px);
    }
    
    .nav-link.active {
        color: var(--primary-purple);
        background: linear-gradient(135deg, rgba(102, 126, 234, 0.15) 0%, rgba(118, 75, 162, 0.15) 100%);
        font-weight: 600;
        box-shadow: 0 2px 8px rgba(102, 126, 234, 0.2);
    }
    
    .nav-link.active::before {
        width: 80%;
    }
    
    .support-link {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%) !important;
        color: var(--white) !important;
        font-weight: 600;
        box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
    }
    
    .support-link:hover {
        background: linear-gradient(135deg, #059669 0%, #047857 100%) !important;
        color: var(--white) !important;
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(16, 185, 129, 0.4);
    }
    
    /* Enhanced Dropdown Styles */
    .dropdown {
        position: relative;
    }
    
    .dropdown-toggle {
        display: flex;
        align-items: center;
        gap: 6px;
        cursor: pointer;
        border: none;
        background: none;
        font: inherit;
    }
    
    .dropdown-arrow {
        width: 18px;
        height: 18px;
        transition: var(--transition);
        filter: drop-shadow(0 1px 2px rgba(0, 0, 0, 0.1));
    }
    
    .dropdown-menu {
        position: absolute;
        top: 110%;
        left: 0;
        min-width: 220px;
        background: rgba(255, 255, 255, 0.98);
        backdrop-filter: blur(20px);
        border: 1px solid var(--gray-200);
        border-radius: var(--border-radius-lg);
        box-shadow: var(--shadow-2xl);
        padding: 12px 0;
        margin-top: 8px;
        opacity: 0;
        visibility: hidden;
        transform: translateY(-15px) scale(0.95);
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        z-index: 1000;
    }
    
    .dropdown.active .dropdown-menu {
        opacity: 1;
        visibility: visible;
        transform: translateY(0) scale(1);
    }
    
    .dropdown.active .dropdown-arrow {
        transform: rotate(180deg);
        color: var(--primary-purple);
    }
    
    .dropdown-item {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 14px 20px;
        color: var(--gray-700);
        text-decoration: none;
        transition: var(--transition);
        font-size: 0.95rem;
        font-weight: 500;
        border-left: 3px solid transparent;
    }
    
    .dropdown-item:hover {
        background: linear-gradient(135deg, var(--gray-50) 0%, rgba(102, 126, 234, 0.1) 100%);
        color: var(--primary-purple);
        border-left-color: var(--primary-purple);
        transform: translateX(2px);
    }
    
    /* Enhanced User Section */
    .user-section {
        display: flex;
        align-items: center;
        gap: 1.5rem;
    }
    
    .user-info {
        text-align: right;
        padding: 12px 16px;
        background: linear-gradient(135deg, var(--gray-50) 0%, rgba(102, 126, 234, 0.05) 100%);
        border-radius: var(--border-radius);
        border: 1px solid var(--gray-200);
        box-shadow: var(--shadow-sm);
        transition: var(--transition);
    }
    
    .user-info:hover {
        box-shadow: var(--shadow-md);
        transform: translateY(-1px);
    }
    
    .user-name {
        font-weight: 600;
        font-size: 0.95rem;
        color: var(--gray-800);
        margin-bottom: 2px;
    }
    
    .user-email {
        font-size: 0.8rem;
        color: var(--gray-500);
    }
    
    .profile-avatar {
        width: 44px;
        height: 44px;
        background: linear-gradient(135deg, var(--primary-purple) 0%, var(--secondary-purple) 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--white);
        cursor: pointer;
        transition: var(--transition);
        border: 3px solid var(--white);
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        position: relative;
        overflow: hidden;
    }
    
    .profile-avatar::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.2), transparent);
        transform: translateX(-100%);
        transition: transform 0.6s;
    }
    
    .profile-avatar:hover::before {
        transform: translateX(100%);
    }
    
    .profile-avatar:hover {
        background: linear-gradient(135deg, var(--primary-purple-dark) 0%, var(--primary-purple-light) 100%);
        transform: scale(1.1);
        box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
    }
    
    .profile-avatar svg {
        width: 22px;
        height: 22px;
        filter: drop-shadow(0 1px 2px rgba(0, 0, 0, 0.1));
    }
    
    /* Mobile Navigation Styles */
    .mobile-menu-btn {
        display: none;
        padding: 12px;
        background: none;
        border: none;
        color: var(--gray-600);
        cursor: pointer;
        border-radius: var(--border-radius);
        transition: var(--transition);
        position: relative;
        z-index: 1001;
    }
    
    .mobile-menu-btn:hover {
        background: linear-gradient(135deg, var(--gray-50) 0%, rgba(102, 126, 234, 0.1) 100%);
        color: var(--primary-purple);
    }
    
    .mobile-menu-btn svg {
        width: 26px;
        height: 26px;
        transition: var(--transition);
    }
    
    /* Mobile Menu Overlay */
    .mobile-menu-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100vh;
        background: rgba(0, 0, 0, 0.5);
        backdrop-filter: blur(5px);
        z-index: 998;
        opacity: 0;
        visibility: hidden;
        transition: all 0.3s ease;
    }
    
    .mobile-menu-overlay.active {
        opacity: 1;
        visibility: visible;
    }
    
    /* Mobile Menu Sidebar */
    .mobile-menu-sidebar {
        position: fixed;
        top: 0;
        right: -100%;
        width: 320px;
        height: 100vh;
        background: rgba(255, 255, 255, 0.98);
        backdrop-filter: blur(20px);
        border-left: 1px solid var(--gray-200);
        box-shadow: var(--shadow-2xl);
        z-index: 999;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        overflow-y: auto;
        padding: 0;
    }
    
    .mobile-menu-sidebar.active {
        right: 0;
    }
    
    .mobile-menu-header {
        padding: 20px;
        background: linear-gradient(135deg, var(--primary-purple) 0%, var(--secondary-purple) 100%);
        color: var(--white);
        display: flex;
        justify-content: space-between;
        align-items: center;
        position: sticky;
        top: 0;
        z-index: 1000;
    }
    
    .mobile-menu-close {
        background: none;
        border: none;
        color: var(--white);
        cursor: pointer;
        padding: 8px;
        border-radius: 50%;
        transition: var(--transition);
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .mobile-menu-close:hover {
        background: rgba(255, 255, 255, 0.2);
        transform: scale(1.1);
    }
    
    .mobile-menu-close svg {
        width: 24px;
        height: 24px;
    }
    
    .mobile-menu-content {
        padding: 20px 0;
    }
    
    .mobile-nav-section {
        margin-bottom: 30px;
    }
    
    .mobile-nav-title {
        padding: 0 20px 10px;
        font-size: 0.85rem;
        font-weight: 600;
        color: var(--gray-500);
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border-bottom: 1px solid var(--gray-200);
        margin-bottom: 15px;
    }
    
    .mobile-nav-item {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 16px 20px;
        color: var(--gray-700);
        text-decoration: none;
        transition: var(--transition);
        font-weight: 500;
        border-left: 3px solid transparent;
    }
    
    .mobile-nav-item:hover {
        background: linear-gradient(135deg, var(--gray-50) 0%, rgba(102, 126, 234, 0.1) 100%);
        color: var(--primary-purple);
        border-left-color: var(--primary-purple);
        transform: translateX(2px);
    }
    
    .mobile-nav-item.active {
        background: linear-gradient(135deg, rgba(102, 126, 234, 0.15) 0%, rgba(118, 75, 162, 0.15) 100%);
        color: var(--primary-purple);
        border-left-color: var(--primary-purple);
        font-weight: 600;
    }
    
    .mobile-nav-item svg {
        width: 20px;
        height: 20px;
        opacity: 0.8;
    }
    
    .mobile-user-info {
        padding: 20px;
        background: linear-gradient(135deg, var(--gray-50) 0%, rgba(102, 126, 234, 0.05) 100%);
        border-top: 1px solid var(--gray-200);
        margin-bottom: 20px;
    }
    
    .mobile-user-avatar {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, var(--primary-purple) 0%, var(--secondary-purple) 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--white);
        margin-bottom: 10px;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }
    
    .mobile-user-avatar svg {
        width: 24px;
        height: 24px;
    }
    
    .mobile-user-name {
        font-weight: 600;
        color: var(--gray-800);
        margin-bottom: 4px;
    }
    
    .mobile-user-email {
        font-size: 0.85rem;
        color: var(--gray-500);
    }
    
    /* Responsive Design */
    @media (max-width: 1024px) {
        .header-content {
            padding: 0 1rem;
        }
        
        .nav-section {
            margin-left: 2rem;
        }
        
        .logo-text {
            font-size: 1.6rem;
        }
    }
    
    @media (max-width: 768px) {
        .mobile-menu-btn {
            display: block;
        }
        
        .nav-section,
        .user-section {
            display: none;
        }
        
        .header-content {
            height: 70px;
            padding: 0 1rem;
        }
        
        .logo-text {
            font-size: 1.4rem;
        }
        
        .logo-container {
            padding: 8px 16px;
        }
        
        .logo-container img {
            height: 32px;
        }
    }
    
    @media (max-width: 480px) {
        .mobile-menu-sidebar {
            width: 100%;
            right: -100%;
        }
        
        .header-content {
            height: 65px;
            padding: 0 0.75rem;
        }
        
        .logo-text {
            font-size: 1.2rem;
            margin-left: 8px;
        }
        
        .logo-container {
            padding: 6px 12px;
        }
        
        .logo-container img {
            height: 28px;
        }
    }
    
    /* Loading States */
    .skeleton {
        background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
        background-size: 200% 100%;
        animation: loading 1.5s infinite;
        border-radius: 4px;
    }
    
    @keyframes loading {
        0% {
            background-position: 200% 0;
        }
        100% {
            background-position: -200% 0;
        }
    }
    
    /* Enhanced Focus States for Accessibility */
    .nav-link:focus,
    .dropdown-item:focus,
    .mobile-nav-item:focus {
        outline: 2px solid var(--primary-purple);
        outline-offset: 2px;
    }
    
    .logo-container:focus {
        outline: 2px solid var(--white);
        outline-offset: 2px;
    }
    
    /* Print Styles */
    @media print {
        #main-header,
        .mobile-menu-sidebar,
        .mobile-menu-overlay {
            display: none !important;
        }
    }
    
    /* High Contrast Mode */
    @media (prefers-contrast: high) {
        :root {
            --primary-purple: #4c1d95;
            --secondary-purple: #581c87;
            --gray-600: #374151;
            --gray-700: #1f2937;
        }
    }
    
    /* Reduced Motion */
    @media (prefers-reduced-motion: reduce) {
        *,
        *::before,
        *::after {
            animation-duration: 0.01ms !important;
            animation-iteration-count: 1 !important;
            transition-duration: 0.01ms !important;
        }
    }
</style>

<!-- Add the mobile menu HTML structure -->
<div class="mobile-menu-overlay" id="mobileMenuOverlay"></div>
<div class="mobile-menu-sidebar" id="mobileMenuSidebar">
    <div class="mobile-menu-header">
        <div class="logo-text">Trading App</div>
        <button class="mobile-menu-close" id="mobileMenuClose">
            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
            </svg>
        </button>
    </div>
    <div class="mobile-menu-content">
        <!-- Navigation items will be populated by JavaScript -->
    </div>
</div>

<script>
// Mobile Menu Functionality
document.addEventListener('DOMContentLoaded', function() {
    const mobileMenuBtn = document.querySelector('.mobile-menu-btn');
    const mobileMenuSidebar = document.getElementById('mobileMenuSidebar');
    const mobileMenuOverlay = document.getElementById('mobileMenuOverlay');
    const mobileMenuClose = document.getElementById('mobileMenuClose');
    
    function openMobileMenu() {
        mobileMenuSidebar.classList.add('active');
        mobileMenuOverlay.classList.add('active');
        document.body.style.overflow = 'hidden';
    }
    
    function closeMobileMenu() {
        mobileMenuSidebar.classList.remove('active');
        mobileMenuOverlay.classList.remove('active');
        document.body.style.overflow = '';
    }
    
    if (mobileMenuBtn) {
        mobileMenuBtn.addEventListener('click', openMobileMenu);
    }
    
    if (mobileMenuClose) {
        mobileMenuClose.addEventListener('click', closeMobileMenu);
    }
    
    if (mobileMenuOverlay) {
        mobileMenuOverlay.addEventListener('click', closeMobileMenu);
    }
    
    // Close mobile menu on escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape' && mobileMenuSidebar.classList.contains('active')) {
            closeMobileMenu();
        }
    });
    
    // Header scroll effect
    const header = document.getElementById('main-header');
    if (header) {
        let lastScrollTop = 0;
        window.addEventListener('scroll', function() {
            const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
            
            if (scrollTop > 100) {
                header.classList.add('scrolled');
            } else {
                header.classList.remove('scrolled');
            }
            
            lastScrollTop = scrollTop;
        });
    }
    
    // Dropdown functionality
    const dropdowns = document.querySelectorAll('.dropdown');
    dropdowns.forEach(dropdown => {
        const toggle = dropdown.querySelector('.dropdown-toggle');
        const menu = dropdown.querySelector('.dropdown-menu');
        
        if (toggle && menu) {
            toggle.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                // Close other dropdowns
                dropdowns.forEach(other => {
                    if (other !== dropdown) {
                        other.classList.remove('active');
                    }
                });
                
                dropdown.classList.toggle('active');
            });
        }
    });
    
    // Close dropdowns when clicking outside
    document.addEventListener('click', function() {
        dropdowns.forEach(dropdown => {
            dropdown.classList.remove('active');
        });
    });
    
    // Prevent dropdown menu clicks from closing the dropdown
    document.querySelectorAll('.dropdown-menu').forEach(menu => {
        menu.addEventListener('click', function(e) {
            e.stopPropagation();
        });
    });
});

// Preloader functionality
window.addEventListener('load', function() {
    const preloader = document.getElementById('preloader');
    if (preloader) {
        setTimeout(function() {
            preloader.style.opacity = '0';
            setTimeout(function() {
                preloader.style.display = 'none';
            }, 600);
        }, 1000);
    }
});
</script>