<?php
// Enable error reporting for debugging (keep commented out in production)
// Disable all error reporting
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);


/**
 * Existing function remains unchanged.
 */
function getCountryCode($countryName) {
    // Your existing logic here...
    return ''; // placeholder
}

// Full list of countries for the country map
$allCountries = [
  ["name" => "Afghanistan", "code" => "af", "dial_code" => "+93"],
    ["name" => "Albania", "code" => "al", "dial_code" => "+355"],
    ["name" => "Algeria", "code" => "dz", "dial_code" => "+213"],
    ["name" => "Andorra", "code" => "ad", "dial_code" => "+376"],
    ["name" => "Angola", "code" => "ao", "dial_code" => "+244"],
    ["name" => "Antigua and Barbuda", "code" => "ag", "dial_code" => "+1-268"],
    ["name" => "Argentina", "code" => "ar", "dial_code" => "+54"],
    ["name" => "Armenia", "code" => "am", "dial_code" => "+374"],
    ["name" => "Australia", "code" => "au", "dial_code" => "+61"],
    ["name" => "Austria", "code" => "at", "dial_code" => "+43"],
    ["name" => "Azerbaijan", "code" => "az", "dial_code" => "+994"],
    ["name" => "Bahamas", "code" => "bs", "dial_code" => "+1-242"],
    ["name" => "Bahrain", "code" => "bh", "dial_code" => "+973"],
    ["name" => "Bangladesh", "code" => "bd", "dial_code" => "+880"],
    ["name" => "Barbados", "code" => "bb", "dial_code" => "+1-246"],
    ["name" => "Belarus", "code" => "by", "dial_code" => "+375"],
    ["name" => "Belgium", "code" => "be", "dial_code" => "+32"],
    ["name" => "Belize", "code" => "bz", "dial_code" => "+501"],
    ["name" => "Benin", "code" => "bj", "dial_code" => "+229"],
    ["name" => "Bhutan", "code" => "bt", "dial_code" => "+975"],
    ["name" => "Bolivia", "code" => "bo", "dial_code" => "+591"],
    ["name" => "Bosnia and Herzegovina", "code" => "ba", "dial_code" => "+387"],
    ["name" => "Botswana", "code" => "bw", "dial_code" => "+267"],
    ["name" => "Brazil", "code" => "br", "dial_code" => "+55"],
    ["name" => "Brunei", "code" => "bn", "dial_code" => "+673"],
    ["name" => "Bulgaria", "code" => "bg", "dial_code" => "+359"],
    ["name" => "Burkina Faso", "code" => "bf", "dial_code" => "+226"],
    ["name" => "Burundi", "code" => "bi", "dial_code" => "+257"],
    ["name" => "Cabo Verde", "code" => "cv", "dial_code" => "+238"],
    ["name" => "Cambodia", "code" => "kh", "dial_code" => "+855"],
    ["name" => "Cameroon", "code" => "cm", "dial_code" => "+237"],
    ["name" => "Canada", "code" => "ca", "dial_code" => "+1"],
    ["name" => "Central African Republic", "code" => "cf", "dial_code" => "+236"],
    ["name" => "Chad", "code" => "td", "dial_code" => "+235"],
    ["name" => "Chile", "code" => "cl", "dial_code" => "+56"],
    ["name" => "China", "code" => "cn", "dial_code" => "+86"],
    ["name" => "Colombia", "code" => "co", "dial_code" => "+57"],
    ["name" => "Comoros", "code" => "km", "dial_code" => "+269"],
    ["name" => "Congo (Congo-Brazzaville)", "code" => "cg", "dial_code" => "+242"],
    ["name" => "Costa Rica", "code" => "cr", "dial_code" => "+506"],
    ["name" => "Croatia", "code" => "hr", "dial_code" => "+385"],
    ["name" => "Cuba", "code" => "cu", "dial_code" => "+53"],
    ["name" => "Cyprus", "code" => "cy", "dial_code" => "+357"],
    ["name" => "Czechia (Czech Republic)", "code" => "cz", "dial_code" => "+420"],
    ["name" => "Democratic Republic of the Congo", "code" => "cd", "dial_code" => "+243"],
    ["name" => "Denmark", "code" => "dk", "dial_code" => "+45"],
    ["name" => "Djibouti", "code" => "dj", "dial_code" => "+253"],
    ["name" => "Dominica", "code" => "dm", "dial_code" => "+1-767"],
    ["name" => "Dominican Republic", "code" => "do", "dial_code" => "+1-809"],
    ["name" => "Ecuador", "code" => "ec", "dial_code" => "+593"],
    ["name" => "Egypt", "code" => "eg", "dial_code" => "+20"],
    ["name" => "El Salvador", "code" => "sv", "dial_code" => "+503"],
    ["name" => "Equatorial Guinea", "code" => "gq", "dial_code" => "+240"],
    ["name" => "Eritrea", "code" => "er", "dial_code" => "+291"],
    ["name" => "Estonia", "code" => "ee", "dial_code" => "+372"],
    ["name" => "Eswatini", "code" => "sz", "dial_code" => "+268"],
    ["name" => "Ethiopia", "code" => "et", "dial_code" => "+251"],
    ["name" => "Fiji", "code" => "fj", "dial_code" => "+679"],
    ["name" => "Finland", "code" => "fi", "dial_code" => "+358"],
    ["name" => "France", "code" => "fr", "dial_code" => "+33"],
    ["name" => "Gabon", "code" => "ga", "dial_code" => "+241"],
    ["name" => "Gambia", "code" => "gm", "dial_code" => "+220"],
    ["name" => "Georgia", "code" => "ge", "dial_code" => "+995"],
    ["name" => "Germany", "code" => "de", "dial_code" => "+49"],
    ["name" => "Ghana", "code" => "gh", "dial_code" => "+233"],
    ["name" => "Greece", "code" => "gr", "dial_code" => "+30"],
    ["name" => "Grenada", "code" => "gd", "dial_code" => "+1-473"],
    ["name" => "Guatemala", "code" => "gt", "dial_code" => "+502"],
    ["name" => "Guinea", "code" => "gn", "dial_code" => "+224"],
    ["name" => "Guinea-Bissau", "code" => "gw", "dial_code" => "+245"],
    ["name" => "Guyana", "code" => "gy", "dial_code" => "+592"],
    ["name" => "Haiti", "code" => "ht", "dial_code" => "+509"],
    ["name" => "Holy See", "code" => "va", "dial_code" => "+379"],
    ["name" => "Honduras", "code" => "hn", "dial_code" => "+504"],
    ["name" => "Hungary", "code" => "hu", "dial_code" => "+36"],
    ["name" => "Iceland", "code" => "is", "dial_code" => "+354"],
    ["name" => "India", "code" => "in", "dial_code" => "+91"],
    ["name" => "Indonesia", "code" => "id", "dial_code" => "+62"],
    ["name" => "Iran", "code" => "ir", "dial_code" => "+98"],
    ["name" => "Iraq", "code" => "iq", "dial_code" => "+964"],
    ["name" => "Ireland", "code" => "ie", "dial_code" => "+353"],
    ["name" => "Israel", "code" => "il", "dial_code" => "+972"],
    ["name" => "Italy", "code" => "it", "dial_code" => "+39"],
    ["name" => "Jamaica", "code" => "jm", "dial_code" => "+1-876"],
    ["name" => "Japan", "code" => "jp", "dial_code" => "+81"],
    ["name" => "Jordan", "code" => "jo", "dial_code" => "+962"],
    ["name" => "Kazakhstan", "code" => "kz", "dial_code" => "+7"],
    ["name" => "Kenya", "code" => "ke", "dial_code" => "+254"],
    ["name" => "Kiribati", "code" => "ki", "dial_code" => "+686"],
    ["name" => "Kuwait", "code" => "kw", "dial_code" => "+965"],
    ["name" => "Kyrgyzstan", "code" => "kg", "dial_code" => "+996"],
    ["name" => "Laos", "code" => "la", "dial_code" => "+856"],
    ["name" => "Latvia", "code" => "lv", "dial_code" => "+371"],
    ["name" => "Lebanon", "code" => "lb", "dial_code" => "+961"],
    ["name" => "Lesotho", "code" => "ls", "dial_code" => "+266"],
    ["name" => "Liberia", "code" => "lr", "dial_code" => "+231"],
    ["name" => "Libya", "code" => "ly", "dial_code" => "+218"],
    ["name" => "Liechtenstein", "code" => "li", "dial_code" => "+423"],
    ["name" => "Lithuania", "code" => "lt", "dial_code" => "+370"],
    ["name" => "Luxembourg", "code" => "lu", "dial_code" => "+352"],
    ["name" => "Madagascar", "code" => "mg", "dial_code" => "+261"],
    ["name" => "Malawi", "code" => "mw", "dial_code" => "+265"],
    ["name" => "Malaysia", "code" => "my", "dial_code" => "+60"],
    ["name" => "Maldives", "code" => "mv", "dial_code" => "+960"],
    ["name" => "Mali", "code" => "ml", "dial_code" => "+223"],
    ["name" => "Malta", "code" => "mt", "dial_code" => "+356"],
    ["name" => "Marshall Islands", "code" => "mh", "dial_code" => "+692"],
    ["name" => "Mauritania", "code" => "mr", "dial_code" => "+222"],
    ["name" => "Mauritius", "code" => "mu", "dial_code" => "+230"],
    ["name" => "Mexico", "code" => "mx", "dial_code" => "+52"],
    ["name" => "Micronesia", "code" => "fm", "dial_code" => "+691"],
    ["name" => "Moldova", "code" => "md", "dial_code" => "+373"],
    ["name" => "Monaco", "code" => "mc", "dial_code" => "+377"],
    ["name" => "Mongolia", "code" => "mn", "dial_code" => "+976"],
    ["name" => "Montenegro", "code" => "me", "dial_code" => "+382"],
    ["name" => "Morocco", "code" => "ma", "dial_code" => "+212"],
    ["name" => "Mozambique", "code" => "mz", "dial_code" => "+258"],
    ["name" => "Myanmar", "code" => "mm", "dial_code" => "+95"],
    ["name" => "Namibia", "code" => "na", "dial_code" => "+264"],
    ["name" => "Nauru", "code" => "nr", "dial_code" => "+674"],
    ["name" => "Nepal", "code" => "np", "dial_code" => "+977"],
    ["name" => "Netherlands", "code" => "nl", "dial_code" => "+31"],
    ["name" => "New Zealand", "code" => "nz", "dial_code" => "+64"],
    ["name" => "Nicaragua", "code" => "ni", "dial_code" => "+505"],
    ["name" => "Niger", "code" => "ne", "dial_code" => "+227"],
    ["name" => "Nigeria", "code" => "ng", "dial_code" => "+234"],
    ["name" => "North Korea", "code" => "kp", "dial_code" => "+850"],
    ["name" => "North Macedonia", "code" => "mk", "dial_code" => "+389"],
    ["name" => "Norway", "code" => "no", "dial_code" => "+47"],
    ["name" => "Oman", "code" => "om", "dial_code" => "+968"],
    ["name" => "Pakistan", "code" => "pk", "dial_code" => "+92"],
    ["name" => "Palau", "code" => "pw", "dial_code" => "+680"],
    ["name" => "Palestine", "code" => "ps", "dial_code" => "+970"],
    ["name" => "Panama", "code" => "pa", "dial_code" => "+507"],
    ["name" => "Papua New Guinea", "code" => "pg", "dial_code" => "+675"],
    ["name" => "Paraguay", "code" => "py", "dial_code" => "+595"],
    ["name" => "Peru", "code" => "pe", "dial_code" => "+51"],
    ["name" => "Philippines", "code" => "ph", "dial_code" => "+63"],
    ["name" => "Poland", "code" => "pl", "dial_code" => "+48"],
    ["name" => "Portugal", "code" => "pt", "dial_code" => "+351"],
    ["name" => "Qatar", "code" => "qa", "dial_code" => "+974"],
    ["name" => "Romania", "code" => "ro", "dial_code" => "+40"],
    ["name" => "Russia", "code" => "ru", "dial_code" => "+7"],
    ["name" => "Rwanda", "code" => "rw", "dial_code" => "+250"],
    ["name" => "Saint Kitts and Nevis", "code" => "kn", "dial_code" => "+1-869"],
    ["name" => "Saint Lucia", "code" => "lc", "dial_code" => "+1-758"],
    ["name" => "Saint Vincent and the Grenadines", "code" => "vc", "dial_code" => "+1-784"],
    ["name" => "Samoa", "code" => "ws", "dial_code" => "+685"],
    ["name" => "San Marino", "code" => "sm", "dial_code" => "+378"],
    ["name" => "Sao Tome and Principe", "code" => "st", "dial_code" => "+239"],
    ["name" => "Saudi Arabia", "code" => "sa", "dial_code" => "+966"],
    ["name" => "Senegal", "code" => "sn", "dial_code" => "+221"],
    ["name" => "Serbia", "code" => "rs", "dial_code" => "+381"],
    ["name" => "Seychelles", "code" => "sc", "dial_code" => "+248"],
    ["name" => "Sierra Leone", "code" => "sl", "dial_code" => "+232"],
    ["name" => "Singapore", "code" => "sg", "dial_code" => "+65"],
    ["name" => "Slovakia", "code" => "sk", "dial_code" => "+421"],
    ["name" => "Slovenia", "code" => "si", "dial_code" => "+386"],
    ["name" => "Solomon Islands", "code" => "sb", "dial_code" => "+677"],
    ["name" => "Somalia", "code" => "so", "dial_code" => "+252"],
    ["name" => "South Africa", "code" => "za", "dial_code" => "+27"],
    ["name" => "South Korea", "code" => "kr", "dial_code" => "+82"],
    ["name" => "South Sudan", "code" => "ss", "dial_code" => "+211"],
    ["name" => "Spain", "code" => "es", "dial_code" => "+34"],
    ["name" => "Sri Lanka", "code" => "lk", "dial_code" => "+94"],
    ["name" => "Sudan", "code" => "sd", "dial_code" => "+249"],
    ["name" => "Suriname", "code" => "sr", "dial_code" => "+597"],
    ["name" => "Sweden", "code" => "se", "dial_code" => "+46"],
    ["name" => "Switzerland", "code" => "ch", "dial_code" => "+41"],
    ["name" => "Syria", "code" => "sy", "dial_code" => "+963"],
    ["name" => "Taiwan", "code" => "tw", "dial_code" => "+886"],
    ["name" => "Tajikistan", "code" => "tj", "dial_code" => "+992"],
    ["name" => "Tanzania", "code" => "tz", "dial_code" => "+255"],
    ["name" => "Thailand", "code" => "th", "dial_code" => "+66"],
    ["name" => "Timor-Leste", "code" => "tl", "dial_code" => "+670"],
    ["name" => "Togo", "code" => "tg", "dial_code" => "+228"],
    ["name" => "Tonga", "code" => "to", "dial_code" => "+676"],
    ["name" => "Trinidad and Tobago", "code" => "tt", "dial_code" => "+1-868"],
    ["name" => "Tunisia", "code" => "tn", "dial_code" => "+216"],
    ["name" => "Turkey", "code" => "tr", "dial_code" => "+90"],
    ["name" => "Turkmenistan", "code" => "tm", "dial_code" => "+993"],
    ["name" => "Tuvalu", "code" => "tv", "dial_code" => "+688"],
    ["name" => "Uganda", "code" => "ug", "dial_code" => "+256"],
    ["name" => "Ukraine", "code" => "ua", "dial_code" => "+380"],
    ["name" => "United Arab Emirates", "code" => "ae", "dial_code" => "+971"],
    ["name" => "United Kingdom", "code" => "gb", "dial_code" => "+44"],
    ["name" => "United States of America", "code" => "us", "dial_code" => "+1"],
    ["name" => "Uruguay", "code" => "uy", "dial_code" => "+598"],
    ["name" => "Uzbekistan", "code" => "uz", "dial_code" => "+998"],
    ["name" => "Vanuatu", "code" => "vu", "dial_code" => "+678"],
    ["name" => "Venezuela", "code" => "ve", "dial_code" => "+58"],
    ["name" => "Vietnam", "code" => "vn", "dial_code" => "+84"],
    ["name" => "Yemen", "code" => "ye", "dial_code" => "+967"],
    ["name" => "Zambia", "code" => "zm", "dial_code" => "+260"],
    ["name" => "Zimbabwe", "code" => "zw", "dial_code" => "+263"]
];

require 'db.php';
include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('Pending or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$balance        = $userDetails['balance'];
$btc            = $userDetails['btc'];
$eth            = $userDetails['eth'];
$usdt           = $userDetails['usdt'];
$xrp            = $userDetails['xrp'];
$doge           = $userDetails['doge'];
$ada            = $userDetails['ada'];
$pepe           = $userDetails['pepe'];
$sol            = $userDetails['sol'];
$bnb            = $userDetails['bnb'];
$message        = $userDetails['message'];
$extra          = $userDetails['extra'];
$msgstatus      = $userDetails['msgstatus'];
$bonus          = $userDetails['bonus'];
$profit         = $userDetails['profit'];
$update_time    = $userDetails['update_time'];

// Check if country or phone is empty/null
$showProfileAlert = empty($country) || $country === null || empty($phone) || $phone === null;

// Fetch country statistics from the database
try {
    $query = "SELECT country, COUNT(*) AS customers
              FROM users 
              GROUP BY country
              ORDER BY customers DESC";
              
    $result = mysqli_query($conn, $query);
    
    if (!$result) {
        throw new Exception("Query failed: " . mysqli_error($conn));
    }
    
    $dbCountries = [];
    $total_customers = 0;
    
    // Build associative array of country counts using country name as key
    while ($row = mysqli_fetch_assoc($result)) {
        $dbCountries[$row['country']] = $row['customers'];
        $total_customers += $row['customers'];
    }
    
    // Merge full list of countries with DB data
    $countriesMap = [];
    foreach ($allCountries as $item) {
        $custCount = isset($dbCountries[$item['name']]) ? $dbCountries[$item['name']] : 0;
        $percentage = ($total_customers > 0) ? round(($custCount / $total_customers) * 100, 2) : 0;
        $item['customers'] = $custCount;
        $item['percentage'] = $percentage;
        $countriesMap[] = $item;
    }
    
    // Prepare JSON for client-side use if needed
    $jsonCountries = json_encode($countriesMap);
    
} catch (Exception $e) {
    die("Database error: " . $e->getMessage());
}

// Process form submission for profile update inline
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_profile'])) {
    $newDialCode = $_POST['country'];
    $newPhone = $_POST['full_phone']; // Full phone with dial code
    
    // Validate inputs
    if (empty($newDialCode) || empty($newPhone)) {
        $updateError = "Both country and phone number are required.";
    } else {
        // Map the dial code to the country name using the full countries list
        $newCountry = $newDialCode; // default fallback
        foreach ($allCountries as $c) {
            if ($c['dial_code'] === $newDialCode) {
                $newCountry = $c['name'];
                break;
            }
        }
        
        // Update user profile in the database using mysqli
        $updateQuery = "UPDATE users 
                        SET country = ?, phone = ? 
                        WHERE google_id = ?";
        $stmt = mysqli_prepare($conn, $updateQuery);
        
        if ($stmt) {
            mysqli_stmt_bind_param($stmt, "sss", $newCountry, $newPhone, $google_id);
            
            if (mysqli_stmt_execute($stmt)) {
                // Instead of redirecting, update inline variables and set a success message
                $updateMessage = "Profile updated successfully.";
                $country = $newCountry;
                $phone = $newPhone;
            } else {
                $updateError = "Failed to update profile: " . mysqli_stmt_error($stmt);
            }
            
            mysqli_stmt_close($stmt);
        } else {
            $updateError = "Failed to prepare statement: " . mysqli_error($conn);
        }
    }
}
?>





<?php include './includes/header.php'; ?>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Primemarketspro | Crypto & Stock Trading Platform</title>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
  <style>
    :root {
      --primary-purple: #7c3aed;
      --primary-purple-dark: #6d28d9;
      --primary-purple-light: #a78bfa;
      --secondary-purple: #8b5cf6;
    }
    .bg-primary-purple {
      background-color: var(--primary-purple);
    }
    .text-primary-purple {
      color: var(--primary-purple);
    }
    .border-primary-purple {
      border-color: var(--primary-purple);
    }
    .hover-bg-primary-purple-dark:hover {
      background-color: var(--primary-purple-dark);
    }
    .price-up {
      color: #10b981;
    }
    .price-down {
      color: #ef4444;
    }
    .tab-active {
      color: var(--primary-purple);
      border-bottom: 2px solid var(--primary-purple);
    }
    .sidebar-item:hover {
      background-color: rgba(124, 58, 237, 0.1);
    }
    .chart-container {
      height: 300px;
      width: 100%;
    }
    .coin-icon {
      width: 24px;
      height: 24px;
    }
    .form-toggle-button {
      background-color: #f3f4f6;
      color: #6b7280;
    }
    .form-toggle-button.active {
      background-color: var(--primary-purple);
      color: white;
    }
    /* Mobile optimizations */
    @media (max-width: 768px) {
      .mobile-hidden {
        display: none;
      }
      .mobile-full {
        width: 100%;
      }
    }
    /* Custom scrollbar for assets list */
    .assets-list::-webkit-scrollbar {
      width: 5px;
    }
    .assets-list::-webkit-scrollbar-track {
      background: #f1f1f1;
    }
    .assets-list::-webkit-scrollbar-thumb {
      background: var(--primary-purple-light);
      border-radius: 5px;
    }
    .pulse-animation {
      animation: pulse 2s infinite;
    }
    @keyframes pulse {
      0% {
        box-shadow: 0 0 0 0 rgba(124, 58, 237, 0.4);
      }
      70% {
        box-shadow: 0 0 0 10px rgba(124, 58, 237, 0);
      }
      100% {
        box-shadow: 0 0 0 0 rgba(124, 58, 237, 0);
      }
    }
  </style>
</head>
<body class="bg-gray-50 font-sans antialiased">
  <!-- Main Container -->
  <div class="flex flex-col min-h-screen">
    <!-- Top Navigation Bar -->
    <nav class="bg-white shadow-md px-4 py-2 flex items-center justify-between">
      <div class="flex items-center">
        <div class="text-2xl font-bold text-primary-purple flex items-center">
          <svg class="h-8 w-8 mr-2" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" stroke="#7c3aed" stroke-width="2"/>
            <path d="M16 8L12 12M12 12L8 16M12 12L8 8M12 12L16 16" stroke="#7c3aed" stroke-width="2" stroke-linecap="round"/>
          </svg>
          Primemarketspro
        </div>
      </div>
      <div class="flex items-center space-x-4">
        <button class="bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-full p-2 hidden md:block">
          <i class="fas fa-bell"></i>
        </button>
        <button class="bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-full p-2 hidden md:block">
          <i class="fas fa-cog"></i>
        </button>
        <button class="bg-primary-purple text-white px-4 py-2 rounded-lg hover:bg-primary-purple-dark transition">
          <i class="fas fa-wallet mr-1"></i>
          <span class="hidden md:inline">Connect Wallet</span>
        </button>
        <div class="flex items-center ml-2">
          <div class="h-8 w-8 rounded-full bg-gray-300 flex items-center justify-center overflow-hidden">
            <i class="fas fa-user text-gray-500"></i>
          </div>
        </div>
      </div>
    </nav>

    <!-- Main Content -->
    <div class="flex flex-col md:flex-row flex-1">
      <!-- Sidebar (desktop only) -->
      <div class="hidden md:block w-56 bg-white shadow-md">
  <div class="p-4">
    <div class="text-sm text-gray-500 mb-2">MENU</div>
    <div class="space-y-1">
      <a href="#" class="flex items-center p-2 rounded-lg sidebar-item text-primary-purple bg-purple-50">
        <i class="fas fa-chart-line mr-3"></i>
        <span>Trading</span>
      </a>
      <a href="dashboard.php" class="flex items-center p-2 rounded-lg sidebar-item text-gray-700">
        <i class="fas fa-wallet mr-3"></i>
        <span>Wallet</span>
      </a>
      <a href="history.php" class="flex items-center p-2 rounded-lg sidebar-item text-gray-700">
        <i class="fas fa-history mr-3"></i>
        <span>History</span>
      </a>
      <a href="dashboard.php" class="flex items-center p-2 rounded-lg sidebar-item text-gray-700">
        <i class="fas fa-credit-card mr-3"></i>
        <span>Deposit</span>
      </a>
      <a href="crypto.php" class="flex items-center p-2 rounded-lg sidebar-item text-gray-700">
        <i class="fas fa-exchange-alt mr-3"></i>
        <span>Withdraw</span>
      </a>
    </div>
  </div>

        <div class="border-t border-gray-200 p-4">
          <div class="text-sm text-gray-500 mb-2">ASSETS</div>
          <div class="space-y-1 assets-list max-h-56 overflow-y-auto">
            <!-- Will be populated with JavaScript -->
          </div>
        </div>
      </div>

      <!-- Main content area -->
      <div class="flex-1 p-4">
        <!-- Breadcrumb -->
        <div class="text-sm text-gray-500 mb-4">
          Home / Trading / <span class="text-primary-purple">Exchange</span>
        </div>

        <!-- Market Overview -->
        <div class="bg-white rounded-lg shadow-md p-4 mb-6">
          <div class="flex items-center justify-between mb-3">
            <h2 class="text-lg font-semibold">Market Overview</h2>
            <div class="text-sm text-gray-500">
              Last updated: <span id="lastUpdated">Loading...</span>
            </div>
          </div>
          <div class="grid grid-cols-2 md:grid-cols-4 gap-4" id="marketOverview">
            <!-- Will be populated with JavaScript -->
          </div>
        </div>

        <!-- Main trading section -->
        <div class="flex flex-col md:flex-row gap-6">
          <!-- Left column - Chart -->
          <div class="md:w-2/3 bg-white rounded-lg shadow-md p-4">
            <div class="flex items-center justify-between mb-4">
              <div class="flex items-center">
                <div id="selectedCoinIcon" class="w-8 h-8 mr-2 rounded-full bg-gray-200 flex items-center justify-center">
                  <i class="fab fa-bitcoin text-yellow-500"></i>
                </div>
                <div>
                  <h2 class="text-xl font-bold" id="selectedCoinName">Bitcoin</h2>
                  <div class="text-sm text-gray-500" id="selectedCoinCode">BTC/USD</div>
                </div>
              </div>
              <div>
                <div class="text-2xl font-bold" id="selectedCoinPrice">$0.00</div>
                <div class="text-sm" id="selectedCoinChange">+0.00%</div>
              </div>
            </div>
            
            <!-- Chart tabs -->
            <div class="flex border-b border-gray-200 mb-4">
              <button class="px-4 py-2 text-sm tab-active">Price</button>
              <button class="px-4 py-2 text-sm text-gray-500">Depth</button>
              <button class="px-4 py-2 text-sm text-gray-500">Technical</button>
            </div>
            
            <!-- Chart time frames -->
            <div class="flex flex-wrap gap-2 mb-4">
              <button class="px-3 py-1 text-xs rounded-full bg-primary-purple text-white">1H</button>
              <button class="px-3 py-1 text-xs rounded-full bg-gray-200 text-gray-700">4H</button>
              <button class="px-3 py-1 text-xs rounded-full bg-gray-200 text-gray-700">1D</button>
              <button class="px-3 py-1 text-xs rounded-full bg-gray-200 text-gray-700">1W</button>
              <button class="px-3 py-1 text-xs rounded-full bg-gray-200 text-gray-700">1M</button>
            </div>
            
            <!-- Chart container -->
            <div class="chart-container mb-4 animate__animated animate__fadeIn">
              <svg id="priceChart" viewBox="0 0 800 300" class="w-full h-full">
                <path d="M0,150 C100,100 200,200 300,120 C400,50 500,200 600,150 C700,100 800,120 800,150" stroke="#7c3aed" stroke-width="2" fill="none"></path>
                <path d="M0,150 C100,100 200,200 300,120 C400,50 500,200 600,150 C700,100 800,120 800,150 L800,300 L0,300 Z" fill="url(#purpleGradient)" opacity="0.2"></path>
                <defs>
                  <linearGradient id="purpleGradient" x1="0%" y1="0%" x2="0%" y2="100%">
                    <stop offset="0%" stop-color="#7c3aed" />
                    <stop offset="100%" stop-color="#7c3aed" stop-opacity="0" />
                  </linearGradient>
                </defs>
              </svg>
            </div>
            
            <!-- Chart Information -->
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-sm">
              <div>
                <div class="text-gray-500">24h High</div>
                <div class="font-medium" id="high24h">$0.00</div>
              </div>
              <div>
                <div class="text-gray-500">24h Low</div>
                <div class="font-medium" id="low24h">$0.00</div>
              </div>
              <div>
                <div class="text-gray-500">24h Volume</div>
                <div class="font-medium" id="volume24h">$0.00</div>
              </div>
              <div>
                <div class="text-gray-500">Market Cap</div>
                <div class="font-medium" id="marketCap">$0.00</div>
              </div>
            </div>
          </div>
          
          <!-- Right column - Trading Form -->
          <div class="md:w-1/3">
            <!-- Trade Form Card -->
            <div class="bg-white rounded-lg shadow-md p-4 mb-6">
              <div class="mb-4">
                <div class="flex rounded-lg overflow-hidden">
                  <button class="flex-1 py-2 text-center form-toggle-button active" id="spotBtn">Spot</button>
                  <button class="flex-1 py-2 text-center form-toggle-button" id="marginBtn">Margin</button>
                  <button class="flex-1 py-2 text-center form-toggle-button" id="futuresBtn">Futures</button>
                </div>
              </div>
              
    <!-- Trading Form -->
    <form id="tradeForm" action="tradeprocess.php" method="POST" class="space-y-4">
      <!-- Transaction Type -->
      <div class="flex rounded-lg overflow-hidden mb-2">
        <button type="button" class="flex-1 py-2 text-center bg-green-500 text-white" id="buyBtn">Buy</button>
        <button type="button" class="flex-1 py-2 text-center bg-gray-200 text-gray-700" id="sellBtn">Sell</button>
        <input type="hidden" name="transactionType" id="transactionTypeInput" value="buy">
      </div>
      
      <!-- Currency Dropdown -->
      <div>
        <label for="transactionCurrency" class="block text-sm font-medium text-gray-700 mb-1">Currency</label>
        <div class="relative">
          <select id="transactionCurrency" name="transactionCurrency" class="block w-full border border-gray-300 rounded-lg shadow-sm p-2 pr-8 appearance-none" required>
            <option value="bitcoin" selected>Bitcoin (BTC)</option>
            <option value="ethereum">Ethereum (ETH)</option>
            <option value="cardano">Cardano (ADA)</option>
            <option value="solana">Solana (SOL)</option>
            <option value="binancecoin">Binance Coin (BNB)</option>
          </select>
          <div class="absolute inset-y-0 right-0 flex items-center px-2 pointer-events-none">
            <svg class="h-4 w-4 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
            </svg>
          </div>
        </div>
      </div>
      
      <!-- Leverage (hidden by default) -->
      <div id="leverageContainer" class="hidden">
        <label class="block text-sm font-medium text-gray-700 mb-1">Leverage</label>
        <div class="flex items-center">
          <input type="range" min="1" max="100" value="1" id="leverageSlider" name="leverage" class="w-full h-2 bg-gray-200 rounded-lg appearance-none cursor-pointer">
          <span id="leverageValue" class="ml-2 text-sm font-medium text-gray-700">1x</span>
        </div>
      </div>
      
      <!-- USD Amount Input -->
      <div>
        <label for="transactionAmount" class="block text-sm font-medium text-gray-700 mb-1">Amount (USD)</label>
        <div class="relative">
          <input type="number" id="transactionAmount" name="transactionAmount" placeholder="Enter amount in USD" min="0.01" step="0.01" required class="block w-full border border-gray-300 rounded-lg shadow-sm p-2 pl-7">
          <div class="absolute inset-y-0 left-0 flex items-center pl-2 pointer-events-none">
            <span class="text-gray-500">$</span>
          </div>
          <div class="absolute inset-y-0 right-0 flex items-center">
            <button type="button" id="quarter" class="text-purple-600 text-xs px-2 py-1 rounded border border-purple-600 mx-1">25%</button>
            <button type="button" id="max" class="text-purple-600 text-xs px-2 py-1 rounded border border-purple-600 mx-1">Max</button>
          </div>
        </div>
      </div>
      
      <!-- Converted Coin Amount -->
      <div>
        <label for="convertedAmount" class="block text-sm font-medium text-gray-700 mb-1">
          Converted Amount (<span id="selectedSymbol">BTC</span>)
        </label>
        <input type="number" id="convertedAmount" name="convertedAmount" placeholder="Coin amount" readonly class="block w-full border border-gray-300 rounded-lg shadow-sm p-2 bg-gray-50">
      </div>
      
      <!-- Order Type -->
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-1">Order Type</label>
        <div class="grid grid-cols-3 gap-2">
          <button type="button" class="py-1 text-center text-sm bg-purple-600 text-white rounded" id="marketOrderBtn">Market</button>
          <button type="button" class="py-1 text-center text-sm bg-gray-200 text-gray-700 rounded" id="limitOrderBtn">Limit</button>
          <button type="button" class="py-1 text-center text-sm bg-gray-200 text-gray-700 rounded" id="stopOrderBtn">Stop</button>
          <input type="hidden" name="orderType" id="orderTypeInput" value="market">
        </div>
      </div>
      
      <!-- Submit Button -->
      <button type="submit" id="submitOrderBtn" class="w-full bg-green-500 text-white py-2 rounded-lg hover:bg-green-600 transition flex items-center justify-center">
        <span>Buy Now</span>
        <i class="fas fa-arrow-right ml-2"></i>
      </button>
    </form>
            </div>
            
            <!-- Balance Card -->
            <div class="bg-white rounded-lg shadow-md p-4">
              <h3 class="text-lg font-medium mb-3">Your Balance</h3>
              <div class="space-y-2">
                <div class="flex justify-between items-center">
                  <div class="flex items-center">
                    <div class="w-8 h-8 rounded-full bg-gray-200 flex items-center justify-center mr-2">
                      <i class="fas fa-dollar-sign text-green-500"></i>
                    </div>
                    <div>
                      <div class="font-medium">USD</div>
                      <div class="text-xs text-gray-500">US Dollar</div>
                    </div>
                  </div>
                  <div class="text-right">
                    <div class="font-medium">$10,000.00</div>
                    <div class="text-xs text-gray-500">Available</div>
                  </div>
                </div>
                <div class="flex justify-between items-center">
                  <div class="flex items-center">
                    <div class="w-8 h-8 rounded-full bg-gray-200 flex items-center justify-center mr-2">
                      <i class="fab fa-bitcoin text-yellow-500"></i>
                    </div>
                    <div>
                      <div class="font-medium">BTC</div>
                      <div class="text-xs text-gray-500">Bitcoin</div>
                    </div>
                  </div>
                  <div class="text-right">
                    <div class="font-medium">0.25</div>
                    <div class="text-xs text-gray-500">≈ $12,500.00</div>
                  </div>
                </div>
                <div class="flex justify-between items-center">
                  <div class="flex items-center">
                    <div class="w-8 h-8 rounded-full bg-gray-200 flex items-center justify-center mr-2">
                      <i class="fab fa-ethereum text-purple-500"></i>
                    </div>
                    <div>
                      <div class="font-medium">ETH</div>
                      <div class="text-xs text-gray-500">Ethereum</div>
                    </div>
                  </div>
                  <div class="text-right">
                    <div class="font-medium">2.5</div>
                    <div class="text-xs text-gray-500">≈ $7,500.00</div>
                  </div>
                </div>
              </div>
              <div class="mt-4 grid grid-cols-2 gap-2">
                <button class="bg-gray-100 hover:bg-gray-200 text-gray-700 py-2 rounded-lg transition flex items-center justify-center">
                  <i class="fas fa-credit-card mr-1"></i>
                  <span>Deposit</span>
                </button>
                <button class="bg-gray-100 hover:bg-gray-200 text-gray-700 py-2 rounded-lg transition flex items-center justify-center">
                  <i class="fas fa-exchange-alt mr-1"></i>
                  <span>Withdraw</span>
                </button>
              </div>
            </div>
          </div>
        </div>
        
        <!-- Order Book -->
        <div class="bg-white rounded-lg shadow-md p-4 mt-6">
          <h2 class="text-lg font-semibold mb-4">Recent Orders</h2>
          <div class="overflow-x-auto">
            <table class="min-w-full">
              <thead>
                <tr class="text-left text-xs text-gray-500 border-b">
                  <th class="pb-2">Date</th>
                  <th class="pb-2">Pair</th>
                  <th class="pb-2">Type</th>
                  <th class="pb-2">Side</th>
                  <th class="pb-2">Price</th>
                  <th class="pb-2">Amount</th>
                  <th class="pb-2">Total</th>
                  <th class="pb-2">Status</th>
                </tr>
              </thead>
              <tbody class="text-sm">
                <tr class="border-b border-gray-100">
                  <td class="py-3">May 21, 2025</td>
                  <td class="py-3">BTC/USD</td>
                  <td class="py-3">Market</td>
                  <td class="py-3 text-green-500">Buy</td>
                  <td class="py-3">$48,231.45</td>
                  <td class="py-3">0.12</td>
                  <td class="py-3">$5,787.77</td>
                  <td class="py-3"><span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs">Completed</span></td>
                </tr>
                <tr class="border-b border-gray-100">
                  <td class="py-3">May 20, 2025</td>
                  <td class="py-3">ETH/USD</td>
                  <td class="py-3">Limit</td>
                  <td class="py-3 text-red-500">Sell</td>
                  <td class="py-3">$3,452.67</td>
                  <td class="py-3">1.5</td>
                  <td class="py-3">$5,179.00</td>
                  <td class="py-3"><span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs">Completed</span></td>
                </tr>
                <tr class="border-b border-gray-100">
                  <td class="py-3">May 19, 2025</td>
                  <td class="py-3">ADA/USD</td>
                  <td class="py-3">Market</td>
                  <td class="py-3 text-green-500">Buy</td>
                  <td class="py-3">$1.22</td>
                  <td class="py-3">2000</td>
                  <td class="py-3">$2,440.00</td>
                  <td class="py-3"><span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs">Completed</span></td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <!-- Mobile Navigation (only visible on mobile) -->
   <div class="md:hidden fixed bottom-0 left-0 right-0 bg-white shadow-lg border-t border-gray-200 flex justify-around p-2">
  <a href="#" class="flex flex-col items-center justify-center p-2 text-primary-purple">
    <i class="fas fa-chart-line"></i>
    <span class="text-xs mt-1">Trading</span>
  </a>
  <a href="dashboard.php" class="flex flex-col items-center justify-center p-2 text-gray-500">
    <i class="fas fa-wallet"></i>
    <span class="text-xs mt-1">Wallet</span>
  </a>
  <a href="history.php" class="flex flex-col items-center justify-center p-2 text-gray-500">
    <i class="fas fa-history"></i>
    <span class="text-xs mt-1">History</span>
  </a>
  <a href="connect.php" class="flex flex-col items-center justify-center p-2 text-gray-500">
    <i class="fas fa-user"></i>
    <span class="text-xs mt-1">Connect</span>
  </a>
</div>

  </div>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/3.2.1/anime.min.js"></script>




<script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/3.2.1/anime.min.js"></script>
  <script>
    // Global variables
    let coinPrices = {};
    let selectedCoinId = "bitcoin";
    let selectedCoinSymbol = "BTC";
    let transactionType = "buy";
    let marketMode = "spot"; // spot, margin, futures
    
    // Theme colors for styling  
    const colors = {
      primary: '#7c3aed',
      success: '#10b981',
      danger: '#ef4444',
      warning: '#f59e0b',
      info: '#3b82f6'
    };
    
    // Mock data for stocks
    const stockData = [
      { id: "apple_stock", name: "Apple Inc.", symbol: "AAPL", current_price: 184.92, price_change_percentage_24h: 1.25, image: "https://api.placeholder.com/24x24" },
      { id: "microsoft_stock", name: "Microsoft", symbol: "MSFT", current_price: 415.26, price_change_percentage_24h: 0.87, image: "https://api.placeholder.com/24x24" },
      { id: "tesla_stock", name: "Tesla Inc.", symbol: "TSLA", current_price: 178.81, price_change_percentage_24h: -1.32, image: "https://api.placeholder.com/24x24" }
    ];

    // Initialize DOM elements
    document.addEventListener('DOMContentLoaded', function() {
      // Set up event listeners for form toggle buttons
      document.getElementById('spotBtn').addEventListener('click', () => setMarketMode('spot'));
      document.getElementById('marginBtn').addEventListener('click', () => setMarketMode('margin'));
      document.getElementById('futuresBtn').addEventListener('click', () => setMarketMode('futures'));
      
      // Set up event listeners for buy/sell buttons
      document.getElementById('buyBtn').addEventListener('click', () => setTransactionType('buy'));
      document.getElementById('sellBtn').addEventListener('click', () => setTransactionType('sell'));
      
      // Set up event listener for leverage slider
      document.getElementById('leverageSlider').addEventListener('input', (e) => {
        document.getElementById('leverageValue').textContent = `${e.target.value}x`;
      });
      
      // Set up event listeners for transaction amount and currency
      document.getElementById('transactionAmount').addEventListener('input', convertUsdToCoin);
      document.getElementById('transactionCurrency').addEventListener('change', function() {
        convertUsdToCoin();
        updateSelectedCoin(this.value);
      });
      
      // Fetch coins
      fetchCoins();
      
      // Update last updated timestamp
      updateLastUpdated();
      
      // Animate chart on load
      animateChart();
    });

    // Set market mode (spot, margin, futures)
    function setMarketMode(mode) {
      marketMode = mode;
      
      // Update buttons
      document.querySelectorAll('.form-toggle-button').forEach(btn => {
        btn.classList.remove('active');
      });
      
      document.getElementById(`${mode}Btn`).classList.add('active');
      
      // Show/hide leverage control based on market mode
      if (mode === 'spot') {
        document.getElementById('leverageContainer').classList.add('hidden');
      } else {
        document.getElementById('leverageContainer').classList.remove('hidden');
      }
    }

    // Set transaction type (buy/sell)
    function setTransactionType(type) {
      transactionType = type;
      
      // Update buttons
      if (type === 'buy') {
        document.getElementById('buyBtn').classList.remove('bg-gray-200', 'text-gray-700');
        document.getElementById('buyBtn').classList.add('bg-green-500', 'text-white');
        document.getElementById('sellBtn').classList.remove('bg-red-500', 'text-white');
        document.getElementById('sellBtn').classList.add('bg-gray-200', 'text-gray-700');
        document.getElementById('submitOrderBtn').classList.remove('bg-red-500');
        document.getElementById('submitOrderBtn').classList.add('bg-green-500');
        document.getElementById('submitOrderBtn').innerHTML = '<span>Buy Now</span><i class="fas fa-arrow-right ml-2"></i>';
      } else {
        document.getElementById('sellBtn').classList.remove('bg-gray-200', 'text-gray-700');
        document.getElementById('sellBtn').classList.add('bg-red-500', 'text-white');
        document.getElementById('buyBtn').classList.remove('bg-green-500', 'text-white');
        document.getElementById('buyBtn').classList.add('bg-gray-200', 'text-gray-700');
        document.getElementById('submitOrderBtn').classList.remove('bg-green-500');
        document.getElementById('submitOrderBtn').classList.add('bg-red-500');
        document.getElementById('submitOrderBtn').innerHTML = '<span>Sell Now</span><i class="fas fa-arrow-right ml-2"></i>';
      }
    }
    
    // Fetch coins from CoinGecko API
    async function fetchCoins() {
      try {
        const url = 'https://api.coingecko.com/api/v3/coins/markets?' + new URLSearchParams({
          vs_currency: 'usd',
          order: 'market_cap_desc',
          per_page: 8, // 8 cryptocurrencies
          page: 1,
          sparkline: false,
          price_change_percentage: '24h'
        });
        
        const response = await fetch(url);
        if (!response.ok) {
          throw new Error('Network response was not ok');
        }
        
        const coins = await response.json();
        
        // Combine with stock data
        const allAssets = [...coins, ...stockData];
        
        // Populate coin dropdown
        populateCoinDropdown(allAssets);
        
        // Populate market overview
        populateMarketOverview(allAssets);
        
        // Populate sidebar assets list
        populateSidebarAssets(allAssets);
        
        // Update default selected coin
        if (allAssets.length > 0) {
          updateSelectedCoin(allAssets[0].id);
        }
        
      } catch (error) {
        console.error('Error fetching coins:', error);
        // Fall back to mock data if API fails
        const mockCoins = [
          { id: "bitcoin", name: "Bitcoin", symbol: "btc", current_price: 48231.45, price_change_percentage_24h: 2.34, image: "https://api.placeholder.com/24x24", market_cap: 912553123456, total_volume: 28123456789, high_24h: 49123.45, low_24h: 47231.45 },
          { id: "ethereum", name: "Ethereum", symbol: "eth", current_price: 3452.67, price_change_percentage_24h: 1.89, image: "https://api.placeholder.com/24x24", market_cap: 412553123456, total_volume: 18123456789, high_24h: 3552.67, low_24h: 3352.67 },
          { id: "cardano", name: "Cardano", symbol: "ada", current_price: 1.22, price_change_percentage_24h: -0.76, image: "https://api.placeholder.com/24x24", market_cap: 39553123456, total_volume: 1123456789, high_24h: 1.25, low_24h: 1.18 },
          { id: "solana", name: "Solana", symbol: "sol", current_price: 136.75, price_change_percentage_24h: 3.45, image: "https://api.placeholder.com/24x24", market_cap: 56553123456, total_volume: 3123456789, high_24h: 142.75, low_24h: 132.75 },
          { id: "binancecoin", name: "Binance Coin", symbol: "bnb", current_price: 543.21, price_change_percentage_24h: 0.88, image: "https://api.placeholder.com/24x24", market_cap: 83553123456, total_volume: 2523456789, high_24h: 548.21, low_24h: 540.21 }
        ];
        
        const allAssets = [...mockCoins, ...stockData];
        populateCoinDropdown(allAssets);
        populateMarketOverview(allAssets);
        populateSidebarAssets(allAssets);
        
        if (allAssets.length > 0) {
          updateSelectedCoin(allAssets[0].id);
        }
      }
    }
    
    // Populate coin dropdown with fetched assets
    function populateCoinDropdown(assets) {
      const select = document.getElementById('transactionCurrency');
      select.innerHTML = '<option value="" disabled>Select Asset</option>';
      
      assets.forEach(asset => {
        // Save asset price for conversion
        coinPrices[asset.id] = asset.current_price;
        
        const option = document.createElement('option');
        option.value = asset.id;
        option.textContent = `${asset.name} (${asset.symbol.toUpperCase()})`;
        select.appendChild(option);
      });
      
      // Select first asset by default
      if (assets.length > 0) {
        select.value = assets[0].id;
      }
    }
    
    // Populate market overview with asset cards
    function populateMarketOverview(assets) {
      const container = document.getElementById('marketOverview');
      container.innerHTML = '';
      
      assets.slice(0, 4).forEach(asset => {
        const priceChangeClass = asset.price_change_percentage_24h >= 0 ? 'price-up' : 'price-down';
        const priceChangeIcon = asset.price_change_percentage_24h >= 0 ? 'fa-caret-up' : 'fa-caret-down';
        
        const assetCard = document.createElement('div');
        assetCard.className = 'bg-gray-50 rounded-lg p-3 animate__animated animate__fadeIn';
        assetCard.innerHTML = `
          <div class="flex items-center justify-between">
            <div class="flex items-center">
              <div class="coin-icon mr-2 bg-gray-200 rounded-full flex items-center justify-center">
                <i class="${asset.id === 'bitcoin' ? 'fab fa-bitcoin text-yellow-500' : 
                           asset.id === 'ethereum' ? 'fab fa-ethereum text-purple-600' : 
                           'fas fa-circle text-blue-500'}"></i>
              </div>
              <div>
                <div class="font-medium">${asset.symbol.toUpperCase()}</div>
                <div class="text-xs text-gray-500">${asset.name}</div>
              </div>
            </div>
            <div class="text-right">
              <div class="font-medium">${asset.current_price.toLocaleString()}</div>
              <div class="text-xs ${priceChangeClass}">
                <i class="fas ${priceChangeIcon}"></i>
                ${Math.abs(asset.price_change_percentage_24h).toFixed(2)}%
              </div>
            </div>
          </div>
        `;
        container.appendChild(assetCard);
        
        // Make cards clickable to select asset
        assetCard.style.cursor = 'pointer';
        assetCard.addEventListener('click', () => {
          updateSelectedCoin(asset.id);
          document.getElementById('transactionCurrency').value = asset.id;
          convertUsdToCoin();
        });
      });
    }
    
    // Populate sidebar assets list
    function populateSidebarAssets(assets) {
      const container = document.querySelector('.assets-list');
      container.innerHTML = '';
      
      assets.forEach(asset => {
        const priceChangeClass = asset.price_change_percentage_24h >= 0 ? 'price-up' : 'price-down';
        
        const assetItem = document.createElement('div');
        assetItem.className = 'flex items-center justify-between p-2 rounded-lg sidebar-item';
        assetItem.innerHTML = `
          <div class="flex items-center">
            <div class="w-6 h-6 rounded-full bg-gray-200 flex items-center justify-center mr-2">
              <i class="${asset.id === 'bitcoin' ? 'fab fa-bitcoin text-yellow-500' : 
                         asset.id === 'ethereum' ? 'fab fa-ethereum text-purple-600' : 
                         asset.id.includes('stock') ? 'fas fa-chart-line text-blue-500' :
                         'fas fa-circle text-blue-500'}"></i>
            </div>
            <span>${asset.symbol.toUpperCase()}</span>
          </div>
          <div class="text-right">
            <div class="text-xs font-medium">${asset.current_price.toLocaleString()}</div>
            <div class="text-xs ${priceChangeClass}">${asset.price_change_percentage_24h >= 0 ? '+' : ''}${asset.price_change_percentage_24h.toFixed(2)}%</div>
          </div>
        `;
        container.appendChild(assetItem);
        
        // Make items clickable to select asset
        assetItem.style.cursor = 'pointer';
        assetItem.addEventListener('click', () => {
          updateSelectedCoin(asset.id);
          document.getElementById('transactionCurrency').value = asset.id;
          convertUsdToCoin();
        });
      });
    }
    
    // Convert USD to selected coin amount
    function convertUsdToCoin() {
      const usdAmount = parseFloat(document.getElementById('transactionAmount').value) || 0;
      const coinId = document.getElementById('transactionCurrency').value;
      
      if (!coinId || !coinPrices[coinId]) {
        document.getElementById('convertedAmount').value = '';
        document.getElementById('selectedSymbol').textContent = 'COIN';
        return;
      }
      
      const price = coinPrices[coinId]; // USD per coin
      const coinAmount = usdAmount / price;
      
      document.getElementById('convertedAmount').value = coinAmount.toFixed(8);
      
      // Update symbol in label
      const selectedOption = document.getElementById('transactionCurrency').selectedOptions[0];
      if (selectedOption) {
        const match = selectedOption.textContent.match(/\(([^)]+)\)/);
        if (match && match[1]) {
          document.getElementById('selectedSymbol').textContent = match[1];
        }
      }
    }
    
    // Update selected coin information
    function updateSelectedCoin(coinId) {
      selectedCoinId = coinId;
      
      // Find the selected coin in the assets (try from both crypto and stocks)
      let selectedCoin = null;
      
      try {
        // Try to fetch the coin's details from CoinGecko
        fetch(`https://api.coingecko.com/api/v3/coins/${coinId}`)
          .then(response => {
            if (!response.ok) {
              throw new Error('Network response was not ok');
            }
            return response.json();
          })
          .then(data => {
            updateCoinUI(data);
          })
          .catch(error => {
            console.error('Error fetching coin details:', error);
            
            // Fall back to stock data or mock data
            let fallbackCoin = stockData.find(stock => stock.id === coinId);
            
            if (!fallbackCoin) {
              // Create mock data if needed
              fallbackCoin = {
                id: coinId,
                name: coinId.charAt(0).toUpperCase() + coinId.slice(1),
                symbol: coinId.substring(0, 3).toUpperCase(),
                current_price: coinPrices[coinId] || 0,
                price_change_percentage_24h: 1.23,
                market_cap: 1000000000,
                total_volume: 500000000,
                high_24h: (coinPrices[coinId] || 0) * 1.05,
                low_24h: (coinPrices[coinId] || 0) * 0.95
              };
            }
            
            updateCoinUI(fallbackCoin);
          });
      } catch (error) {
        console.error('Error in updateSelectedCoin:', error);
      }
    }
    
    // Update UI with selected coin data
    function updateCoinUI(coin) {
      try {
        // Update selected coin information
        document.getElementById('selectedCoinName').textContent = coin.name || coin.id;
        document.getElementById('selectedCoinCode').textContent = `${(coin.symbol || '').toUpperCase()}/USD`;
        
        const price = coin.current_price || coin.market_data?.current_price?.usd || 0;
        document.getElementById('selectedCoinPrice').textContent = `${price.toLocaleString()}`;
        
        const priceChange = coin.price_change_percentage_24h || coin.market_data?.price_change_percentage_24h || 0;
        const priceChangeElement = document.getElementById('selectedCoinChange');
        priceChangeElement.textContent = `${priceChange >= 0 ? '+' : ''}${priceChange.toFixed(2)}%`;
        priceChangeElement.className = priceChange >= 0 ? 'text-sm price-up' : 'text-sm price-down';
        
        // Update 24h statistics
        document.getElementById('high24h').textContent = `${(coin.high_24h || coin.market_data?.high_24h?.usd || price * 1.05).toLocaleString()}`;
        document.getElementById('low24h').textContent = `${(coin.low_24h || coin.market_data?.low_24h?.usd || price * 0.95).toLocaleString()}`;
        document.getElementById('volume24h').textContent = `${(coin.total_volume || coin.market_data?.total_volume?.usd || 0).toLocaleString()}`;
        document.getElementById('marketCap').textContent = `${(coin.market_cap || coin.market_data?.market_cap?.usd || 0).toLocaleString()}`;
        
        // Update symbol for selected coin
        selectedCoinSymbol = (coin.symbol || '').toUpperCase();
        document.getElementById('selectedSymbol').textContent = selectedCoinSymbol;
        
        // Update coin icon
        const iconContainer = document.getElementById('selectedCoinIcon');
        iconContainer.innerHTML = '';
        
        if (coin.id === 'bitcoin') {
          iconContainer.innerHTML = '<i class="fab fa-bitcoin text-yellow-500"></i>';
        } else if (coin.id === 'ethereum') {
          iconContainer.innerHTML = '<i class="fab fa-ethereum text-purple-600"></i>';
        } else if (coin.id.includes('stock')) {
          iconContainer.innerHTML = '<i class="fas fa-chart-line text-blue-500"></i>';
        } else {
          iconContainer.innerHTML = '<i class="fas fa-circle text-blue-500"></i>';
        }
        
        // Animate the price change
        animateValue('selectedCoinPrice', price);
        
        // Update the chart for this coin
        updateChart(coin);
      } catch (error) {
        console.error('Error in updateCoinUI:', error);
      }
    }
    
    // Update last updated timestamp
    function updateLastUpdated() {
      const now = new Date();
      document.getElementById('lastUpdated').textContent = now.toLocaleTimeString();
      
      // Update every minute
      setTimeout(updateLastUpdated, 60000);
    }
    
    // Animate numeric value change
    function animateValue(elementId, newValue) {
      const element = document.getElementById(elementId);
      const oldValue = parseFloat(element.textContent.replace(/[$,]/g, '')) || 0;
      
      anime({
        targets: { value: oldValue },
        value: newValue,
        duration: 800,
        easing: 'easeOutExpo',
        update: function(anim) {
          const value = anim.animatables[0].target.value;
          element.textContent = `${value.toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 })}`;
        }
      });
    }
    
    // Animate chart on load
    function animateChart() {
      anime({
        targets: '#priceChart path',
        strokeDashoffset: [anime.setDashoffset, 0],
        easing: 'easeInOutSine',
        duration: 1500,
        delay: function(el, i) { return i * 250 },
        direction: 'normal',
      });
    }
    
    // Update chart for selected coin
    function updateChart(coin) {
      const svg = document.getElementById('priceChart');
      
      // Generate random path for demo purposes (in real app, would use actual price data)
      const height = 300;
      const width = 800;
      const points = 20;
      const variance = 50; // Amount of randomness
      
      let pathData = `M0,${height/2}`;
      let fillPathData = `M0,${height/2}`;
      
      for (let i = 1; i <= points; i++) {
        const x = (width / points) * i;
        // More random path when price is volatile
        const volatility = Math.abs(coin.price_change_percentage_24h || 2) / 2;
        const y = height/2 + (Math.sin(i / 2) * 50) + (Math.random() - 0.5) * variance * volatility;
        pathData += ` L${x},${y}`;
        fillPathData += ` L${x},${y}`;
      }
      
      // Close the fill path
      fillPathData += ` L${width},${height} L0,${height} Z`;
      
      // Update the SVG paths with animation
      const strokePath = svg.querySelector('path:nth-child(1)');
      const fillPath = svg.querySelector('path:nth-child(2)');
      
      // Determine color based on price change
      const isPositive = (coin.price_change_percentage_24h || 0) >= 0;
      const strokeColor = isPositive ? '#10b981' : '#ef4444'; // Green or red
      const fillColor = isPositive ? 'url(#greenGradient)' : 'url(#redGradient)';
      
      // Update the gradient definitions
      let defs = svg.querySelector('defs');
      if (!defs) {
        defs = document.createElementNS('http://www.w3.org/2000/svg', 'defs');
        svg.appendChild(defs);
      }
      
      defs.innerHTML = `
        <linearGradient id="greenGradient" x1="0%" y1="0%" x2="0%" y2="100%">
          <stop offset="0%" stop-color="#10b981" />
          <stop offset="100%" stop-color="#10b981" stop-opacity="0" />
        </linearGradient>
        <linearGradient id="redGradient" x1="0%" y1="0%" x2="0%" y2="100%">
          <stop offset="0%" stop-color="#ef4444" />
          <stop offset="100%" stop-color="#ef4444" stop-opacity="0" />
        </linearGradient>
        <linearGradient id="purpleGradient" x1="0%" y1="0%" x2="0%" y2="100%">
          <stop offset="0%" stop-color="#7c3aed" />
          <stop offset="100%" stop-color="#7c3aed" stop-opacity="0" />
        </linearGradient>
      `;
      
      // Animate the chart update
      anime({
        targets: strokePath,
        d: pathData,
        stroke: strokeColor,
        easing: 'easeOutQuad',
        duration: 800
      });
      
      anime({
        targets: fillPath,
        d: fillPathData,
        fill: fillColor,
        easing: 'easeOutQuad',
        duration: 800
      });
    }
    
    // Handle form submission
    document.getElementById('tradeForm').addEventListener('submit', function(e) {
      e.preventDefault();
      
      // Get form values
      const formData = {
        type: transactionType,
        mode: marketMode,
        coinId: selectedCoinId,
        symbol: selectedCoinSymbol,
        usdAmount: parseFloat(document.getElementById('transactionAmount').value) || 0,
        coinAmount: parseFloat(document.getElementById('convertedAmount').value) || 0,
        leverage: marketMode !== 'spot' ? parseInt(document.getElementById('leverageSlider').value) : 1
      };
      
      // Show success notification
      const actionText = formData.type === 'buy' ? 'Purchase' : 'Sale';
      const notification = document.createElement('div');
      notification.className = 'fixed top-4 right-4 bg-primary-purple text-white p-4 rounded-lg shadow-lg animate__animated animate__fadeIn z-50';
      notification.innerHTML = `
        <div class="flex items-center">
          <i class="fas fa-check-circle mr-2"></i>
          <div>
            <div class="font-bold">${actionText} Successful!</div>
            <div class="text-sm">${formData.coinAmount.toFixed(8)} ${formData.symbol} ${formData.type === 'buy' ? 'bought' : 'sold'} for ${formData.usdAmount.toFixed(2)}</div>
          </div>
        </div>
      `;
      document.body.appendChild(notification);
      
      // Remove notification after 3 seconds
      setTimeout(() => {
        notification.classList.remove('animate__fadeIn');
        notification.classList.add('animate__fadeOut');
        setTimeout(() => notification.remove(), 1000);
      }, 3000);
      
      // Reset form
      document.getElementById('transactionAmount').value = '';
      document.getElementById('convertedAmount').value = '';
      
      // Add a new row to the recent orders table
      addNewOrderToTable(formData);
    });
    
    // Add new order to the recent orders table
    function addNewOrderToTable(formData) {
      const table = document.querySelector('tbody');
      const newRow = document.createElement('tr');
      newRow.className = 'border-b border-gray-100 animate__animated animate__fadeIn';
      
      const now = new Date();
      const dateString = now.toLocaleDateString();
      
      newRow.innerHTML = `
        <td class="py-3">${dateString}</td>
        <td class="py-3">${formData.symbol}/USD</td>
        <td class="py-3">Market</td>
        <td class="py-3 ${formData.type === 'buy' ? 'text-green-500' : 'text-red-500'}">${formData.type === 'buy' ? 'Buy' : 'Sell'}</td>
        <td class="py-3">${coinPrices[formData.coinId].toLocaleString()}</td>
        <td class="py-3">${formData.coinAmount.toFixed(8)}</td>
        <td class="py-3">${formData.usdAmount.toFixed(2)}</td>
        <td class="py-3"><span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs">Completed</span></td>
      `;
      
      // Insert at the beginning of the table
      table.insertBefore(newRow, table.firstChild);
    }
    
    // Set up UI components on load
    setTransactionType('buy');
    setMarketMode('spot');
  </script>
  </head>
  </body>