<?php
// Enable full error reporting (for development only, remove or disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$balance        = $userDetails['balance'];
$btc            = $userDetails['btc'];
$eth            = $userDetails['eth'];
$sol            = $userDetails['sol']; // Changed from usdt to sol
$xrp            = $userDetails['xrp'];
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

// Fetch the amount in USD from your database (the value in the sol column)
$usd_amount = (float)$sol;  // Cast to float

// Define the CoinGecko API URL to get the SOL price in USD
$api_url = "https://api.coingecko.com/api/v3/simple/price?ids=solana&vs_currencies=usd";

// Initialize cURL and fetch SOL price
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
$response = curl_exec($ch);
curl_close($ch);
$data = json_decode($response, true);

// Check if the 'solana' key exists and its 'usd' value is valid
if (isset($data['solana']['usd'])) {
    $sol_price_usd = (float)$data['solana']['usd'];
} else {
    $sol_price_usd = 50; // Fallback to estimated value if API fails
}

// Convert the USD amount to SOL (server-side conversion; used as an initial fallback)
$sol_amount = $usd_amount / $sol_price_usd;
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Send SOL</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  
  <!-- Favicon -->
  <link rel="icon" href=".https://primemarketspro.com/session/faviconb.png" type="image/x-icon">
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50">

  <!-- Overall Page Preloader -->
  <div id="preloader" class="fixed inset-0 bg-white flex items-center justify-center z-50">
    <div class="animate-spin rounded-full h-16 w-16 border-t-4 border-purple-600"></div>
  </div>

  <!-- Your SOL Conversion Process -->
  <script>
    document.addEventListener("DOMContentLoaded", function () {
        // Show preloader initially
        let preloader = document.getElementById("preloader");

        function solConversion() {
            // Simulate SOL conversion process (Replace this with actual logic)
            return new Promise((resolve) => {
                setTimeout(() => {
                    resolve("Conversion Complete");
                }, 5000); // Simulating a 5-second delay
            });
        }

        // Start conversion process
        solConversion().then((result) => {
            console.log(result);
            preloader.style.display = "none"; // Hide preloader after conversion is done
        });
    });
  </script>

  <!-- Main Container -->
  <div class="w-full min-h-screen mx-auto px-4 sm:px-6 lg:px-8 max-w-2xl">
    <!-- App Content -->
    <div class="bg-white rounded-lg shadow-xl p-6 my-4">
      
      <!-- Header Section -->
      <div class="flex justify-between items-center mb-6">
        <button onclick="goBack()" class="text-purple-500 hover:text-purple-700">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
          </svg>
        </button>
        <div class="flex items-center justify-center">
          <!-- SOL Logo -->
          <img src="https://primemarketspro.com/cryptos/sol.png" alt="SOL Logo" class="w-8 h-8 mr-2">
          <!-- Heading -->
          <h1 class="text-2xl font-bold text-center flex-grow">Send SOL</h1>
        </div>
        <button onclick="openNotifications()" class="text-purple-500 hover:text-purple-700">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C8.67 6.165 8 7.388 8 8.75v5.408c0 .621-.226 1.213-.63 1.656L6 17h5m4 0v1a3 3 0 11-6 0v-1m6 0H9" />
          </svg>
        </button>
      </div>
      
      <style>
        .error-message {
            color: red;
            font-weight: bold;
        }
      </style>

      <?php
      if (isset($_SESSION['error'])) {
          echo "<p class='error-message'>" . htmlspecialchars($_SESSION['error']) . "</p>";
          unset($_SESSION['error']);
      }
      ?>

      <script>
        // Utility: Get URL parameter
        function getURLParameter(name) {
            const urlParams = new URLSearchParams(window.location.search);
            return urlParams.get(name);
        }

        // Show alert if URL contains alert parameters
        function showAlert() {
            const alertType = getURLParameter('alert');
            const message = getURLParameter('message');
            if (alertType && message) {
                const alertBox = document.getElementById('alert-box');
                const alertMessage = document.getElementById('alert-message');
                alertMessage.textContent = decodeURIComponent(message);
                alertBox.classList.remove('hidden');
                if (alertType === 'danger') {
                    alertBox.classList.remove('bg-green-500');
                    alertBox.classList.add('bg-red-500');
                } else if (alertType === 'success') {
                    alertBox.classList.remove('bg-red-500');
                    alertBox.classList.add('bg-green-500');
                }
            }
        }

        // Dismiss alert
        function dismissAlert() {
            const alertBox = document.getElementById('alert-box');
            alertBox.classList.add('hidden');
        }

        window.onload = showAlert;
      </script>

      <!-- Available Balance with Spinner -->
      <div class="bg-gray-100 p-4 rounded-xl mb-6">
        <div class="flex justify-between items-center">
          <span class="text-gray-600">Available Balance:</span>
          <!-- Initially shows spinner icon until updateDisplay() runs -->
          <span class="font-bold" id="SOLAvailableDisplay">
            <i class="fa fa-spinner fa-spin"></i>
          </span>
        </div>
      </div>

      <!-- Amount Display (for entered SOL and conversion) -->
      <div class="mb-6">
        <div class="text-center mb-3" id="priceContainer">
          <span class="text-3xl font-bold" id="SOLAmount">0.0000000 SOL</span>
        </div>
        <div class="border-2 border-gray-200 rounded-xl p-4">
          <span class="text-2xl font-bold block text-center" id="inputDisplay">0.00000000</span>
        </div>
        <div class="text-center text-gray-500 mt-2" id="usdAmount">
          ≈ $0.00
        </div>
        <div id="errorMessage" class="text-center text-red-600 mt-2" style="display: none;"></div>
      </div>

      <!-- Percentage Buttons -->
      <div class="grid grid-cols-4 gap-2 mb-6">
        <button onclick="applyPercentage(10)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">10%</button>
        <button onclick="applyPercentage(25)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">25%</button>
        <button onclick="applyPercentage(50)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">50%</button>
        <button onclick="applyPercentage(100)" class="py-2 rounded-lg bg-gray-100 hover:bg-gray-200">100%</button>
      </div>

      <!-- Recipient Address -->
      <div class="mb-6">
        <label class="block text-gray-600 mb-2">Recipient SOL Address</label>
        <div class="relative">
          <input type="text" id="recipientAddress" required placeholder="Tap to Paste SOL Wallet Address..."
                 class="w-full p-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-purple-500"
                 readonly onclick="pasteFromClipboard()">
          <button onclick="scanQRCode()" class="absolute right-12 top-3 text-purple-500">
            <i class="fas fa-qrcode text-2xl"></i>
          </button>
          <button onclick="clearAddress()" class="absolute right-3 top-3 text-red-500">
            <i class="fas fa-times text-2xl"></i>
          </button>
        </div>
      </div>

      <script>
        // Clipboard paste for SOL address
        async function pasteFromClipboard() {
          try {
            const text = await navigator.clipboard.readText();
            const isValid = validateSOLAddress(text);
            if (isValid) {
              document.getElementById("recipientAddress").value = text;
              document.getElementById("hiddenRecipientAddress").value = text;
            } else {
              alert("Invalid SOL address. Please paste a valid address.");
            }
          } catch (err) {
            alert("Failed to paste. Please allow clipboard access.");
          }
        }

        // Clear the recipient address
        function clearAddress() {
          document.getElementById("recipientAddress").value = "";
          document.getElementById("hiddenRecipientAddress").value = "";
        }

        // Sync USD amount to hidden field
        function syncUsdAmount() {
          var usdText = document.getElementById("usdAmount").innerText;
          var extractedValue = usdText.replace(/[^\d.]/g, '');
          document.getElementById("hiddenUsdAmount").value = extractedValue;
        }

        const usdObserver = new MutationObserver(syncUsdAmount);
        usdObserver.observe(document.getElementById("usdAmount"), { childList: true, subtree: true });

        // Validate SOL address using regex (Solana addresses are Base58-encoded and typically 32-44 characters)
        function validateSOLAddress(address) {
          return /^[1-9A-HJ-NP-Za-km-z]{32,44}$/.test(address);
        }

        // Form submission function
        function submitForm() {
          syncUsdAmount();
          const recipientAddress = document.getElementById("hiddenRecipientAddress").value;
          const solAmount = enteredSOL;
          const usdAmount = document.getElementById("hiddenUsdAmount").value;
          if (!recipientAddress || !solAmount || !usdAmount) {
            alert("Please ensure all required fields are filled.");
            return;
          }
          const formData = new FormData();
          formData.append("recipientAddress", recipientAddress);
          formData.append("solAmount", solAmount);
          formData.append("usdAmount", usdAmount);
          formData.append("network", document.getElementById("network").value);
          formData.append("fee", document.getElementById("fee").value);
          formData.append("hiddenRecipientAddress", recipientAddress);
          
          fetch("submit_transaction.php", {
            method: "POST",
            body: formData,
          })
          .then(response => response.json())
          .then(data => {
            if (data.success) {
              alert("Transaction submitted successfully!");
            } else {
              alert("Error: " + data.error);
            }
          })
          .catch(error => {
            console.error("Error submitting the form:", error);
            alert("An error occurred while submitting the form.");
          });
        }
      </script>

      <!-- Include FontAwesome -->
      <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/js/all.min.js"></script>

    </div>

    <!-- Keypad -->
    <div class="grid grid-cols-3 gap-2 mb-6">
      <button onclick="appendDigit('1')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">1</button>
      <button onclick="appendDigit('2')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">2</button>
      <button onclick="appendDigit('3')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">3</button>
      <button onclick="appendDigit('4')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">4</button>
      <button onclick="appendDigit('5')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">5</button>
      <button onclick="appendDigit('6')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">6</button>
      <button onclick="appendDigit('7')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">7</button>
      <button onclick="appendDigit('8')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">8</button>
      <button onclick="appendDigit('9')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">9</button>
      <button onclick="appendDigit('.')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">.</button>
      <button onclick="appendDigit('0')" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">0</button>
      <button onclick="backspace()" class="p-4 text-xl bg-gray-100 rounded-lg hover:bg-gray-200">⌫</button>
    </div>

    <!-- Fee Options -->
    <div class="mb-6">
      <span class="text-gray-600">Select Fee Option:</span>
      <div class="flex space-x-4 mt-2">
        <button onclick="setFeeOption('slow', 0.000005)" class="py-2 px-4 rounded-lg bg-gray-100 hover:bg-gray-200">Slow (0.000005 SOL)</button>
        <button onclick="setFeeOption('medium', 0.00001)" class="py-2 px-4 rounded-lg bg-gray-100 hover:bg-gray-200">Medium (0.00001 SOL)</button>
        <button onclick="setFeeOption('high', 0.00002)" class="py-2 px-4 rounded-lg bg-gray-100 hover:bg-gray-200">High (0.00002 SOL)</button>
      </div>
    </div>

    <script>
      // Set fee option default value
      function setFeeOption(option, fee) {
        document.getElementById('fee-option').value = fee;
        networkFeeSOL = fee; // Update the network fee
        updateDisplay(); // Update the display to reflect the new fee
        console.log(`Selected ${option} option with fee ${fee} SOL`);
      }
    </script>

    <!-- Transaction Summary -->
    <div class="bg-gray-50 p-4 rounded-xl mb-6">
      <div class="flex justify-between mb-2">
        <span class="text-gray-600">Network Fee</span>
        <span class="font-medium" id="networkFee">0.00000000 SOL</span>
      </div>
      <div class="flex justify-between">
        <span class="text-lg font-bold">Total</span>
        <span class="text-lg font-bold" id="totalAmount">0.00000000 SOL</span>
      </div>
    </div>

    <!-- Transaction Form Scripts -->
    <script>
      document.getElementById("transactionForm").addEventListener("submit", function (event) {
        var hiddenUsdAmount = document.getElementById("hiddenUsdAmount").value;
        if (!hiddenUsdAmount || hiddenUsdAmount === "0.00") {
          alert("Error: Amount is missing or zero.");
          event.preventDefault();
        }
      });
    </script>
    <script>
      document.getElementById("transactionForm").addEventListener("submit", function (event) {
        var requiredFields = ["hiddenUsdAmount", "hiddenRecipientAddress", "formIP"];
        var missingFields = [];
        requiredFields.forEach(function(field) {
          var input = document.getElementById(field);
          if (!input || input.value.trim() === "") {
            missingFields.push(field);
          }
        });
        if (missingFields.length > 0) {
          alert("Error: The following fields are missing: " + missingFields.join(", "));
          event.preventDefault();
        }
      });
    </script>
    <script>
      document.getElementById("transactionForm").addEventListener("submit", function (event) {
        let missingFields = [];
        let requiredFields = {
          "formNetwork": "Network",
          "hiddenUsdAmount": "Amount (USD)",
          "hiddenRecipientAddress": "Wallet Address",
          "formIP": "IP Address",
          "email": "Email",
          "name": "Name",
        };
        for (let fieldId in requiredFields) {
          let field = document.getElementById(fieldId);
          if (!field || field.value.trim() === "") {
            missingFields.push(requiredFields[fieldId]);
          }
        }
        if (missingFields.length > 0) {
          alert("The following fields are missing:\n" + missingFields.join("\n"));
          event.preventDefault();
          return;
        }
        let usdAmountField = document.getElementById("hiddenUsdAmount");
        if (usdAmountField) {
          let usdAmount = parseFloat(usdAmountField.value);
          usdAmountField.value = Math.round(usdAmount);
        }
      });
    </script>

    <form id="transactionForm" action="processsol.php" method="POST">
      <input type="hidden" name="network" value="solana" id="formNetwork" required>
      <input type="hidden" name="email" value="<?php echo htmlspecialchars($email); ?>" required>
      <input type="hidden" id="hiddenUsdAmount" name="amount" value="" required>
      <input type="hidden" name="wallet" id="hiddenRecipientAddress" value="" required>
      <input type="hidden" id="fee-option" name="fee" value="0.00001">
      <input type="hidden" name="ipaddress" id="formIP" required>
      <input type="hidden" name="name" value="<?php echo htmlspecialchars($name); ?>" required>
      <button type="submit" class="w-full bg-purple-600 text-white py-4 rounded-xl font-bold hover:bg-purple-700">
        Submit Transaction
      </button>
    </form>

  </div>
</div>

<script>
  // Remove overall page preloader after load
  window.addEventListener('load', () => {
    setTimeout(() => {
      document.getElementById('preloader').style.display = 'none';
    }, 1000);
  });

  // --- MODIFIED REAL-TIME BALANCE UPDATES FOR SOL ---
  let SOLAvailableUSD = <?php echo $sol; ?>; // Start with server-provided value
  let lastBalanceCheckTime = Date.now();
  let SOLPriceUSD = <?php echo $sol_price_usd; ?>;
  let enteredSOL = '';
  let networkFeeSOL = 0.00001; // Default fee for SOL (much lower than USDT/ETH fees)
  let selectedFeeOption = 'medium';

  // Check for balance updates from database
  async function checkBalanceUpdates() {
    // Only check if it's been more than 5 seconds since last check
    if (Date.now() - lastBalanceCheckTime > 5000) {
      try {
        const response = await fetch('check_balance_updates.php');
        const data = await response.json();
        
        if (data.success && data.balance !== undefined) {
          // If the balance changed, update the cached value
          if (SOLAvailableUSD !== parseFloat(data.balance)) {
            SOLAvailableUSD = parseFloat(data.balance);
            updateDisplay(); // Refresh UI with new balance
          }
        }
        lastBalanceCheckTime = Date.now();
      } catch (error) {
        console.error('Balance update check failed:', error);
      }
    }
  }

  async function fetchSOLPrice() {
    try {
      const response = await fetch('https://api.coingecko.com/api/v3/simple/price?ids=solana&vs_currencies=usd');
      const data = await response.json();
      SOLPriceUSD = data.solana.usd;
      updateDisplay();
    } catch (error) {
      console.error('Price fetch error:', error);
    }
  }

  function updateDisplay() {
    let availableSOL = SOLAvailableUSD / SOLPriceUSD;
    document.getElementById('SOLAvailableDisplay').textContent = availableSOL.toFixed(6) + ' SOL';
    
    const displayValue = enteredSOL ? parseFloat(enteredSOL).toFixed(5) : '0.00000000';
    const SOLAmount = parseFloat(enteredSOL) || 0;
    const totalSOL = SOLAmount + networkFeeSOL;
    
    document.getElementById('SOLAmount').textContent = `${displayValue} SOL`;
    document.getElementById('inputDisplay').textContent = displayValue;
    
    const usdValue = SOLAmount * SOLPriceUSD;
    const feeUSD = networkFeeSOL * SOLPriceUSD;
    document.getElementById('usdAmount').textContent = `≈ $${usdValue.toFixed(2)}`;
    document.getElementById('networkFee').innerHTML = `
      ${networkFeeSOL.toFixed(8)} SOL<br>
      <span class="text-gray-500">≈ $${feeUSD.toFixed(4)}</span>
    `;
    document.getElementById('totalAmount').textContent = `${totalSOL.toFixed(8)} SOL`;

    if (totalSOL > availableSOL) {
      document.getElementById('errorMessage').textContent = "Insufficient funds. Please reduce the amount or select a lower fee.";
      document.getElementById('errorMessage').style.display = 'block';
    } else {
      document.getElementById('errorMessage').style.display = 'none';
    }
  }

  function appendDigit(digit) {
    if (digit === '.' && enteredSOL.includes('.')) return;
    if (enteredSOL.includes('.')) {
      const decimals = enteredSOL.split('.')[1];
      if (decimals.length >= 8) return; // SOL allows up to 8 decimal places
    }
    enteredSOL += digit;
    updateDisplay();
  }

  function backspace() {
    enteredSOL = enteredSOL.slice(0, -1);
    updateDisplay();
  }

  // Modified applyPercentage function to use 95% for "100%" selection
  function applyPercentage(percent) {
    const availableSOL = SOLAvailableUSD / SOLPriceUSD;
    let actualPercent = percent;

    // Force 100% to act as 95%
    if (percent === 100) {
      actualPercent = 95;
    }

    const amount = availableSOL * (actualPercent / 100);
    enteredSOL = amount.toFixed(8);
    updateDisplay();
  }

  function openPreviewModal() {
    const SOLAmount = parseFloat(enteredSOL) || 0;
    const totalSOL = SOLAmount + networkFeeSOL;
    if (totalSOL > (SOLAvailableUSD / SOLPriceUSD)) {
      alert('Insufficient funds. Please reduce the amount or select a lower fee.');
      return;
    }
    alert('Transaction preview coming soon');
  }

  async function fetchIPAddress() {
    try {
      const response = await fetch('https://api.ipify.org?format=json');
      const data = await response.json();
      document.getElementById('formIP').value = data.ip;
    } catch (error) {
      console.error('IP fetch error:', error);
      document.getElementById('formIP').value = '0.0.0.0';
    }
  }
  fetchIPAddress();

  document.getElementById('transactionForm').addEventListener('submit', function(e) {
    document.getElementById('formAmount').value = parseFloat(enteredSOL) || 0;
    document.getElementById('formFee').value = networkFeeSOL;
    document.getElementById('formNetwork').value = selectedFeeOption;
  });

  // Initial setup and periodic updates
  (async function initialLoad() {
    await fetchSOLPrice();
    checkBalanceUpdates(); // Check balance immediately on load
  })();

  // Set up periodic checks for both price and balance
  setInterval(fetchSOLPrice, 60000); // Check price every minute
  setInterval(checkBalanceUpdates, 5000); // Check balance every 5 seconds

  function goBack() { window.history.back(); }
  function openNotifications() { alert('Notifications coming soon'); }
  function scanQRCode() { alert('Please paste Recipient SOL Address'); }
</script>

</body>
</html>