<?php
// Start session (or require a session management file)
// For this example, we directly call session_start()
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}


require 'db.php';

include '../session.php'; // Include session.php to manage session and database


// Optionally, for testing purposes, set a dummy user ID if not already set.
// Uncomment the following lines if needed for testing:
// if (!isset($_SESSION['user_id'])) {
//     $_SESSION['user_id'] = 1;
// }

// Database connection settings
$db_host = "localhost";      // Change to your database host
$db_name = "wptlgmnb_dbp";   // Change to your database name
$db_user = "wptlgmnb_userp"; // Change to your database username
$db_pass = "Qliox4ITygj6Vh4V";    // Change to your database password

// Response array to communicate success or error
$response = [
    'status' => 'error',
    'message' => 'An unknown error occurred'
];

// Enable error reporting for debugging (disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if form was submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_profile'])) {
    // Retrieve form data and trim whitespace
    $country = trim($_POST['country'] ?? '');
    $full_phone = trim($_POST['full_phone'] ?? '');
    
    // Validate required fields
    if (empty($country) || empty($full_phone)) {
        $response['message'] = 'Country and phone number are required';
    } else {
        try {
            // Connect to the database using PDO
            $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
            $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // Retrieve user ID from session
            $user_id = $_SESSION['user_id'] ?? null;
            
            if ($user_id) {
                // Prepare and execute the UPDATE query
                $stmt = $conn->prepare("UPDATE users SET country = :country, phone = :phone WHERE id = :user_id");
                $stmt->bindParam(':country', $country);
                $stmt->bindParam(':phone', $full_phone);
                $stmt->bindParam(':user_id', $user_id);
                
                if ($stmt->execute()) {
                    $response['status'] = 'success';
                    $response['message'] = 'Profile updated successfully';
                } else {
                    // Dump parameters for debugging if update fails
                    $stmt->debugDumpParams();
                    $response['message'] = 'Failed to update profile';
                }
            } else {
                $response['message'] = 'User not authenticated';
            }
        } catch (PDOException $e) {
            // Log and display database errors for debugging
            error_log("Database error: " . $e->getMessage());
            $response['message'] = 'Database error: ' . $e->getMessage();
        }
    }
}

// If this is an AJAX request, return JSON; otherwise, redirect to index.php with status parameters.
if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) &&
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// Redirect for non-AJAX requests
$status = $response['status'];
$message = urlencode($response['message']);
header("Location: index.php?status=$status&message=$message");
exit;
?>
