<?php
session_start();
// Check if the user is logged in
if (!isset($_SESSION['user_email'])) {
    die("Error: User is not logged in. Please log in first.");
}

$email = $_SESSION['user_email'];

// Database connection
$servername = "localhost";
$username = "wptlgmnb_userp";
$password = "Qliox4ITygj6Vh4V";
$dbname = "wptlgmnb_dbp";

$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Function to log errors (optional)
function logError($message) {
    error_log($message . "\n", 3, "error_log.txt"); // Log errors to a file
}

// Handle form submission via AJAX
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['pin'])) {
    $input_pin = trim($_POST['pin']);

    // Validate pin length
    if (strlen($input_pin) !== 4 || !is_numeric($input_pin)) {
        echo json_encode(["success" => false, "error" => "PIN must be exactly 4 digits."]);
        exit();
    }

    // Retrieve the user's stored PIN
    try {
        $stmt = $conn->prepare("SELECT pin FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->bind_result($stored_pin);
        $stmt->fetch();
        $stmt->close();

        if ($stored_pin && $input_pin === $stored_pin) {
            $_SESSION['authenticated'] = true;
            echo json_encode(["success" => true, "redirect" => "./user/dashboard.php"]);
        } else {
            echo json_encode(["success" => false, "error" => "Incorrect PIN. Please try again."]);
        }
    } catch (Exception $e) {
        // Log error and display generic message
        logError("Database error: " . $e->getMessage());
        echo json_encode(["success" => false, "error" => "An error occurred. Please try again later."]);
    }

    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Secure PIN Verification</title>
  
  <!-- Favicon -->
  <link rel="icon" href="https://primemarketspro.com/session/favicon.png" type="image/x-icon">
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    /* Neumorphic Styles with Whitish Grey and Blue Accents */
    body {
      background: #f5f7fa;
    }
    .neumorphic-card {
      background: #f5f7fa;
      border-radius: 15px;
      box-shadow: 8px 8px 16px #cfd7e2,
                  -8px -8px 16px #ffffff;
    }
    .neumorphic-input {
      background: #f5f7fa;
      border: none;
      border-radius: 10px;
      box-shadow: inset 4px 4px 8px #cfd7e2,
                  inset -4px -4px 8px #ffffff;
      padding: 1rem;
      font-size: 1.25rem;
      text-align: center;
      outline: none;
      color: #3d4863;
    }
    .neumorphic-keypad-button {
      background: #f5f7fa;
      border: none;
      border-radius: 50%;
      box-shadow: 4px 4px 8px #cfd7e2,
                  -4px -4px 8px #ffffff;
      padding: 1rem;
      font-size: 1.25rem;
      cursor: pointer;
      transition: all 0.2s ease-in-out;
      color: #3d4863;
    }
    .neumorphic-keypad-button:active {
      box-shadow: inset 4px 4px 8px #cfd7e2,
                  inset -4px -4px 8px #ffffff;
    }
    .neumorphic-delete-button {
      background: #f5f7fa;
      border: none;
      border-radius: 50%;
      box-shadow: 4px 4px 8px #cfd7e2,
                  -4px -4px 8px #ffffff;
      padding: 1rem;
      font-size: 1.25rem;
      color: #3d4863;
      cursor: pointer;
      transition: all 0.2s ease-in-out;
    }
    .neumorphic-delete-button:active {
      box-shadow: inset 4px 4px 8px #cfd7e2,
                  inset -4px -4px 8px #ffffff;
    }
    .neumorphic-submit {
      background: #f5f7fa;
      border: none;
      border-radius: 20px;
      box-shadow: 4px 4px 8px #cfd7e2,
                  -4px -4px 8px #ffffff;
      padding: 1rem;
      font-size: 1.25rem;
      width: 100%;
      transition: all 0.2s ease-in-out;
      color: #3d4863;
      cursor: pointer;
    }
    .neumorphic-submit:active {
      box-shadow: inset 4px 4px 8px #cfd7e2,
                  inset -4px -4px 8px #ffffff;
    }
  </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4">
  <div class="form-content neumorphic-card p-8 max-w-md w-full">
     
     
    

<script type="text/javascript">
  function googleTranslateElementInit() {
    new google.translate.TranslateElement({ pageLanguage: 'en' }, 'google_translate_element');
  }

  const countryLangMap = {
    'US': 'en', 'CA': 'en', 'GB': 'en', 'AU': 'en', 'NZ': 'en', 'IE': 'en',
    'FR': 'fr', 'BE': 'nl', 'NL': 'nl', 'DE': 'de', 'AT': 'de', 'CH': 'de',
    'IT': 'it', 'ES': 'es', 'PT': 'pt', 'BR': 'pt', 'MX': 'es', 'AR': 'es',
    'CL': 'es', 'CO': 'es', 'PE': 'es', 'VE': 'es', 'EC': 'es', 'RU': 'ru',
    'PL': 'pl', 'CZ': 'cs', 'SK': 'sk', 'HU': 'hu', 'RO': 'ro', 'BG': 'bg',
    'GR': 'el', 'TR': 'tr', 'IL': 'he', 'SA': 'ar', 'AE': 'ar', 'EG': 'ar',
    'IN': 'hi', 'PK': 'ur', 'BD': 'bn', 'LK': 'si', 'NP': 'ne', 'ID': 'id',
    'MY': 'ms', 'PH': 'fil', 'TH': 'th', 'VN': 'vi', 'KR': 'ko', 'JP': 'ja',
    'CN': 'zh-CN', 'TW': 'zh-TW', 'HK': 'zh-TW', 'SG': 'en', 'FI': 'fi',
    'SE': 'sv', 'NO': 'no', 'DK': 'da', 'IS': 'is', 'EE': 'et', 'LV': 'lv',
    'LT': 'lt'
  };

  function getLanguageFromIP() {
    return fetch('https://ipapi.co/json/')
      .then(response => response.json())
      .then(data => {
        if (data && data.country) {
          return countryLangMap[data.country] || 'en';
        }
        return 'en';
      })
      .catch(error => {
        console.error('Language detection failed:', error);
        return 'en';
      });
  }

  function translatePageTo(language) {
    let attempts = 0;
    const intervalId = setInterval(() => {
      const combo = document.querySelector('.goog-te-combo');
      if (combo) {
        combo.value = language;
        combo.dispatchEvent(new Event('change'));
        clearInterval(intervalId);
      }
      attempts++;
      if (attempts > 20) clearInterval(intervalId);
    }, 500);
  }

  document.addEventListener("DOMContentLoaded", function () {
    getLanguageFromIP().then(function(lang) {
      setTimeout(function() {
        translatePageTo(lang);
      }, 2000);
    });
  });
</script>

<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

<!-- CSS for floating Google Translate widget on the bottom-left and hiding the logo -->
<style>
  .floating-translate {
    position: fixed;
    bottom: 20px;
    left: 20px; /* Positioned to the left-hand side */
    z-index: 9999;
    background-color: #8a2be2; /* Optional: purple background */
    padding: 10px; /* Optional: internal spacing */
    border-radius: 8px; /* Optional: rounded corners */
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.25); /* Optional: subtle shadow */
  }

  /* Hide the default Google Translate logo */
  .goog-te-gadget img {
    display: none;
  }
</style>

    <div class="flex items-center mb-6">
      <img src="<?= htmlspecialchars($_SESSION['user_picture'] ?? 'default-avatar.png'); ?>" class="w-16 h-16 rounded-full object-cover" alt="avatar">
      <div class="ml-4">
        <p class="text-lg font-medium text-gray-700"><?= htmlspecialchars($_SESSION['user_name'] ?? 'User') ?></p>
        <p class="text-sm text-gray-600"><?= htmlspecialchars($_SESSION['user_email'] ?? 'user@example.com') ?></p>
      </div>
    </div>
    <div class="text-center mb-6">
      <h3 class="text-2xl font-semibold mb-2 text-gray-700">Welcome</h3>
      <p class="text-gray-600">Please enter your PIN</p>
    </div>
    <form id="pin-form" class="text-left">
      <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
      <div class="mb-4">
        <label for="pin-input" class="block text-lg font-medium text-gray-700">PIN CODE</label>
        <div class="flex items-center space-x-2 mt-2">
          <input id="pin-input" name="pin" type="password" class="neumorphic-input w-full" placeholder="****" maxlength="4" readonly>
        </div>
      </div>
      <div id="container" class="grid grid-cols-3 gap-4 mb-6"></div>
      <p id="error-message" class="text-red-600 text-center mb-4 hidden"></p>
      <div class="text-center">
        <button type="submit" id="submit-btn" class="neumorphic-submit" disabled>Submit</button>
      </div>
    </form>
  </div>
  <script>
    const pinInput = document.getElementById("pin-input");
    const container = document.getElementById("container");
    const errorMessage = document.getElementById("error-message");
    const form = document.getElementById("pin-form");
    const submitBtn = document.getElementById("submit-btn");
    
    function updateSubmitState() {
      submitBtn.disabled = pinInput.value.length !== 4;
    }
    
    function shuffleButtons() {
      container.innerHTML = '';
      let numbers = [...Array(10).keys()].sort(() => Math.random() - 0.5);
      
      numbers.forEach(num => {
        const btn = document.createElement("button");
        btn.className = 'neumorphic-keypad-button';
        btn.innerText = num;
        btn.onclick = (e) => {
          e.preventDefault();
          if (pinInput.value.length < 4) {
            pinInput.value += num;
            updateSubmitState();
          }
        };
        container.appendChild(btn);
      });
      
      const deleteButton = document.createElement("button");
      deleteButton.className = 'neumorphic-delete-button';
      deleteButton.innerText = "X";
      deleteButton.onclick = (e) => {
        e.preventDefault();
        pinInput.value = pinInput.value.slice(0, -1);
        updateSubmitState();
      };
      container.appendChild(deleteButton);
    }
    
    shuffleButtons();
    
    form.addEventListener("submit", async (event) => {
      event.preventDefault();
      if (pinInput.value.length !== 4) {
        errorMessage.innerText = "Please enter a 4-digit PIN.";
        errorMessage.classList.remove("hidden");
        return;
      }
      submitBtn.disabled = true;
      const formData = new FormData(form);
      try {
        const response = await fetch("", { method: "POST", body: formData });
        const data = await response.json();
        if (data.success) {
          window.location.href = data.redirect;
        } else {
          errorMessage.innerText = data.error;
          errorMessage.classList.remove("hidden");
          pinInput.value = "";
          shuffleButtons();
          updateSubmitState();
        }
      } catch (error) {
        errorMessage.innerText = "An error occurred. Please try again.";
        errorMessage.classList.remove("hidden");
      }
      submitBtn.disabled = false;
    });
  </script>
</body>
</html>
