<?php
session_start(); // Start the session
require 'db.php'; // Database connection

// Include the Google API client
require 'google-api-php-client/vendor/autoload.php';

// Enable error reporting for debugging
// ini_set('display_errors', 1);
// error_reporting(E_ALL);

// Initialize Google Client
$client = new Google\Client();
$client->setClientId('591255606353-56huc1sm3plsos7626duvcpneb7r3122.apps.googleusercontent.com');
$client->setClientSecret('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');
$client->setRedirectUri('https://bitnovaspro.com/session/auth/callback.php');
$client->addScope('email');
$client->addScope('profile');

// Handle the OAuth callback
if (isset($_GET['code'])) {
    try {
        // Get the Google access token
        $accessToken = $client->fetchAccessTokenWithAuthCode($_GET['code']);

        if (isset($accessToken['error'])) {
            throw new Exception("Error fetching access token: " . $accessToken['error']);
        }

        // Set the access token to the client
        $client->setAccessToken($accessToken['access_token']);

        // Get the Google user info
        $oauth2Service = new Google\Service\Oauth2($client);
        $userInfo = $oauth2Service->userinfo->get();

        // Get user details
        $google_id = $userInfo->getId();
        $email = $userInfo->getEmail();
        $name = $userInfo->getName();
        $picture = $userInfo->getPicture();

        // Log user details for debugging
        error_log("Google ID: $google_id, Email: $email, Name: $name, Picture: $picture");

        // Check if the user already exists in the database
        $query = "SELECT id, email, google_id, pin FROM users WHERE email = :email";
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':email', $email, PDO::PARAM_STR);
        $stmt->execute();

        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        // Log successful login
        file_put_contents('logs/user_login.log', "User Logged In: " . print_r($user, true) . "\n", FILE_APPEND);

        // If user doesn't exist, register them
        if (!$user) {
            // Set default status as 'hold'
            $status = 'hold';

            // Insert new user into the database
            $query = "INSERT INTO users (email, google_id, name, status, picture) 
                      VALUES (:email, :google_id, :name, :status, :picture)";
            $stmt = $conn->prepare($query);
            $stmt->bindParam(':email', $email, PDO::PARAM_STR);
            $stmt->bindParam(':google_id', $google_id, PDO::PARAM_STR);
            $stmt->bindParam(':name', $name, PDO::PARAM_STR);
            $stmt->bindParam(':status', $status, PDO::PARAM_STR);
            $stmt->bindParam(':picture', $picture, PDO::PARAM_STR);
            $stmt->execute();

            // Get the newly inserted user ID
            $user_id = $conn->lastInsertId();

            // Store user info in session
            $_SESSION['user_id'] = $user_id;
            $_SESSION['user_email'] = $email;
            $_SESSION['user_name'] = $name;
            $_SESSION['user_picture'] = $picture;

            // Redirect to pin.php for users who just signed up
            header('Location: pin.php');
            exit();
        } else {
            // Existing user, use the stored ID
            $user_id = $user['id'];

            // Store user info in session
            $_SESSION['user_id'] = $user_id;
            $_SESSION['user_email'] = $email;
            $_SESSION['user_name'] = $name;
            $_SESSION['user_picture'] = $picture;

            // Redirect based on PIN status
            if (empty($user['pin'])) {
                header('Location: pin.php'); // Redirect to set PIN
            } else {
                header('Location: verify_pin.php'); // Redirect to PIN verification
            }
            exit();
        }

    } catch (Exception $e) {
        // Display error message in case of an exception
        echo 'Error: ' . $e->getMessage();
        // Log the error message
        error_log("Error during OAuth: " . $e->getMessage());
    }
} else {
    echo 'No code received from Google OAuth.';
    error_log("No code received from Google OAuth.");
}
?>
