<?php
session_start(); // Start the session

// Database connection details (update with your actual credentials)
$host     = 'localhost';
$username = 'ouxrysgh_userb';
$password = 'zaoix8Q45uD868e2';
$database = 'wptlgmnb_dbp';

// reCAPTCHA configuration
$recaptcha_site_key = '6LeS6V4rAAAAABCqKIKk9VJfgRsO2-QRFd05VOHS'; // Replace with your actual site key
$recaptcha_secret_key = '6LeS6V4rAAAAAGwCkZKCDuIjsPaeJaHWHN_x-apB'; // Replace with your actual secret key

// Create the database connection
$conn = new mysqli($host, $username, $password, $database);

// Check if the connection is successful
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Verify reCAPTCHA first
    $recaptcha_response = $_POST['g-recaptcha-response'];
    
    // Make request to Google to verify the reCAPTCHA response
    $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
    $recaptcha_data = [
        'secret' => $recaptcha_secret_key,
        'response' => $recaptcha_response,
        'remoteip' => $_SERVER['REMOTE_ADDR']
    ];
    
    $recaptcha_options = [
        'http' => [
            'header' => "Content-type: application/x-www-form-urlencoded\r\n",
            'method' => 'POST',
            'content' => http_build_query($recaptcha_data)
        ]
    ];
    
    $recaptcha_context = stream_context_create($recaptcha_options);
    $recaptcha_result = file_get_contents($recaptcha_url, false, $recaptcha_context);
    $recaptcha_json = json_decode($recaptcha_result, true);
    
    // If reCAPTCHA verification failed
    if (!$recaptcha_json['success']) {
        $error = 'recaptcha_failed';
    } else {
        // reCAPTCHA passed, proceed with login
        $userEmail    = $_POST['email'];    // Get email from login form
        $userPassword = $_POST['password']; // Get password from login form

        // Query the database to authenticate the user (ensure to use proper hashing comparison)
        $query = "SELECT id, email, password FROM users WHERE email = ?";
        $stmt  = $conn->prepare($query);
        $stmt->bind_param('s', $userEmail);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $stmt->bind_result($id, $email, $hashedPassword);
            $stmt->fetch();

            // If password matches, set session and redirect to pin.php
            if (password_verify($userPassword, $hashedPassword)) {
                $_SESSION['email'] = $userEmail; // Set session email
                header('Location: pin.php');     // Redirect to pin.php
                exit();
            } else {
                $error = 'incorrect_password';
            }
        } else {
            $error = 'email_not_found';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | Bitnovaspro</title>
    <!-- Tailwind CSS for styling -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Google reCAPTCHA v2 Invisible -->
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    
    <!-- Custom styles for the site branding and responsive design -->
    <style>
        .logo {
            font-family: 'Arial', sans-serif;
            font-size: 2.5rem;
            font-weight: bold;
            color: #5d0fd8; /* Tailwind's Blue-800 */
            margin-bottom: 0px;
            text-align: center;
        }

        /* Info widget styling */
        .info-widget {
            display: flex;
            align-items: center;
            padding: 10px;
            background-color: #e6f7ff;
            border-radius: 6px;
            margin-bottom: 16px;
        }
        
        .info-widget .icon {
            margin-right: 10px;
        }
        
        .info-widget .message {
            font-size: 0.9rem;
            color: #333;
        }

        /* Custom focus effect for form inputs */
        input:focus {
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.3);
        }

        /* Media query adjustments for smaller screens */
        @media (max-width: 640px) {
            .logo {
                font-size: 2rem;
            }
        }
    </style>
    <!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = 'b185b89eff779bf61a239a91251da652ef9b45cb';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>
    <!-- Favicon set to the logo image -->
    <link rel="icon" href="https://bitnovaspro.com/session/faviconb.png" type="image/x-icon">
</head>
<body class="bg-white text-black font-sans">
    
    <!-- Main Container with improved responsive padding -->
    <div class="flex justify-center items-center min-h-screen p-4">
        
        
        <div class="bg-gray-100 p-6 sm:p-8 rounded-lg shadow-lg w-full max-w-md mx-auto">
            
            <!-- Branding Section: Logo and Site Name -->
           <a href="https://bitnovaspro.com"> <div class="flex flex-col items-center mb-6">
                <!-- Logo image with responsive sizing -->
                <img src="https://bitnovaspro.com/session/logob.png" alt="Bitnovaspro Logo" class="h-10 sm:h-12" />
              
            </div></a>
            
            <!-- Display Success Message from Registration (if any) -->
            <?php
            if (isset($_SESSION['success_message'])) {
                echo '<div class="mb-4 text-green-600 text-center">';
                echo $_SESSION['success_message'];
                echo "<p>Your registered email: <strong style='color: blue;'>" . $_SESSION['user_email'] . "</strong></p>";
                echo '</div>';
                unset($_SESSION['success_message']); // Remove message after displaying
            }
            ?>
            
            <hr class="mb-4">
          
          
          
        
        
 




            <!-- Info Widget with improved responsiveness -->
            <div class="info-widget">
                <div class="icon">
                    <!-- Info icon using SVG -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#17a2b8" viewBox="0 0 24 24">
                        <path d="M12 0C5.372 0 0 5.372 0 12s5.372 12 12 12 12-5.372 12-12S18.628 0 12 0zm1 17h-2v-6h2v6zm0-8h-2V7h2v2z"/>
                    </svg>
                </div>
                <div class="message">
                    We've gone passwordless! Login with just your email for enhanced account security.
                </div>
            </div>
            
        <!-- Google Translate Element Container -->
<div id="google_translate_element" class="floating-translate"></div>

<!-- Google Translate Scripts -->
<script type="text/javascript">
  function googleTranslateElementInit() {
    new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element');
  }
</script>
<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

<!-- CSS for floating Google Translate widget on the bottom-left and hiding the logo -->
<style>
  .floating-translate {
    position: fixed;
    bottom: 20px;
    left: 20px; /* Positioned to the left-hand side */
    z-index: 9999;
    background-color: #8a2be2; /* Optional: purple background */
    padding: 10px; /* Optional: internal spacing */
    border-radius: 8px; /* Optional: rounded corners */
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.25); /* Optional: subtle shadow */
  }

  /* Hide the default Google Translate logo */
  .goog-te-gadget img {
    display: none;
  }
</style>


            <!-- Alert Container for Error Messages (positioned fixed for better mobile experience) -->
            <div id="alert-container" class="fixed top-5 left-1/2 transform -translate-x-1/2 w-11/12 max-w-sm px-4 py-2 bg-red-600 text-white rounded-lg shadow-lg z-50 hidden">
                <span id="alert-message">Error message will appear here.</span>
            </div>

            <!-- Google Login Button with improved sizing -->
            <a href="https://accounts.google.com/o/oauth2/auth?client_id=591255606353-56huc1sm3plsos7626duvcpneb7r3122.apps.googleusercontent.com&redirect_uri=https://bitnovaspro.com/session/auth/callback.php&response_type=code&scope=email profile" 
         class="w-full flex items-center justify-center bg-blue-500 text-white py-2 rounded-lg font-semibold hover:bg-blue-600 transition duration-200">
  <img src="https://cdn.iconscout.com/icon/free/png-256/free-google-logo-icon-download-in-svg-png-gif-file-formats--brands-pack-logos-icons-189824.png?f=webp&w=128" alt="Google" class="w-6 h-6 mr-2">
  Signin with Google
</a>
            
            <!-- OR Divider -->
            <div class="flex items-center justify-between my-6">
                <div class="w-full border-t border-gray-400"></div>
                <span class="mx-4 text-gray-600 text-sm">OR</span>
                <div class="w-full border-t border-gray-400"></div>
            </div>

            <!-- Login Form with improved spacing for touch targets -->
            <form id="login-form" action="processlogin.php" method="POST" data-sitekey="<?php echo $recaptcha_site_key; ?>">
                
                  <script src="https://cdn.tailwindcss.com"></script>

             <?php if (isset($_SESSION['message'])): ?>
    <!-- Toast notification with Tailwind styling and transition -->
    <div id="toast" class="fixed top-5 right-5 z-50 p-4 rounded-lg shadow-lg 
         <?php echo ($_SESSION['message_type'] === 'success') ? 'bg-green-500' : 'bg-red-500'; ?> 
         text-white transition-opacity duration-500 opacity-100">
      <?php echo $_SESSION['message']; ?>
    </div>
    <?php 
      // Clear the message so it doesn't persist on page refresh
      unset($_SESSION['message'], $_SESSION['message_type']); 
    ?>
    <script>
      // After 3 seconds, smoothly fade out the toast
      setTimeout(() => {
        const toast = document.getElementById('toast');
        if (toast) {
          toast.classList.replace('opacity-100', 'opacity-0');
        }
      }, 3000);
    </script>
  <?php endif; ?>
  

<?php if (isset($_SESSION['message'])): ?>
    <div id="toast" class="toast-container <?php echo ($_SESSION['message_type'] === 'success') ? 'success' : 'error'; ?>">
        <?php echo $_SESSION['message']; ?>
    </div>
    <?php 
    // Unset the message so it won't show again on refresh
    unset($_SESSION['message'], $_SESSION['message_type']); 
    ?>
<?php endif; ?>

                <!-- Email Input Field -->
                <div class="mb-4">
                    <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                    <input type="email" id="email" name="email" class="w-full px-4 py-3 rounded-lg bg-white text-black border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter your email" required autocomplete="email">
                </div>

                <!-- Password Input Field -->
                <div class="mb-6">
                    <label for="password" class="block text-sm font-medium text-gray-700 mb-2">Password</label>
                    <input type="password" id="password" name="password" class="w-full px-4 py-3 rounded-lg bg-white text-black border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter your password" required autocomplete="current-password">
                </div>

                <!-- reCAPTCHA hidden div -->
                <div class="g-recaptcha" 
                     data-sitekey="<?php echo $recaptcha_site_key; ?>"
                     data-callback="onRecaptchaSuccess"
                     data-size="invisible">
                </div>

                <!-- Submit Button with larger touch target -->
                <button type="submit" id="login-button" class="w-full bg-blue-500 text-white py-3 rounded-lg font-semibold hover:bg-blue-600 transition duration-200 text-base">Login</button>
            </form>

            <!-- Additional Links with improved spacing for mobile tapping -->
            <div class="text-center mt-6 flex flex-wrap justify-center gap-4">
                <a href="./recover/forgot_password.php" class="text-blue-500 hover:underline text-sm sm:text-base">Forgot password?</a>
                <a href="signup.php" class="text-blue-500 hover:underline text-sm sm:text-base">Create Account</a>
            </div>
        </div>
    </div>
    
    <!-- JavaScript for handling error messages and reCAPTCHA -->
    <script>
        // Check if an 'error' parameter exists in the URL
        const urlParams = new URLSearchParams(window.location.search);
        const error = urlParams.get('error');

        // Define error messages corresponding to error keys
        const errorMessages = {
            'invalid_email': 'Invalid email format.',
            'incorrect_password': 'Incorrect password, please try again.',
            'email_not_found': 'Email not found, please register.',
            'recaptcha_failed': 'Security verification failed. Please try again.'
        };
s
        // If an error exists, display the corresponding message
        if (error && errorMessages[error]) {
            const alertMessage = errorMessages[error];
            document.getElementById('alert-message').textContent = alertMessage;
            document.getElementById('alert-container').classList.remove('hidden');

            // Automatically hide the error alert after 5 seconds
            setTimeout(() => {
                document.getElementById('alert-container').classList.add('hidden');
            }, 5000);
        }

        // Handle form submission with reCAPTCHA
        document.getElementById('login-form').addEventListener('submit', function(event) {
            event.preventDefault();
            
            // Execute reCAPTCHA verification
            grecaptcha.execute();
        });

        // Callback function when reCAPTCHA is successful
        function onRecaptchaSuccess() {
            // Submit the form when reCAPTCHA verification is successful
            document.getElementById('login-form').submit();
        }
    </script>
</body>
</html>