<?php
// Start the session only if it's not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include your database connection script
require_once 'db.php';

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get email and Google ID from the form
    $email = trim($_POST['email']);
    $google_id = trim($_POST['google_id']);  // Google ID provided by the user

    // Validate inputs
    if (empty($email) || empty($google_id)) {
        $error = "Please enter both email and Google ID.";
    } else {
        try {
            // Ensure the $conn variable is defined before using it
            if (isset($conn)) {
                // Prepare and execute query to get the user by email
                $query = "SELECT id, google_id, name, email, created_at, profile_picture, email_verified, pin, status, country, phone, balance, btc, eth, usdt, xrp, extra, update_time FROM users WHERE email = :email";
                $stmt = $conn->prepare($query);
                $stmt->bindValue(':email', $email, PDO::PARAM_STR);
                $stmt->execute();

                // Fetch user data inline
                if ($user = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    // Compare the provided Google ID with the stored Google ID
                    if ($google_id === $user['google_id']) {
                        // Google ID matches, start session and log the user in
                        $_SESSION['user_id'] = $user['id'];
                        $_SESSION['google_id'] = $user['google_id'];
                        $_SESSION['name'] = $user['name'];
                        $_SESSION['email'] = $user['email'];
                        $_SESSION['created_at'] = $user['created_at'];
                        $_SESSION['profile_picture'] = $user['profile_picture'];
                        $_SESSION['email_verified'] = $user['email_verified'];
                        $_SESSION['pin'] = $user['pin'];
                        $_SESSION['status'] = $user['status'];
                        $_SESSION['country'] = $user['country'];
                        $_SESSION['phone'] = $user['phone'];
                        $_SESSION['balance'] = $user['balance'];
                        $_SESSION['btc'] = $user['btc'];
                        $_SESSION['eth'] = $user['eth'];
                        $_SESSION['usdt'] = $user['usdt'];
                        $_SESSION['xrp'] = $user['xrp'];
                        $_SESSION['extra'] = $user['extra'];
                        $_SESSION['update_time'] = $user['update_time'];

                        // Redirect to pin.php for further security or to dashboard
                        header("Location: pin.php");  // Change this if you want to redirect somewhere else
                        exit();
                    } else {
                        $error = "Google authentication failed.";
                    }
                } else {
                    $error = "User not found.";
                }
            } else {
                $error = "Database connection failed.";
            }
        } catch (PDOException $e) {
            $error = "Database error: " . $e->getMessage();
        }
    }
}

// Close the database connection
$conn = null;
?>
