<?php
session_start();

// Include the session file if needed
require_once 'session.php';

// Database credentials
$servername = "localhost";
$username = "ouxrysgh_userb";
$password = "zaoix8Q45uD868e2";
$dbname = "ouxrysgh_dbb";

// Enable detailed error reporting
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

try {
    $conn = new mysqli($servername, $username, $password, $dbname);
} catch (mysqli_sql_exception $e) {
    error_log("Database connection failed: " . $e->getMessage());
    $_SESSION['message'] = "Database connection error. Please try again.";
    $_SESSION['message_type'] = "error";
    header("Location: login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $userEmail = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $userPassword = $_POST['password'];

    // Validate email format
    if (!filter_var($userEmail, FILTER_VALIDATE_EMAIL)) {
        $_SESSION['message'] = "Invalid email format.";
        $_SESSION['message_type'] = "error";
        header("Location: login.php");
        exit();
    }

    // Escape email input for use in SQL query
    $userEmail = $conn->real_escape_string($userEmail);

    try {
        $sql = "SELECT id, email, password, name, picture, pin FROM users WHERE email = ? LIMIT 1";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $userEmail);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($id, $email, $hashedPassword, $name, $picture, $pin);
        $stmt->fetch();

        if ($stmt->num_rows > 0) {
            // Verify the password
            if (password_verify($userPassword, $hashedPassword)) {
                // Set session variables for logged in user
                $_SESSION['user_id'] = $id;
                $_SESSION['user_email'] = $email;
                $_SESSION['user_name'] = $name;
                $_SESSION['user_picture'] = $picture ?: 'https://bitnovaspro.com/session/favicon.png';
                $_SESSION['pin_verified'] = false; // PIN not verified yet

                // Regenerate session ID for security
                session_regenerate_id(true);

                // Log successful login attempt
                $logData = "User Logged In: " . json_encode([
                    'id'        => $id,
                    'email'     => $email,
                    'name'      => $name,
                    'timestamp' => date('Y-m-d H:i:s')
                ]) . "\n";
                file_put_contents('logs/user_login.log', $logData, FILE_APPEND);

                // Set a success message
                $_SESSION['message'] = "Login successful! Welcome, $name.";
                $_SESSION['message_type'] = "success";

                // Redirect based on PIN status
                if (empty($pin)) {
                    header('Location: pin.php'); // Redirect to set PIN
                } else {
                    header('Location: verify_pin.php'); // Redirect to PIN verification
                }
                exit();
            } else {
                // Incorrect password
                $_SESSION['message'] = "Incorrect  email or password";
                $_SESSION['message_type'] = "error";
                header("Location: login.php");
                exit();
            }
        } else {
            // No user found with the provided email
            $_SESSION['message'] = "Incorrect  email or password";
            $_SESSION['message_type'] = "error";
            header("Location: login.php");
            exit();
        }
    } catch (mysqli_sql_exception $e) {
        error_log("Database query error: " . $e->getMessage());
        $_SESSION['message'] = "Database error. Please try again.";
        $_SESSION['message_type'] = "error";
        header("Location: login.php");
        exit();
    }
}

$conn->close();
?>
