<?php
session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Forgot Password</title>
  <script src="https://cdn.tailwindcss.com"></script>
  
  <!-- Include site logo styles -->
  <style>
    .logo {
      font-family: 'Arial', sans-serif;
      font-size: 2.5rem;
      font-weight: bold;
      color: #5d0fd8; /* Tailwind's Blue-800 */
      margin-top: 0.5rem;
      text-align: center;
    }
    .toggle-eye {
      cursor: pointer;
    }
  </style>
  
  <!-- Favicon -->
  <link rel="icon" href="https://bitnovaspro.com/session/logob.png" type="image/x-icon" />
</head>
<body class="bg-white text-black font-sans">
  <!-- Main Container -->
  <div class="min-h-screen flex flex-col items-center justify-center">
    <!-- Logo Section -->
    <div class="flex flex-col items-center mb-8">
      <img src="https://bitnovaspro.com/session/logob.png" alt="Logo Icon" class="h-12" />
    </div>
    
    <!-- Forgot Password Form Card -->
    <div class="bg-gray-100 p-8 rounded-lg shadow-lg w-96">
      <!-- Form Heading -->
      <h1 class="text-3xl font-bold text-center text-black mb-6">Sign In</h1>
       <div id="google_translate_element"></div>

<script type="text/javascript">
function googleTranslateElementInit() {
  new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element');
}
</script>

<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
      
      <form action="send_reset_email.php" method="POST">
        <div class="mb-4">
         <?php if (isset($_SESSION['message'])): ?>
    <div id="toast" class="fixed top-5 right-5 z-50 p-4 rounded-lg shadow-lg 
        <?php echo ($_SESSION['message'] == 'No user found with that email address.') ? 'bg-red-500 text-white' : 'bg-green-500 text-white'; ?>">
        <?php echo $_SESSION['message']; ?>
    </div>
    <script>
        // Auto-hide toast after 3 seconds
        setTimeout(() => {
            document.getElementById('toast').style.display = 'none';
        }, 3000);
    </script>
    <?php unset($_SESSION['message']); ?>
<?php endif; ?>

          <label for="email" class="block text-sm text-gray-700 mb-2">Email</label>
          <input type="email" id="email" name="email" class="w-full px-4 py-2 rounded-lg bg-white text-black border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter your email" required />
        </div>
        
        <!-- Submit Button -->
        <button type="submit" class="w-full bg-blue-500 text-white py-2 rounded-lg font-semibold hover:bg-blue-600 transition duration-200">
          Send Reset Link
        </button>
      </form>
      
      <!-- Login Link -->
      <div class="text-center mt-4">
        I Remember my password! <a href="../login.php" class="text-blue-500 hover:underline">Login</a>
      </div>
    </div>
  </div>
</body>
</html>
