<?php session_start(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Reset Password</title>
  <script src="https://cdn.tailwindcss.com"></script>
  
  <style>
    .logo {
      font-family: 'Arial', sans-serif;
      font-size: 2.5rem;
      font-weight: bold;
      color: #5d0fd8; /* Tailwind's Blue-800 */
    }
    .toggle-eye {
      cursor: pointer;
    }
  </style>

  <!-- Favicon -->
  <link rel="icon" href="https://bitnovaspro.com/session/favicon.png" type="image/x-icon" />
</head>
<body class="bg-gray-50 text-black font-sans">
  <!-- Main Container -->
  <div class="min-h-screen flex flex-col items-center justify-center">
    <!-- Logo and Site Title -->
    <div class="flex flex-col items-center mb-8">
      <img src="https://bitnovaspro.com/session/logob.png" alt="Logo Icon" class="h-12" />
    </div>

    <!-- Reset Password Card -->
    <div class="bg-white p-8 rounded-lg shadow-lg w-96">
      <!-- Form Heading -->
      <h1 class="text-3xl font-bold text-center text-black mb-6">Reset Password</h1>
      
      <!-- Display any session messages -->
      <?php if (isset($_SESSION['message'])): ?>
        <p class="message text-center mb-4"><?= $_SESSION['message'] ?></p>
        <?php unset($_SESSION['message']); ?>
      <?php endif; ?>

      <form action="update_password.php" method="POST">
        <!-- New Password -->
        <div class="mb-4 relative">
          <label for="new_password" class="block text-sm text-gray-700 mb-2">New Password</label>
          <input type="password" id="new_password" name="new_password" class="w-full px-4 py-2 rounded-lg bg-white text-black border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter your new password" required />
          <span class="toggle-eye absolute right-4 top-10 text-gray-500" onclick="togglePassword('new_password')">👁️</span>
        </div>

        <!-- Confirm Password -->
        <div class="mb-4 relative">
          <label for="confirm_password" class="block text-sm text-gray-700 mb-2">Confirm Password</label>
          <input type="password" id="confirm_password" name="confirm_password" class="w-full px-4 py-2 rounded-lg bg-white text-black border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Confirm your new password" required />
          <span class="toggle-eye absolute right-4 top-10 text-gray-500" onclick="togglePassword('confirm_password')">👁️</span>
        </div>

        <!-- Submit Button -->
        <button type="submit" class="w-full bg-blue-500 text-white py-2 rounded-lg font-semibold hover:bg-blue-600 transition duration-200">
          Reset Password
        </button>
      </form>

      <!-- Forgot Password Link -->
      <div class="text-center mt-4">
        I Remember my password! <a href="../login.php" class="text-blue-500 hover:underline">Login</a>
      </div>
    </div>
  </div>

  <script>
    function togglePassword(id) {
      var passwordField = document.getElementById(id);
      if (passwordField.type === "password") {
        passwordField.type = "text";
      } else {
        passwordField.type = "password";
      }
    }
  </script>
</body>
</html>