<?php
// Enable error reporting for debugging (remove or adjust in production)
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

// Start the session at the very beginning
session_start();

/*-------------------------------------------------
  INLINE PDO DATABASE CONNECTION
-------------------------------------------------*/
$host     = 'localhost';
$dbname   = 'ouxrysgh_dbb'; // Replace with your database name
$username = 'ouxrysgh_userb'; // Replace with your database username
$password = 'zaoix8Q45uD868e2'; // Replace with your database password
$charset  = 'utf8';

$dsn = "mysql:host=$host;dbname=$dbname;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION, // Throw exceptions on errors
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,       // Fetch associative arrays
    PDO::ATTR_EMULATE_PREPARES   => false,                  // Use real prepared statements
];

try {
    $conn = new PDO($dsn, $username, $password, $options);
    // Optional: echo "Database connection established successfully.";
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

/*-------------------------------------------------
  CONFIGURATION & INITIALIZATION
-------------------------------------------------*/
// reCAPTCHA configuration
$recaptcha_site_key   = '6LeS6V4rAAAAABCqKIKk9VJfgRsO2-QRFd05VOHS';
$recaptcha_secret_key = '6LeS6V4rAAAAAGwCkZKCDuIjsPaeJaHWHN_x-apB';

// Initialize variables
$message = "";
$form_data = [
    'name'    => '',
    'email'   => '',
    'country' => '',
    'phone'   => ''
];

// Debug function to log errors
function debug_log($msg, $is_error = true) {
    error_log($msg);
    if (isset($_SESSION['debug_mode']) && $_SESSION['debug_mode']) {
        echo "<div class='alert alert-danger'>Debug: " . htmlspecialchars($msg) . "</div>";
    }
}

/*-------------------------------------------------
  ENSURE USERS TABLE EXISTS AND HAS picture COLUMN
-------------------------------------------------*/
try {
    $check_table = "SHOW TABLES LIKE 'users'";
    $stmt = $conn->prepare($check_table);
    $stmt->execute();
    $table_exists = $stmt->rowCount() > 0;
    
    if (!$table_exists) {
        // Create the table including the picture column.
        $create_table = "CREATE TABLE users (
            id INT AUTO_INCREMENT PRIMARY KEY,
            email VARCHAR(255) UNIQUE NOT NULL,
            password VARCHAR(255) NOT NULL,
            name VARCHAR(255) NOT NULL,
            country VARCHAR(100),
            phone VARCHAR(20),
            picture VARCHAR(255),
            status VARCHAR(20) DEFAULT 'hold',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            update_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )";
        $conn->exec($create_table);
        debug_log("Created users table", false);
    } else {
        // Check if the picture column exists; if not, add it.
        $check_column = "SHOW COLUMNS FROM users LIKE 'picture'";
        $stmt = $conn->prepare($check_column);
        $stmt->execute();
        if ($stmt->rowCount() == 0) {
            $alter_table = "ALTER TABLE users ADD COLUMN picture VARCHAR(255)";
            $conn->exec($alter_table);
            debug_log("Added picture column to users table", false);
        }
    }
} catch (PDOException $e) {
    debug_log("Table/column check error: " . $e->getMessage());
    // Continue execution or halt if critical
}

/*-------------------------------------------------
  PROCESS REGISTRATION FORM (ON POST)
-------------------------------------------------*/
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Save form data for repopulation in case of errors
    foreach (['name', 'email', 'country', 'phone'] as $field) {
        if (isset($_POST[$field])) {
            $form_data[$field] = $_POST[$field];
        }
    }

    // CSRF token check
    if (!isset($_POST['csrf_token']) || !isset($_SESSION['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        debug_log("CSRF token validation failed");
        $message = "<div class='alert alert-danger'>Security validation failed. Please try again.</div>";
    } else {
        // Verify reCAPTCHA
        if (!isset($_POST['g-recaptcha-response']) || empty($_POST['g-recaptcha-response'])) {
            $message = "<div class='alert alert-danger'>Please complete the security verification.</div>";
        } else {
            $recaptcha_response = $_POST['g-recaptcha-response'];
            $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
            $recaptcha_data = [
                'secret'   => $recaptcha_secret_key,
                'response' => $recaptcha_response,
                'remoteip' => $_SERVER['REMOTE_ADDR']
            ];
            $recaptcha_options = [
                'http' => [
                    'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                    'method'  => 'POST',
                    'content' => http_build_query($recaptcha_data)
                ]
            ];
            try {
                $recaptcha_context = stream_context_create($recaptcha_options);
                $recaptcha_result = file_get_contents($recaptcha_url, false, $recaptcha_context);
                if ($recaptcha_result === false) {
                    throw new Exception("Failed to connect to reCAPTCHA service");
                }
                $recaptcha_json = json_decode($recaptcha_result, true);
                if (!isset($recaptcha_json['success']) || !$recaptcha_json['success']) {
                    debug_log("reCAPTCHA verification failed: " . print_r($recaptcha_json, true));
                    $message = "<div class='alert alert-danger'>Security verification failed. Please try again.</div>";
                } else {
                    // reCAPTCHA passed; sanitize and validate inputs
                    $email = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
                    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                        $message = "<div class='alert alert-danger'>Invalid email format.</div>";
                    } else {
                        $password_input   = isset($_POST['password']) ? $_POST['password'] : '';
                        $confirm_password = isset($_POST['confirm_password']) ? $_POST['confirm_password'] : '';
                        $name             = isset($_POST['name']) ? htmlspecialchars(trim($_POST['name'])) : '';
                        $country          = isset($_POST['country']) ? htmlspecialchars($_POST['country']) : '';
                        $phone            = isset($_POST['phone']) ? htmlspecialchars(trim($_POST['phone'])) : '';

                        // Check required fields and password rules
                        if (empty($name) || empty($password_input) || empty($confirm_password)) {
                            $message = "<div class='alert alert-danger'>All required fields must be filled.</div>";
                        } elseif (strlen($password_input) < 8) {
                            $message = "<div class='alert alert-danger'>Password must be at least 8 characters long.</div>";
                        } elseif ($password_input !== $confirm_password) {
                            $message = "<div class='alert alert-danger'>Passwords do not match.</div>";
                        } else {
                            // Process picture upload if a file was provided.
                            // If a file input named "picture" is present and a file was uploaded, it will be used.
                            // Otherwise, the default URL is used directly.
                            if (isset($_FILES['picture']) && $_FILES['picture']['error'] == 0) {
                                $upload_dir = 'pictures/';
                                if (!is_dir($upload_dir)) {
                                    mkdir($upload_dir, 0755, true);
                                }
                                // Create a unique filename for the uploaded file
                                $uploaded_filename = $upload_dir . uniqid('profile_', true) . '_' . basename($_FILES['picture']['name']);
                                if (move_uploaded_file($_FILES['picture']['tmp_name'], $uploaded_filename)) {
                                    $picture = $uploaded_filename;
                                } else {
                                    $picture = 'https://bitnovaspro.com/session/logob.png';
                                }
                            } else {
                                // No file uploaded; use the default URL directly.
                                $picture = 'https://bitnovaspro.com/session/faviconb.png';
                            }

                            try {
                                // Check if the email already exists
                                $query = "SELECT id FROM users WHERE email = :email";
                                $stmt = $conn->prepare($query);
                                $stmt->bindValue(':email', $email, PDO::PARAM_STR);
                                $stmt->execute();

                                if ($stmt->rowCount() > 0) {
                                    $message = "<div class='alert alert-danger'>Email already exists.</div>";
                                } else {
                                    // Hash the password with a cost parameter
                                    $password = password_hash($password_input, PASSWORD_DEFAULT, ['cost' => 12]);

                                    // Begin transaction and insert the new user (including picture)
                                    $conn->beginTransaction();
                                    $query = "INSERT INTO users (email, password, name, country, phone, picture) 
                                              VALUES (:email, :password, :name, :country, :phone, :picture)";
                                    $stmt = $conn->prepare($query);
                                    $stmt->bindValue(':email', $email, PDO::PARAM_STR);
                                    $stmt->bindValue(':password', $password, PDO::PARAM_STR);
                                    $stmt->bindValue(':name', $name, PDO::PARAM_STR);
                                    $stmt->bindValue(':country', $country, PDO::PARAM_STR);
                                    $stmt->bindValue(':phone', $phone, PDO::PARAM_STR);
                                    $stmt->bindValue(':picture', $picture, PDO::PARAM_STR);
                                    $stmt->execute();
                                    $conn->commit();

                                    // Set session variables for the new user
                                    $user_id = $conn->lastInsertId();
                                    $_SESSION['user_email'] = $email;
                                    $_SESSION['user_id']    = $user_id;
                                    $_SESSION['user_name']  = $name;

                                    // Generate a new CSRF token for future requests
                                    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));

                                    // Set a success message and redirect to the login page
                                    $_SESSION['success_message'] = "<div class='alert alert-success'>Account created successfully. Kindly login.</div>";
                                    header('Location: login.php');
                                    exit();
                                }
                            } catch (PDOException $e) {
                                // Roll back transaction if an error occurs
                                if ($conn->inTransaction()) {
                                    $conn->rollBack();
                                }
                                debug_log("Registration error: " . $e->getMessage());
                                $message = "<div class='alert alert-danger'>Registration failed: " .
                                    (strpos($e->getMessage(), 'Duplicate entry') !== false ? "Email already exists." : "Database error. Please try again later.") . "</div>";
                            } catch (Exception $e) {
                                debug_log("General error: " . $e->getMessage());
                                $message = "<div class='alert alert-danger'>Registration failed: " . $e->getMessage() . "</div>";
                            }
                        }
                    }
                }
            } catch (Exception $e) {
                debug_log("reCAPTCHA error: " . $e->getMessage());
                $message = "<div class='alert alert-danger'>Security verification failed. Please try again.</div>";
            }
        }
    }
}

/*-------------------------------------------------
  CSRF TOKEN & HELPER FUNCTION
-------------------------------------------------*/
// Generate a CSRF token if one is not already set
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$csrf_token = $_SESSION['csrf_token'];

// Function to safely output form values
function get_form_value($key) {
    global $form_data;
    return isset($form_data[$key]) ? htmlspecialchars($form_data[$key]) : '';
}

/*-------------------------------------------------
  TOGGLE DEBUG MODE VIA URL (optional, remove in production)
-------------------------------------------------*/
if (isset($_GET['debug']) && $_GET['debug'] == 'on') {
    $_SESSION['debug_mode'] = true;
} elseif (isset($_GET['debug']) && $_GET['debug'] == 'off') {
    $_SESSION['debug_mode'] = false;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description" content="Sign up for Bitnovaspro - Create your account">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sign Up - Bitnovaspro</title>

  <!-- Favicon -->
  <link rel="icon" href="https://bitnovaspro.com/session/favicon.png" type="image/x-icon">

  <!-- Include TailwindCSS -->
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
  
  <!-- Include Flag Icon CSS library -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/6.6.6/css/flag-icons.min.css" integrity="sha512-uvXdJud8WaOlQFjlz9B15Yy2Au/bMNgxAXO7295ZTukkP4DZTwpFNlq0KgQoZ5GT1O4EhE97vYx8XSGmaFx5Q==" crossorigin="anonymous" referrerpolicy="no-referrer" />

  <!-- Include Select2 CSS for enhanced dropdown -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

  <!-- Google reCAPTCHA (invisible) -->
  <script src="https://www.google.com/recaptcha/api.js" async defer></script>

  <!-- Include jQuery for Select2 -->
  <script src="https://code.jquery.com/jquery-3.6.4.min.js" integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>
  
   <!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = 'b185b89eff779bf61a239a91251da652ef9b45cb';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>

  <!-- Custom styles -->
  <style>
    .logo {
      font-family: 'Arial', sans-serif;
      font-size: 2.5rem;
      font-weight: bold;
      color: #5d0fd8;
      text-align: center;
      margin-bottom: 0;
    }
    .info-widget {
      display: flex;
      align-items: center;
      background-color: #e3f2fd;
      border-radius: 8px;
      padding: 10px;
      margin-bottom: 20px;
    }
    .info-widget .icon { margin-right: 10px; }
    .info-widget .message { font-size: 0.875rem; color: #0c5460; }
    .select2-container--default .select2-selection--single {
      height: 42px;
      padding: 6px;
      border-radius: 8px;
      border: 1px solid #d1d5db;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
      height: 42px;
    }
    /* Alert container (for error messages via URL parameters) */
    .hidden { display: none; }
  </style>
</head>
<body class="bg-gray-100">

  <!-- Site Logo -->
 <a href="https://bitnovaspro.com"> <div class="flex flex-col items-center mb-6">
                <!-- Logo image with responsive sizing -->
                
                <img src="https://bitnovaspro.com/session/logob.png" alt="Bitnovaspro Logo" class="h-10 sm:h-12" />
              
            </div></a>

  <div class="flex justify-center items-center min-h-screen py-8">
    <div class="bg-white p-8 rounded-lg shadow-lg w-full max-w-md mx-4">
      
      
     
     <!-- Google Translate Element Container -->
<div id="google_translate_element" class="floating-translate"></div>

<!-- Google Translate Scripts -->
<script type="text/javascript">
  function googleTranslateElementInit() {
    new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element');
  }
</script>
<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

<!-- CSS for floating Google Translate widget on the bottom-left and hiding the logo -->
<style>
  .floating-translate {
    position: fixed;
    bottom: 20px;
    left: 20px; /* Positioned to the left-hand side */
    z-index: 9999;
    background-color: #8a2be2; /* Optional: purple background */
    padding: 10px; /* Optional: internal spacing */
    border-radius: 8px; /* Optional: rounded corners */
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.25); /* Optional: subtle shadow */
  }

  /* Hide the default Google Translate logo */
  .goog-te-gadget img {
    display: none;
  }
</style>


      <!-- Info Widget -->
      <div class="info-widget">
        <div class="icon">
          <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="#17a2b8" viewBox="0 0 24 24">
            <path d="M12 0C5.372 0 0 5.372 0 12s5.372 12 12 12 12-5.372 12-12S18.628 0 12 0zm1 17h-2v-6h2v6zm0-8h-2V7h2v2z"/>
          </svg>
        </div>
        <div class="message">
          We've gone passwordless! Signup with just your email for enhanced account security.
        </div>
      </div>
      
      <!-- Google Signup Button -->
     <a href="https://accounts.google.com/o/oauth2/auth?client_id=591255606353-56huc1sm3plsos7626duvcpneb7r3122.apps.googleusercontent.com&redirect_uri=https://bitnovaspro.com/session/auth/callback.php&response_type=code&scope=email profile" 
         class="w-full flex items-center justify-center bg-blue-500 text-white py-2 rounded-lg font-semibold hover:bg-blue-600 transition duration-200">
  <img src="https://cdn.iconscout.com/icon/free/png-256/free-google-logo-icon-download-in-svg-png-gif-file-formats--brands-pack-logos-icons-189824.png?f=webp&w=128" alt="Google Logo" class="w-6 h-6 mr-2">
  Signup with Google
</a>

      
      <!-- OR Divider -->
      <div class="flex items-center justify-between my-4">
        <div class="w-full border-t border-gray-400"></div>
        <span class="mx-2 text-gray-600">OR</span>
        <div class="w-full border-t border-gray-400"></div>
      </div>
      
      <!-- PHP Error/Info Alert (if any) -->
      <?php
        if (!empty($message)) {
            echo '<div class="bg-blue-100 border border-blue-400 text-blue-700 px-4 py-3 rounded relative mb-4" role="alert">' . $message . '</div>';
        }
      ?>

      <!-- Alert Container for URL errors (invisible error messaging) -->
      <div id="alert-container" class="hidden bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
          <span id="alert-message"></span>
      </div>


      <!-- Signup Form -->
      <form action="" method="POST" enctype="multipart/form-data" id="signup-form" class="space-y-4" novalidate>
        <!-- CSRF Token -->
        <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
        
        <!-- Name -->
        <div>
          <label for="name" class="block text-sm text-gray-700 mb-2">Full Name</label>
          <input type="text" id="name" name="name" class="w-full px-4 py-2 rounded-lg bg-white text-black border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500" 
                 placeholder="Enter your full name" required minlength="2" maxlength="100">
          <p id="name-error" class="text-sm text-red-500 mt-1 hidden">Please enter a valid name.</p>
        </div>
        
        <!-- Email -->
        <div>
          <label for="email" class="block text-sm text-gray-700 mb-2">Email</label>
          <input type="email" id="email" name="email" class="w-full px-4 py-2 rounded-lg bg-white text-black border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500" 
                 placeholder="Enter your email" required>
          <p id="email-error" class="text-sm text-red-500 mt-1 hidden">Please enter a valid email address.</p>
        </div>

        <!-- Country -->
        <div>
          <label for="country" class="block text-sm text-gray-700 mb-2">Country</label>
          <select id="country" name="country" class="w-full px-4 py-2 rounded-lg bg-white text-black border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            <option value="">Select your country</option>
            <!-- Options generated by JS -->
          </select>
        </div>

        <!-- Phone -->
        <div>
          <label for="phone" class="block text-sm text-gray-700 mb-2">Phone</label>
          <div class="flex">
            <input type="tel" id="phone" name="phone" class="w-full px-4 py-2 rounded-r-lg bg-white text-black border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500" 
                   placeholder="Enter your phone number" required>
          </div>
          <p id="phone-error" class="text-sm text-red-500 mt-1 hidden">Please enter a valid phone number.</p>
        </div>

        <!-- Password -->
        <div>
          <label for="password" class="block text-sm text-gray-700 mb-2">Password</label>
          <div class="relative">
            <input type="password" id="password" name="password" class="w-full px-4 py-2 rounded-lg bg-white text-black border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500" 
                   placeholder="Enter your password" required minlength="8">
            <button type="button" class="absolute right-3 top-3 text-gray-500 focus:outline-none" aria-label="Toggle password visibility" onclick="togglePasswordVisibility('password')">
              <i class="fas fa-eye"></i>
            </button>
          </div>
          <div class="mt-1">
            <div class="password-strength-meter bg-gray-300 h-2 rounded-full mt-2 overflow-hidden">
              <div id="password-meter" class="h-full bg-gray-500 transition-all duration-300"></div>
            </div>
            <p id="password-strength" class="text-sm mt-1"></p>
          </div>
        </div>

        <!-- Confirm Password -->
        <div>
          <label for="confirm-password" class="block text-sm text-gray-700 mb-2">Confirm Password</label>
          <div class="relative">
            <input type="password" id="confirm-password" name="confirm_password" class="w-full px-4 py-2 rounded-lg bg-white text-black border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500" 
                   placeholder="Confirm your password" required>
            <button type="button" class="absolute right-3 top-3 text-gray-500 focus:outline-none" aria-label="Toggle password visibility" onclick="togglePasswordVisibility('confirm-password')">
              <i class="fas fa-eye"></i>
            </button>
          </div>
          <p id="password-match" class="text-sm mt-1"></p>
        </div>

        <!-- Invisible Google reCAPTCHA Widget -->
        <div class="g-recaptcha" 
             data-sitekey="<?php echo $recaptcha_site_key; ?>" 
             data-size="invisible" 
             data-callback="onRecaptchaSuccess">
        </div>

        <!-- Terms and Conditions -->
        <div class="flex items-start">
          <input type="checkbox" id="terms-check" name="terms" class="mt-1 mr-2" required>
          <label for="terms-check" class="text-sm text-gray-600">
            I agree to the <a href="terms.php" class="text-blue-500 hover:underline">Terms and Conditions</a> and <a href="privacy.php" class="text-blue-500 hover:underline">Privacy Policy</a>
          </label>
        </div>

        <!-- Submit Button -->
        <button type="submit" id="submit-btn" class="w-full bg-blue-500 text-white py-2 rounded-lg font-semibold hover:bg-blue-600 transition duration-200 disabled:opacity-50 disabled:cursor-not-allowed">
          Sign Up
        </button>
      </form>
      
      <div class="text-center mt-4">
        Already have an Account? <a href="login.php" class="text-blue-500 hover:underline">Login</a>
      </div>
    </div>
  </div>

  <!-- Include FontAwesome for password visibility icon -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/js/all.min.js" integrity="sha512-RPiXYMj9s/rsLg5jJl+RjhJjsKv3z7c3h12YFZpKdPxYM6MHX3jUpd6/HR8iYaBEUR+KYsHtutAF+8WL/xiXQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  <!-- Include Select2 JS -->
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <!-- Include libphonenumber JS for phone validation -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/libphonenumber-js/1.10.18/libphonenumber-js.min.js" integrity="sha512-atIxAnwlnE6jNIKgHWYHJJEHGJsbjgPZb8CsdQZH5F/ycWikrGtKnHaBkGJJKKXYbPOCVDuU0j78mVpyzJyCw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

  <script>
    // Form validation variables
    let formValid = false;
    let passwordStrong = false;
    let passwordsMatch = false;
    let termsAccepted = false;
    
    // Country codes for phone numbers
    const countryCodes = {
      'United States': '+1',
      'United Kingdom': '+44',
      'Canada': '+1',
      'Australia': '+61',
      'Germany': '+49',
      'France': '+33',
      'India': '+91',
      'China': '+86'
    };
    
    let selectedCountryCode = '+1';
    
    async function loadCountries() {
      try {
        const cachedCountries = localStorage.getItem('countries');
        if (cachedCountries) {
          populateCountries(JSON.parse(cachedCountries));
          return;
        }
        const response = await fetch('https://restcountries.com/v3.1/all');
        if (!response.ok) {
          throw new Error('Failed to fetch countries');
        }
        const countries = await response.json();
        localStorage.setItem('countries', JSON.stringify(countries));
        populateCountries(countries);
      } catch (error) {
        console.error('Error fetching country data:', error);
        const fallbackCountries = [
          { name: { common: 'Afghanistan' }, cca2: 'AF' },
  { name: { common: 'Albania' }, cca2: 'AL' },
  { name: { common: 'Algeria' }, cca2: 'DZ' },
  { name: { common: 'Andorra' }, cca2: 'AD' },
  { name: { common: 'Angola' }, cca2: 'AO' },
  { name: { common: 'Antigua and Barbuda' }, cca2: 'AG' },
  { name: { common: 'Argentina' }, cca2: 'AR' },
  { name: { common: 'Armenia' }, cca2: 'AM' },
  { name: { common: 'Australia' }, cca2: 'AU' },
  { name: { common: 'Austria' }, cca2: 'AT' },
  { name: { common: 'Azerbaijan' }, cca2: 'AZ' },
  { name: { common: 'Bahamas' }, cca2: 'BS' },
  { name: { common: 'Bahrain' }, cca2: 'BH' },
  { name: { common: 'Bangladesh' }, cca2: 'BD' },
  { name: { common: 'Barbados' }, cca2: 'BB' },
  { name: { common: 'Belarus' }, cca2: 'BY' },
  { name: { common: 'Belgium' }, cca2: 'BE' },
  { name: { common: 'Belize' }, cca2: 'BZ' },
  { name: { common: 'Benin' }, cca2: 'BJ' },
  { name: { common: 'Bhutan' }, cca2: 'BT' },
  { name: { common: 'Bolivia' }, cca2: 'BO' },
  { name: { common: 'Bosnia and Herzegovina' }, cca2: 'BA' },
  { name: { common: 'Botswana' }, cca2: 'BW' },
  { name: { common: 'Brazil' }, cca2: 'BR' },
  { name: { common: 'Brunei' }, cca2: 'BN' },
  { name: { common: 'Bulgaria' }, cca2: 'BG' },
  { name: { common: 'Burkina Faso' }, cca2: 'BF' },
  { name: { common: 'Burundi' }, cca2: 'BI' },
  { name: { common: 'Cabo Verde' }, cca2: 'CV' },
  { name: { common: 'Cambodia' }, cca2: 'KH' },
  { name: { common: 'Cameroon' }, cca2: 'CM' },
  { name: { common: 'Canada' }, cca2: 'CA' },
  { name: { common: 'Central African Republic' }, cca2: 'CF' },
  { name: { common: 'Chad' }, cca2: 'TD' },
  { name: { common: 'Chile' }, cca2: 'CL' },
  { name: { common: 'China' }, cca2: 'CN' },
  { name: { common: 'Colombia' }, cca2: 'CO' },
  { name: { common: 'Comoros' }, cca2: 'KM' },
  { name: { common: 'Congo (Congo-Brazzaville)' }, cca2: 'CG' },
  { name: { common: 'Costa Rica' }, cca2: 'CR' },
  { name: { common: 'Croatia' }, cca2: 'HR' },
  { name: { common: 'Cuba' }, cca2: 'CU' },
  { name: { common: 'Cyprus' }, cca2: 'CY' },
  { name: { common: 'Czechia (Czech Republic)' }, cca2: 'CZ' },
  { name: { common: 'Democratic Republic of the Congo' }, cca2: 'CD' },
  { name: { common: 'Denmark' }, cca2: 'DK' },
  { name: { common: 'Djibouti' }, cca2: 'DJ' },
  { name: { common: 'Dominica' }, cca2: 'DM' },
  { name: { common: 'Dominican Republic' }, cca2: 'DO' },
  { name: { common: 'Ecuador' }, cca2: 'EC' },
  { name: { common: 'Egypt' }, cca2: 'EG' },
  { name: { common: 'El Salvador' }, cca2: 'SV' },
  { name: { common: 'Equatorial Guinea' }, cca2: 'GQ' },
  { name: { common: 'Eritrea' }, cca2: 'ER' },
  { name: { common: 'Estonia' }, cca2: 'EE' },
  { name: { common: 'Eswatini' }, cca2: 'SZ' },
  { name: { common: 'Ethiopia' }, cca2: 'ET' },
  { name: { common: 'Fiji' }, cca2: 'FJ' },
  { name: { common: 'Finland' }, cca2: 'FI' },
  { name: { common: 'France' }, cca2: 'FR' },
  { name: { common: 'Gabon' }, cca2: 'GA' },
  { name: { common: 'Gambia' }, cca2: 'GM' },
  { name: { common: 'Georgia' }, cca2: 'GE' },
  { name: { common: 'Germany' }, cca2: 'DE' },
  { name: { common: 'Ghana' }, cca2: 'GH' },
  { name: { common: 'Greece' }, cca2: 'GR' },
  { name: { common: 'Grenada' }, cca2: 'GD' },
  { name: { common: 'Guatemala' }, cca2: 'GT' },
  { name: { common: 'Guinea' }, cca2: 'GN' },
  { name: { common: 'Guinea-Bissau' }, cca2: 'GW' },
  { name: { common: 'Guyana' }, cca2: 'GY' },
  { name: { common: 'Haiti' }, cca2: 'HT' },
  { name: { common: 'Holy See' }, cca2: 'VA' },
  { name: { common: 'Honduras' }, cca2: 'HN' },
  { name: { common: 'Hungary' }, cca2: 'HU' },
  { name: { common: 'Iceland' }, cca2: 'IS' },
  { name: { common: 'India' }, cca2: 'IN' },
  { name: { common: 'Indonesia' }, cca2: 'ID' },
  { name: { common: 'Iran' }, cca2: 'IR' },
  { name: { common: 'Iraq' }, cca2: 'IQ' },
  { name: { common: 'Ireland' }, cca2: 'IE' },
  { name: { common: 'Israel' }, cca2: 'IL' },
  { name: { common: 'Italy' }, cca2: 'IT' },
  { name: { common: 'Jamaica' }, cca2: 'JM' },
  { name: { common: 'Japan' }, cca2: 'JP' },
  { name: { common: 'Jordan' }, cca2: 'JO' },
  { name: { common: 'Kazakhstan' }, cca2: 'KZ' },
  { name: { common: 'Kenya' }, cca2: 'KE' },
  { name: { common: 'Kiribati' }, cca2: 'KI' },
  { name: { common: 'Kuwait' }, cca2: 'KW' },
  { name: { common: 'Kyrgyzstan' }, cca2: 'KG' },
  { name: { common: 'Laos' }, cca2: 'LA' },
  { name: { common: 'Latvia' }, cca2: 'LV' },
  { name: { common: 'Lebanon' }, cca2: 'LB' },
  { name: { common: 'Lesotho' }, cca2: 'LS' },
  { name: { common: 'Liberia' }, cca2: 'LR' },
  { name: { common: 'Libya' }, cca2: 'LY' },
  { name: { common: 'Liechtenstein' }, cca2: 'LI' },
  { name: { common: 'Lithuania' }, cca2: 'LT' },
  { name: { common: 'Luxembourg' }, cca2: 'LU' },
  { name: { common: 'Madagascar' }, cca2: 'MG' },
  { name: { common: 'Malawi' }, cca2: 'MW' },
  { name: { common: 'Malaysia' }, cca2: 'MY' },
  { name: { common: 'Maldives' }, cca2: 'MV' },
  { name: { common: 'Mali' }, cca2: 'ML' },
  { name: { common: 'Malta' }, cca2: 'MT' },
  { name: { common: 'Marshall Islands' }, cca2: 'MH' },
  { name: { common: 'Mauritania' }, cca2: 'MR' },
  { name: { common: 'Mauritius' }, cca2: 'MU' },
  { name: { common: 'Mexico' }, cca2: 'MX' },
  { name: { common: 'Micronesia' }, cca2: 'FM' },
  { name: { common: 'Moldova' }, cca2: 'MD' },
  { name: { common: 'Monaco' }, cca2: 'MC' },
  { name: { common: 'Mongolia' }, cca2: 'MN' },
  { name: { common: 'Montenegro' }, cca2: 'ME' },
  { name: { common: 'Morocco' }, cca2: 'MA' },
  { name: { common: 'Mozambique' }, cca2: 'MZ' },
  { name: { common: 'Myanmar (Burma)' }, cca2: 'MM' },
  { name: { common: 'Namibia' }, cca2: 'NA' },
  { name: { common: 'Nauru' }, cca2: 'NR' },
  { name: { common: 'Nepal' }, cca2: 'NP' },
  { name: { common: 'Netherlands' }, cca2: 'NL' },
  { name: { common: 'New Zealand' }, cca2: 'NZ' },
  { name: { common: 'Nicaragua' }, cca2: 'NI' },
  { name: { common: 'Niger' }, cca2: 'NE' },
  { name: { common: 'Nigeria' }, cca2: 'NG' },
  { name: { common: 'North Korea' }, cca2: 'KP' },
  { name: { common: 'North Macedonia' }, cca2: 'MK' },
  { name: { common: 'Norway' }, cca2: 'NO' },
  { name: { common: 'Oman' }, cca2: 'OM' },
  { name: { common: 'Pakistan' }, cca2: 'PK' },
  { name: { common: 'Palau' }, cca2: 'PW' },
  { name: { common: 'Palestine State' }, cca2: 'PS' },
  { name: { common: 'Panama' }, cca2: 'PA' },
  { name: { common: 'Papua New Guinea' }, cca2: 'PG' },
  { name: { common: 'Paraguay' }, cca2: 'PY' },
  { name: { common: 'Peru' }, cca2: 'PE' },
  { name: { common: 'Philippines' }, cca2: 'PH' },
  { name: { common: 'Poland' }, cca2: 'PL' },
  { name: { common: 'Portugal' }, cca2: 'PT' },
  { name: { common: 'Qatar' }, cca2: 'QA' },
  { name: { common: 'Romania' }, cca2: 'RO' },
  { name: { common: 'Russia' }, cca2: 'RU' },
  { name: { common: 'Rwanda' }, cca2: 'RW' },
  { name: { common: 'Saint Kitts and Nevis' }, cca2: 'KN' },
  { name: { common: 'Saint Lucia' }, cca2: 'LC' },
  { name: { common: 'Saint Vincent and the Grenadines' }, cca2: 'VC' },
  { name: { common: 'Samoa' }, cca2: 'WS' },
  { name: { common: 'San Marino' }, cca2: 'SM' },
  { name: { common: 'Sao Tome and Principe' }, cca2: 'ST' },
  { name: { common: 'Saudi Arabia' }, cca2: 'SA' },
  { name: { common: 'Senegal' }, cca2: 'SN' },
  { name: { common: 'Serbia' }, cca2: 'RS' },
  { name: { common: 'Seychelles' }, cca2: 'SC' },
  { name: { common: 'Sierra Leone' }, cca2: 'SL' },
  { name: { common: 'Singapore' }, cca2: 'SG' },
  { name: { common: 'Slovakia' }, cca2: 'SK' },
  { name: { common: 'Slovenia' }, cca2: 'SI' },
  { name: { common: 'Solomon Islands' }, cca2: 'SB' },
  { name: { common: 'Somalia' }, cca2: 'SO' },
  { name: { common: 'South Africa' }, cca2: 'ZA' },
  { name: { common: 'South Korea' }, cca2: 'KR' },
  { name: { common: 'South Sudan' }, cca2: 'SS' },
  { name: { common: 'Spain' }, cca2: 'ES' },
  { name: { common: 'Sri Lanka' }, cca2: 'LK' },
  { name: { common: 'Sudan' }, cca2: 'SD' },
  { name: { common: 'Suriname' }, cca2: 'SR' },
  { name: { common: 'Sweden' }, cca2: 'SE' },
  { name: { common: 'Switzerland' }, cca2: 'CH' },
  { name: { common: 'Syria' }, cca2: 'SY' },
  { name: { common: 'Tajikistan' }, cca2: 'TJ' },
  { name: { common: 'Tanzania' }, cca2: 'TZ' },
  { name: { common: 'Thailand' }, cca2: 'TH' },
  { name: { common: 'Timor-Leste' }, cca2: 'TL' },
  { name: { common: 'Togo' }, cca2: 'TG' },
  { name: { common: 'Tonga' }, cca2: 'TO' },
  { name: { common: 'Trinidad and Tobago' }, cca2: 'TT' },
  { name: { common: 'Tunisia' }, cca2: 'TN' },
  { name: { common: 'Turkey' }, cca2: 'TR' },
  { name: { common: 'Turkmenistan' }, cca2: 'TM' },
  { name: { common: 'Tuvalu' }, cca2: 'TV' },
  { name: { common: 'Uganda' }, cca2: 'UG' },
  { name: { common: 'Ukraine' }, cca2: 'UA' },
  { name: { common: 'United Arab Emirates' }, cca2: 'AE' },
  { name: { common: 'United Kingdom' }, cca2: 'GB' },
  { name: { common: 'United States of America' }, cca2: 'US' },
  { name: { common: 'Uruguay' }, cca2: 'UY' },
  { name: { common: 'Uzbekistan' }, cca2: 'UZ' },
  { name: { common: 'Vanuatu' }, cca2: 'VU' },
  { name: { common: 'Venezuela' }, cca2: 'VE' },
  { name: { common: 'Vietnam' }, cca2: 'VN' },
  { name: { common: 'Yemen' }, cca2: 'YE' },
  { name: { common: 'Zambia' }, cca2: 'ZM' },
  { name: { common: 'Zimbabwe' }, cca2: 'ZW' }
        ];
        populateCountries(fallbackCountries);
      }
    }
    
    function populateCountries(countries) {
      countries.sort((a, b) => a.name.common.localeCompare(b.name.common));
      const countrySelect = document.getElementById("country");
      
      countries.forEach(country => {
        const option = document.createElement("option");
        option.value = country.name.common;
        option.textContent = country.name.common;
        const countryCode = country.cca2 ? country.cca2.toLowerCase() : '';
        option.setAttribute('data-code', countryCode);
        countrySelect.appendChild(option);
      });
      
      $('#country').select2({
        templateResult: formatCountry,
        templateSelection: formatCountrySelection,
        placeholder: "Select your country"
      });
      
      $('#country').on('change', function() {
        const selectedCountry = $(this).val();
        if (countryCodes[selectedCountry]) {
          selectedCountryCode = countryCodes[selectedCountry];
          document.getElementById('country-code').textContent = selectedCountryCode;
        }
      });
    }

    function formatCountry(country) {
      if (!country.id || !country.element) return country.text;
      var code = $(country.element).data('code');
      return code ? $('<span><i class="flag-icon flag-icon-' + code + ' mr-2"></i> ' + country.text + '</span>') : country.text;
    }

    function formatCountrySelection(country) {
      if (!country.id || !country.element) return country.text;
      var code = $(country.element).data('code');
      return code ? $('<span><i class="flag-icon flag-icon-' + code + ' mr-2"></i> ' + country.text + '</span>') : country.text;
    }

    function togglePasswordVisibility(fieldId) {
      const field = document.getElementById(fieldId);
      const icon = field.nextElementSibling.querySelector('i');
      if (field.type === "password") {
        field.type = "text";
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
      } else {
        field.type = "password";
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
      }
    }

    function checkPasswordStrength() {
      const password = document.getElementById('password').value;
      const strengthElement = document.getElementById('password-strength');
      const meterElement = document.getElementById('password-meter');
      
      if (password.length === 0) {
        strengthElement.textContent = "";
        meterElement.style.width = "0%";
        meterElement.style.backgroundColor = "#9CA3AF";
        passwordStrong = false;
        return;
      }
      
      let score = 0;
      if (password.length >= 8) score += 25;
      if (password.length >= 12) score += 15;
      if (/[a-z]/.test(password)) score += 10;
      if (/[A-Z]/.test(password)) score += 15;
      if (/[0-9]/.test(password)) score += 15;
      if (/[^a-zA-Z0-9]/.test(password)) score += 20;
      const unique = [...new Set(password)].length;
      score += Math.min(unique, 5) * 2;
      
      meterElement.style.width = `${score}%`;
      let strength, color;
      if (score < 50) {
        strength = "Weak";
        color = "#EF4444";
        passwordStrong = false;
      } else if (score < 75) {
        strength = "Medium";
        color = "#F59E0B";
        passwordStrong = false;
      } else {
        strength = "Strong";
        color = "#10B981";
        passwordStrong = true;
      }
      strengthElement.textContent = `Password Strength: ${strength}`;
      strengthElement.style.color = color;
      meterElement.style.backgroundColor = color;
      updateFormValidity();
    }

    function checkPasswordMatch() {
      const password = document.getElementById('password').value;
      const confirmPassword = document.getElementById('confirm-password').value;
      const messageElement = document.getElementById('password-match');
      if (confirmPassword === "") {
        messageElement.textContent = "";
        passwordsMatch = false;
        return;
      }
      if (password === confirmPassword) {
        messageElement.textContent = "Passwords match.";
        messageElement.style.color = "#10B981";
        passwordsMatch = true;
      } else {
        messageElement.textContent = "Passwords do not match.";
        messageElement.style.color = "#EF4444";
        passwordsMatch = false;
      }
      updateFormValidity();
    }
    
    function validateEmail() {
      const email = document.getElementById('email').value;
      const errorElement = document.getElementById('email-error');
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (email === "" || emailRegex.test(email)) {
        errorElement.classList.add('hidden');
        return true;
      } else {
        errorElement.classList.remove('hidden');
        return false;
      }
    }
    
    function validateName() {
      const name = document.getElementById('name').value;
      const errorElement = document.getElementById('name-error');
      if (name === "" || name.length >= 2) {
        errorElement.classList.add('hidden');
        return true;
      } else {
        errorElement.classList.remove('hidden');
        return false;
      }
    }
    
    function validatePhone() {
      const phone = document.getElementById('phone').value;
      const errorElement = document.getElementById('phone-error');
      if (phone === "") {
        errorElement.classList.add('hidden');
        return true;
      }
      try {
        const phoneNumber = libphonenumber.parsePhoneNumber(selectedCountryCode + phone);
        const isValid = phoneNumber.isValid();
        if (isValid) {
          errorElement.classList.add('hidden');
          return true;
        } else {
          errorElement.classList.remove('hidden');
          return false;
        }
      } catch (e) {
        const phoneRegex = /^[0-9]{7,15}$/;
        const isValid = phoneRegex.test(phone.replace(/\D/g, ''));
        if (isValid) {
          errorElement.classList.add('hidden');
          return true;
        } else {
          errorElement.classList.remove('hidden');
          return false;
        }
      }
    }
    
    function checkTerms() {
      termsAccepted = document.getElementById('terms-check').checked;
      updateFormValidity();
    }
    
    function updateFormValidity() {
      const nameValid = validateName();
      const emailValid = validateEmail();
      const phoneValid = validatePhone();
      const countrySelected = document.getElementById('country').value !== "";
      formValid = nameValid && emailValid && phoneValid && countrySelected && 
                  passwordsMatch && document.getElementById('password').value.length >= 8 && termsAccepted;
      document.getElementById('submit-btn').disabled = !formValid;
    }
    
    // Load countries and add event listeners on DOMContentLoaded
    document.addEventListener('DOMContentLoaded', function() {
      loadCountries();
      document.getElementById('password').addEventListener('input', function() {
        checkPasswordStrength();
        checkPasswordMatch();
      });
      document.getElementById('confirm-password').addEventListener('input', checkPasswordMatch);
      document.getElementById('name').addEventListener('input', updateFormValidity);
      document.getElementById('email').addEventListener('input', updateFormValidity);
      document.getElementById('phone').addEventListener('input', updateFormValidity);
      document.getElementById('country').addEventListener('change', updateFormValidity);
      document.getElementById('terms-check').addEventListener('change', checkTerms);
      updateFormValidity();
    });

    // Error message handling using URL parameters (if applicable)
    const urlParams = new URLSearchParams(window.location.search);
    const error = urlParams.get('error');
    const errorMessages = {
      'invalid_email': 'Invalid email format.',
      'incorrect_password': 'Incorrect password, please try again.',
      'email_not_found': 'Email not found, please register.',
      'recaptcha_failed': 'Security verification failed. Please try again.'
    };
    if (error && errorMessages[error]) {
      const alertMessage = errorMessages[error];
      document.getElementById('alert-message').textContent = alertMessage;
      document.getElementById('alert-container').classList.remove('hidden');
      setTimeout(() => {
        document.getElementById('alert-container').classList.add('hidden');
      }, 5000);
    }

    // Handle signup form submission with invisible reCAPTCHA
    document.getElementById('signup-form').addEventListener('submit', function(event) {
      event.preventDefault();
      grecaptcha.execute();
    });

    // Callback when reCAPTCHA verification is successful
    function onRecaptchaSuccess() {
      document.getElementById('signup-form').submit();
    }
  </script>
</body>
</html>
