<?php
// Enable error reporting for debugging (remove these in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/**
 * Returns the country code for a given country name.
 *
 * @param mixed $countryName The country name or code.
 * @return string The two-letter country code in lowercase, or an empty string.
 */
function getCountryCode($countryName) {
    static $codes = [
        'Afghanistan'                     => 'af',
        'Albania'                         => 'al',
        'Algeria'                         => 'dz',
        'Andorra'                         => 'ad',
        'Angola'                          => 'ao',
        'Antigua and Barbuda'             => 'ag',
        'Argentina'                       => 'ar',
        'Armenia'                         => 'am',
        'Australia'                       => 'au',
        'Austria'                         => 'at',
        'Azerbaijan'                      => 'az',
        'Bahamas'                         => 'bs',
        'Bahrain'                         => 'bh',
        'Bangladesh'                      => 'bd',
        'Barbados'                        => 'bb',
        'Belarus'                         => 'by',
        'Belgium'                         => 'be',
        'Belize'                          => 'bz',
        'Benin'                           => 'bj',
        'Bhutan'                          => 'bt',
        'Bolivia'                         => 'bo',
        'Bosnia and Herzegovina'          => 'ba',
        'Botswana'                        => 'bw',
        'Brazil'                          => 'br',
        'Brunei'                          => 'bn',
        'Bulgaria'                        => 'bg',
        'Burkina Faso'                    => 'bf',
        'Burundi'                         => 'bi',
        'Cabo Verde'                      => 'cv',
        'Cambodia'                        => 'kh',
        'Cameroon'                        => 'cm',
        'Canada'                          => 'ca',
        'Central African Republic'        => 'cf',
        'Chad'                            => 'td',
        'Chile'                           => 'cl',
        'China'                           => 'cn',
        'Colombia'                        => 'co',
        'Comoros'                         => 'km',
        'Congo (Congo-Brazzaville)'       => 'cg',
        'Costa Rica'                      => 'cr',
        'Croatia'                         => 'hr',
        'Cuba'                            => 'cu',
        'Cyprus'                          => 'cy',
        'Czechia (Czech Republic)'        => 'cz',
        'Democratic Republic of the Congo'=> 'cd',
        'Denmark'                         => 'dk',
        'Djibouti'                        => 'dj',
        'Dominica'                        => 'dm',
        'Dominican Republic'              => 'do',
        'Ecuador'                         => 'ec',
        'Egypt'                           => 'eg',
        'El Salvador'                     => 'sv',
        'Equatorial Guinea'               => 'gq',
        'Eritrea'                         => 'er',
        'Estonia'                         => 'ee',
        'Eswatini'                        => 'sz',
        'Ethiopia'                        => 'et',
        'Fiji'                            => 'fj',
        'Finland'                         => 'fi',
        'France'                          => 'fr',
        'Gabon'                           => 'ga',
        'Gambia'                          => 'gm',
        'Georgia'                         => 'ge',
        'Germany'                         => 'de',
        'Ghana'                           => 'gh',
        'Greece'                          => 'gr',
        'Grenada'                         => 'gd',
        'Guatemala'                       => 'gt',
        'Guinea'                          => 'gn',
        'Guinea-Bissau'                   => 'gw',
        'Guyana'                          => 'gy',
        'Haiti'                           => 'ht',
        'Holy See'                        => 'va',
        'Honduras'                        => 'hn',
        'Hungary'                         => 'hu',
        'Iceland'                         => 'is',
        'India'                           => 'in',
        'Indonesia'                       => 'id',
        'Iran'                            => 'ir',
        'Iraq'                            => 'iq',
        'Ireland'                         => 'ie',
        'Israel'                          => 'il',
        'Italy'                           => 'it',
        'Jamaica'                         => 'jm',
        'Japan'                           => 'jp',
        'Jordan'                          => 'jo',
        'Kazakhstan'                      => 'kz',
        'Kenya'                           => 'ke',
        'Kiribati'                        => 'ki',
        'Kuwait'                          => 'kw',
        'Kyrgyzstan'                      => 'kg',
        'Laos'                            => 'la',
        'Latvia'                          => 'lv',
        'Lebanon'                         => 'lb',
        'Lesotho'                         => 'ls',
        'Liberia'                         => 'lr',
        'Libya'                           => 'ly',
        'Liechtenstein'                   => 'li',
        'Lithuania'                       => 'lt',
        'Luxembourg'                      => 'lu',
        'Madagascar'                      => 'mg',
        'Malawi'                          => 'mw',
        'Malaysia'                        => 'my',
        'Maldives'                        => 'mv',
        'Mali'                            => 'ml',
        'Malta'                           => 'mt',
        'Marshall Islands'                => 'mh',
        'Mauritania'                      => 'mr',
        'Mauritius'                       => 'mu',
        'Mexico'                          => 'mx',
        'Micronesia'                      => 'fm',
        'Moldova'                         => 'md',
        'Monaco'                          => 'mc',
        'Mongolia'                        => 'mn',
        'Montenegro'                      => 'me',
        'Morocco'                         => 'ma',
        'Mozambique'                      => 'mz',
        'Myanmar (formerly Burma)'        => 'mm',
        'Namibia'                         => 'na',
        'Nauru'                           => 'nr',
        'Nepal'                           => 'np',
        'Netherlands'                     => 'nl',
        'New Zealand'                     => 'nz',
        'Nicaragua'                       => 'ni',
        'Niger'                           => 'ne',
        'Nigeria'                         => 'ng',
        'North Korea'                     => 'kp',
        'North Macedonia'                 => 'mk',
        'Norway'                          => 'no',
        'Oman'                            => 'om',
        'Pakistan'                        => 'pk',
        'Palau'                           => 'pw',
        'Palestine State'                 => 'ps',
        'Panama'                          => 'pa',
        'Papua New Guinea'                => 'pg',
        'Paraguay'                        => 'py',
        'Peru'                            => 'pe',
        'Philippines'                     => 'ph',
        'Poland'                          => 'pl',
        'Portugal'                        => 'pt',
        'Qatar'                           => 'qa',
        'Romania'                         => 'ro',
        'Russia'                          => 'ru',
        'Rwanda'                          => 'rw',
        'Saint Kitts and Nevis'           => 'kn',
        'Saint Lucia'                     => 'lc',
        'Saint Vincent and the Grenadines'=> 'vc',
        'Samoa'                           => 'ws',
        'San Marino'                      => 'sm',
        'Sao Tome and Principe'           => 'st',
        'Saudi Arabia'                    => 'sa',
        'Senegal'                         => 'sn',
        'Serbia'                          => 'rs',
        'Seychelles'                      => 'sc',
        'Sierra Leone'                    => 'sl',
        'Singapore'                       => 'sg',
        'Slovakia'                        => 'sk',
        'Slovenia'                        => 'si',
        'Solomon Islands'                 => 'sb',
        'Somalia'                         => 'so',
        'South Africa'                    => 'za',
        'South Korea'                     => 'kr',
        'South Sudan'                     => 'ss',
        'Spain'                           => 'es',
        'Sri Lanka'                       => 'lk',
        'Sudan'                           => 'sd',
        'Suriname'                        => 'sr',
        'Sweden'                          => 'se',
        'Switzerland'                     => 'ch',
        'Syria'                           => 'sy',
        'Taiwan'                          => 'tw',
        'Tajikistan'                      => 'tj',
        'Tanzania'                        => 'tz',
        'Thailand'                        => 'th',
        'Timor-Leste'                     => 'tl',
        'Togo'                            => 'tg',
        'Tonga'                           => 'to',
        'Trinidad and Tobago'             => 'tt',
        'Tunisia'                         => 'tn',
        'Turkey'                          => 'tr',
        'Turkmenistan'                    => 'tm',
        'Tuvalu'                          => 'tv',
        'Uganda'                          => 'ug',
        'Ukraine'                         => 'ua',
        'United Arab Emirates'            => 'ae',
        'United Kingdom'                  => 'gb',
        'United States'                   => 'us',
        'Uruguay'                         => 'uy',
        'Uzbekistan'                      => 'uz',
        'Vanuatu'                         => 'vu',
        'Venezuela'                       => 've',
        'Vietnam'                         => 'vn',
        'Yemen'                           => 'ye',
        'Zambia'                          => 'zm',
        'Zimbabwe'                        => 'zw'
    ];

    if (empty($countryName)) {
        return '';
    }

    if (strlen($countryName) === 2) {
        return strtolower($countryName);
    }

    return $codes[$countryName] ?? '';
}

// Include the database connection file.
require './db.php';

try {
    // Fetch country data from the users table.
    $query = $conn->prepare("
        SELECT 
            country AS name, 
            COUNT(*) AS customers
        FROM users 
        GROUP BY country
        ORDER BY customers DESC
    ");
    $query->execute();
    $countries = $query->fetchAll(PDO::FETCH_ASSOC);

    // Calculate total customers for progress bar calculations.
    $total_customers = array_sum(array_column($countries, 'customers'));

    // For each country, add the proper country code and progress percentage.
    foreach ($countries as &$country) {
        $country['percentage'] = round(($country['customers'] / $total_customers) * 100, 2);
        $country['code']       = getCountryCode($country['name']);
    }

    // Prepare JSON for client-side use.
    $jsonCountries = json_encode($countries);
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}

// Include session.php to manage session and database.
include '../session.php';

// Ensure the user is logged in; if not, redirect to the login page.
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database.
$userDetails = getUserDetails($conn);

if ($userDetails === null) {
    die('Pending or session expired.');
}

// Extract user data into variables.
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$balance        = $userDetails['balance'];
$btc            = $userDetails['btc'];
$eth            = $userDetails['eth'];
$usdt           = $userDetails['usdt'];
$xrp            = $userDetails['xrp'];
$doge           = $userDetails['doge'];
$ada            = $userDetails['ada'];
$pepe           = $userDetails['pepe'];
$sol            = $userDetails['sol'];
$bnb            = $userDetails['bnb'];
$message        = $userDetails['message'];
$extra          = $userDetails['extra'];
$msgstatus      = $userDetails['msgstatus'];
$bonus          = $userDetails['bonus'];
$profit         = $userDetails['profit'];
$plan           = $userDetails['plan'];
$update_time    = $userDetails['update_time'];

// Calculate total amount from btc, eth, usdt, bnb, xrp, sol, pepe, doge, profit, bonus, and ada.
$totalAmount = (float)$btc + (float)$eth + (float)$usdt + (float)$bnb + (float)$xrp + (float)$sol + (float)$pepe + (float)$doge + (float)$profit + (float)$bonus + (float)$ada;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Advanced Analytics Dashboard</title>
    <link rel="icon" href="https://bitnovaspro.com/session/faviconb.png" type="image/x-icon">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
    
    <!-- Chart.js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>
    
    <!-- SweetAlert2 -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert2/11.10.5/sweetalert2.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert2/11.10.5/sweetalert2.min.css">
    
    <!-- AOS Animation -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap');
        
        * {
            font-family: 'Inter', sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .glass-effect {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .card-hover {
            transition: all 0.3s ease;
        }
        
        .card-hover:hover {
            transform: translateY(-5px);
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.1);
        }
        
        .gradient-text {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .pulse-animation {
            animation: pulse-custom 2s infinite;
        }
        
        @keyframes pulse-custom {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
        
        .floating {
            animation: floating 3s ease-in-out infinite;
        }
        
        @keyframes floating {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }
        
        .crypto-card {
            background: linear-gradient(135deg, #fff 0%, #f8faff 100%);
            border: 2px solid transparent;
            background-clip: padding-box;
            position: relative;
        }
        
        .crypto-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, #667eea, #764ba2);
            z-index: -1;
            border-radius: inherit;
            margin: -2px;
        }
        
        .scrollbar-hide {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }
        
        .scrollbar-hide::-webkit-scrollbar {
            display: none;
        }
        
        .calendar-day {
            transition: all 0.2s ease;
        }
        
        .calendar-day:hover {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            transform: scale(1.1);
        }
        
        .progress-bar {
            background: linear-gradient(90deg, #667eea, #764ba2);
            height: 8px;
            border-radius: 10px;
            overflow: hidden;
        }
        
        .progress-fill {
            background: linear-gradient(90deg, #10f2c5, #00d4ff);
            height: 100%;
            border-radius: 10px;
            transition: width 1s ease;
        }
    </style>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'primary': '#667eea',
                        'secondary': '#764ba2',
                        'accent': '#10f2c5'
                    }
                }
            }
        }
    </script>
</head>

<body class="bg-gradient-to-br from-purple-600 via-blue-600 to-purple-800">
    <!-- Navigation -->
    <nav class="glass-effect p-4 mb-8" data-aos="fade-down">
        <div class="container mx-auto flex justify-between items-center">
          <div class="flex items-center space-x-4 bg-white p-2">
  <img src="https://bitnovaspro.com/session/logob.png" alt="Bitnovaspro Logo" class="h-8 w-auto" />
</div>


            <div class="flex items-center space-x-4">
                <img src="<?php echo htmlspecialchars($picture); ?>" alt="Profile" class="w-10 h-10 rounded-full border-2 border-white">
                <span class="text-white font-medium"><?php echo htmlspecialchars($name); ?></span>
            </div>
        </div>
    </nav>

    <div class="container mx-auto px-4 pb-8">
        <!-- Stats Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <!-- Total Balance -->
            <div class="bg-white rounded-2xl p-6 shadow-xl card-hover floating" data-aos="fade-up" data-aos-delay="100">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500 text-sm font-medium">Bonus Balance</p>
                        <p class="text-3xl font-bold gradient-text">$<?php echo number_format($bonus, 2); ?></p>
                        <p class="text-green-500 text-sm font-medium mt-1">
                            <i class="fas fa-arrow-up"></i> +12.5%
                        </p>
                    </div>
                    <div class="bg-gradient-to-r from-primary to-secondary p-3 rounded-full">
                        <i class="fas fa-wallet text-white text-xl"></i>
                    </div>
                </div>
            </div>

            <!-- Crypto Portfolio -->
            <div class="bg-white rounded-2xl p-6 shadow-xl card-hover floating" data-aos="fade-up" data-aos-delay="200">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500 text-sm font-medium">Crypto Portfolio</p>
                        <p class="text-3xl font-bold gradient-text">$<?php echo number_format($totalAmount, 2); ?></p>
                        <p class="text-green-500 text-sm font-medium mt-1">
                            <i class="fas fa-arrow-up"></i> +8.3%
                        </p>
                    </div>
                    <div class="bg-gradient-to-r from-accent to-primary p-3 rounded-full">
                        <i class="fab fa-bitcoin text-white text-xl"></i>
                    </div>
                </div>
            </div>

            <!-- Active Trades -->
            <div class="bg-white rounded-2xl p-6 shadow-xl card-hover floating" data-aos="fade-up" data-aos-delay="300">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500 text-sm font-medium">Active Trades</p>
                        <p class="text-3xl font-bold gradient-text">24</p>
                        <p class="text-blue-500 text-sm font-medium mt-1">
                            <i class="fas fa-chart-line"></i> 4 pending
                        </p>
                    </div>
                    <div class="bg-gradient-to-r from-blue-500 to-purple-600 p-3 rounded-full">
                        <i class="fas fa-exchange-alt text-white text-xl"></i>
                    </div>
                </div>
            </div>

            <!-- Profit/Loss -->
            <div class="bg-white rounded-2xl p-6 shadow-xl card-hover floating" data-aos="fade-up" data-aos-delay="400">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500 text-sm font-medium">Today's P&L</p>
                        <p class="text-3xl font-bold gradient-text">$<?php echo number_format($profit, 2); ?></p>
                        <p class="text-green-500 text-sm font-medium mt-1">
                            <i class="fas fa-arrow-up"></i> +15.7%
                        </p>
                    </div>
                    <div class="bg-gradient-to-r from-green-500 to-emerald-600 p-3 rounded-full">
                        <i class="fas fa-chart-bar text-white text-xl"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Dashboard Grid -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Left Column -->
            <div class="lg:col-span-2 space-y-8">
                <!-- Portfolio Chart -->
                <div class="bg-white rounded-2xl p-6 shadow-xl" data-aos="fade-up">
                    <div class="flex items-center justify-between mb-6">
                        <h3 class="text-xl font-bold gradient-text">
                            <i class="fas fa-chart-area mr-2"></i>
                            Portfolio Performance
                        </h3>
                        <div class="flex space-x-2">
                            <button class="px-4 py-2 bg-gradient-to-r from-primary to-secondary text-white rounded-lg text-sm font-medium hover:shadow-lg transition-all">
                                7D
                            </button>
                            <button class="px-4 py-2 bg-gray-100 text-gray-600 rounded-lg text-sm font-medium hover:bg-gray-200 transition-all">
                                30D
                            </button>
                            <button class="px-4 py-2 bg-gray-100 text-gray-600 rounded-lg text-sm font-medium hover:bg-gray-200 transition-all">
                                1Y
                            </button>
                        </div>
                    </div>
                    <div class="h-80">
                        <canvas id="portfolioChart"></canvas>
                    </div>
                </div>

                <!-- Country Distribution -->
                <div class="bg-white rounded-2xl p-6 shadow-xl" data-aos="fade-up">
                    <h3 class="text-xl font-bold gradient-text mb-6">
                        <i class="fas fa-globe mr-2"></i>
                        Global Customer Distribution
                    </h3>
                    <div class="h-64">
                        <canvas id="countryChart"></canvas>
                    </div>
                </div>

                <!-- Crypto Holdings -->
                <div class="bg-white rounded-2xl p-6 shadow-xl" data-aos="fade-up">
                    <h3 class="text-xl font-bold gradient-text mb-6">
                        <i class="fas fa-coins mr-2"></i>
                        Crypto Holdings
                    </h3>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <?php
                        $cryptos = [
                            ['name' => 'Bitcoin', 'symbol' => 'BTC', 'value' => $btc, 'icon' => 'fab fa-bitcoin', 'color' => 'from-yellow-400 to-orange-500'],
                            ['name' => 'Ethereum', 'symbol' => 'ETH', 'value' => $eth, 'icon' => 'fab fa-ethereum', 'color' => 'from-blue-400 to-blue-600'],
                            ['name' => 'USDT', 'symbol' => 'USDT', 'value' => $usdt, 'icon' => 'fas fa-dollar-sign', 'color' => 'from-green-400 to-green-600'],
                            ['name' => 'Solana', 'symbol' => 'SOL', 'value' => $sol, 'icon' => 'fas fa-sun', 'color' => 'from-purple-400 to-purple-600'],
                            ['name' => 'Cardano', 'symbol' => 'ADA', 'value' => $ada, 'icon' => 'fas fa-heart', 'color' => 'from-blue-500 to-indigo-600'],
                            ['name' => 'Dogecoin', 'symbol' => 'DOGE', 'value' => $doge, 'icon' => 'fas fa-dog', 'color' => 'from-yellow-500 to-yellow-600'],
                            ['name' => 'XRP', 'symbol' => 'XRP', 'value' => $xrp, 'icon' => 'fas fa-coins', 'color' => 'from-gray-400 to-gray-600'],
                            ['name' => 'BNB', 'symbol' => 'BNB', 'value' => $bnb, 'icon' => 'fas fa-fire', 'color' => 'from-orange-400 to-red-500']
                        ];
                        
                        foreach ($cryptos as $crypto):
                        ?>
                        <div class="crypto-card rounded-xl p-4 text-center hover:shadow-lg transition-all duration-300">
                            <div class="bg-gradient-to-r <?php echo $crypto['color']; ?> w-12 h-12 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="<?php echo $crypto['icon']; ?> text-white text-lg"></i>
                            </div>
                            <h4 class="font-semibold text-gray-800 text-sm"><?php echo $crypto['name']; ?></h4>
                            <p class="text-xs text-gray-500 mb-2"><?php echo $crypto['symbol']; ?></p>
                            <p class="font-bold text-gray-900">$<?php echo number_format($crypto['value'], 2); ?></p>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Right Column -->
            <div class="space-y-8">
                <!-- Quick Actions -->
                <div class="bg-white rounded-2xl p-6 shadow-xl" data-aos="fade-left">
                    <h3 class="text-xl font-bold gradient-text mb-6">
                        <i class="fas fa-bolt mr-2"></i>
                        Quick Actions
                    </h3>
                    <div class="space-y-3">
  <a href="dashboard.php" class="block w-full bg-gradient-to-r from-primary to-secondary text-white py-3 rounded-lg font-medium hover:shadow-lg transition-all text-center">
    <i class="fas fa-plus mr-2"></i>
    Deposit Funds
  </a>
  <a href="forex.php" class="block w-full bg-gradient-to-r from-accent to-primary text-white py-3 rounded-lg font-medium hover:shadow-lg transition-all text-center">
    <i class="fas fa-minus mr-2"></i>
    Forex Trading
  </a>
  <a href="copytrade.php" class="block w-full bg-gradient-to-r from-purple-500 to-pink-500 text-white py-3 rounded-lg font-medium hover:shadow-lg transition-all text-center">
    <i class="fas fa-chart-line mr-2"></i>
    Copy Trading
  </a>
  <a href="crypto.php" class="block w-full bg-gradient-to-r from-indigo-500 to-blue-500 text-white py-3 rounded-lg font-medium hover:shadow-lg transition-all text-center">
    <i class="fas fa-exchange-alt mr-2"></i>
    Transfer Assets
  </a>
</div>

                </div>

             

<!-- Chart.js CDN (ideally placed before closing </body>) -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>

<script>
  // Fetch Bitcoin price data from CoinGecko
  async function fetchBitcoinData() {
    try {
      const response = await fetch(
        'https://api.coingecko.com/api/v3/coins/bitcoin/market_chart?vs_currency=usd&days=7'
      );
      const data = await response.json();
      return data.prices; // [ [timestamp, price], ... ]
    } catch (err) {
      console.error('Error fetching CoinGecko data:', err);
      return [];
    }
  }

  // Format a Unix timestamp (ms) to "MM/DD"
  function formatDate(ms) {
    const d = new Date(ms);
    return `${d.getMonth() + 1}/${d.getDate()}`;
  }

  // Initialize and render the chart
  async function renderBitcoinChart() {
    const prices = await fetchBitcoinData();
    if (!prices.length) return;

    const labels = prices.map(entry => formatDate(entry[0]));
    const values = prices.map(entry => entry[1]);

    // Update current price and percentage change
    const latestPrice = values[values.length - 1];
    const firstPrice = values[0];
    const changePercent = ((latestPrice - firstPrice) / firstPrice) * 100;

    document.getElementById('btc-current').textContent =
      `$${latestPrice.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}`;
    const changeEl = document.getElementById('btc-change');
    changeEl.textContent = `${changePercent >= 0 ? '+' : ''}${changePercent.toFixed(2)}%`;
    changeEl.classList.toggle('text-green-500', changePercent >= 0);
    changeEl.classList.toggle('text-red-500', changePercent < 0);

    // Render Chart.js line chart
    const ctx = document.getElementById('bitcoinChart').getContext('2d');
    new Chart(ctx, {
      type: 'line',
      data: {
        labels: labels,
        datasets: [{
          label: 'BTC Price (USD)',
          data: values,
          borderColor: '#F7931A',
          backgroundColor: 'rgba(247, 147, 26, 0.2)',
          borderWidth: 2,
          pointRadius: 0,
          fill: true,
          tension: 0.2
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: true,
        scales: {
          x: {
            ticks: { color: '#6B7280', font: { size: 12 } },
            grid: { display: false }
          },
          y: {
            ticks: { color: '#6B7280', font: { size: 12 } },
            grid: { color: '#E5E7EB' }
          }
        },
        plugins: {
          legend: { display: false },
          tooltip: {
            callbacks: {
              label: ctx => 
                `$${ctx.parsed.y.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}`
            }
          }
        }
      }
    });
  }

  document.addEventListener('DOMContentLoaded', renderBitcoinChart);
</script>


                <!-- Market Trends -->
                
                        
                      
                    </div>
                </div>

                <!-- User Stats -->
                <div class="bg-white rounded-2xl p-6 shadow-xl" data-aos="fade-left" data-aos-delay="300">
                    <h3 class="text-xl font-bold gradient-text mb-6">
                        <i class="fas fa-user-chart mr-2"></i>
                        Your Stats
                    </h3>
                    <div class="space-y-4">
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Member Since</span>
                            <span class="font-medium"><?php echo date('M Y', strtotime($created_at)); ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Country</span>
                            <span class="font-medium"><?php echo htmlspecialchars($country); ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Status</span>
                            <span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-sm font-medium">
                                <?php echo ucfirst(htmlspecialchars($status)); ?>
                            </span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Plan</span>
                            <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded-full text-sm font-medium">
                                <?php echo htmlspecialchars($plan ?: 'Basic'); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modals -->
    <!-- Deposit Modal -->
    <div id="depositModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center">
        <div class="bg-white rounded-2xl p-8 m-4 max-w-md w-full">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-2xl font-bold gradient-text">Deposit Funds</h3>
                <button onclick="closeModal('depositModal')" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <form class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Amount</label>
                    <input type="number" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent" placeholder="Enter amount">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Payment Method</label>
                    <select class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                        <option>Bank Transfer</option>
                        <option>Credit Card</option>
                        <option>Crypto</option>
                    </select>
                </div>
                <button type="submit" class="w-full bg-gradient-to-r from-primary to-secondary text-white py-3 rounded-lg font-medium hover:shadow-lg transition-all">
                    Deposit Now
                </button>
            </form>
        </div>
    </div>

    <!-- Withdraw Modal -->
    <div id="withdrawModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center">
        <div class="bg-white rounded-2xl p-8 m-4 max-w-md w-full">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-2xl font-bold gradient-text">Withdraw Funds</h3>
                <button onclick="closeModal('withdrawModal')" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <form class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Amount</label>
                    <input type="number" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent" placeholder="Enter amount">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Withdrawal Method</label>
                    <select class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                        <option>Bank Transfer</option>
                        <option>Crypto Wallet</option>
                    </select>
                </div>
                <button type="submit" class="w-full bg-gradient-to-r from-accent to-primary text-white py-3 rounded-lg font-medium hover:shadow-lg transition-all">
                    Withdraw Now
                </button>
            </form>
        </div>
    </div>

    <!-- Trade Modal -->
    <div id="tradeModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center">
        <div class="bg-white rounded-2xl p-8 m-4 max-w-md w-full">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-2xl font-bold gradient-text">Start Trading</h3>
                <button onclick="closeModal('tradeModal')" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <form class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Trading Pair</label>
                    <select class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                        <option>BTC/USD</option>
                        <option>ETH/USD</option>
                        <option>SOL/USD</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Amount</label>
                    <input type="number" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent" placeholder="Enter amount">
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <button type="button" class="bg-green-500 text-white py-3 rounded-lg font-medium hover:bg-green-600 transition-all">
                        Buy
                    </button>
                    <button type="button" class="bg-red-500 text-white py-3 rounded-lg font-medium hover:bg-red-600 transition-all">
                        Sell
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Transfer Modal -->
    <div id="transferModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center">
        <div class="bg-white rounded-2xl p-8 m-4 max-w-md w-full">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-2xl font-bold gradient-text">Transfer Assets</h3>
                <button onclick="closeModal('transferModal')" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <form class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">From</label>
                    <select class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                        <option>Spot Wallet</option>
                        <option>Trading Account</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">To</label>
                    <select class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                        <option>Trading Account</option>
                        <option>Spot Wallet</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Amount</label>
                    <input type="number" class="w-full p-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent" placeholder="Enter amount">
                </div>
                <button type="submit" class="w-full bg-gradient-to-r from-indigo-500 to-blue-500 text-white py-3 rounded-lg font-medium hover:shadow-lg transition-all">
                    Transfer Now
                </button>
            </form>
        </div>
    </div>

    <script>
        // Initialize AOS
        AOS.init({
            duration: 1000,
            once: true
        });

        // Country data from PHP
        const countries = <?php echo $jsonCountries; ?>;

        // Portfolio Chart
        const portfolioCtx = document.getElementById('portfolioChart').getContext('2d');
        new Chart(portfolioCtx, {
            type: 'line',
            data: {
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul'],
                datasets: [{
                    label: 'Portfolio Value',
                    data: [30000, 35000, 32000, 45000, 42000, 48000, 52000],
                    borderColor: 'rgb(102, 126, 234)',
                    backgroundColor: 'rgba(102, 126, 234, 0.1)',
                    tension: 0.4,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: false,
                        grid: {
                            color: 'rgba(0,0,0,0.05)'
                        }
                    },
                    x: {
                        grid: {
                            display: false
                        }
                    }
                }
            }
        });

        // Country Distribution Chart
        const countryCtx = document.getElementById('countryChart').getContext('2d');
        const topCountries = countries.slice(0, 8);
        
        new Chart(countryCtx, {
            type: 'doughnut',
            data: {
                labels: topCountries.map(country => country.name),
                datasets: [{
                    data: topCountries.map(country => country.customers),
                    backgroundColor: [
                        '#667eea', '#764ba2', '#f093fb', '#f5576c',
                        '#4facfe', '#00f2fe', '#43e97b', '#38f9d7'
                    ],
                    borderWidth: 0
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            padding: 20,
                            usePointStyle: true
                        }
                    }
                }
            }
        });

        // Modal Functions
        function showDepositModal() {
            document.getElementById('depositModal').classList.remove('hidden');
        }

        function showWithdrawModal() {
            document.getElementById('withdrawModal').classList.remove('hidden');
        }

        function showTradeModal() {
            document.getElementById('tradeModal').classList.remove('hidden');
        }

        function showTransferModal() {
            document.getElementById('transferModal').classList.remove('hidden');
        }

        function closeModal(modalId) {
            document.getElementById(modalId).classList.add('hidden');
        }

        // Close modals when clicking outside
        document.addEventListener('click', function(e) {
            if (e.target.classList.contains('bg-black')) {
                e.target.classList.add('hidden');
            }
        });

        // Add some interactive features
        document.addEventListener('DOMContentLoaded', function() {
            // Animate numbers on load
            const animateValue = (element, start, end, duration) => {
                let startTimestamp = null;
                const step = (timestamp) => {
                    if (!startTimestamp) startTimestamp = timestamp;
                    const progress = Math.min((timestamp - startTimestamp) / duration, 1);
                    element.innerHTML = '$' + Math.floor(progress * (end - start) + start).toLocaleString();
                    if (progress < 1) {
                        window.requestAnimationFrame(step);
                    }
                };
                window.requestAnimationFrame(step);
            };

            // Show success message for demo
            setTimeout(() => {
                Swal.fire({
                    title: 'Welcome back!',
                    text: 'Your dashboard has been updated with the latest data.',
                    icon: 'success',
                    showConfirmButton: false,
                    timer: 3000,
                    position: 'top-end',
                    toast: true
                });
            }, 1000);
        });
    </script>
</body>
</html>