<?php
header('Content-Type: application/json');

// Define cache file and cache duration (in seconds)
$cache_file = "btc_price_cache.json";
$cache_duration = 300; // 5 minutes

// Check if cache exists and is still valid
if (file_exists($cache_file) && (time() - filemtime($cache_file)) < $cache_duration) {
    $data = json_decode(file_get_contents($cache_file), true);
} else {
    // Fetch fresh data from CoinGecko API
    $api_url = "https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd";
    $response = @file_get_contents($api_url);

    if ($response !== false) {
        $data = json_decode($response, true);
        if (isset($data['bitcoin']['usd'])) {
            file_put_contents($cache_file, json_encode($data));
        }
    }
}

// Ensure BTC price is available
if (isset($data['bitcoin']['usd'])) {
    $btc_price = $data['bitcoin']['usd'];

    // Get USD amount dynamically (if passed via GET request)
    $usd_amount = isset($_GET['amount']) ? floatval($_GET['amount']) : 0;

    // Convert USD to BTC
    $btc_amount = ($btc_price > 0) ? $usd_amount / $btc_price : 0;

    // Return JSON response
    echo json_encode([
        "price" => $btc_price,
        "btc_amount" => number_format($btc_amount, 7) // 7 decimal places
    ]);
} else {
    echo json_encode(["error" => "Error fetching BTC price."]);
}
?>
