<?php
session_start();
if (!isset($_SESSION['transaction_data'])) {
    header("Location: dashboard.php");
    exit();
}

$transaction_data = $_SESSION['transaction_data'];

// Network logic
$coin_id = '';
$icon_url = '';
$networkName = '';
$networkFullName = '';

if ($transaction_data['network'] === 'eth') {
    $coin_id = 'ethereum';
    $icon_url = "https://bitnovaspro.com/cryptos/eth.png";
    $networkName = 'ETH';
    $networkFullName = 'Ethereum';
} else {
    $coin_id = 'ethereum';
    $icon_url = "https://bitnovaspro.com/cryptos/eth.png";
    $networkName = 'ETH';
    $networkFullName = 'Ethereum';
}

$total_usd = isset($transaction_data['total_amount']) ? floatval($transaction_data['total_amount']) : 0;
$usd_fee = isset($transaction_data['fee']) ? floatval($transaction_data['fee']) : 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Swipe to Confirm</title>
  <link rel="icon" href="https://bitnovaspro.com/session/faviconb.png" type="image/x-icon">
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    html, body { height: 100%; margin: 0; padding: 0; user-select: none; background-color: #ffffff; }
    .container { max-width: 420px; margin: 0 auto; height: 100%; position: relative; }
    .header { position: absolute; top: 0; left: 0; width: 100%; padding: 0.5rem; display: flex; justify-content: space-between; z-index: 10; }
    #btcDetails { display: flex; flex-direction: column; align-items: center; width: 100%; padding: 0 1rem; }
    .swipe-track { position: relative; width: 300px; height: 80px; background: linear-gradient(to right, #881ff9, #93c5fd); border-radius: 40px; display: flex; align-items: center; padding: 2px; margin: 1.5rem auto; }
    .swipe-button { position: absolute; left: 2px; width: 56px; height: 56px; background-color: #881ff9; border-radius: 50%; display: flex; justify-content: center; align-items: center; cursor: pointer; touch-action: none; transition: left 0.3s ease-in-out, opacity 0.3s ease-in-out; opacity: 1; }
    .swipe-button.fade-out { opacity: 0; }
    .eth-gradient { background: linear-gradient(135deg, #627eea 0%, #8a92b2 100%); }
  </style>
</head>
<body>
  <div class="container">
    <div class="header">
      <button onclick="goBack()" class="text-blue-500 hover:text-blue-700">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
        </svg>
      </button>
      <button onclick="openNotifications()" class="text-blue-500 hover:text-blue-700">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C8.67 6.165 8 7.388 8 8.75v5.408c0 .621-.226 1.213-.63 1.656L6 17h5m4 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
        </svg>
      </button>
    </div>

    <div class="h-full flex flex-col justify-center items-center mt-8">
      <form id="confirmationForm" action="ethprocessor.php" method="POST">
        <div id="btcDetails">
          <div class="mt-6 mb-2 flex flex-col items-center">
            <div class="w-16 h-16 bg-blue-600 bg-opacity-10 rounded-full flex items-center justify-center mx-auto mb-4">
              <img src="<?= $icon_url ?>" alt="<?= htmlspecialchars($networkName) ?>" class="w-8 h-8">
            </div>
            <h1 class="text-lg font-bold">Confirm Send <?= htmlspecialchars($networkName) ?></h1>
          </div>
          <div class="text-center mb-6">
            <p id="coinAmountDisplay" class="text-2xl font-bold text-gray-800">Loading...</p>
            <p class="text-gray-700 text-sm">1 <?= htmlspecialchars($networkName) ?> ≈ $<span id="priceDisplay">...</span></p>
          </div>

          <div class="bg-white w-full max-w-sm shadow rounded-lg p-4 mb-6">
            <input type="hidden" name="amount_usd" value="<?= number_format($total_usd, 2, '.', '') ?>">
            <input type="hidden" name="conversion_rate" id="conversionRateInput">
            <input type="hidden" name="amount_coin" id="amountCoinInput">
            <input type="hidden" name="fee_coin" id="feeCoinInput">
            <input type="hidden" name="recipient" value="<?= htmlspecialchars($transaction_data['wallet']) ?>">

            <div class="flex justify-between items-center mb-3">
              <div class="flex items-center text-gray-800 font-bold space-x-2">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M12 1C5.925 1 1 5.925 1 12s4.925 11 11 11 11-4.925 11-11S18.075 1 12 1z"/>
                </svg><span>Amount</span>
              </div>
              <span class="font-bold text-gray-800">$<?= number_format($total_usd, 2) ?></span>
            </div>
            <div class="flex justify-between items-center mb-3">
              <div class="flex items-center text-gray-800 font-bold space-x-2">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M12 1a9 9 0 019 9c0 7.732-9 13-9 13S3 17.732 3 10a9 9 0 019-9zm0 12a3 3 0 100-6 3 3 0 000 6z" />
                </svg><span>Fee</span>
              </div>
              <span id="feeCoinDisplay" class="font-bold text-gray-800">Loading...</span>
            </div>
            <div class="flex justify-between items-center mb-3">
              <div class="flex items-center text-gray-800 font-bold space-x-2">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M12 2C6.489 2 2 6.489 2 12s4.489 10 10 10c5.512 0 10-4.489 10-10S17.512 2 12 2z"/>
                </svg><span>You Get</span>
              </div>
              <span id="youGetDisplay" class="font-bold text-gray-800">Loading...</span>
            </div>
            <div class="flex justify-between items-center">
              <div class="flex items-center text-gray-800 font-bold space-x-2">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M19 7H5C3.346 7 2 8.346 2 10v4c0 1.654 1.346 3 3 3h14c1.654 0 3-1.346 3-3v-4c0-1.654-1.346-3-3-3z" />
                </svg><span><?= htmlspecialchars($networkFullName) ?></span>
              </div>
              <span class="font-semibold text-blue-600 break-all"><?= htmlspecialchars($transaction_data['wallet']) ?></span>
            </div>
          </div>
          <div id="swipeLabel" class="text-center">
            <p class="text-lg font-bold text-gray-800">Swipe to confirm</p>
            <p class="text-xs text-gray-600">By confirming, you agree to the terms.</p>
          </div>
        </div>
        <div id="swipeTrack" class="swipe-track">
          <div id="swipeButton" class="swipe-button">
            <button type="submit" style="all: unset; display: flex; justify-content: center; align-items: center;">
              <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                <path d="M20 12l-7-7v4H4v6h9v4l7-7z" />
              </svg>
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>

<script>
function goBack() { window.history.back(); }
function openNotifications() { alert("Notifications not implemented."); }

const swipeButton = document.getElementById('swipeButton');
const swipeTrack = document.getElementById('swipeTrack');
const confirmationForm = document.getElementById('confirmationForm');

let isDragging = false, startX = 0, initialLeft = 0;
function getMinLeft() { return 2; }
function getMaxLeft() { return swipeTrack.clientWidth - swipeButton.clientWidth - 2; }

function finishDrag() {
  const maxLeft = getMaxLeft();
  const minLeft = getMinLeft();
  const currentLeft = parseInt(window.getComputedStyle(swipeButton).left);
  const conversionRate = parseFloat(document.getElementById('conversionRateInput').value || 0);
  if (currentLeft >= maxLeft && conversionRate > 0) {
    confirmationForm.submit();
    swipeButton.classList.add('fade-out');
    setTimeout(() => {
      swipeButton.classList.remove('fade-out');
      swipeButton.style.transition = 'left 0.3s ease';
      swipeButton.style.left = minLeft + 'px';
    }, 300);
  } else {
    swipeButton.style.transition = 'left 0.3s ease';
    swipeButton.style.left = minLeft + 'px';
  }
}

swipeButton.addEventListener('touchstart', e => {
  isDragging = true;
  startX = e.touches[0].clientX;
  initialLeft = parseInt(window.getComputedStyle(swipeButton).left);
  swipeButton.style.transition = 'none';
});
swipeButton.addEventListener('touchmove', e => {
  if (!isDragging) return;
  const deltaX = e.touches[0].clientX - startX;
  let newLeft = initialLeft + deltaX;
  newLeft = Math.max(getMinLeft(), Math.min(getMaxLeft(), newLeft));
  swipeButton.style.left = newLeft + 'px';
  e.preventDefault();
}, { passive: false });
swipeButton.addEventListener('touchend', () => { finishDrag(); isDragging = false; });

swipeButton.addEventListener('mousedown', e => {
  isDragging = true;
  startX = e.clientX;
  initialLeft = parseInt(window.getComputedStyle(swipeButton).left);
  swipeButton.style.transition = 'none';
  e.preventDefault();
});
document.addEventListener('mousemove', e => {
  if (!isDragging) return;
  let newLeft = initialLeft + (e.clientX - startX);
  newLeft = Math.max(getMinLeft(), Math.min(getMaxLeft(), newLeft));
  swipeButton.style.left = newLeft + 'px';
  e.preventDefault();
});
document.addEventListener('mouseup', () => { finishDrag(); isDragging = false; });

// AJAX: Fetch real-time price
document.addEventListener("DOMContentLoaded", () => {
  const coinId = "<?= $coin_id ?>";
  const priceURL = `https://api.coingecko.com/api/v3/simple/price?ids=${encodeURIComponent(coinId)}&vs_currencies=usd`;
  fetch(priceURL)
    .then(res => res.json())
    .then(data => {
      const usd = data[coinId]?.usd || 0;
      if (usd <= 0) throw new Error("Invalid price");
      const totalUSD = <?= $total_usd ?>;
      const feeUSD = <?= $usd_fee ?>;
      const coinAmount = totalUSD / usd;
      const feeCoin = feeUSD / usd;

      document.getElementById('priceDisplay').textContent = usd.toFixed(2);
      document.getElementById('coinAmountDisplay').textContent = `${coinAmount.toFixed(6)} <?= $networkName ?>`;
      document.getElementById('youGetDisplay').textContent = `${coinAmount.toFixed(6)} <?= $networkName ?>`;
      document.getElementById('feeCoinDisplay').textContent = `${feeCoin.toFixed(8)} <?= $networkName ?>`;

      document.getElementById('conversionRateInput').value = usd.toFixed(8);
      document.getElementById('amountCoinInput').value = coinAmount.toFixed(8);
      document.getElementById('feeCoinInput').value = feeCoin.toFixed(8);
    })
    .catch(err => {
      alert("Failed to fetch live price. Please refresh.");
      document.getElementById('priceDisplay').textContent = "Error";
      document.getElementById('coinAmountDisplay').textContent = "Unavailable";
      document.getElementById('youGetDisplay').textContent = "Unavailable";
      document.getElementById('feeCoinDisplay').textContent = "Unavailable";
    });
});
</script>
</body>
</html>