<?php
header('Content-Type: application/json');

// Path to the JSON cache
$copiedTradersCache = __DIR__ . '/cache/copied_traders_cache.json';
$cacheTime = 30 * 24 * 60 * 60; // 30 days

// Read incoming JSON
$inputJSON = file_get_contents('php://input');
$data = json_decode($inputJSON, true);

if (!isset($data['trader_id']) || !isset($data['action'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid payload']);
    exit;
}

$traderId = intval($data['trader_id']);
$action = $data['action'];

// Load existing cache (or initialize)
if (file_exists($copiedTradersCache)) {
    $copiedData = json_decode(file_get_contents($copiedTradersCache), true);
    if (!is_array($copiedData)) {
        $copiedData = [];
    }
} else {
    // Ensure cache directory exists
    if (!file_exists(dirname($copiedTradersCache))) {
        mkdir(dirname($copiedTradersCache), 0777, true);
    }
    $copiedData = [];
}

// Clean expired entries
$currentTime = time();
foreach ($copiedData as $id => $timestamp) {
    if (($currentTime - $timestamp) >= $cacheTime) {
        unset($copiedData[$id]);
    }
}

// Perform action: copy or uncopy
if ($action === 'copy') {
    // Add or update this trader’s timestamp
    $copiedData[$traderId] = time();
} elseif ($action === 'uncopy') {
    // Remove this trader from cache
    if (isset($copiedData[$traderId])) {
        unset($copiedData[$traderId]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Unknown action']);
    exit;
}

// Write back updated cache
file_put_contents($copiedTradersCache, json_encode($copiedData));

echo json_encode(['success' => true]);
