<?php

$host = 'localhost';
$dbname = 'ouxrysgh_dbb';
$username = 'ouxrysgh_userb';
$password = 'zaoix8Q45uD868e2';

// Initialize variables
$traders = [];
$copiedTraders = [];
$error_message = '';

try {
    // Create PDO connection with proper error handling
    $dsn = "mysql:host=$host;dbname=$dbname;charset=utf8mb4";
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];
    
    $pdo = new PDO($dsn, $username, $password, $options);
    
    // Test connection
    $test_query = $pdo->query("SELECT 1");
    if (!$test_query) {
        throw new Exception("Database connection test failed");
    }
    
    // Cache configuration - Only for copied traders status
    $cacheDir = __DIR__ . '/cache';
    $copiedTradersCache = $cacheDir . '/copied_traders_cache.json';
    $cacheTime = 30 * 24 * 60 * 60; // 30 days in seconds
    
    // Create cache directory if it doesn't exist
    if (!file_exists($cacheDir)) {
        mkdir($cacheDir, 0755, true);
    }
    
    // Load copied traders from cache ONLY (not profile data)
    if (file_exists($copiedTradersCache)) {
        $copiedData = json_decode(file_get_contents($copiedTradersCache), true);
        if ($copiedData) {
            $currentTime = time();
            foreach ($copiedData as $traderId => $timestamp) {
                if (($currentTime - $timestamp) < $cacheTime) {
                    $copiedTraders[$traderId] = $timestamp;
                }
            }
            // Update cache with cleaned data (remove expired entries)
            file_put_contents($copiedTradersCache, json_encode($copiedTraders));
        }
    }
    
    // ALWAYS fetch profiles fresh from database (no caching for profiles)
    $sql = "SELECT id, name, image_url, percentage, type, created_at FROM copy_traders ORDER BY percentage DESC";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $traders = $stmt->fetchAll();
    
} catch (PDOException $e) {
    $error_message = "Database connection failed: " . $e->getMessage();
    error_log("Copy Traders DB Error: " . $e->getMessage());
} catch (Exception $e) {
    $error_message = "Error: " . $e->getMessage();
    error_log("Copy Traders Error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bitnovaspro Copy Traders</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert2/11.10.1/sweetalert2.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert2/11.10.1/sweetalert2.min.css">
    <script src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>
    
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .fade-in-up {
            opacity: 0;
            transform: translateY(30px);
            transition: all 0.6s ease;
        }

        .fade-in-up.animate {
            opacity: 1;
            transform: translateY(0);
        }

        .stagger-1 { transition-delay: 0.1s; }
        .stagger-2 { transition-delay: 0.2s; }
        .stagger-3 { transition-delay: 0.3s; }
        .stagger-4 { transition-delay: 0.4s; }

        .card-glow {
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }

        .card-glow:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        }

        .status-badge {
            position: absolute;
            top: 12px;
            right: 12px;
            z-index: 20;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 600;
        }

        .status-active {
            background-color: #10b981;
            color: white;
        }

        .status-inactive {
            background-color: #6b7280;
            color: white;
        }

        .profit-positive {
            background: linear-gradient(135deg, #10b981, #059669);
        }

        .profit-negative {
            background: linear-gradient(135deg, #ef4444, #dc2626);
        }

        .copy-btn {
            background: linear-gradient(135deg, #3b82f6, #1d4ed8);
            position: relative;
            overflow: hidden;
        }

        .copy-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(59, 130, 246, 0.3);
        }

        .copy-btn.copying {
            background: linear-gradient(135deg, #f59e0b, #d97706);
        }

        .copy-btn.copied {
            background: linear-gradient(135deg, #10b981, #059669);
        }

        .copy-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }

        .copy-btn:hover::before {
            left: 100%;
        }

        @media (max-width: 768px) {
            #tradersGrid {
                grid-template-columns: repeat(1, minmax(0,1fr)) !important;
            }
        }
    </style>
</head>

<body class="bg-gray-50">

    <!-- Header Section -->
    <div class="gradient-bg text-white py-16">
        <div class="container mx-auto px-4">
            <div class="text-center">
                <h1 class="text-4xl md:text-6xl font-bold mb-4 fade-in-up">
                    Bitnovaspro Copy Traders
                </h1>
                <p class="text-xl md:text-2xl opacity-90 mb-8 fade-in-up stagger-1">
                    Follow the best performers and copy their strategies
                </p>
               <div class="flex justify-center items-center space-x-4 fade-in-up stagger-2">
    <div class="bg-white/20 backdrop-blur-sm rounded-lg px-6 py-3">
        <span class="text-sm opacity-80">Active Traders:</span>
        <span class="text-xl font-bold ml-2" id="totalTraders">0</span>
    </div>
    <div class="bg-white/20 backdrop-blur-sm rounded-lg px-6 py-3">
        <span class="text-sm opacity-80">Avg. Profit:</span>
        <span class="text-xl font-bold ml-2" id="avgProfit">0%</span>
    </div>
    <a href="dashboard.php" class="bg-white/20 backdrop-blur-sm rounded-lg px-6 py-3 text-white text-sm font-semibold hover:bg-white/30 transition duration-300">
        Go to Dashboard
    </a>
</div>

            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="container mx-auto px-4 py-12">
        <!-- Filter Section -->
        <div class="mb-8 fade-in-up stagger-3">
            <div class="flex flex-wrap gap-4 justify-center">
                <button class="filter-btn bg-blue-500 text-white px-6 py-2 rounded-full hover:bg-blue-600 transition-all" data-filter="all">
                    All Traders
                </button>
                <button class="filter-btn bg-gray-200 text-gray-700 px-6 py-2 rounded-full hover:bg-gray-300 transition-all" data-filter="forex">
                    Forex
                </button>
                <button class="filter-btn bg-gray-200 text-gray-700 px-6 py-2 rounded-full hover:bg-gray-300 transition-all" data-filter="crypto">
                    Crypto
                </button>
                <button class="filter-btn bg-gray-200 text-gray-700 px-6 py-2 rounded-full hover:bg-gray-300 transition-all" data-filter="stocks">
                    Stocks
                </button>
            </div>
        </div>

        <!-- Debug Information (remove in production) -->
        <?php if ($error_message): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                <strong>Debug Info:</strong> <?php echo htmlspecialchars($error_message); ?>
            </div>
        <?php endif; ?>
        
        <?php if (empty($traders) && empty($error_message)): ?>
            <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded mb-6">
                <strong>Info:</strong> No traders found in database. Please check if the 'copy_traders' table exists and has data.
            </div>
        <?php endif; ?>

        <!-- Traders Grid -->
        <div id="tradersGrid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
            <?php
            if (!empty($traders)) {
                foreach ($traders as $index => $trader) {
                    $id = htmlspecialchars($trader['id']);
                    $name = htmlspecialchars($trader['name']);
                    $image_url = htmlspecialchars($trader['image_url']);
                    $percentage = floatval($trader['percentage']);
                    $type = htmlspecialchars($trader['type']);
                    $created_at = htmlspecialchars($trader['created_at']);

                    // Check if trader is already copied (from cache only)
                    $isCopied = isset($copiedTraders[$id]);

                    // Determine profit or loss styles
                    $profitClass = $percentage >= 0 ? 'profit-positive' : 'profit-negative';
                    $profitIcon = $percentage >= 0 ? 'fa-arrow-up' : 'fa-arrow-down';
                    $profitSign = $percentage >= 0 ? '+' : '';

                    // Chart values (clamped to [0, 100])
                    $chartValue = min(max(abs($percentage), 0), 100);
                    $chartColor = $percentage >= 0 ? "#059669" : "#dc2626";

                    // Demo status logic
                    $isActive = rand(0, 1);
                    $statusClass = $isActive ? 'status-active' : 'status-inactive';
                    $statusText = $isActive ? 'Active' : 'Offline';

                    echo "
                    <div class='trader-card bg-white rounded-xl card-glow overflow-hidden fade-in-up stagger-" . ($index % 4 + 1) . "' data-type='" . strtolower($type) . "'>
                        <div class='relative'>
                            <div class='status-badge $statusClass'>$statusText</div>

                            <!-- Profile Image Container with Chart Background -->
                            <div class='h-48 relative overflow-hidden flex items-center justify-center'>
                                <div id='chartContainer-$id' style='position: absolute; inset: 0;'></div>

                                <!-- Trader Image on Top -->
                                <img src='./admin/copy_trader_images/$image_url' alt='$name' 
                                     class='w-20 h-20 rounded-full object-cover border-4 border-white shadow-lg relative z-10'
                                     onerror=\"this.src='https://via.placeholder.com/80x80/4F46E5/FFFFFF?text=" . strtoupper(substr($name, 0, 1)) . "'\">
                            </div>
                        </div>

                        <div class='p-6'>
                            <div class='flex items-center justify-between mb-3'>
                                <h3 class='text-lg font-bold text-gray-800'>$name</h3>
                                <span class='text-xs bg-blue-100 text-blue-800 px-2 py-1 rounded-full font-medium uppercase'>$type</span>
                            </div>

                            <div class='flex items-center justify-between mb-4'>
                                <div class='flex items-center'>
                                    <i class='fas $profitIcon text-white mr-2'></i>
                                    <span class='text-2xl font-bold text-white'>$profitSign" . number_format($percentage, 1) . "%</span>
                                </div>
                                <div class='$profitClass text-white px-3 py-1 rounded-full text-sm font-medium'>
                                    <i class='fas fa-chart-line mr-1'></i>
                                    " . ($percentage >= 0 ? 'Profit' : 'Loss') . "
                                </div>
                            </div>

                            <div class='mb-4'>
                                <div class='flex justify-between text-sm text-gray-600 mb-2'>
                                    <span>Performance</span>
                                    <span>" . abs($percentage) . "%</span>
                                </div>
                                <div class='w-full bg-gray-200 rounded-full h-2'>
                                    <div class='$profitClass h-2 rounded-full' style='width: " . min(abs($percentage), 100) . "%;'></div>
                                </div>
                            </div>

                            <div class='flex items-center justify-between text-sm text-gray-500 mb-4'>
                                <span><i class='fas fa-calendar-alt mr-1'></i> Joined " . date('M Y', strtotime($created_at)) . "</span>
                                <span><i class='fas fa-users mr-1'></i> " . rand(50, 500) . " followers</span>
                            </div>

                            <button class='copy-btn w-full font-bold py-3 px-6 rounded-lg transition-all duration-300 " . ($isCopied ? 'copied bg-green-500 text-white' : 'text-white') . "' 
                                    onclick='handleCopyTrader(this, $id, \"$name\")' 
                                    data-copied='" . ($isCopied ? 'true' : 'false') . "'>
                                <i class='fas " . ($isCopied ? 'fa-check' : 'fa-copy') . " mr-2'></i>
                                <span class='btn-text'>" . ($isCopied ? 'Copied!' : 'Copy Trader') . "</span>
                            </button>
                        </div>
                    </div>

                    <!-- Inline Script to Render CanvasJS Chart for This Card -->
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            var chart$id = new CanvasJS.Chart('chartContainer-$id', {
                                animationEnabled: true,
                                backgroundColor: 'transparent',
                                data: [{
                                    type: 'doughnut',
                                    startAngle: 0,
                                    innerRadius: '70%',
                                    indexLabelFontColor: 'white',
                                    dataPoints: [
                                        { y: $chartValue, color: '$chartColor' },
                                        { y: " . (100 - $chartValue) . ", color: '#e5e5e5' }
                                    ]
                                }]
                            });
                            chart$id.render();
                        });
                    </script>
                    ";
                }
            } else {
                echo "<div class='col-span-full text-center py-12'>
                        <i class='fas fa-chart-line text-6xl text-gray-300 mb-4'></i>
                        <p class='text-xl text-gray-500'>No copy traders found.</p>
                        <p class='text-sm text-gray-400 mt-2'>Please check your database connection and ensure the 'copy_traders' table has data.</p>
                      </div>";
            }
            ?>
        </div>
    </div>

    <!-- Success Modal -->
    <div id="successModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-xl p-8 max-w-md mx-4">
            <div class="text-center">
                <i class="fas fa-check-circle text-green-500 text-5xl mb-4"></i>
                <h3 class="text-xl font-bold mb-2">Successfully Copied!</h3>
                <p class="text-gray-600 mb-4">You are now copying <span id="copiedTraderName" class="font-semibold"></span>'s strategy.</p>
                <button onclick="closeModal()" class="bg-blue-500 text-white px-6 py-2 rounded-lg hover:bg-blue-600 transition-all">
                    Continue Trading
                </button>
            </div>
        </div>
    </div>

    <script>
        // Store copied traders in memory
        let copiedTraders = new Set();

        // Initialize page
        document.addEventListener('DOMContentLoaded', function() {
            updateStats();
            initializeFilters();
            animateCards();
            loadCopiedTraders();
        });

        // Load copied traders from server-side cache
        function loadCopiedTraders() {
            document.querySelectorAll('.copy-btn[data-copied="true"]').forEach(btn => {
                const traderId = btn.getAttribute('onclick').match(/\d+/)[0];
                copiedTraders.add(traderId);
            });
        }

        // Handle copy trader with confirmation
        function handleCopyTrader(button, traderId, traderName) {
            const isCopied = button.dataset.copied === 'true';

            if (isCopied) {
                // Show uncopy confirmation
                Swal.fire({
                    title: 'Uncopy Trader?',
                    text: `Are you sure you want to stop copying ${traderName}?`,
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Uncopy',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        uncopyTrader(button, traderId, traderName);
                    }
                });
            } else {
                // Show copy confirmation
                Swal.fire({
                    title: 'Copy Trader?',
                    text: `Do you want to start copying ${traderName}'s trading strategy?`,
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Copy',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        copyTrader(button, traderId, traderName);
                    }
                });
            }
        }

        // Copy trader function
        function copyTrader(button, traderId, traderName) {
            const btnText = button.querySelector('.btn-text');
            const btnIcon = button.querySelector('i');

            // Show copying state
            button.classList.add('copying');
            btnText.textContent = 'Copying...';
            button.disabled = true;

            // Simulate API call to save copied trader
            setTimeout(() => {
                fetch('copycache.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        trader_id: traderId,
                        action: 'copy'
                    })
                }).then(() => {
                    // Update UI
                    button.classList.remove('copying');
                    button.classList.add('copied');
                    button.dataset.copied = 'true';
                    btnIcon.className = 'fas fa-check mr-2';
                    btnText.textContent = 'Copied!';
                    button.disabled = false;

                    // Add to local set
                    copiedTraders.add(traderId.toString());

                    // Show success message
                    Swal.fire({
                        title: 'Success!',
                        text: `You are now copying ${traderName}'s strategy.`,
                        icon: 'success',
                        timer: 2000,
                        showConfirmButton: false
                    });
                }).catch(() => {
                    // Fallback for demo - just update UI
                    button.classList.remove('copying');
                    button.classList.add('copied');
                    button.dataset.copied = 'true';
                    btnIcon.className = 'fas fa-check mr-2';
                    btnText.textContent = 'Copied!';
                    button.disabled = false;

                    copiedTraders.add(traderId.toString());

                    Swal.fire({
                        title: 'Success!',
                        text: `You are now copying ${traderName}'s strategy.`,
                        icon: 'success',
                        timer: 2000,
                        showConfirmButton: false
                    });
                });

            }, 1500);
        }

        // Uncopy trader function
        function uncopyTrader(button, traderId, traderName) {
            const btnText = button.querySelector('.btn-text');
            const btnIcon = button.querySelector('i');

            // Show uncopying state
            btnText.textContent = 'Uncopying...';
            button.disabled = true;

            // Simulate API call to remove copied trader
            setTimeout(() => {
                fetch('copycache.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        trader_id: traderId,
                        action: 'uncopy'
                    })
                }).then(() => {
                    // Update UI
                    button.classList.remove('copied');
                    button.dataset.copied = 'false';
                    btnIcon.className = 'fas fa-copy mr-2';
                    btnText.textContent = 'Copy Trader';
                    button.disabled = false;

                    // Remove from local set
                    copiedTraders.delete(traderId.toString());

                    // Show success message
                    Swal.fire({
                        title: 'Uncopied!',
                        text: `You have stopped copying ${traderName}.`,
                        icon: 'info',
                        timer: 2000,
                        showConfirmButton: false
                    });
                }).catch(() => {
                    // Fallback for demo - just update UI
                    button.classList.remove('copied');
                    button.dataset.copied = 'false';
                    btnIcon.className = 'fas fa-copy mr-2';
                    btnText.textContent = 'Copy Trader';
                    button.disabled = false;

                    copiedTraders.delete(traderId.toString());

                    Swal.fire({
                        title: 'Uncopied!',
                        text: `You have stopped copying ${traderName}.`,
                        icon: 'info',
                        timer: 2000,
                        showConfirmButton: false
                    });
                });

            }, 1000);
        }

        // Close modal
        function closeModal() {
            document.getElementById('successModal').classList.add('hidden');
        }

        // Filter functionality
        function initializeFilters() {
            const filterBtns = document.querySelectorAll('.filter-btn');
            const traderCards = document.querySelectorAll('.trader-card');

            filterBtns.forEach(btn => {
                btn.addEventListener('click', function() {
                    const filter = this.dataset.filter;

                    // Update active button
                    filterBtns.forEach(b => {
                        b.classList.remove('bg-blue-500', 'text-white');
                        b.classList.add('bg-gray-200', 'text-gray-700');
                    });
                    this.classList.remove('bg-gray-200', 'text-gray-700');
                    this.classList.add('bg-blue-500', 'text-white');

                    // Filter cards
                    traderCards.forEach(card => {
                        if (filter === 'all' || card.dataset.type === filter) {
                            card.style.display = 'block';
                            card.classList.add('fade-in-up');
                        } else {
                            card.style.display = 'none';
                        }
                    });

                    updateStats();
                });
            });
        }

        // Update statistics
        function updateStats() {
            const visibleCards = document.querySelectorAll('.trader-card[style*="display: block"], .trader-card:not([style*="display: none"])');
            const totalTraders = visibleCards.length;

            let totalPercentage = 0;
            visibleCards.forEach(card => {
                const percentageText = card.querySelector('.text-2xl.font-bold').textContent;
                const percentage = parseFloat(percentageText.replace(/[+%]/g, ''));
                totalPercentage += percentage;
            });

            const avgProfit = totalTraders > 0 ? (totalPercentage / totalTraders).toFixed(1) : 0;

            // Animate numbers if elements exist
            if (document.getElementById('totalTraders')) {
                animateNumber('totalTraders', totalTraders);
            }
            if (document.getElementById('avgProfit')) {
                animateNumber('avgProfit', avgProfit + '%');
            }
        }

        // Animate numbers
        function animateNumber(elementId, targetValue) {
            const element = document.getElementById(elementId);
            if (!element) return;

            const isPercentage = targetValue.toString().includes('%');
            const numericValue = parseFloat(targetValue.toString().replace('%', ''));
            const startValue = 0;
            const duration = 1000;
            const startTime = performance.now();

            function update(currentTime) {
                const elapsed = currentTime - startTime;
                const progress = Math.min(elapsed / duration, 1);
                const current = startValue + (numericValue - startValue) * progress;

                element.textContent = Math.round(current) + (isPercentage ? '%' : '');

                if (progress < 1) {
                    requestAnimationFrame(update);
                }
            }

            requestAnimationFrame(update);
        }

        // Animate cards on scroll
        function animateCards() {
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('animate');
                    }
                });
            }, { threshold: 0.1 });

            document.querySelectorAll('.fade-in-up').forEach(card => {
                observer.observe(card);
            });
        }

        // Close modal when clicking outside
        document.getElementById('successModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeModal();
            }
        });
    </script>
</body>
</html>