<?php
// Enable full error reporting (for development only, remove or disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);

if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$balance        = $userDetails['balance'];
$btc            = $userDetails['btc'];
$eth            = $userDetails['eth'];
$usdt           = $userDetails['usdt'];
$xrp            = $userDetails['xrp'];
$message          = $userDetails['message'];
$update_time    = $userDetails['update_time'];
?>

<?php
if (!isset($_SESSION['user_email'])) {
    header("Location: login.php");
    exit();
}
$userEmail = $_SESSION['user_email'];

// Optional: Database connection (if needed)
$servername = "localhost";
$username = "ouxrysgh_userb";
$password = "zaoix8Q45uD868e2";
$dbname = "ouxrysgh_dbb";
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Define cryptocurrencies and their properties
$cryptocurrencies = [
    'bitcoin' => [
        'symbol'   => 'BTC',
        'name'     => 'Bitcoin',
        'network'  => 'Bitcoin',
        'logo'     => 'https://bitnovaspro.com/cryptos/bitcoin.png',
        'explorer' => 'https://www.blockchain.com/explorer/transactions/btc/',
        'wallet'   => ''
    ],
    'ethereum' => [
        'symbol'   => 'ETH',
        'name'     => 'Ethereum',
        'network'  => 'Ethereum',
        'logo'     => 'https://bitnovaspro.com/cryptos/eth.png',
        'explorer' => 'https://etherscan.io/tx/',
        'wallet'   => ''
    ],
    'tether' => [
        'symbol'   => 'USDT',
        'name'     => 'Tether',
        'network'  => 'ERC20',
        'logo'     => 'https://bitnovaspro.com/cryptos/usdt.png',
        'explorer' => 'https://etherscan.io/tx/',
        'wallet'   => ''
    ],
    'usdt-tron' => [
        'symbol'   => 'USDT',
        'name'     => 'Tether (TRC20)',
        'network'  => 'TRC20',
        'logo'     => 'https://bitnovaspro.com/cryptos/usdt.png',
        'explorer' => 'https://tronscan.org/#/transaction/',
        'wallet'   => ''
    ],
    'binancecoin' => [
        'symbol'   => 'BNB',
        'name'     => 'Binance Coin',
        'network'  => 'BEP20',
        'logo'     => 'https://bitnovaspro.com/cryptos/bnb.png',
        'explorer' => 'https://bscscan.com/tx/',
        'wallet'   => ''
    ],
    'ripple' => [
        'symbol'   => 'XRP',
        'name'     => 'XRP',
        'network'  => 'XRP',
        'logo'     => 'https://bitnovaspro.com/cryptos/xrp.png',
        'explorer' => 'https://xrpscan.com/tx/',
        'wallet'   => ''
    ],
    'cardano' => [
        'symbol'   => 'ADA',
        'name'     => 'Cardano',
        'network'  => 'Cardano',
        'logo'     => 'https://bitnovaspro.com/cryptos/ada.png',
        'explorer' => 'https://cardanoscan.io/transaction/',
        'wallet'   => ''
    ],
    'solana' => [
        'symbol'   => 'SOL',
        'name'     => 'Solana',
        'network'  => 'Solana',
        'logo'     => 'https://bitnovaspro.com/cryptos/sol.png',
        'explorer' => 'https://explorer.solana.com/tx/',
        'wallet'   => ''
    ],
    'dogecoin' => [
        'symbol'   => 'DOGE',
        'name'     => 'Dogecoin',
        'network'  => 'Dogecoin',
        'logo'     => 'https://bitnovaspro.com/cryptos/doge.png',
        'explorer' => 'https://dogechain.info/tx/',
        'wallet'   => ''
    ],
    'polkadot' => [
        'symbol'   => 'DOT',
        'name'     => 'Polkadot',
        'network'  => 'Polkadot',
        'logo'     => 'https://bitnovaspro.com/cryptos/pok.png',
        'explorer' => 'https://polkascan.io/polkadot/transaction/',
        'wallet'   => ''
    ],
    'litecoin' => [
        'symbol'   => 'LTC',
        'name'     => 'Litecoin',
        'network'  => 'Litecoin',
        'logo'     => 'https://cryptologos.cc/logos/litecoin-ltc-logo.png?v=040',
        'explorer' => 'https://live.blockcypher.com/ltc/tx/',
        'wallet'   => ''
    ],
    // Additional coins can be added here to reach up to 100 different coins
];

// Handle API rate limits by caching crypto prices using CoinGecko
$cacheFile = 'crypto_prices.json';
$cacheDuration = 300; // 5 minutes
$cryptoPrices = [];
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheDuration) {
    $cryptoPrices = json_decode(file_get_contents($cacheFile), true);
} else {
    $coinIds = implode(',', array_keys($cryptocurrencies));
    $apiUrl = "https://api.coingecko.com/api/v3/simple/price?ids={$coinIds}&vs_currencies=usd";
    $response = @file_get_contents($apiUrl);
    if ($response) {
        $cryptoPrices = json_decode($response, true);
        file_put_contents($cacheFile, $response);
    } else {
        $cryptoPrices = file_exists($cacheFile) ? json_decode(file_get_contents($cacheFile), true) : [];
    }
}

// For demonstration, using static data for 24h changes, market caps, and volumes
$priceChanges = [
    'bitcoin'     => 2.45,
    'ethereum'    => -1.23,
    'tether'      => 0.01,
    'usdt-tron'   => 0.03,
    'binancecoin' => 3.67,
    'ripple'      => -2.15,
    'cardano'     => 5.78,
    'solana'      => 7.92,
    'dogecoin'    => -4.56,
    'polkadot'    => 1.34,
    'litecoin'    => -0.89,
];

$marketCaps = [
    'bitcoin'     => 912000000000,
    'ethereum'    => 456000000000,
    'tether'      => 95000000000,
    'usdt-tron'   => 95000000000,
    'binancecoin' => 82000000000,
    'ripple'      => 63000000000,
    'cardano'     => 41000000000,
    'solana'      => 38000000000,
    'dogecoin'    => 23000000000,
    'polkadot'    => 19000000000,
    'litecoin'    => 8900000000,
];

$volumes = [
    'bitcoin'     => 32000000000,
    'ethereum'    => 18000000000,
    'tether'      => 73000000000,
    'usdt-tron'   => 53000000000,
    'binancecoin' => 2300000000,
    'ripple'      => 1900000000,
    'cardano'     => 1200000000,
    'solana'      => 2800000000,
    'dogecoin'    => 980000000,
    'polkadot'    => 450000000,
    'litecoin'    => 320000000,
];

// Helper function to format large numbers (e.g., market cap)
function formatLargeNumber($num) {
    if ($num >= 1000000000) {
        return '$' . round($num / 1000000000, 2) . 'B';
    } elseif ($num >= 1000000) {
        return '$' . round($num / 1000000, 2) . 'M';
    } else {
        return '$' . number_format($num);
    }
}
?>
</head>
<?php include './includes/header.php'; ?>

<body class="bg-gray-100 min-h-screen pt-16">
  <!-- Header and Navigation Bar -->
  
  
    <?php include './includes/nav.php'; ?>


  <!-- TradingView Ticker Tape Widget -->
  <div class="container mx-auto px-4 py-4">
    <div class="tradingview-widget-container">
      <div class="tradingview-widget-container__widget"></div>
      <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
      {
        "symbols": [
          { "proName": "BINANCE:BTCUSDT", "title": "BTC" },
          { "proName": "BINANCE:ETHUSDT", "title": "ETH" },
          { "proName": "BINANCE:BNBUSDT", "title": "BNB" },
          { "proName": "BINANCE:ADAUSDT", "title": "ADA" },
          { "proName": "BINANCE:XRPUSDT", "title": "XRP" }
        ],
        "colorTheme": "light",
        "isTransparent": false,
        "displayMode": "adaptive",
        "locale": "en"
      }
      </script>
    </div>
  </div>

  <!-- Main Content -->
  <div class="container mx-auto px-4 py-6">
    <!-- Market Overview Section -->

        
        
        
        
<?php
require('db.php'); // Ensure database connection is set up

// Retrieve the user email from session
$user_email = getSessionEmail();

if (!$user_email) {
    echo '<div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded relative" role="alert">
            <strong class="font-bold">Not Logged In</strong>
            <span class="block sm:inline"> Please log in to access your dashboard.</span>
          </div>';
    exit;
}

// Fetch user details (msgstatus, message)
$query = "SELECT msgstatus, message FROM users WHERE email = :email";
$stmt = $conn->prepare($query);
$stmt->bindParam(':email', $user_email, PDO::PARAM_STR);
$stmt->execute();
$user = $stmt->fetch(PDO::FETCH_ASSOC);

$show_modal = false;
$popup_message = '';

if ($user) {
    $msgstatus = strtolower(trim($user['msgstatus'] ?? ''));
    $message = trim($user['message'] ?? '');

    // Show popup only if msgstatus is "yes"
    if ($msgstatus === 'yes') {
        $show_modal = true;
        $popup_message = $message; // Fetching 'message' value from the database
    }
}
?>

<!-- Overlay for Popup -->
<div id="overlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.7); z-index: 999;"></div>

<!-- Popup HTML -->
<div id="popupmain" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: #343a40; width: 350px; padding: 20px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); text-align: center; color: white; z-index: 1000;">
    <div id="popupfo">
        <h1>NOTICE!</h1>
        <p id="popupMessage" style="font-size: 16px !important; margin-left: 20px; margin-right: 20px;">
            <?= htmlspecialchars($popup_message) ?>
        </p>
        <button class="submitId" onclick="closePopup()" style="background: #dc3545; color: white; padding: 10px 20px; border: none; cursor: pointer; margin-top: 20px;">
            OK
        </button>
    </div>
</div>

<!-- JavaScript to show and close the popup -->
<script>
function closePopup() {
    document.getElementById('popupmain').style.display = 'none';
    document.getElementById('overlay').style.display = 'none';
}

// Display the popup if conditions are met
window.onload = function() {
    var showModal = <?php echo json_encode($show_modal); ?>;
    if (showModal) {
        document.getElementById('popupmain').style.display = 'block';
        document.getElementById('overlay').style.display = 'block';
    }
};
</script>

        
      
  <style>
   
   
    h1 {
      text-align: center;
      margin-bottom: 24px;
    }
    /* Neumorphic card container */
    .card {
      background: #e0e5ec;
      border-radius: 16px;
      box-shadow:  8px 8px 16px #a3b1c6,
                  -8px -8px 16px #ffffff;
      padding: 16px;
      margin-bottom: 24px;
      display: flex;
      align-items: center;
    }
    /* Reduce the gap between the icon and the text */
    .card svg {
      margin-right: 4px;
    }
    /* Card content */
    .info {
      flex: 1;
    }
    .title {
      font-size: 20px;
      margin-bottom: 4px;
    }
    .subtitle {
      color: #6B7280;
      font-size: 14px;
    }
    .price {
      font-size: 20px;
      font-weight: bold;
    }
    .change {
      font-size: 14px;
      display: flex;
      align-items: center;
      margin-top: 4px;
    }
    .change svg {
      width: 16px;
      height: 16px;
      margin-right: 4px;
    }
  </style>




 
 
 


    <style>
    
      
       
        
        
        .change {
            display: flex;
            align-items: center;
            font-size: 14px;
        }
        
        .change svg {
            width: 16px;
            height: 16px;
            margin-right: 5px;
        }
        
        .price {
            font-size: 22px;
            font-weight: bold;
        }
        
        .coin-logo {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            object-fit: contain;
        }
        
        .user-holdings {
            position: absolute;
            top: 10px;
            right: 10px;
            font-size: 12px;
            color: #555;
        }
    </style>

    <div class="card-container">
  <?php
// -------------------- Bitcoin --------------------
$btc_cache_file = "btc_price_cache.json";
$cache_duration = 300;

if (file_exists($btc_cache_file) && (time() - filemtime($btc_cache_file)) < $cache_duration) {
    $btc_data = json_decode(file_get_contents($btc_cache_file), true);
} else {
    $btc_api_url = "https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd&include_24hr_change=true";
    $btc_response = @file_get_contents($btc_api_url);
    if ($btc_response !== false) {
        $btc_data = json_decode($btc_response, true);
        if (isset($btc_data['bitcoin']['usd'], $btc_data['bitcoin']['usd_24h_change'])) {
            file_put_contents($btc_cache_file, json_encode($btc_data));
        }
    }
}

$btc_price_usd = isset($btc_data['bitcoin']['usd']) ? (float)$btc_data['bitcoin']['usd'] : 0;
$btc_change    = isset($btc_data['bitcoin']['usd_24h_change']) ? (float)$btc_data['bitcoin']['usd_24h_change'] : 0;
// Assume $btc holds the user’s USD amount invested in Bitcoin; if not defined, default to 0.
$btc_investment = isset($btc) ? (float)$btc : 0;
$btc_amount     = ($btc_price_usd > 0) ? $btc_investment / $btc_price_usd : 0;
$btcValue       = $btc_investment;
?>

<!-- Bitcoin Card -->
<div class="card">
    <img src="https://bitnovaspro.com/cryptos/bitcoin.png" class="coin-logo" alt="Bitcoin Logo">
    <div class="info">
        <div class="title"><b>BTC</b> <span class="subtitle">/ USDT</span></div>
        <div class="change" style="color: <?php echo $btc_change >= 0 ? '#6DD64D' : '#FF4842'; ?>">
            <svg viewBox="5 5 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" <?php echo $btc_change >= 0 ? 'style="transform: rotate(180deg);"' : ''; ?>>
                <path d="M10.869 16.6308C10.811 16.5743 10.563 16.3609 10.359 16.1622C9.076 14.9971 6.976 11.9576 6.335 10.3668C6.232 10.1252 6.014 9.51437 6 9.18802C6 8.8753 6.072 8.5772 6.218 8.29274C6.422 7.93814 6.743 7.65368 7.122 7.49781C7.385 7.39747 8.172 7.2416 8.186 7.2416C9.047 7.08573 10.446 7 11.992 7C13.465 7 14.807 7.08573 15.681 7.21335C15.695 7.22796 16.673 7.38383 17.008 7.55431C17.62 7.86702 18 8.47784 18 9.13151V9.18802C17.985 9.61374 17.605 10.509 17.591 10.509C16.949 12.0141 14.952 14.9834 13.625 16.1768C13.625 16.1768 13.284 16.5129 13.071 16.659C12.765 16.887 12.386 17 12.007 17C11.584 17 11.19 16.8724 10.869 16.6308Z" fill="<?php echo $btc_change >= 0 ? '#6DD64D' : '#FF4842'; ?>"/>
            </svg>
            $<?php echo abs($btc_change * $btc_price_usd / 100); ?> (<?php echo abs($btc_change); ?>%)
        </div>
    </div>
    <div class="price">$<?php echo number_format($btc_price_usd, 2); ?></div>
    <div class="user-holdings">
        You own: <?php echo number_format($btc_amount, 8); ?> BTC<br>
        ($<?php echo number_format($btcValue, 2); ?>)
    </div>
</div>

<?php
// -------------------- Ethereum --------------------
$eth_cache_file = "eth_price_cache.json";
if (file_exists($eth_cache_file) && (time() - filemtime($eth_cache_file)) < $cache_duration) {
    $eth_data = json_decode(file_get_contents($eth_cache_file), true);
} else {
    $eth_api_url = "https://api.coingecko.com/api/v3/simple/price?ids=ethereum&vs_currencies=usd&include_24hr_change=true";
    $eth_response = @file_get_contents($eth_api_url);
    if ($eth_response !== false) {
        $eth_data = json_decode($eth_response, true);
        if (isset($eth_data['ethereum']['usd'], $eth_data['ethereum']['usd_24h_change'])) {
            file_put_contents($eth_cache_file, json_encode($eth_data));
        }
    }
}
$eth_price_usd = isset($eth_data['ethereum']['usd']) ? (float)$eth_data['ethereum']['usd'] : 0;
$eth_change    = isset($eth_data['ethereum']['usd_24h_change']) ? (float)$eth_data['ethereum']['usd_24h_change'] : 0;
$eth_investment = isset($eth) ? (float)$eth : 0;
$eth_amount     = ($eth_price_usd > 0) ? $eth_investment / $eth_price_usd : 0;
$ethValue       = $eth_investment;
?>

<!-- Ethereum Card -->
<div class="card">
    <img src="https://bitnovaspro.com/cryptos/eth.png" class="coin-logo" alt="Ethereum Logo">
    <div class="info">
        <div class="title"><b>ETH</b> <span class="subtitle">/ USDT</span></div>
        <div class="change" style="color: <?php echo $eth_change >= 0 ? '#6DD64D' : '#FF4842'; ?>">
            <svg viewBox="5 5 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" <?php echo $eth_change >= 0 ? 'style="transform: rotate(180deg);"' : ''; ?>>
                <path d="M10.869 16.6308C10.811 16.5743 10.563 16.3609 10.359 16.1622C9.076 14.9971 6.976 11.9576 6.335 10.3668C6.232 10.1252 6.014 9.51437 6 9.18802C6 8.8753 6.072 8.5772 6.218 8.29274C6.422 7.93814 6.743 7.65368 7.122 7.49781C7.385 7.39747 8.172 7.2416 8.186 7.2416C9.047 7.08573 10.446 7 11.992 7C13.465 7 14.807 7.08573 15.681 7.21335C15.695 7.22796 16.673 7.38383 17.008 7.55431C17.62 7.86702 18 8.47784 18 9.13151V9.18802C17.985 9.61374 17.605 10.509 17.591 10.509C16.949 12.0141 14.952 14.9834 13.625 16.1768C13.625 16.1768 13.284 16.5129 13.071 16.659C12.765 16.887 12.386 17 12.007 17C11.584 17 11.19 16.8724 10.869 16.6308Z" fill="<?php echo $eth_change >= 0 ? '#6DD64D' : '#FF4842'; ?>"/>
            </svg>
            $<?php echo abs($eth_change * $eth_price_usd / 100); ?> (<?php echo abs($eth_change); ?>%)
        </div>
    </div>
    <div class="price">$<?php echo number_format($eth_price_usd, 2); ?></div>
    <div class="user-holdings">
        You own: <?php echo number_format($eth_amount, 6); ?> ETH<br>
        ($<?php echo number_format($ethValue, 2); ?>)
    </div>
</div>

<?php
// -------------------- Tether (USDT) --------------------
$usdt_cache_file = "usdt_price_cache.json";
if (file_exists($usdt_cache_file) && (time() - filemtime($usdt_cache_file)) < $cache_duration) {
    $usdt_data = json_decode(file_get_contents($usdt_cache_file), true);
} else {
    $usdt_api_url = "https://api.coingecko.com/api/v3/simple/price?ids=tether&vs_currencies=usd&include_24hr_change=true";
    $usdt_response = @file_get_contents($usdt_api_url);
    if ($usdt_response !== false) {
        $usdt_data = json_decode($usdt_response, true);
        if (isset($usdt_data['tether']['usd'], $usdt_data['tether']['usd_24h_change'])) {
            file_put_contents($usdt_cache_file, json_encode($usdt_data));
        }
    }
}
$usdt_price_usd = isset($usdt_data['tether']['usd']) ? (float)$usdt_data['tether']['usd'] : 1;
$usdt_change    = isset($usdt_data['tether']['usd_24h_change']) ? (float)$usdt_data['tether']['usd_24h_change'] : 0;
$usdt_investment = isset($usdt) ? (float)$usdt : 0;
$usdt_amount     = ($usdt_price_usd > 0) ? $usdt_investment / $usdt_price_usd : 0;
$usdtValue       = $usdt_investment;
?>

<!-- USDT Card -->
<div class="card">
    <img src="https://bitnovaspro.com/cryptos/usdt.png" class="coin-logo" alt="Tether Logo">
    <div class="info">
        <div class="title"><b>USDT</b> <span class="subtitle">/ USDT</span></div>
        <div class="change" style="color: <?php echo $usdt_change >= 0 ? '#6DD64D' : '#FF4842'; ?>">
            <svg viewBox="5 5 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" <?php echo $usdt_change >= 0 ? 'style="transform: rotate(180deg);"' : ''; ?>>
                <path d="M10.869 16.6308C10.811 16.5743 10.563 16.3609 10.359 16.1622C9.076 14.9971 6.976 11.9576 6.335 10.3668C6.232 10.1252 6.014 9.51437 6 9.18802C6 8.8753 6.072 8.5772 6.218 8.29274C6.422 7.93814 6.743 7.65368 7.122 7.49781C7.385 7.39747 8.172 7.2416 8.186 7.2416C9.047 7.08573 10.446 7 11.992 7C13.465 7 14.807 7.08573 15.681 7.21335C15.695 7.22796 16.673 7.38383 17.008 7.55431C17.62 7.86702 18 8.47784 18 9.13151V9.18802C17.985 9.61374 17.605 10.509 17.591 10.509C16.949 12.0141 14.952 14.9834 13.625 16.1768C13.625 16.1768 13.284 16.5129 13.071 16.659C12.765 16.887 12.386 17 12.007 17C11.584 17 11.19 16.8724 10.869 16.6308Z" fill="<?php echo $usdt_change >= 0 ? '#6DD64D' : '#FF4842'; ?>"/>
            </svg>
            $<?php echo abs($usdt_change * $usdt_price_usd / 100); ?> (<?php echo abs($usdt_change); ?>%)
        </div>
    </div>
    <div class="price">$<?php echo number_format($usdt_price_usd, 2); ?></div>
    <div class="user-holdings">
        You own: <?php echo number_format($usdt_amount, 2); ?> USDT<br>
        ($<?php echo number_format($usdtValue, 2); ?>)
    </div>
</div>

<?php
// -------------------- XRP --------------------
$xrp_cache_file = "xrp_price_cache.json";
if (file_exists($xrp_cache_file) && (time() - filemtime($xrp_cache_file)) < $cache_duration) {
    $xrp_data = json_decode(file_get_contents($xrp_cache_file), true);
} else {
    $xrp_api_url = "https://api.coingecko.com/api/v3/simple/price?ids=ripple&vs_currencies=usd&include_24hr_change=true";
    $xrp_response = @file_get_contents($xrp_api_url);
    if ($xrp_response !== false) {
        $xrp_data = json_decode($xrp_response, true);
        if (isset($xrp_data['ripple']['usd'], $xrp_data['ripple']['usd_24h_change'])) {
            file_put_contents($xrp_cache_file, json_encode($xrp_data));
        }
    }
}
$xrp_price_usd = isset($xrp_data['ripple']['usd']) ? (float)$xrp_data['ripple']['usd'] : 0;
$xrp_change    = isset($xrp_data['ripple']['usd_24h_change']) ? (float)$xrp_data['ripple']['usd_24h_change'] : 0;
$xrp_investment = isset($xrp) ? (float)$xrp : 0;
$xrp_amount     = ($xrp_price_usd > 0) ? $xrp_investment / $xrp_price_usd : 0;
$xrpValue       = $xrp_investment;
?>

<!-- XRP Card -->
<div class="card">
    <img src="https://bitnovaspro.com/cryptos/xrp.png" class="coin-logo" alt="XRP Logo">
    <div class="info">
        <div class="title"><b>XRP</b> <span class="subtitle">/ USDT</span></div>
        <div class="change" style="color: <?php echo $xrp_change >= 0 ? '#6DD64D' : '#FF4842'; ?>">
            <svg viewBox="5 5 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" <?php echo $xrp_change >= 0 ? 'style="transform: rotate(180deg);"' : ''; ?>>
                <path d="M10.869 16.6308C10.811 16.5743 10.563 16.3609 10.359 16.1622C9.076 14.9971 6.976 11.9576 6.335 10.3668C6.232 10.1252 6.014 9.51437 6 9.18802C6 8.8753 6.072 8.5772 6.218 8.29274C6.422 7.93814 6.743 7.65368 7.122 7.49781C7.385 7.39747 8.172 7.2416 8.186 7.2416C9.047 7.08573 10.446 7 11.992 7C13.465 7 14.807 7.08573 15.681 7.21335C15.695 7.22796 16.673 7.38383 17.008 7.55431C17.62 7.86702 18 8.47784 18 9.13151V9.18802C17.985 9.61374 17.605 10.509 17.591 10.509C16.949 12.0141 14.952 14.9834 13.625 16.1768C13.625 16.1768 13.284 16.5129 13.071 16.659C12.765 16.887 12.386 17 12.007 17C11.584 17 11.19 16.8724 10.869 16.6308Z" fill="<?php echo $xrp_change >= 0 ? '#6DD64D' : '#FF4842'; ?>"/>
            </svg>
            $<?php echo abs($xrp_change * $xrp_price_usd / 100); ?> (<?php echo abs($xrp_change); ?>%)
        </div>
    </div>
    <div class="price">$<?php echo number_format($xrp_price_usd, 2); ?></div>
    <div class="user-holdings">
        You own: <?php echo number_format($xrp_amount, 2); ?> XRP<br>
        ($<?php echo number_format($xrpValue, 2); ?>)
    </div>
</div>

    <script>
        // Add JavaScript for real-time updates if needed
        document.addEventListener('DOMContentLoaded', function() {
            // Example: Refresh data every 60 seconds
            setInterval(function() {
                location.reload();
            }, 60000);
        });
    </script>

  
        
      <h2 class="text-2xl font-bold mb-4">Market Overview</h2>
      <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
        <!-- Market Cap Widget -->
        <div class="card p-4">
          <div class="flex justify-between items-center">
            <div>
              <h3 class="text-gray-500 text-sm">Total Market Cap</h3>
              <p class="text-2xl font-bold">$2.17T</p>
            </div>
            <div class="bg-green-100 p-2 rounded-lg">
              <span class="text-green-600 font-semibold">+1.2%</span>
            </div>
          </div>
          <div class="mt-2">
            <canvas id="marketCapChart" height="60"></canvas>
          </div>
        </div>
        <!-- 24h Volume Widget -->
        <div class="card p-4">
          <div class="flex justify-between items-center">
            <div>
              <h3 class="text-gray-500 text-sm">24h Volume</h3>
              <p class="text-2xl font-bold">$84.5B</p>
            </div>
            <div class="bg-red-100 p-2 rounded-lg">
              <span class="text-red-600 font-semibold">-3.7%</span>
            </div>
          </div>
          <div class="mt-2">
            <canvas id="volumeChart" height="60"></canvas>
          </div>
        </div>
        <!-- BTC Dominance Widget -->
        <div class="card p-4">
          <div class="flex justify-between items-center">
            <div>
              <h3 class="text-gray-500 text-sm">BTC Dominance</h3>
              <p class="text-2xl font-bold">42.1%</p>
            </div>
            <div class="bg-green-100 p-2 rounded-lg">
              <span class="text-green-600 font-semibold">+0.8%</span>
            </div>
          </div>
          <div class="mt-2">
            <canvas id="btcDominanceChart" height="60"></canvas>
          </div>
        </div>
        <!-- Fear & Greed Index Widget -->
        <div class="card p-4">
          <div class="flex justify-between items-center">
            <div>
              <h3 class="text-gray-500 text-sm">Fear & Greed Index</h3>
              <p class="text-2xl font-bold">54</p>
            </div>
            <div class="bg-yellow-100 p-2 rounded-lg">
              <span class="text-yellow-600 font-semibold">Neutral</span>
            </div>
          </div>
          <div class="mt-2 flex justify-center">
            <div class="w-full h-12 bg-gray-200 rounded-full overflow-hidden">
              <div class="h-full w-1/2 bg-gradient-to-r from-red-500 via-yellow-500 to-green-500 relative">
                <div class="absolute h-full w-2 bg-black opacity-50" style="left: 54%;"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- Additional content can go here -->
  </div>
  
  <!-- Optional JavaScript for mobile menu toggle and header transparency on scroll -->
  <script>
    // Mobile menu toggle
    const menuToggle = document.querySelector('button[aria-controls="mobile-menu"]');
    const mobileMenu = document.getElementById('mobile-menu');

    menuToggle.addEventListener('click', () => {
      const isExpanded = menuToggle.getAttribute('aria-expanded') === 'true';
      menuToggle.setAttribute('aria-expanded', !isExpanded);
      mobileMenu.classList.toggle('hidden');
    });

    // Sticky header with transparent effect on scroll
    window.addEventListener('scroll', () => {
      const header = document.getElementById('main-header');
      if (window.scrollY > 50) {
        header.classList.add('bg-transparent');
        header.classList.remove('bg-white', 'shadow');
      } else {
        header.classList.remove('bg-transparent');
        header.classList.add('bg-white', 'shadow');
      }
    });
  </script>
  
  
<style>
    * {
      box-sizing: border-box;
      font-family: 'Arial', sans-serif;
      margin: 0;
      padding: 0;
    }

    body {
      background-color: #f5f5f5;
      padding: 20px;
    }

    .order-book-container {
      width: 100%;
      margin: 0 auto;
      background-color: white;
      border-radius: 8px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
      overflow: hidden;
      transition: all 0.3s ease;
    }

    .order-book-header {
      padding: 18px 20px;
      font-size: 20px;
      font-weight: 600;
      color: #2c3e50;
      border-bottom: 2px solid #f0f0f0;
      background: linear-gradient(145deg, #ffffff 0%, #f8f9fa 100%);
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .market-selector {
      background: #e8f4ff;
      padding: 6px 12px;
      border-radius: 4px;
      font-size: 14px;
      color: #3498db;
      cursor: pointer;
    }

    .order-book-table {
      width: 100%;
      border-collapse: collapse;
      table-layout: fixed;
    }

    .order-book-table th {
      background-color: #f8f9fa;
      text-align: right;
      padding: 12px 15px;
      font-size: 13px;
      color: #7f8c8d;
      font-weight: 500;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    .order-book-table th:first-child {
      padding-left: 20px;
      text-align: left;
    }

    .order-book-table td {
      padding: 12px 15px;
      text-align: right;
      position: relative;
      font-size: 14px;
      font-family: 'Courier New', monospace;
      font-weight: 500;
      color: #2c3e50;
      transition: background-color 0.2s ease;
    }

    .order-book-table td:first-child {
      padding-left: 20px;
      text-align: left;
    }

    .sell-row:hover td {
      background-color: rgba(231, 76, 60, 0.05);
    }

    .buy-row:hover td {
      background-color: rgba(46, 204, 113, 0.05);
    }

    .sell-row td:first-child {
      color: #e74c3c;
      font-weight: 600;
    }

    .buy-row td:first-child {
      color: #27ae60;
      font-weight: 600;
    }

    .order-depth {
      position: absolute;
      top: 0;
      bottom: 0;
      right: 0;
      z-index: 0;
      transition: width 0.3s ease;
    }

    .sell-depth {
      background: linear-gradient(90deg, rgba(231, 76, 60, 0.08) 0%, rgba(231, 76, 60, 0.15) 100%);
    }

    .buy-depth {
      background: linear-gradient(90deg, rgba(46, 204, 113, 0.08) 0%, rgba(46, 204, 113, 0.15) 100%);
    }

    .order-book-table tr {
      border-bottom: 1px solid #f0f0f0;
      position: relative;
    }

    .order-book-divider {
      background-color: #f8f9fa;
      padding: 14px 20px;
      font-size: 15px;
      display: flex;
      justify-content: space-between;
      border-top: 2px solid #eee;
      border-bottom: 2px solid #eee;
      position: relative;
    }

    .divider-line {
      position: absolute;
      left: 0;
      right: 0;
      height: 1px;
      background: repeating-linear-gradient(90deg, transparent 0 4px, #ddd 4px 8px);
      top: 50%;
      transform: translateY(-50%);
    }

    .last-price {
      font-weight: 700;
      color: #2c3e50;
      background-color: rgba(52, 152, 219, 0.1);
      padding: 6px 12px;
      border-radius: 4px;
    }

    .price-info {
      display: flex;
      gap: 15px;
      align-items: center;
    }

    .price-change {
      padding: 6px 12px;
      border-radius: 4px;
      font-size: 13px;
      font-weight: 600;
      display: inline-flex;
      align-items: center;
      gap: 4px;
    }

    .price-change.negative {
      background-color: rgba(231, 76, 60, 0.15);
      color: #c0392b;
    }

    .price-change.positive {
      background-color: rgba(46, 204, 113, 0.15);
      color: #27ae60;
    }

    .price-change i {
      font-size: 12px;
    }

    .volume-spread {
      position: absolute;
      left: 50%;
      transform: translateX(-50%);
      background: rgba(127, 140, 141, 0.1);
      padding: 4px 8px;
      border-radius: 3px;
      font-size: 12px;
      color: #7f8c8d;
    }

    @media (min-width: 1200px) {
      .order-book-container {
        max-width: 98%;
      }
    }

    @media (max-width: 768px) {
      .order-book-header {
        padding: 15px;
        font-size: 18px;
      }
      
      .market-selector {
        display: none;
      }
      
      .order-book-table th {
        padding: 10px;
      }
      
      .order-book-table td {
        padding: 10px;
      }
    }
</style>

<div class="order-book-container">
  <div class="order-book-header">
    <span>Order Book</span>
    <div class="market-selector">
      BTC/ETH <i class="fas fa-chevron-down"></i>
    </div>
  </div>
  
  <table class="order-book-table">
    <thead>
      <tr>
        <th>Price (BTC)</th>
        <th>Amount (ETH)</th>
        <th>Total (ETH)</th>
      </tr>
    </thead>
    <tbody id="sell-orders">
      <!-- Sell orders populated by JavaScript -->
    </tbody>
  </table>
  
  <div class="order-book-divider">
    <div class="divider-line"></div>
    <span class="last-price">Last Price: <span id="last-price">0.020367</span></span>
    <div class="price-info">
      <span id="usd-price">USD 148.65</span>
      <span id="price-change" class="price-change negative">
        <i class="fas fa-arrow-down"></i>0.51%
      </span>
    </div>
    <div class="volume-spread">
      24h Volume: 1,245.67 BTC
    </div>
  </div>
  
  <table class="order-book-table">
    <tbody id="buy-orders">
      <!-- Buy orders populated by JavaScript -->
    </tbody>
  </table>
</div>

<script>
  // Enhanced sample data with more realistic values
  const generateOrders = (count, basePrice, isSell) => {
    const orders = [];
    for (let i = 0; i < count; i++) {
      const price = basePrice * (1 + (isSell ? 1 : -1) * Math.random() * 0.05);
      const amount = Math.random() * 10 + 1;
      orders.push({
        price: price,
        amount: amount,
        total: price * amount,
        depth: Math.random() * 80 + 20
      });
    }
    return orders.sort((a, b) => isSell ? a.price - b.price : b.price - a.price);
  };

  const sellOrders = generateOrders(15, 0.0205, true);
  const buyOrders = generateOrders(15, 0.0203, false);

  // Advanced number formatting with locale support
  function formatNumber(num, isPrice = true) {
    const options = {
      minimumFractionDigits: isPrice ? 6 : 4,
      maximumFractionDigits: isPrice ? 6 : 4,
      useGrouping: true
    };
    return new Intl.NumberFormat('en-US', options).format(num);
  }

  // Create animated row elements
  function createOrderRow(order, isSell) {
    const row = document.createElement('tr');
    row.className = isSell ? 'sell-row' : 'buy-row';
    row.innerHTML = `
      <td>${formatNumber(order.price)}</td>
      <td>${formatNumber(order.amount, false)}</td>
      <td>${formatNumber(order.total, false)}
        <div class="order-depth ${isSell ? 'sell-depth' : 'buy-depth'}" 
             style="width: ${order.depth}%"></div>
      </td>
    `;
    return row;
  }

  // Initialize order book tables
  function initializeOrderBook() {
    const sellOrdersEl = document.getElementById('sell-orders');
    const buyOrdersEl = document.getElementById('buy-orders');

    sellOrders.forEach(order => {
      sellOrdersEl.appendChild(createOrderRow(order, true));
    });

    buyOrders.forEach(order => {
      buyOrdersEl.appendChild(createOrderRow(order, false));
    });
  }

  // Real-time update simulation with animation
  function simulateMarketUpdates() {
    const updateOrder = (orders, elementId, isSell) => {
      const index = Math.floor(Math.random() * orders.length);
      const order = orders[index];
      
      // Simulate market changes
      order.price *= 1 + (Math.random() * 0.02 - 0.01);
      order.amount *= 1 + (Math.random() * 0.1 - 0.05);
      order.total = order.price * order.amount;
      order.depth = Math.random() * 80 + 20;

      // Animate update
      const row = document.querySelector(`#${elementId} tr:nth-child(${index + 1})`);
      row.style.backgroundColor = isSell ? 'rgba(231, 76, 60, 0.05)' : 'rgba(46, 204, 113, 0.05)';
      setTimeout(() => row.style.backgroundColor = '', 500);

      // Update values
      const cells = row.querySelectorAll('td');
      cells[0].textContent = formatNumber(order.price);
      cells[1].textContent = formatNumber(order.amount, false);
      cells[2].textContent = formatNumber(order.total, false);
      row.querySelector('.order-depth').style.width = `${order.depth}%`;
    };

    setInterval(() => {
      updateOrder(sellOrders, 'sell-orders', true);
      updateOrder(buyOrders, 'buy-orders', false);
    }, 1000);
  }

  // Initialize
  initializeOrderBook();
  simulateMarketUpdates();
</script>



    <!-- Trending Coins Section -->
    <div class="mb-12">
      <h2 class="text-2xl font-bold mb-4">Trending Coins</h2>
      <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
        <?php
        $trendingCoins = ['bitcoin', 'ethereum', 'solana', 'dogecoin'];
        foreach ($trendingCoins as $coinId):
          $coin = $cryptocurrencies[$coinId];
          $price = isset($cryptoPrices[$coinId]['usd']) ? $cryptoPrices[$coinId]['usd'] : 'N/A';
          $formattedPrice = is_numeric($price) ? '$' . number_format($price, 2) : $price;
          $change = isset($priceChanges[$coinId]) ? $priceChanges[$coinId] : 0;
          $changeClass = $change >= 0 ? 'price-up' : 'price-down';
          $changeIcon = $change >= 0 ? 'fa-caret-up' : 'fa-caret-down';
        ?>
        <div class="card p-4" onclick="openCoinModal('<?php echo $coinId; ?>')">
          <div class="flex justify-between items-center mb-3">
            <div class="flex items-center">
              <img src="<?php echo htmlspecialchars($coin['logo']); ?>" alt="<?php echo htmlspecialchars($coin['name']); ?>" class="w-8 h-8 mr-2">
              <div>
                <h3 class="font-bold"><?php echo htmlspecialchars($coin['name']); ?></h3>
                <span class="text-gray-500 text-sm"><?php echo htmlspecialchars($coin['symbol']); ?></span>
              </div>
            </div>
            <div class="<?php echo $changeClass; ?> font-semibold">
              <i class="fas <?php echo $changeIcon; ?>"></i> <?php echo abs($change); ?>%
            </div>
          </div>
          <div class="flex justify-between items-end">
            <p class="text-xl font-bold"><?php echo $formattedPrice; ?></p>
            <div class="mini-chart">
              <canvas id="miniChart-<?php echo $coinId; ?>"></canvas>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
      </div>
    </div>

    <!-- Top Cryptocurrencies Table (up to 100 coins) -->
    <div class="mb-8">
                <h2 class="text-2xl font-bold">Top Cryptocurrencies</h2>

      <div class="flex justify-between items-center mb-4">

        <div class="flex space-x-2">
          <input type="text" placeholder="Search coin..." class="px-3 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
          <select class="px-3 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            <option> Categories</option>
            <option>DeFi</option>
            <option>NFTs</option>
            <option>Layer 1</option>
            <option>Layer 2</option>
          </select>
        </div>
      </div>
      <div class="card overflow-x-auto">
        <table class="w-full">
          <thead class="bg-gray-50">
            <tr>
              <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">#</th>
              <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Coin</th>
              <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Price</th>
              <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">24h Change</th>
              <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Market Cap</th>
              <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Volume (24h)</th>
              <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Chart</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $counter = 1;
            foreach (array_slice($cryptocurrencies, 0, 100) as $coinId => $coin):
              $price = isset($cryptoPrices[$coinId]['usd']) ? $cryptoPrices[$coinId]['usd'] : 'N/A';
              $formattedPrice = is_numeric($price) ? '$' . number_format($price, 2) : $price;
              $change = isset($priceChanges[$coinId]) ? $priceChanges[$coinId] : 0;
              $changeClass = $change >= 0 ? 'price-up' : 'price-down';
              $changeIcon = $change >= 0 ? 'fa-caret-up' : 'fa-caret-down';
              $marketCap = isset($marketCaps[$coinId]) ? formatLargeNumber($marketCaps[$coinId]) : 'N/A';
              $volume = isset($volumes[$coinId]) ? formatLargeNumber($volumes[$coinId]) : 'N/A';
            ?>
            <tr class="table-row-hover" onclick="openCoinModal('<?php echo $coinId; ?>')">
              <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo $counter++; ?></td>
              <td class="px-6 py-4 whitespace-nowrap">
                <div class="flex items-center">
                  <img src="<?php echo htmlspecialchars($coin['logo']); ?>" alt="<?php echo htmlspecialchars($coin['name']); ?>" class="w-6 h-6 mr-2">
                  <div>
                    <div class="font-medium text-gray-900"><?php echo htmlspecialchars($coin['name']); ?></div>
                    <div class="text-sm text-gray-500"><?php echo htmlspecialchars($coin['symbol']); ?></div>
                  </div>
                </div>
              </td>
              <td class="px-6 py-4 whitespace-nowrap text-sm font-medium"><?php echo $formattedPrice; ?></td>
              <td class="px-6 py-4 whitespace-nowrap text-sm">
                <span class="<?php echo $changeClass; ?> font-semibold">
                  <i class="fas <?php echo $changeIcon; ?>"></i> <?php echo abs($change); ?>%
                </span>
              </td>
              <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $marketCap; ?></td>
              <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $volume; ?></td>
              <td class="px-6 py-4 whitespace-nowrap">
                <div class="h-10 w-32">
                  <canvas id="lineChart-<?php echo $coinId; ?>"></canvas>
                </div>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>

    <!-- TradingView Widget Section -->
    <div class="mb-8">
      <h2 class="text-2xl font-bold mb-4">Market Analysis</h2>
      <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
        <!-- BTC/USD TradingView Widget -->
        <div class="card p-4">
          <h3 class="font-bold mb-2">BTC/USD Chart</h3>
          <div class="tradingview-widget">
            <!-- TradingView Widget BEGIN -->
            <div class="tradingview-widget-container">
              <div id="tradingview_btcusd"></div>
              <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
              <script type="text/javascript">
                new TradingView.widget({
                  "autosize": true,
                  "symbol": "BITSTAMP:BTCUSD",
                  "interval": "D",
                  "timezone": "Etc/UTC",
                  "theme": "light",
                  "style": "1",
                  "locale": "en",
                  "toolbar_bg": "#f1f3f6",
                  "enable_publishing": false,
                  "hide_side_toolbar": false,
                  "allow_symbol_change": true,
                  "container_id": "tradingview_btcusd"
                });
              </script>
            </div>
            <!-- TradingView Widget END -->
          </div>
        </div>
        <!-- ETH/USD TradingView Widget -->
        <div class="card p-4">
          <h3 class="font-bold mb-2">ETH/USD Chart</h3>
          <div class="tradingview-widget">
            <!-- TradingView Widget BEGIN -->
            <div class="tradingview-widget-container">
              <div id="tradingview_ethusd"></div>
              <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
              <script type="text/javascript">
                new TradingView.widget({
                  "autosize": true,
                  "symbol": "BITSTAMP:ETHUSD",
                  "interval": "D",
                  "timezone": "Etc/UTC",
                  "theme": "light",
                  "style": "1",
                  "locale": "en",
                  "toolbar_bg": "#f1f3f6",
                  "enable_publishing": false,
                  "hide_side_toolbar": false,
                  "allow_symbol_change": true,
                  "container_id": "tradingview_ethusd"
                });
              </script>
            </div>
            <!-- TradingView Widget END -->
          </div>
        </div>
      </div>
    </div>
  </div>
  
  <!-- Coin Modal Template (Receive Crypto Modal) -->
  <div id="coinModal" class="fixed inset-0 z-50 flex items-center justify-center hidden modal-bg">
    <div class="modal bg-white rounded-xl shadow-2xl">
      <div id="modalContent" class="p-6">
        <div class="flex justify-between items-center mb-4">
          <div class="flex items-center">
            <img id="modalCoinLogo" src="" alt="" class="w-10 h-10 mr-3">
            <div>
              <h2 id="modalCoinName" class="text-2xl font-bold"></h2>
              <span id="modalCoinSymbol" class="text-gray-500"></span>
            </div>
          </div>
          <button onclick="closeCoinModal()" class="text-gray-500 hover:text-gray-800">
            <i class="fas fa-times text-xl"></i>
          </button>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 mb-6">
          <div class="bg-gray-50 p-4 rounded-lg">
            <span class="text-gray-500 text-sm">Price</span>
            <p id="modalCoinPrice" class="text-2xl font-bold"></p>
            <span id="modalCoinChange" class="font-semibold"></span>
          </div>
          <div class="bg-gray-50 p-4 rounded-lg">
            <span class="text-gray-500 text-sm">Market Cap</span>
            <p id="modalMarketCap" class="text-2xl font-bold"></p>
          </div>
          <div class="bg-gray-50 p-4 rounded-lg">
            <span class="text-gray-500 text-sm">Volume (24h)</span>
            <p id="modalVolume" class="text-2xl font-bold"></p>
          </div>
        </div>
        
        <div class="bg-gray-50 p-4 rounded-lg mb-6">
          <h3 class="font-bold mb-2">Price Chart</h3>
          <div class="h-64">
            <canvas id="modalChart"></canvas>
          </div>
        </div>
        
        
      </div>
    </div>
  </div>
  
  
  
  
  
  
  






 <!-- JavaScript to hide the preloader once the DOM is loaded -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // Optionally stop the spinner animation
      var spinner = document.getElementById('spinner');
      if (spinner) {
        spinner.classList.remove('animate-spin');
      }
      
      // Hide the preloader container
      var preloader = document.getElementById('preloader');
      if (preloader) {
        preloader.style.display = 'none';
      }
    });
  </script>

  
  <!-- JavaScript for Dropdowns and Mobile Menu -->
  <script>
    document.addEventListener("DOMContentLoaded", () => {
      /* Desktop Dropdowns */
      const desktopReceiveBtn = document.getElementById('desktop-receive-btn');
      const desktopReceiveMenu = document.getElementById('desktop-receive');
      const desktopSendBtn = document.getElementById('desktop-send-btn');
      const desktopSendMenu = document.getElementById('desktop-send');

      desktopReceiveBtn.addEventListener('click', (e) => {
        e.stopPropagation(); // Prevent click from closing the menu
        desktopReceiveMenu.classList.toggle('hidden');
        // Close the other dropdown if open
        if (!desktopSendMenu.classList.contains('hidden')) {
          desktopSendMenu.classList.add('hidden');
        }
      });

      desktopSendBtn.addEventListener('click', (e) => {
        e.stopPropagation();
        desktopSendMenu.classList.toggle('hidden');
        if (!desktopReceiveMenu.classList.contains('hidden')) {
          desktopReceiveMenu.classList.add('hidden');
        }
      });

      // Close desktop dropdowns if clicking outside
      document.addEventListener('click', () => {
        desktopReceiveMenu.classList.add('hidden');
        desktopSendMenu.classList.add('hidden');
      });

      /* Mobile Menu Toggle */
      const mobileMenuButton = document.getElementById('mobile-menu-button');
      const mobileMenu = document.getElementById('mobile-menu');

      mobileMenuButton.addEventListener('click', (e) => {
        e.stopPropagation();
        mobileMenu.classList.toggle('hidden');
      });

      /* Mobile Dropdowns */
      const mobileReceiveBtn = document.getElementById('mobile-receive-btn');
      const mobileReceiveMenu = document.getElementById('mobile-receive');
      const mobileSendBtn = document.getElementById('mobile-send-btn');
      const mobileSendMenu = document.getElementById('mobile-send');

      mobileReceiveBtn.addEventListener('click', (e) => {
        e.stopPropagation();
        mobileReceiveMenu.classList.toggle('hidden');
        if (!mobileSendMenu.classList.contains('hidden')) {
          mobileSendMenu.classList.add('hidden');
        }
      });

      mobileSendBtn.addEventListener('click', (e) => {
        e.stopPropagation();
        mobileSendMenu.classList.toggle('hidden');
        if (!mobileReceiveMenu.classList.contains('hidden')) {
          mobileReceiveMenu.classList.add('hidden');
        }
      });

      // Close mobile dropdowns if clicking outside
      document.addEventListener('click', () => {
        mobileReceiveMenu.classList.add('hidden');
        mobileSendMenu.classList.add('hidden');
      });
    });
  </script>
  
  
  
  
  <!-- JavaScript Section -->
  <script>
    // Convert PHP arrays to JavaScript objects
    const cryptocurrencies = <?php echo json_encode($cryptocurrencies); ?>;
    const cryptoPrices = <?php echo json_encode($cryptoPrices); ?>;
    const priceChanges = <?php echo json_encode($priceChanges); ?>;
    const marketCaps = <?php echo json_encode($marketCaps); ?>;
    const volumes = <?php echo json_encode($volumes); ?>;
    
    // Function to open the coin modal and populate it with data (Receive Crypto Modal)
    function openCoinModal(coinId) {
      const coin = cryptocurrencies[coinId];
      if (!coin) return;
      
      // Update modal header info
      document.getElementById('modalCoinLogo').src = coin.logo;
      document.getElementById('modalCoinName').innerText = coin.name;
      document.getElementById('modalCoinSymbol').innerText = coin.symbol;
      
      // Price and change
      const price = cryptoPrices[coinId] && cryptoPrices[coinId].usd ? cryptoPrices[coinId].usd : 'N/A';
      const formattedPrice = (typeof price === 'number') ? '$' + price.toFixed(2) : price;
      document.getElementById('modalCoinPrice').innerText = formattedPrice;
      
      const change = priceChanges[coinId] !== undefined ? priceChanges[coinId] : 0;
      const changeElement = document.getElementById('modalCoinChange');
      changeElement.innerText = Math.abs(change) + '%';
      changeElement.className = change >= 0 ? 'price-up font-semibold' : 'price-down font-semibold';
      
      // Market Cap and Volume
      const marketCap = marketCaps[coinId] ? formatLargeNumber(marketCaps[coinId]) : 'N/A';
      document.getElementById('modalMarketCap').innerText = marketCap;
      
      const volume = volumes[coinId] ? formatLargeNumber(volumes[coinId]) : 'N/A';
      document.getElementById('modalVolume').innerText = volume;
      
      // Update Receive Crypto section: Set wallet address as "Contact support for <coin name>"
      const walletText = "Contact support for address " + coin.name;
      document.getElementById('modalWallet').value = walletText;
      document.getElementById('walletQRCode').src = "https://chart.googleapis.com/chart?chs=150x150&cht=qr&chl=" + encodeURIComponent(walletText) + "&choe=UTF-8";
      document.getElementById('receiveCryptoHeading').innerText = 'Receive ' + coin.symbol;
      
      // Initialize the modal chart with dummy data (replace with real data if available)
      initializeModalChart(coinId);
      
      // Show the modal
      document.getElementById('coinModal').classList.remove('hidden');
    }
    
    // Function to close the coin modal
    function closeCoinModal() {
      document.getElementById('coinModal').classList.add('hidden');
    }
    
    // Client-side utility function to format large numbers
    function formatLargeNumber(num) {
      if (num >= 1000000000) {
        return '$' + (num / 1000000000).toFixed(2) + 'B';
      } else if (num >= 1000000) {
        return '$' + (num / 1000000).toFixed(2) + 'M';
      } else {
        return '$' + num.toLocaleString();
      }
    }
    
    // Initialize mini charts for trending coins and line charts in the table
    function initializeMiniCharts() {
      Object.keys(cryptocurrencies).forEach(coinId => {
        // Mini Chart for Trending Coins
        const miniChartCanvas = document.getElementById('miniChart-' + coinId);
        if (miniChartCanvas) {
          new Chart(miniChartCanvas, {
            type: 'line',
            data: {
              labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
              datasets: [{
                data: Array.from({length: 7}, () => Math.random() * 100),
                borderColor: '#10b981',
                fill: false,
                tension: 0.3,
                pointRadius: 0
              }]
            },
            options: {
              responsive: true,
              maintainAspectRatio: false,
              scales: { x: { display: false }, y: { display: false } },
              plugins: { legend: { display: false } }
            }
          });
        }
    
        // Line Chart for Table
        const lineChartCanvas = document.getElementById('lineChart-' + coinId);
        if (lineChartCanvas) {
          new Chart(lineChartCanvas, {
            type: 'line',
            data: {
              labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
              datasets: [{
                data: Array.from({length: 7}, () => Math.random() * 100),
                borderColor: '#881ff9',
                fill: false,
                tension: 0.3,
                pointRadius: 0
              }]
            },
            options: {
              responsive: true,
              maintainAspectRatio: false,
              scales: { x: { display: false }, y: { display: false } },
              plugins: { legend: { display: false } }
            }
          });
        }
      });
    }
    
    // Initialize the modal chart with dummy price history data
    let modalChart;
    function initializeModalChart(coinId) {
      const ctx = document.getElementById('modalChart').getContext('2d');
      const labels = Array.from({length: 30}, (_, i) => 'Day ' + (i + 1));
      const data = {
        labels: labels,
        datasets: [{
          label: cryptocurrencies[coinId].name + ' Price',
          data: Array.from({length: 30}, () => Math.random() * 100),
          borderColor: '#8b63f1',
          fill: false,
          tension: 0.3,
          pointRadius: 2
        }]
      };
      if (modalChart) { modalChart.destroy(); }
      modalChart = new Chart(ctx, {
        type: 'line',
        data: data,
        options: {
          responsive: true,
          maintainAspectRatio: false,
          scales: { x: { display: true }, y: { display: true } },
          plugins: { legend: { display: false } }
        }
      });
    }
    
    // Initialize charts after DOM is loaded
    document.addEventListener('DOMContentLoaded', function() {
      initializeMiniCharts();
    });
    
    // Function to copy wallet address to clipboard
    function copyWalletAddress() {
      var walletInput = document.getElementById('modalWallet');
      walletInput.select();
      walletInput.setSelectionRange(0, 99999); // For mobile devices
      navigator.clipboard.writeText(walletInput.value).then(function() {
          var copyMessage = document.getElementById('copyMessage');
          copyMessage.classList.remove('hidden');
          setTimeout(function() {
              copyMessage.classList.add('hidden');
          }, 2000);
      });
    }
  </script>
  
  
  <?php include './includes/footer.php'; ?>

</body>
</html>
