<?php
include 'action/check-login.php';
session_start();

// Handle AJAX request
if (isset($_POST['ajax']) && $_POST['ajax'] == 'verify_cot') {
    header('Content-Type: application/json');
    
    try {
        // Input validation
        if (empty($_POST['mtccode'])) {
            throw new Exception('Missing required parameters: TOKEN code is required');
        }
        
        $mtccode = trim($_POST['mtccode']);
        
        // Validate MTC code format (should be 4 digits)
        if (!preg_match('/^\d{4}$/', $mtccode)) {
            throw new Exception('Invalid TOKEN code format. Must be 4 digits.');
        }
        
        // Get user email from session
        $user_email = '';
        if (isset($_SESSION['email']) && !empty($_SESSION['email'])) {
            $user_email = $_SESSION['email'];
        } elseif (isset($_SESSION['user_email']) && !empty($_SESSION['user_email'])) {
            $user_email = $_SESSION['user_email'];
        } else {
            throw new Exception('User email not found in session. Please login again.');
        }
        
        // Validate email format
        if (!filter_var($user_email, FILTER_VALIDATE_EMAIL)) {
            throw new Exception('Invalid email format in session');
        }
        
        // Database connection with error handling
        $servername = 'localhost';
        $dbname = 'ouxrysgh_dbb';
        $username = 'ouxrysgh_userb';
        $password = 'zaoix8Q45uD868e2';
        
        // Create connection with mysqli options
        $conn = new mysqli($servername, $username, $password, $dbname);
        
        // Set charset to prevent encoding issues
        $conn->set_charset("utf8");
        
        // Check connection
        if ($conn->connect_error) {
            throw new Exception('Database connection failed: ' . $conn->connect_error);
        }
        
        // Verify that the user exists and the MTC code matches for this specific user
        $stmt = $conn->prepare("SELECT id, email, mtccode FROM users WHERE email = ? AND mtccode = ? LIMIT 1");
        if (!$stmt) {
            throw new Exception('Prepare statement failed: ' . $conn->error);
        }
        
        $stmt->bind_param("ss", $user_email, $mtccode);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result && $result->num_rows > 0) {
            $user_data = $result->fetch_assoc();
            
            // MTC code is correct, update extra column to 'no' and clear mtccode
            $stmt_update = $conn->prepare("UPDATE users SET status = 'inactive', mtccode = NULL WHERE email = ?");
            if (!$stmt_update) {
                throw new Exception('Prepare update statement failed: ' . $conn->error);
            }
            
            $stmt_update->bind_param("s", $user_email);
            
            if ($stmt_update->execute()) {
                // Check if any rows were actually updated
                if ($stmt_update->affected_rows > 0) {
                    echo json_encode([
                        'success' => true, 
                        'message' => 'Token verified successfully! Session Started.',
                        'user_id' => $user_data['id']
                    ]);
                } else {
                    throw new Exception('No user found with the provided email or update failed');
                }
            } else {
                throw new Exception('Error updating user record: ' . $stmt_update->error);
            }
            
            $stmt_update->close();
        } else {
            // MTC code is incorrect or user doesn't exist
            echo json_encode([
                'success' => false, 
                'message' => 'Invalid token.try again.'
            ]);
        }
        
        $stmt->close();
        $conn->close();
        
    } catch (Exception $e) {
        // Log error for debugging (optional)
        error_log("COT Verification Error: " . $e->getMessage());
        
        echo json_encode([
            'success' => false, 
            'message' => 'An error occurred: ' . $e->getMessage()
        ]);
    }
    
    exit;
}

// Check if user is logged in
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] == false) {
    header("Location: logout.php");
    exit;
}

// Include session.php to manage session and database
include '../session.php';

// Ensure the user is logged in; if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$usd_balance    = isset($userDetails['balance']) ? (float)$userDetails['balance'] : 0.00;
$btc            = isset($userDetails['btc']) ? (float)$userDetails['btc'] : 0.000000;
$eth            = isset($userDetails['eth']) ? (float)$userDetails['eth'] : 0.000000;
$usdt           = isset($userDetails['usdt']) ? (float)$userDetails['usdt'] : 0.000000;
$xrp            = isset($userDetails['xrp']) ? (float)$userDetails['xrp'] : 0.000000;
$doge           = isset($userDetails['doge']) ? (float)$userDetails['doge'] : 0.000000;
$ada            = isset($userDetails['ada']) ? (float)$userDetails['ada'] : 0.000000;
$sol            = isset($userDetails['sol']) ? (float)$userDetails['sol'] : 0.000000;
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

// Generate a reset token for security
$reset_token = bin2hex(random_bytes(32));

// Define cache file and cache duration (2 hours)
$cache_file = "sol_price_cache.json";
$cache_duration = 7200; // 2 hours

// Function to fetch SOL price from CoinGecko API using cURL
function fetch_sol_price() {
    $api_url = "https://api.coingecko.com/api/v3/simple/price?ids=solana&vs_currencies=usd";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Only for development
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Timeout after 10 seconds
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Ensure response is valid and HTTP status code is 200 (OK)
    if ($http_code == 200 && $response) {
        return json_decode($response, true);
    }
    return false;
}

// Use cache if valid
if (file_exists($cache_file) && (time() - filemtime($cache_file)) < $cache_duration) {
    $data = json_decode(file_get_contents($cache_file), true);
} else {
    // Fetch fresh SOL price
    $data = fetch_sol_price();

    // Store new price in cache if valid
    if ($data && isset($data['solana']['usd'])) {
        file_put_contents($cache_file, json_encode($data));
    }
}

// Ensure SOL price is available
$sol_price = $data['solana']['usd'] ?? null;

// Function to generate a new MTC code for a user
function generateMTCCode($email, $conn) {
    // Generate a 4-digit random code
    $mtc_code = str_pad(rand(1000, 9999), 4, '0', STR_PAD_LEFT);
    
    // Update the user's MTC code in the database
    $stmt = $conn->prepare("UPDATE users SET mtccode = ? WHERE email = ?");
    if ($stmt) {
        $stmt->bind_param("ss", $mtc_code, $email);
        if ($stmt->execute()) {
            $stmt->close();
            return $mtc_code;
        }
        $stmt->close();
    }
    return false;
}

// Function to verify MTC code and update extra column
function verifyMTCAndUpdateExtra($email, $mtc_code, $conn) {
    // Verify the MTC code for this specific user
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ? AND mtccode = ? LIMIT 1");
    if (!$stmt) {
        return ['success' => false, 'message' => 'Database error'];
    }
    
    $stmt->bind_param("ss", $email, $mtc_code);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        // MTC code is correct, update extra to 'no' and clear mtccode
        $stmt_update = $conn->prepare("UPDATE users SET ststus = 'inactive', mtccode = NULL WHERE email = ?");
        if (!$stmt_update) {
            $stmt->close();
            return ['success' => false, 'message' => 'Database error'];
        }
        
        $stmt_update->bind_param("s", $email);
        
        if ($stmt_update->execute() && $stmt_update->affected_rows > 0) {
            $stmt->close();
            $stmt_update->close();
            return ['success' => true, 'message' => 'TOKEN code verified successfully! Account Session Started.'];
        } else {
            $stmt->close();
            $stmt_update->close();
            return ['success' => false, 'message' => 'Failed to update user record'];
        }
    } else {
        $stmt->close();
        return ['success' => false, 'message' => 'Incorrect TOKEN code. Please check your code and try again.'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Pending Approval - Prime</title>
    <link rel="icon" type="image/png" href="favicon.png">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Anime.js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/3.2.1/anime.min.js"></script>
    
    <!-- Smartsupp Live Chat script -->
    <script type="text/javascript">
    var _smartsupp = _smartsupp || {};
    _smartsupp.key = 'b185b89eff779bf61a239a91251da652ef9b45cb';
    window.smartsupp||(function(d) {
      var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
      s=d.getElementsByTagName('script')[0];c=d.createElement('script');
      c.type='text/javascript';c.charset='utf-8';c.async=true;
      c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
    })(document);
    </script>
    <noscript> Powered by <a href="https://www.smartsupp.com" target="_blank">Smartsupp</a></noscript>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .container {
            background: #f0f2f5;
            border-radius: 30px;
            box-shadow: 
                20px 20px 60px #bebebe,
                -20px -20px 60px #ffffff;
            padding: 40px;
            max-width: 480px;
            width: 100%;
            text-align: center;
            opacity: 0;
            transform: translateY(20px);
        }

        .logo {
            width: 120px;
            height: 60px;
            background: #f0f2f5;
            border-radius: 20px;
            box-shadow: 
                inset 8px 8px 16px #bebebe,
                inset -8px -8px 16px #ffffff;
            margin: 0 auto 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            font-weight: bold;
            color: #667eea;
        }

        .title {
            font-size: 28px;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 10px;
        }

        .subtitle {
            font-size: 16px;
            color: #718096;
            margin-bottom: 30px;
        }

        .status-card {
            background: #f0f2f5;
            border-radius: 20px;
            box-shadow: 
                inset 8px 8px 16px #bebebe,
                inset -8px -8px 16px #ffffff;
            padding: 25px;
            margin-bottom: 30px;
        }

        .status-icon {
            width: 60px;
            height: 60px;
            background: #f0f2f5;
            border-radius: 50%;
            box-shadow: 
                8px 8px 16px #bebebe,
                -8px -8px 16px #ffffff;
            margin: 0 auto 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            color: #f6ad55;
        }

        .status-text {
            font-size: 18px;
            font-weight: 600;
            color: #f6ad55;
            margin-bottom: 10px;
        }

        .user-info {
            background: #f0f2f5;
            border-radius: 15px;
            box-shadow: 
                inset 5px 5px 10px #bebebe,
                inset -5px -5px 10px #ffffff;
            padding: 20px;
            margin-bottom: 30px;
            text-align: left;
        }

        .user-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .user-row:last-child {
            margin-bottom: 0;
        }

        .user-label {
            font-weight: 600;
            color: #4a5568;
            font-size: 14px;
        }

        .user-value {
            font-weight: 500;
            color: #2d3748;
            font-size: 14px;
        }

        .action-buttons {
            display: flex;
            gap: 15px;
            margin-bottom: 30px;
        }

        .btn {
            flex: 1;
            padding: 15px;
            border: none;
            border-radius: 15px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            background: #f0f2f5;
        }

        .btn-primary {
            box-shadow: 
                8px 8px 16px #bebebe,
                -8px -8px 16px #ffffff;
            color: #667eea;
        }

        .btn-primary:hover {
            box-shadow: 
                inset 8px 8px 16px #bebebe,
                inset -8px -8px 16px #ffffff;
        }

        .btn-secondary {
            box-shadow: 
                8px 8px 16px #bebebe,
                -8px -8px 16px #ffffff;
            color: #68d391;
        }

        .btn-secondary:hover {
            box-shadow: 
                inset 8px 8px 16px #bebebe,
                inset -8px -8px 16px #ffffff;
        }

        .token-section {
            display: none;
            margin-top: 30px;
        }

        .token-section.active {
            display: block;
        }

        .token-prompt {
            color: #718096;
            font-size: 16px;
            margin-bottom: 20px;
        }

        .token-inputs {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-bottom: 20px;
        }

        .token-input {
            width: 60px;
            height: 60px;
            border: none;
            border-radius: 15px;
            text-align: center;
            font-size: 24px;
            font-weight: 600;
            color: #2d3748;
            background: #f0f2f5;
            box-shadow: 
                inset 8px 8px 16px #bebebe,
                inset -8px -8px 16px #ffffff;
            outline: none;
            transition: all 0.3s ease;
        }

        .token-input:focus {
            box-shadow: 
                inset 12px 12px 24px #bebebe,
                inset -12px -12px 24px #ffffff;
        }

        .token-hint {
            color: #a0aec0;
            font-size: 14px;
            margin-bottom: 15px;
        }

        .error-message {
            color: #e53e3e;
            font-size: 14px;
            font-weight: 500;
            margin-top: 10px;
            display: none;
        }

        .loading-indicator {
            display: none;
            color: #667eea;
            font-size: 16px;
            margin-top: 20px;
        }

        .spinner {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 2px solid #e2e8f0;
            border-top: 2px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-right: 10px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .logout-btn {
            position: fixed;
            top: 20px;
            right: 20px;
            width: 50px;
            height: 50px;
            border: none;
            border-radius: 50%;
            background: #f0f2f5;
            box-shadow: 
                8px 8px 16px #bebebe,
                -8px -8px 16px #ffffff;
            cursor: pointer;
            transition: all 0.3s ease;
            color: #e53e3e;
            font-size: 18px;
            z-index: 1000;
        }

        .logout-btn:hover {
            box-shadow: 
                inset 8px 8px 16px #bebebe,
                inset -8px -8px 16px #ffffff;
            transform: rotate(90deg);
        }

        /* SweetAlert2 Custom Styles */
        .swal2-confirm-custom {
            background-color: #dc2626 !important;
            color: white !important;
            padding: 8px 16px;
            border-radius: 15px;
            font-weight: 500;
            box-shadow: 
                8px 8px 16px rgba(220, 38, 38, 0.3),
                -8px -8px 16px rgba(255, 255, 255, 0.8);
        }

        .swal2-cancel-custom {
            background-color: #16a34a !important;
            color: white !important;
            padding: 8px 16px;
            border-radius: 15px;
            font-weight: 500;
            margin-left: 8px;
            box-shadow: 
                8px 8px 16px rgba(22, 163, 74, 0.3),
                -8px -8px 16px rgba(255, 255, 255, 0.8);
        }

        /* Enhanced Token Input Styling */
        .suspend-input {
            width: 60px !important;
            height: 60px !important;
            border: 2px solid #d1d5db !important;
            border-radius: 8px !important;
            text-align: center !important;
            font-size: 1.5rem !important;
            font-weight: 600 !important;
            color: #1e293b !important;
            background: #fff !important;
            outline: none !important;
            transition: all 0.3s ease !important;
        }

        .suspend-input:focus {
            border-color: #667eea !important;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1) !important;
        }

        .suspend-input:valid {
            border-color: #10b981 !important;
        }

        @media (max-width: 480px) {
            .container {
                padding: 30px 20px;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .token-inputs {
                gap: 10px;
            }
            
            .token-input, .suspend-input {
                width: 50px !important;
                height: 50px !important;
                font-size: 20px !important;
            }
        }
    </style>
</head>
<body>
    <!-- Logout Button -->
    <button class="logout-btn" onclick="confirmLogout()">
        <i class="fas fa-power-off"></i>
    </button>

    <div class="container" id="mainContainer">
        <!-- Logo -->
        <div class="logo">
<img src="https://bitnovaspro.com/session/logob.png" alt="Bitnovaspro Logo" style="height: 18px;">
  </div>

        <!-- Title -->
        <h1 class="title">Account Pending Approval</h1>
        <p class="subtitle">Your account is currently under review</p>

        <!-- Status Card -->
        <div class="status-card">
            <div class="status-icon">
                <i class="fas fa-clock"></i>
            </div>
            <div class="status-text">Pending Approval</div>
            <p style="color: #718096; font-size: 14px;">Your account is being reviewed by our team</p>
        </div>

        <!-- User Information -->
        <div class="user-info">
            <div class="user-row">
                <span class="user-label">Name:</span>
                <span class="user-value"><?php echo htmlspecialchars($name ?? 'N/A'); ?></span>
            </div>
            <div class="user-row">
                <span class="user-label">Email:</span>
                <span class="user-value"><?php echo htmlspecialchars($email ?? 'N/A'); ?></span>
            </div>
            <div class="user-row">
                <span class="user-label">Status:</span>
                <span class="user-value" style="color: #f6ad55;">Pending</span>
            </div>
            <div class="user-row">
                <span class="user-label">Last Update:</span>
                <span class="user-value"><?php echo date('M d, Y H:i', strtotime($update_time ?? 'now')); ?></span>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="action-buttons">
            <button class="btn btn-primary" onclick="openModal()">
                <i class="fas fa-headset"></i> Contact Support
            </button>
            <button class="btn btn-secondary" onclick="showTokenSection()">
                <i class="fas fa-key"></i> Use Token
            </button>
        </div>

        <!-- Token Section -->
        <div class="token-section" id="tokenSection">
            <div class="token-prompt">Enter your 4-digit token</div>
            
            <!-- COT Submission Form -->
            <form id="cotForm" style="width:100%; max-width:320px; display:flex; flex-direction:column; align-items:center; padding:1rem;">
                <!-- Prompt -->
                <div id="suspendPrompt" style="text-align:center; margin:1rem 0; color:#9ca3af; font-size:0.95rem; opacity:1;">
                    Input a Valid TOKEN
                </div>

                <!-- COT Input Boxes -->
                <div style="width:100%; margin-bottom:1.5rem;">
                    <div style="display:flex; justify-content:center; gap:0.75rem; margin-bottom:0.5rem;">
                        <input class="suspend-input" type="text" maxlength="1" inputmode="numeric" pattern="[0-9]" autocomplete="off">
                        <input class="suspend-input" type="text" maxlength="1" inputmode="numeric" pattern="[0-9]" autocomplete="off">
                        <input class="suspend-input" type="text" maxlength="1" inputmode="numeric" pattern="[0-9]" autocomplete="off">
                        <input class="suspend-input" type="text" maxlength="1" inputmode="numeric" pattern="[0-9]" autocomplete="off">
                    </div>
                    <div style="text-align:center; color:#6b7280; font-size:0.8rem;">
                        Enter your 4-digit Token
                    </div>
                    <div id="errorMessage" style="display:none; text-align:center; color:#dc2626; font-size:0.75rem; margin-top:0.5rem; font-weight:500;"></div>
                </div>

                <!-- Loading indicator -->
                <div id="loadingIndicator" style="display:none; text-align:center; margin-bottom:1rem;">
                    <div style="display:inline-flex; align-items:center; gap:0.5rem; color:#2563eb; font-size:0.9rem;">
                        <svg style="width:20px; height:20px; fill:#2563eb; animation:spin 1s linear infinite;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                            <path d="M12 4V2A10 10 0 0 0 2 12h2a8 8 0 0 1 8-8z"/>
                        </svg>
                        Verifying code...
                    </div>
                </div>
            </form>
        </div>
    </div>

<script>
        // PHP variables for JavaScript
        const resetToken = '<?php echo $reset_token ?? ""; ?>';
        const userEmail = '<?php echo $email ?? ""; ?>';

        document.addEventListener('DOMContentLoaded', function() {
            // Fade in container
            anime({
                targets: '#mainContainer',
                opacity: [0, 1],
                translateY: [20, 0],
                duration: 800,
                easing: 'easeOutQuad'
            });

            // Token input functionality
            const tokenInputs = document.querySelectorAll('.suspend-input');
            
            tokenInputs.forEach((input, index) => {
                input.addEventListener('input', function(e) {
                    const value = e.target.value;
                    
                    // Only allow numbers
                    if (!/^\d$/.test(value)) {
                        e.target.value = '';
                        return;
                    }
                    
                    // Move to next input
                    if (value.length === 1 && index < tokenInputs.length - 1) {
                        tokenInputs[index + 1].focus();
                    }
                    
                    // If all inputs are filled, verify token
                    if (value.length === 1 && index === tokenInputs.length - 1) {
                        const allFilled = Array.from(tokenInputs).every(input => input.value.length === 1);
                        if (allFilled) {
                            setTimeout(() => verifyToken(), 100);
                        }
                    }
                });
                
                input.addEventListener('keydown', function(e) {
                    if (e.key === 'Backspace' && !e.target.value && index > 0) {
                        tokenInputs[index - 1].focus();
                        tokenInputs[index - 1].value = '';
                    }
                });

                // Prevent non-numeric input
                input.addEventListener('keypress', function(e) {
                    if (!/\d/.test(e.key) && !['Backspace', 'Delete', 'Tab', 'Enter'].includes(e.key)) {
                        e.preventDefault();
                    }
                });
            });

            // Add floating animation to status icon
            anime({
                targets: '.status-icon',
                translateY: [0, -10, 0],
                duration: 3000,
                loop: true,
                easing: 'easeInOutQuad'
            });
        });

        function confirmLogout() {
            Swal.fire({
                title: 'Are you sure you want to logout?',
                text: "You will be redirected to the login page.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc2626',
                cancelButtonColor: '#16a34a',
                confirmButtonText: 'Yes, logout',
                cancelButtonText: 'Cancel',
                customClass: {
                    confirmButton: 'swal2-confirm-custom',
                    cancelButton: 'swal2-cancel-custom'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = 'logout.php';
                }
            });
        }

        function openModal() {
            // Trigger Smartsupp chat widget
            if (typeof smartsupp !== 'undefined') {
                smartsupp('chat:open');
            } else {
                Swal.fire({
                    title: 'Contact Support',
                    text: 'Please use the chat widget in the bottom right corner to contact support.',
                    icon: 'info',
                    confirmButtonText: 'OK'
                });
            }
        }

        function showTokenSection() {
            const tokenSection = document.getElementById('tokenSection');
            tokenSection.classList.add('active');
            
            // Animate token section appearance
            anime({
                targets: '#tokenSection',
                opacity: [0, 1],
                translateY: [20, 0],
                duration: 600,
                easing: 'easeOutQuad'
            });
            
            // Focus first input
            setTimeout(() => {
                const firstInput = document.querySelector('.suspend-input');
                if (firstInput) firstInput.focus();
            }, 300);
        }

        function showLoadingSequence() {
            const loadingTexts = [
                'Loading trade...',
                'Activating widgets...',
                'Confirming plan...',
                'Location setup...',
                'Finalizing...'
            ];
            
            let currentTextIndex = 0;
            
            return Swal.fire({
                title: 'Processing...',
                html: `
                    <div style="text-align: center;">
                        <div class="loading-spinner" style="margin: 20px auto;">
                            <div style="width: 50px; height: 50px; border: 4px solid #f3f3f3; border-top: 4px solid #3498db; border-radius: 50%; animation: spin 1s linear infinite; margin: 0 auto;"></div>
                        </div>
                        <div id="loadingText" style="font-size: 16px; color: #666; margin-top: 15px; min-height: 20px;">${loadingTexts[0]}</div>
                    </div>
                    <style>
                        @keyframes spin {
                            0% { transform: rotate(0deg); }
                            100% { transform: rotate(360deg); }
                        }
                        .loading-text-fade {
                            opacity: 0;
                            transition: opacity 0.3s ease;
                        }
                    </style>
                `,
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                willOpen: () => {
                    const loadingTextEl = document.getElementById('loadingText');
                    
                    // Function to update loading text
                    const updateLoadingText = () => {
                        // Fade out current text
                        loadingTextEl.style.opacity = '0';
                        
                        setTimeout(() => {
                            currentTextIndex = (currentTextIndex + 1) % loadingTexts.length;
                            loadingTextEl.textContent = loadingTexts[currentTextIndex];
                            // Fade in new text
                            loadingTextEl.style.opacity = '1';
                        }, 300);
                    };
                    
                    // Change text every 800ms
                    const textInterval = setInterval(updateLoadingText, 800);
                    
                    // Store interval ID to clear it later
                    Swal.getPopup().textInterval = textInterval;
                    
                    // Set transition for smooth fade
                    loadingTextEl.style.transition = 'opacity 0.3s ease';
                }
            });
        }

        function verifyToken() {
            const inputs = document.querySelectorAll('.suspend-input');
            const code = Array.from(inputs).map(input => input.value).join('');
            
            if (code.length !== 4) {
                showError('Please enter a complete 4-digit code');
                return;
            }
            
            // Show loading indicator
            document.getElementById('loadingIndicator').style.display = 'block';
            document.getElementById('errorMessage').style.display = 'none';
            
            // Disable inputs during verification
            inputs.forEach(input => input.disabled = true);
            
            // Send AJAX request
            fetch('', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `ajax=verify_cot&mtccode=${encodeURIComponent(code)}`
            })
            .then(response => response.json())
            .then(data => {
                document.getElementById('loadingIndicator').style.display = 'none';
                inputs.forEach(input => input.disabled = false);
                
                if (data.success) {
                    // Show 4-second loading sequence
                    const loadingAlert = showLoadingSequence();
                    
                    // After 4 seconds, show success alert
                    setTimeout(() => {
                        // Clear the text interval
                        if (Swal.getPopup() && Swal.getPopup().textInterval) {
                            clearInterval(Swal.getPopup().textInterval);
                        }
                        
                        // Close loading alert and show success
                        Swal.close();
                        
                        setTimeout(() => {
                            Swal.fire({
                                title: 'Success!',
                                html: `
                                    <div style="text-align: center;">
                                        <div style="font-size: 18px; margin-bottom: 15px;">${data.message}</div>
                                        <div style="color: #16a34a; font-weight: bold;">
                                            <div>✅ Trade loaded successfully</div>
                                            <div>✅ Widgets activated</div>
                                            <div>✅ Plan confirmed</div>
                                            <div>✅ Location setup complete</div>
                                        </div>
                                    </div>
                                `,
                                icon: 'success',
                                confirmButtonText: 'Continue to Dashboard',
                                confirmButtonColor: '#16a34a',
                                allowOutsideClick: false,
                                customClass: {
                                    confirmButton: 'swal2-confirm-custom'
                                }
                            }).then(() => {
                                // Redirect to dashboard
                                window.location.href = 'dashboard.php';
                            });
                        }, 300);
                    }, 4000); // 4 seconds
                    
                } else {
                    showError(data.message || 'Verification failed. Please try again.');
                    // Clear inputs
                    inputs.forEach(input => input.value = '');
                    inputs[0].focus();
                }
            })
            .catch(error => {
                document.getElementById('loadingIndicator').style.display = 'none';
                inputs.forEach(input => input.disabled = false);
                showError('Network error. Please check your connection and try again.');
                console.error('Error:', error);
            });
        }

        function showError(message) {
            const errorDiv = document.getElementById('errorMessage');
            errorDiv.textContent = message;
            errorDiv.style.display = 'block';
            
            // Shake animation for error
            anime({
                targets: '#cotForm',
                translateX: [0, -10, 10, -10, 10, 0],
                duration: 500,
                easing: 'easeOutQuad'
            });
        }
    </script>
</body>
</html>