<script type="text/javascript">
  function googleTranslateElementInit() {
    new google.translate.TranslateElement({ pageLanguage: 'en' }, 'google_translate_element');
  }

  const countryLangMap = {
    'US': 'en', 'CA': 'en', 'GB': 'en', 'AU': 'en', 'NZ': 'en', 'IE': 'en',
    'FR': 'fr', 'BE': 'nl', 'NL': 'nl', 'DE': 'de', 'AT': 'de', 'CH': 'de',
    'IT': 'it', 'ES': 'es', 'PT': 'pt', 'BR': 'pt', 'MX': 'es', 'AR': 'es',
    'CL': 'es', 'CO': 'es', 'PE': 'es', 'VE': 'es', 'EC': 'es', 'RU': 'ru',
    'PL': 'pl', 'CZ': 'cs', 'SK': 'sk', 'HU': 'hu', 'RO': 'ro', 'BG': 'bg',
    'GR': 'el', 'TR': 'tr', 'IL': 'he', 'SA': 'ar', 'AE': 'ar', 'EG': 'ar',
    'IN': 'hi', 'PK': 'ur', 'BD': 'bn', 'LK': 'si', 'NP': 'ne', 'ID': 'id',
    'MY': 'ms', 'PH': 'fil', 'TH': 'th', 'VN': 'vi', 'KR': 'ko', 'JP': 'ja',
    'CN': 'zh-CN', 'TW': 'zh-TW', 'HK': 'zh-TW', 'SG': 'en', 'FI': 'fi',
    'SE': 'sv', 'NO': 'no', 'DK': 'da', 'IS': 'is', 'EE': 'et', 'LV': 'lv',
    'LT': 'lt'
  };

  function getLanguageFromIP() {
    return fetch('https://ipapi.co/json/')
      .then(response => response.json())
      .then(data => {
        if (data && data.country) {
          return countryLangMap[data.country] || 'en';
        }
        return 'en';
      })
      .catch(error => {
        console.error('Language detection failed:', error);
        return 'en';
      });
  }

  function translatePageTo(language) {
    let attempts = 0;
    const intervalId = setInterval(() => {
      const combo = document.querySelector('.goog-te-combo');
      if (combo) {
        combo.value = language;
        combo.dispatchEvent(new Event('change'));
        clearInterval(intervalId);
      }
      attempts++;
      if (attempts > 20) clearInterval(intervalId);
    }, 500);
  }

  document.addEventListener("DOMContentLoaded", function () {
    getLanguageFromIP().then(function(lang) {
      setTimeout(function() {
        translatePageTo(lang);
      }, 2000);
    });
  });
</script>

<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <!-- Disable pinch zoom and horizontal scaling -->
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, shrink-to-fit=no, viewport-fit=cover">
  
  <title>Bitnovaspro - Wallet</title>
  
  <!-- Meta Tags -->
  <meta name="keywords" content="crypto, stock, forex dashboard, trading, investment">
  <meta name="description" content="Advanced cryptocurrency dashboard with gradient background, Google Translator, live prices, chart, news, and more.">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="theme-color" content="#ffffff"> <!-- White Theme Color -->

  <!-- Optional CSS to prevent horizontal scrolling (reinforcement) -->
  <style>
    html, body {
      max-width: 100%;
      overflow-x: hidden;
      touch-action: manipulation; /* Helps limit zoom and pan gestures */
    }
  </style>



    <!-- Tailwind CSS CDN -->
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2/dist/tailwind.min.css" rel="stylesheet">
  <!-- SweetAlert2 CDN -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <!-- Favicon -->
  <link rel="icon" href="https://bitnovaspro.com/session/faviconb.png" type="image/x-icon">
  
  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  
  <!-- Chart.js -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css"/>
  
  <!-- Google Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
  


  <script>
    // SweetAlert2 Functions
    function getQueryParams() {
        const urlParams = new URLSearchParams(window.location.search);
        return {
            status: urlParams.get("status"),
            message: urlParams.get("message")
        };
    }

    function showSweetAlert(type, msg) {
        let icon = (type === "error") ? "error" : "success";
        Swal.fire({
            toast: true,
            icon: icon,
            title: decodeURIComponent(msg.replace(/\+/g, " ")),
            position: 'top-end',
            showConfirmButton: false,
            timer: 5000,
            background: '#ffffff',
            color: '#000000',
            timerProgressBar: true,
            customClass: {
                popup: 'swal2-toast-custom'
            },
            didOpen: (toast) => {
                toast.classList.add('animate__animated', 'animate__fadeInDown');
            }
        });
    }

    // Professional Forex Trading Progress Functions
    function initTradingProgress() {
        const progressContainer = document.getElementById('progressContainer');
        const percentDisplay = document.getElementById('percentDisplay');
        
        // Initialize with 78% - check if elements exist first
        if (!progressContainer || !percentDisplay) {
            console.warn('Trading progress elements not found');
            return;
        }
        
        let currentPercent = 78;
        let marketSession = 'london'; // london, newyork, tokyo, sydney
        let volatility = 0.3; // Market volatility factor
        let trendDirection = 'bullish'; // bullish, bearish, sideways
        let lastCandlestickColor = 'green';
        
        updateProgress(currentPercent);
        
        // Function to update progress display
        function updateProgress(percent) {
            if (!progressContainer || !percentDisplay) return;
            
            // Clear container
            progressContainer.innerHTML = '';
            
            // Professional forex labels
            if (percent <= 50) {
                percentDisplay.innerHTML = '<span style="font-size: 0.6em;">ENTRY</span><br>' + percent + '%';
            } else {
                percentDisplay.innerHTML = '<span style="font-size: 0.6em;">PROFIT</span><br>' + percent + '%';
            }
            
            // Determine color based on percent (professional colors)
            let color;
            if (percent <= 50) {
                color = '#ef4444'; // Professional red
            } else {
                color = '#22c55e'; // Professional green
            }
            percentDisplay.style.color = color;
            percentDisplay.style.textShadow = `0 0 8px ${color}40`;
            
            // Generate forex candlesticks
            const totalCandlesticks = 25;
            const filledCandlesticks = Math.ceil((percent / 100) * totalCandlesticks);
            
            for (let i = 0; i < totalCandlesticks; i++) {
                const candlestick = document.createElement('div');
                candlestick.style.position = 'relative';
                candlestick.style.width = '6px';
                candlestick.style.display = 'flex';
                candlestick.style.flexDirection = 'column';
                candlestick.style.alignItems = 'center';
                candlestick.style.justifyContent = 'end';
                candlestick.style.animation = 'fadeInUp 0.4s ease-out forwards';
                candlestick.style.opacity = '0';
                
                // Create upper wick (increased height)
                const upperWick = document.createElement('div');
                upperWick.style.width = '1px';
                upperWick.style.marginBottom = '0px';
                const upperWickHeight = 4 + Math.floor(Math.random() * 10); // Increased from 2–8 to 4–14
                upperWick.style.height = upperWickHeight + 'px';
                
                // Create body (increased height)
                const body = document.createElement('div');
                body.style.width = '6px';
                body.style.borderRadius = '1px';
                body.style.transition = 'all 0.3s cubic-bezier(0.4, 0, 0.2, 1)';
                const bodyHeight = 12 + Math.floor(Math.random() * 24); // Increased from 6–16 to 12–36
                body.style.height = bodyHeight + 'px';
                
                // Create lower wick (increased height)
                const lowerWick = document.createElement('div');
                lowerWick.style.width = '1px';
                lowerWick.style.marginTop = '0px';
                const lowerWickHeight = 4 + Math.floor(Math.random() * 10); // Increased from 2–8 to 4–14
                lowerWick.style.height = lowerWickHeight + 'px';
                
                if (i < filledCandlesticks) {
                    // Professional forex color logic
                    const forexPattern = getForexPattern(i, trendDirection, volatility);
                    
                    if (forexPattern.isGreen) {
                        // Professional green (bullish)
                        body.style.background = '#22c55e';
                        body.style.border = '1px solid #16a34a';
                        body.style.boxShadow = '0 0 6px rgba(34, 197, 94, 0.3)';
                        upperWick.style.background = '#22c55e';
                        lowerWick.style.background = '#22c55e';
                    } else {
                        // Professional red (bearish)
                        body.style.background = '#ef4444';
                        body.style.border = '1px solid #dc2626';
                        body.style.boxShadow = '0 0 6px rgba(239, 68, 68, 0.3)';
                        upperWick.style.background = '#ef4444';
                        lowerWick.style.background = '#ef4444';
                    }
                    
                    // Professional staggered animation
                    candlestick.style.animationDelay = (i * 0.03) + 's';
                } else {
                    // Unfilled candlesticks (muted)
                    const isGreen = Math.random() > 0.5;
                    
                    if (isGreen) {
                        body.style.background = '#22c55e';
                        body.style.border = '1px solid #16a34a';
                        body.style.boxShadow = '0 0 3px rgba(34, 197, 94, 0.15)';
                        upperWick.style.background = '#22c55e';
                        lowerWick.style.background = '#22c55e';
                    } else {
                        body.style.background = '#ef4444';
                        body.style.border = '1px solid #dc2626';
                        body.style.boxShadow = '0 0 3px rgba(239, 68, 68, 0.15)';
                        upperWick.style.background = '#ef4444';
                        lowerWick.style.background = '#ef4444';
                    }
                    candlestick.style.opacity = '0.15';
                }
                
                candlestick.appendChild(upperWick);
                candlestick.appendChild(body);
                candlestick.appendChild(lowerWick);
                progressContainer.appendChild(candlestick);
            }
        }
        
        // Professional forex pattern logic
        function getForexPattern(index, trend, vol) {
            const patterns = {
                bullish: [0.7, 0.6, 0.8, 0.5, 0.75, 0.65, 0.8, 0.4, 0.7],
                bearish: [0.3, 0.4, 0.2, 0.5, 0.25, 0.35, 0.2, 0.6, 0.3],
                sideways: [0.5, 0.6, 0.4, 0.5, 0.55, 0.45, 0.5, 0.4, 0.6]
            };
            
            const baseProb = patterns[trend][index % patterns[trend].length];
            const volatilityFactor = (Math.random() - 0.5) * vol;
            const finalProb = Math.max(0.1, Math.min(0.9, baseProb + volatilityFactor));
            
            return {
                isGreen: Math.random() < finalProb,
                strength: finalProb
            };
        }
        
        // Professional forex movement simulation
        let tradingInterval;
        let currentFilledCandlesticks = Math.ceil((currentPercent / 100) * 25);
        let consecutiveDirection = 0;
        let lastMovement = 0;
        
        function professionalForexMove() {
            // Market session influence
            const sessionMultiplier = getSessionMultiplier(marketSession);
            
            // Trend continuation probability
            const trendContinuation = getTrendContinuation(consecutiveDirection);
            
            // Professional movement logic
            let movement;
            const random = Math.random();
            
            if (random < 0.15) {
                movement = 0; // Consolidation (15%)
            } else if (random < 0.15 + trendContinuation) {
                movement = lastMovement; // Continue trend
            } else {
                movement = Math.random() < 0.5 ? -1 : 1; // New direction
            }
            
            // Apply session volatility
            if (Math.random() < sessionMultiplier && movement !== 0) {
                movement *= Math.random() < 0.3 ? 2 : 1; // Occasional double moves
            }
            
            // Update consecutive direction counter
            if (movement === lastMovement && movement !== 0) {
                consecutiveDirection++;
            } else {
                consecutiveDirection = 0;
            }
            lastMovement = movement;
            
            // Apply movement with professional bounds
            const oldValue = currentFilledCandlesticks;
            currentFilledCandlesticks = Math.max(1, Math.min(25, currentFilledCandlesticks + movement));
            
            // Update display and candlesticks
            const newPercent = Math.round((currentFilledCandlesticks / 25) * 100);
            updatePercentageDisplay(newPercent);
            
            if (oldValue !== currentFilledCandlesticks) {
                const isUpward = currentFilledCandlesticks > oldValue;
                updateProfessionalCandlestick(currentFilledCandlesticks - 1, movement, isUpward);
            }
            
            // Randomly change market conditions
            if (Math.random() < 0.05) {
                updateMarketConditions();
            }
        }
        
        function getSessionMultiplier(session) {
            const multipliers = {
                london: 0.8,    // High volatility
                newyork: 0.7,   // High volatility
                tokyo: 0.4,     // Medium volatility
                sydney: 0.2     // Low volatility
            };
            return multipliers[session] || 0.5;
        }
        
        function getTrendContinuation(consecutive) {
            if (consecutive === 0) return 0.4;
            if (consecutive < 3) return 0.6;
            if (consecutive < 5) return 0.3;
            return 0.1; // Strong reversal probability after long trend
        }
        
        function updateMarketConditions() {
            const trends = ['bullish', 'bearish', 'sideways'];
            const sessions = ['london', 'newyork', 'tokyo', 'sydney'];
            
            trendDirection = trends[Math.floor(Math.random() * trends.length)];
            marketSession = sessions[Math.floor(Math.random() * sessions.length)];
            volatility = 0.2 + Math.random() * 0.6;
            
            console.log(`Market Update: ${trendDirection} trend, ${marketSession} session, volatility: ${volatility.toFixed(2)}`);
        }
        
        function updatePercentageDisplay(percent) {
            if (percent <= 50) {
                percentDisplay.innerHTML = '<span style="font-size: 0.6em;">ENTRY</span><br>' + percent + '%';
                percentDisplay.style.color = '#ef4444';
                percentDisplay.style.textShadow = '0 0 8px #ef444440';
            } else {
                percentDisplay.innerHTML = '<span style="font-size: 0.6em;">PROFIT</span><br>' + percent + '%';
                percentDisplay.style.color = '#22c55e';
                percentDisplay.style.textShadow = '0 0 8px #22c55e40';
            }
        }
        
        function updateProfessionalCandlestick(index, movement, isUpward) {
            if (!progressContainer) return;
            
            const candlesticks = progressContainer.children;
            if (index < 0 || index >= candlesticks.length) return;
            
            const candlestick = candlesticks[index];
            const body = candlestick.children[1];
            const upperWick = candlestick.children[0];
            const lowerWick = candlestick.children[2];
            
            const shouldBeFilled = index < currentFilledCandlesticks;
            
            if (shouldBeFilled) {
                // Professional forex colors
                const forexPattern = getForexPattern(index, trendDirection, volatility);
                
                if (forexPattern.isGreen) {
                    body.style.background = '#22c55e';
                    body.style.border = '1px solid #16a34a';
                    body.style.boxShadow = '0 0 8px rgba(34, 197, 94, 0.4)';
                    upperWick.style.background = '#22c55e';
                    lowerWick.style.background = '#22c55e';
                } else {
                    body.style.background = '#ef4444';
                    body.style.border = '1px solid #dc2626';
                    body.style.boxShadow = '0 0 8px rgba(239, 68, 68, 0.4)';
                    upperWick.style.background = '#ef4444';
                    lowerWick.style.background = '#ef4444';
                }
                
                candlestick.style.opacity = '1';
                
                // Professional animation timing
                if (isUpward) {
                    // Fast upward movement
                    candlestick.style.transform = 'scale(1.08) translateY(-3px)';
                    candlestick.style.transition = 'all 0.2s cubic-bezier(0.25, 0.46, 0.45, 0.94)';
                    setTimeout(() => {
                        candlestick.style.transform = 'scale(1) translateY(0)';
                    }, 200);
                } else {
                    // Slower downward movement
                    candlestick.style.transform = 'scale(1.05) translateY(2px)';
                    candlestick.style.transition = 'all 0.4s cubic-bezier(0.55, 0.055, 0.675, 0.19)';
                    setTimeout(() => {
                        candlestick.style.transform = 'scale(1) translateY(0)';
                    }, 400);
                }
                
            } else {
                // Fade out smoothly
                candlestick.style.opacity = '0.15';
                candlestick.style.transform = 'scale(0.98)';
                candlestick.style.transition = 'all 0.3s ease-out';
                
                setTimeout(() => {
                    candlestick.style.transform = 'scale(1)';
                }, 300);
            }
        }
        
        function startProfessionalForexTrading() {
            stopProfessionalForexTrading();
            
            // Variable intervals for realistic forex trading
            function scheduleNextMove() {
                const baseInterval = 600; // Base 600ms
                const sessionMultiplier = getSessionMultiplier(marketSession);
                const volatilityFactor = volatility * 400; // 0-240ms additional
                
                const interval = baseInterval - (sessionMultiplier * 200) + (Math.random() * volatilityFactor);
                
                tradingInterval = setTimeout(() => {
                    professionalForexMove();
                    scheduleNextMove(); // Schedule next move
                }, Math.max(300, interval)); // Minimum 300ms
            }
            
            scheduleNextMove();
        }
        
        function stopProfessionalForexTrading() {
            if (tradingInterval) {
                clearTimeout(tradingInterval);
                tradingInterval = null;
            }
        }
        
        // Auto-start professional forex trading
        setTimeout(() => {
            startProfessionalForexTrading();
        }, 1000);
        
        // Global functions
        window.startProfessionalForexTrading = startProfessionalForexTrading;
        window.stopProfessionalForexTrading = stopProfessionalForexTrading;
        window.updateProgress = updateProgress;
        window.updateMarketConditions = updateMarketConditions;
    }

    // Initialize everything when page loads
    window.addEventListener("DOMContentLoaded", function () {
        // Handle SweetAlert2 first
        const { status, message } = getQueryParams();
        if (status && message) {
            showSweetAlert(status, message);
        }
        
        // Initialize professional forex trading
        setTimeout(initTradingProgress, 300);
    });
</script>

    
  
  <!-- Custom Styles -->
  <style>
    /* Base Styles */
    body {
      font-family: 'Inter', sans-serif;
      background-color: #F2F5FA;
      color: #1F2937;
      overflow-x: hidden;
      margin: 0;
      padding: 0;
    }
    /* Preloader Styles */
    .preloader {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background-color: #F2F5FA;
      display: flex;
      justify-content: center;
      align-items: center;
      z-index: 9999;
    }
    .loader {
      border: 6px solid #E5E7EB;
      border-top: 6px solid #6366F1;
      border-radius: 50%;
      width: 40px;
      height: 40px;
      animation: spin 1s linear infinite;
    }
    @keyframes spin {
      to { transform: rotate(360deg); }
    }
    /* Scrollbar Styles (optional) */
    ::-webkit-scrollbar {
      width: 8px;
    }
    ::-webkit-scrollbar-thumb {
      background-color: #CBD5E1;
      border-radius: 9999px;
    }
    /* Card Styles */
    .card {
      background-color: #FFFFFF;
      border-radius: 16px;
      box-shadow: 0 10px 15px rgba(0, 0, 0, 0.05);
    }
    /* Button Styles */
    .btn-gradient {
      background: linear-gradient(90deg, #4F46E5 0%, #7C3AED 100%);
      color: #FFFFFF;
      box-shadow: 0 4px 6px rgba(124, 58, 237, 0.4);
    }
    .btn-icon {
      background-color: #E0E7FF;
      color: #4F46E5;
    }
    /* Responsive Adjustments */
    @media (max-width: 640px) {
      .nav-item-text {
        display: none;
      }
    }
    /* Neumorphic Styles */
    :root {
      --primary-light: #8abdff;
      --primary: #6d5dfc;
      --primary-dark: #5b0eeb;
      --white: #FFFFFF;
      --greyLight-1: #E4EBF5;
      --greyLight-2: #c8d0e7;
      --greyLight-3: #bec8e4;
      --greyDark: #9baacf;
    }
    @keyframes shimmer {
      0% { background-position: -200% 0; }
      100% { background-position: 200% 0; }
    }
    .neumorphic-card {
      border-radius: 1.6rem;
      padding: 1.5rem;
      margin: 1.2rem 0;
      box-shadow: .3rem .3rem .6rem var(--greyLight-2), 
                 -.2rem -.2rem .5rem var(--white);
      transition: all 0.3s cubic-bezier(0.645, 0.045, 0.355, 1);
      position: relative;
      overflow: hidden;
    }
    .neumorphic-card:hover {
      box-shadow: .4rem .4rem .8rem var(--greyLight-2), 
                 -.4rem -.4rem .8rem var(--white);
      transform: translateY(-0.2rem);
    }
    .shimmer-effect {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, 
          rgba(198,212,245,0) 0%,
          rgba(198,212,245,0.3) 50%,
          rgba(198,212,245,0) 100%);
      animation: shimmer 2.5s infinite;
      z-index: 1;
    }
    .text-green-500 { color: var(--primary); }
    .text-red-500 { color: #EF4444; }
    .font-medium { color: var(--greyDark); }
    .text-gray-500 { color: var(--greyLight-3); }
    .font-semibold { color: var(--greyDark); }
  </style>
  
  
  

<script type="text/javascript">
  // Helper: Traverse the document and return all text nodes (excluding script/style content)
  function getTextNodes() {
    const walker = document.createTreeWalker(document.body, NodeFilter.SHOW_TEXT, {
      acceptNode: function(node) {
        if (node.parentNode && ['SCRIPT', 'STYLE'].indexOf(node.parentNode.nodeName) === -1) {
          if (node.textContent.trim() !== "") {
            return NodeFilter.FILTER_ACCEPT;
          }
        }
        return NodeFilter.FILTER_REJECT;
      }
    });
    const nodes = [];
    while (walker.nextNode()) {
      nodes.push(walker.currentNode);
    }
    return nodes;
  }

  // Function to chunk text to avoid exceeding API limits
  function chunkText(text, maxLength = 500) {
    if (text.length <= maxLength) return [text];
    
    const chunks = [];
    let currentChunk = "";
    
    // Split by sentences or spaces to create more natural breaks
    const sentences = text.split(/(?<=[.!?])\s+/);
    
    for (const sentence of sentences) {
      if ((currentChunk + sentence).length <= maxLength) {
        currentChunk += (currentChunk ? " " : "") + sentence;
      } else {
        if (currentChunk) chunks.push(currentChunk);
        
        // If a single sentence is longer than maxLength, split by words
        if (sentence.length > maxLength) {
          const words = sentence.split(" ");
          currentChunk = "";
          
          for (const word of words) {
            if ((currentChunk + word).length <= maxLength) {
              currentChunk += (currentChunk ? " " : "") + word;
            } else {
              if (currentChunk) chunks.push(currentChunk);
              currentChunk = word;
            }
          }
        } else {
          currentChunk = sentence;
        }
      }
    }
    
    if (currentChunk) chunks.push(currentChunk);
    return chunks;
  }

  // Function to translate text using LibreTranslate API
  async function translateText(text, targetLang) {
    // Skip translation for very short text or numbers
    if (text.length < 2 || !isNaN(text)) {
      return text;
    }
    
    try {
      const chunks = chunkText(text);
      let fullTranslation = "";
      
      for (const chunk of chunks) {
        const response = await fetch('https://libretranslate.com/translate', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json'
          },
          body: JSON.stringify({
            q: chunk,
            source: 'en',
            target: targetLang,
            format: 'text'
          })
        });
        
        const data = await response.json();
        
        if (data && data.translatedText) {
          fullTranslation += (fullTranslation ? " " : "") + data.translatedText;
        } else {
          fullTranslation += (fullTranslation ? " " : "") + chunk; // Fallback to original text
        }
        
        // Add a small delay between API calls to avoid rate limits
        await new Promise(resolve => setTimeout(resolve, 250));
      }
      
      return fullTranslation;
    } catch (error) {
      console.error("Translation error:", error);
      return text; // Fallback to original text if translation fails
    }
  }

  // Function to translate all text nodes on the page
  async function translateAllTextNodes(targetLang) {
    const textNodes = getTextNodes();
    // Process each text node sequentially
    for (const node of textNodes) {
      try {
        const originalText = node.textContent.trim();
        if (originalText.length > 1) {
          const translated = await translateText(originalText, targetLang);
          node.textContent = translated;
        }
      } catch (error) {
        console.error("Error translating a node:", error);
      }
      
      // Add a small delay between nodes to avoid overwhelming translation APIs
      await new Promise(resolve => setTimeout(resolve, 100));
    }
  }

  // Mapping of country codes to their official languages
  const countryLanguageMap = {
    "MX": "es", // Mexico - Spanish
    "CO": "es", // Colombia - Spanish
    "AR": "es", // Argentina - Spanish
    "ES": "es", // Spain - Spanish
    "PE": "es", // Peru - Spanish
    "VE": "es", // Venezuela - Spanish
    "CL": "es", // Chile - Spanish
    "EC": "es", // Ecuador - Spanish
    "GT": "es", // Guatemala - Spanish
    "BO": "es", // Bolivia - Spanish
    "DO": "es", // Dominican Republic - Spanish
    "HN": "es", // Honduras - Spanish
    "PY": "es", // Paraguay - Spanish
    "SV": "es", // El Salvador - Spanish
    "NI": "es", // Nicaragua - Spanish
    "CR": "es", // Costa Rica - Spanish
    "PA": "es", // Panama - Spanish
    "UY": "es", // Uruguay - Spanish
    "CU": "es", // Cuba - Spanish
    "GQ": "es", // Equatorial Guinea - Spanish
    "DE": "de", // Germany - German
    "AT": "de", // Austria - German
    "CH": "de", // Switzerland - German
    "LI": "de", // Liechtenstein - German
    "LU": "de", // Luxembourg - German
    "BE": "de"  // Belgium - German
  };

  // Check geolocation and translate based on country
  async function checkGeolocationAndTranslate() {
    try {
      const response = await fetch('https://ipapi.co/json/');
      const data = await response.json();
      
      if (data && data.country_code) {
        const targetLang = countryLanguageMap[data.country_code];
        if (targetLang) {
          console.log(`User is in ${data.country_name}. Translating page to ${targetLang}...`);
          await translateAllTextNodes(targetLang);
        } else {
          console.log(`No translation available for country code: ${data.country_code}`);
        }
      }
    } catch (error) {
      console.error("Geolocation error:", error);
    }
  }

  // Run the geolocation check once the page loads
  window.addEventListener("load", checkGeolocationAndTranslate);
</script>



 <!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = 'b185b89eff779bf61a239a91251da652ef9b45cb';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>

</head>

