<?php
include 'action/check-login.php';
session_start();
// Handle AJAX request
if (isset($_POST['ajax']) && $_POST['ajax'] == 'verify_cot') {
    header('Content-Type: application/json');
    
    try {
        // Input validation
        if (empty($_POST['mtccode']) || empty($_POST['reset_token'])) {
            throw new Exception('Missing required parameters');
        }
        
        $mtccode = trim($_POST['mtccode']);
        $reset_token = trim($_POST['reset_token']);
        
        // Validate MTC code format (should be 4 digits)
        if (!preg_match('/^\d{4}$/', $mtccode)) {
            throw new Exception('Invalid INSURANCE code format. Must be 4 digits.');
        }
        
        // Get user email from session or other source
        $user_email = '';
        if (isset($_SESSION['email']) && !empty($_SESSION['email'])) {
            $user_email = $_SESSION['email'];
        } elseif (isset($_SESSION['user_email']) && !empty($_SESSION['user_email'])) {
            $user_email = $_SESSION['user_email'];
        } else {
            throw new Exception('User email not found in session. Please login again.');
        }
        
        // Validate email format
        if (!filter_var($user_email, FILTER_VALIDATE_EMAIL)) {
            throw new Exception('Invalid email format in session');
        }
        
        // Database connection with error handling
        $servername = 'localhost';
        $dbname = 'ouxrysgh_dbb';
        $username = 'ouxrysgh_userb';
        $password = 'zaoix8Q45uD868e2';
        
        // Create connection with mysqli options
        $conn = new mysqli($servername, $username, $password, $dbname);
        
        // Set charset to prevent encoding issues
        $conn->set_charset("utf8");
        
        // Check connection
        if ($conn->connect_error) {
            throw new Exception('Database connection failed: ' . $conn->connect_error);
        }
        
        // First, verify that the user exists and the MTC code matches for this specific user
        $stmt = $conn->prepare("SELECT id, email, mtccode FROM users WHERE email = ? AND mtccode = ? LIMIT 1");
        if (!$stmt) {
            throw new Exception('Prepare statement failed: ' . $conn->error);
        }
        
        $stmt->bind_param("ss", $user_email, $mtccode);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result && $result->num_rows > 0) {
            $user_data = $result->fetch_assoc();
            
            // MTC code is valid for this user, now update the reset token
            $stmt_update = $conn->prepare("UPDATE users SET reset_token = ? WHERE email = ?");
            if (!$stmt_update) {
                throw new Exception('Prepare update statement failed: ' . $conn->error);
            }
            
            $stmt_update->bind_param("ss", $reset_token, $user_email);
            
            if ($stmt_update->execute()) {
                // Check if any rows were actually updated
                if ($stmt_update->affected_rows > 0) {
                    // Also clear the MTC code after successful verification (optional security measure)
                    $stmt_clear = $conn->prepare("UPDATE users SET mtccode = NULL WHERE email = ?");
                    if ($stmt_clear) {
                        $stmt_clear->bind_param("s", $user_email);
                        $stmt_clear->execute();
                        $stmt_clear->close();
                    }
                    
                    echo json_encode([
                        'success' => true, 
                        'message' => 'INSURANCE code verified successfully! Account activated.',
                        'user_id' => $user_data['id']
                    ]);
                } else {
                    throw new Exception('No user found with the provided email or update failed');
                }
            } else {
                throw new Exception('Error updating user record: ' . $stmt_update->error);
            }
            
            $stmt_update->close();
        } else {
            // Either user doesn't exist or MTC code doesn't match
            echo json_encode([
                'success' => false, 
                'message' => 'Invalid INSURANCE code for this user. Please verify your code and try again.'
            ]);
        }
        
        $stmt->close();
        $conn->close();
        
    } catch (Exception $e) {
        // Log error for debugging (optional)
        error_log("INSURANCE Verification Error: " . $e->getMessage());
        
        echo json_encode([
            'success' => false, 
            'message' => 'An error occurred: ' . $e->getMessage()
        ]);
    }
    
    exit;
}

// Check if user is logged in
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] == false) {
    header("Location: logout.php");
    exit;
}
?>
<?php
// Enable error reporting (for development only)
// Remove or disable in production

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in; if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$usd_balance    = isset($userDetails['balance']) ? (float)$userDetails['balance'] : 0.00;
$btc            = isset($userDetails['btc']) ? (float)$userDetails['btc'] : 0.000000;
$eth            = isset($userDetails['eth']) ? (float)$userDetails['eth'] : 0.000000;
$usdt           = isset($userDetails['usdt']) ? (float)$userDetails['usdt'] : 0.000000;
$xrp            = isset($userDetails['xrp']) ? (float)$userDetails['xrp'] : 0.000000;
$doge           = isset($userDetails['doge']) ? (float)$userDetails['doge'] : 0.000000;
$ada            = isset($userDetails['ada']) ? (float)$userDetails['ada'] : 0.000000;
$sol            = isset($userDetails['sol']) ? (float)$userDetails['sol'] : 0.000000;
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

// Define cache file and cache duration (2 hours)
$cache_file = "sol_price_cache.json";
$cache_duration = 7200; // 2 hours

// Function to fetch SOL price from CoinGecko API using cURL
function fetch_sol_price() {
    $api_url = "https://api.coingecko.com/api/v3/simple/price?ids=solana&vs_currencies=usd";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Only for development
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Timeout after 10 seconds
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Ensure response is valid and HTTP status code is 200 (OK)
    if ($http_code == 200 && $response) {
        return json_decode($response, true);
    }
    return false;
}

// Use cache if valid
if (file_exists($cache_file) && (time() - filemtime($cache_file)) < $cache_duration) {
    $data = json_decode(file_get_contents($cache_file), true);
} else {
    // Fetch fresh SOL price
    $data = fetch_sol_price();

    // Store new price in cache if valid
    if ($data && isset($data['solana']['usd'])) {
        file_put_contents($cache_file, json_encode($data));
    }
}

// Ensure SOL price is available
$sol_price = $data['solana']['usd'] ?? null;

// Function to generate a new MTC code for a user
function generateMTCCode($email, $conn) {
    // Generate a 4-digit random code
    $mtc_code = str_pad(rand(1000, 9999), 4, '0', STR_PAD_LEFT);
    
    // Update the user's MTC code in the database
    $stmt = $conn->prepare("UPDATE users SET mtccode = ? WHERE email = ?");
    if ($stmt) {
        $stmt->bind_param("ss", $mtc_code, $email);
        if ($stmt->execute()) {
            $stmt->close();
            return $mtc_code;
        }
        $stmt->close();
    }
    return false;
}

// Function to verify MTC code and reset token for a specific user
function verifyMTCAndResetToken($email, $mtc_code, $reset_token, $conn) {
    // Verify the MTC code for this specific user
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ? AND mtccode = ? LIMIT 1");
    if (!$stmt) {
        return ['success' => false, 'message' => 'Database error'];
    }
    
    $stmt->bind_param("ss", $email, $mtc_code);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        // MTC code is valid for this user, update the reset token
        $stmt_update = $conn->prepare("UPDATE users SET reset_token = ?, mtccode = NULL WHERE email = ?");
        if (!$stmt_update) {
            $stmt->close();
            return ['success' => false, 'message' => 'Database error'];
        }
        
        $stmt_update->bind_param("ss", $reset_token, $email);
        
        if ($stmt_update->execute() && $stmt_update->affected_rows > 0) {
            $stmt->close();
            $stmt_update->close();
            return ['success' => true, 'message' => 'MTC code verified and token reset successfully'];
        } else {
            $stmt->close();
            $stmt_update->close();
            return ['success' => false, 'message' => 'Failed to update user record'];
        }
    } else {
        $stmt->close();
        return ['success' => false, 'message' => 'Invalid MTC code for this user'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Login - Prime</title>
  <link rel="icon" type="image/png" href="favicon.png">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- Sweet Alert -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  
  <!-- Animate.js -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/3.2.1/anime.min.js"></script>
  <!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = 'b185b89eff779bf61a239a91251da652ef9b45cb';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>
 <style>
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }
    
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: #e5eaf0;
      color: #333;
      line-height: 1.6;
    }
    
    #mainContainer {
      display: flex;
      flex-direction: row;
      height: 100vh;
      width: 100%;
      flex-wrap: wrap;
      opacity: 0;
    }
    
    .left-section {
      flex: 1 1 500px;
      min-width: 320px;
      background: #fff;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      padding: 2rem;
      position: relative;
    }
    
    .right-section {
      flex: 1 1 500px;
      min-width: 320px;
      background-image: linear-gradient(rgba(37, 99, 235, 0.85), rgba(37, 99, 235, 0.85)), url('https://images.unsplash.com/photo-1589829545856-d10d557cf95f?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1200&q=80');
      color: white;
      display: flex;
      align-items: center;
      justify-content: center;
      flex-direction: column;
      padding: 2rem;
      opacity: 0;
      background-size: cover;
      background-position: center;
    }
    
    .logo {
      height: 50px;
      margin-bottom: 1.5rem;
      opacity: 1;
    }
    
    .title {
      font-size: 1.8rem;
      margin-bottom: 1rem;
      color: white;
      background-color: #2D77FF;
      text-align: center;
      padding: 0.9rem 1.5rem;
      border-radius: 0.6rem;
      opacity: 1;
      font-weight: 600;
    }
    
    .home-btn {
      position: absolute;
      top: 1.5rem;
      left: 1.5rem;
      z-index: 10;
      padding: 0.65rem 1rem;
      border: 1px solid #d1d5db;
      border-radius: 8px;
      background: #f0f9ff;
      cursor: pointer;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 0.5rem;
      font-weight: 600;
      font-size: 0.95rem;
      transition: all 0.3s ease;
      opacity: 0;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
    }
    
    .home-btn:hover {
      background: #e1f0ff;
      transform: translateY(-2px);
    }
    
    .home-btn svg {
      width: 20px;
      height: 20px;
      fill: #3b82f6;
    }
    
    #insureForm {
      width: 100%;
      max-width: 340px;
      display: flex;
      flex-direction: column;
      align-items: center;
      margin-top: 1rem;
    }
    
    .divider {
      text-align: center;
      margin: 1.5rem 0;
      color: #9ca3af;
      opacity: 0;
      font-size: 1.05rem;
    }
    
    .input-container {
      width: 100%;
      margin-bottom: 1.5rem;
      opacity: 0;
    }
    
    .input-row {
      display: flex;
      justify-content: center;
      gap: 0.9rem;
      margin-bottom: 0.8rem;
    }
    
    .insure-input {
      width: 65px;
      height: 65px;
      border: 2px solid #d1d5db;
      border-radius: 10px;
      text-align: center;
      font-size: 1.7rem;
      font-weight: 600;
      color: #1e293b;
      background: #fff;
      outline: none;
      transition: all 0.3s ease;
      box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
    }
    
    .insure-input:focus {
      border-color: #2563eb !important;
      box-shadow: 0 0 0 4px rgba(37, 99, 235, 0.15) !important;
    }
    
    .input-label {
      text-align: center;
      color: #6b7280;
      font-size: 0.95rem;
      margin-top: 0.5rem;
    }
    
    #errorMessage {
      display: none;
      text-align: center;
      color: #dc2626;
      font-size: 0.85rem;
      margin-top: 0.8rem;
      font-weight: 500;
      padding: 0.5rem;
      background: #fef2f2;
      border-radius: 6px;
      width: 100%;
    }
    
    #loadingIndicator {
      display: none;
      text-align: center;
      margin-bottom: 1.5rem;
      opacity: 0;
    }
    
    .loading-content {
      display: inline-flex;
      align-items: center;
      gap: 0.6rem;
      color: #2563eb;
      font-size: 1rem;
      font-weight: 500;
    }
    
    .loading-content svg {
      width: 22px;
      height: 22px;
      fill: #2563eb;
    }
    
    .footer {
      font-size: 0.95rem;
      color: #6b7280;
      opacity: 0;
      text-align: center;
      margin-top: 1rem;
    }
    
    #supportLink {
      color: #2563eb;
      text-decoration: none;
      cursor: pointer;
      font-weight: 500;
      transition: color 0.2s;
    }
    
    #supportLink:hover {
      color: #1d4ed8;
      text-decoration: underline;
    }
    
    /* Animations */
    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }
    
    @keyframes pulse {
      0%, 100% { opacity: 1; }
      50% { opacity: 0.7; }
    }
    
    .processing {
      animation: pulse 1.5s ease-in-out infinite;
    }
    
    .insure-input.filled {
      background: #f0f9ff;
      border-color: #2563eb;
    }
    
    .insure-input.error {
      border-color: #dc2626 !important;
      background: #fef2f2;
      animation: shake 0.5s ease-in-out;
    }
    
    .insure-input.success {
      border-color: #10b981 !important;
      background: #f0fdf4;
    }
    
    @keyframes shake {
      0%, 100% { transform: translateX(0); }
      25% { transform: translateX(-5px); }
      75% { transform: translateX(5px); }
    }
    
    @keyframes fadeInUp {
      0% { 
        opacity: 0;
        transform: translateY(10px);
      }
      100% { 
        opacity: 1;
        transform: translateY(0);
      }
    }
    
    .fade-in-up {
      animation: fadeInUp 0.3s ease-out;
    }
    
    /* Modal styles */
    #modalOverlay {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0,0,0,0.5);
      display: none;
      z-index: 1000;
      opacity: 0;
    }
    
    #modalContent {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%) scale(0.8);
      background: white;
      padding: 2.5rem;
      border-radius: 12px;
      max-width: 450px;
      width: 90%;
      text-align: center;
      box-shadow: 0 15px 35px rgba(0,0,0,0.3);
    }
    
    .modal-icon {
      width: 60px;
      height: 60px;
      fill: #2563eb;
      margin: 0 auto 1.5rem;
    }
    
    .modal-title {
      color: #1e293b;
      margin-bottom: 0.8rem;
      font-size: 1.5rem;
    }
    
    .modal-text {
      color: #6b7280;
      margin-bottom: 1.5rem;
      font-size: 1.05rem;
    }
    
    .info-box {
      background: #f8fafc;
      padding: 1.2rem;
      border-radius: 10px;
      margin-bottom: 1.8rem;
    }
    
    .modal-buttons {
      display: flex;
      gap: 1rem;
      justify-content: center;
    }
    
    .modal-button {
      padding: 0.7rem 1.5rem;
      border-radius: 8px;
      cursor: pointer;
      font-weight: 500;
      font-size: 1rem;
      transition: all 0.2s;
    }
    
    .close-button {
      background: #f3f4f6;
      color: #374151;
      border: none;
    }
    
    .close-button:hover {
      background: #e5e7eb;
    }
    
    .action-button {
      background: #2563eb;
      color: white;
      border: none;
      text-decoration: none;
      display: inline-flex;
      align-items: center;
      justify-content: center;
    }
    
    .action-button:hover {
      background: #1d4ed8;
    }
    
    /* Right section content */
    .right-content {
      text-align: center;
      max-width: 500px;
      padding: 1rem;
    }
    
    .right-title {
      font-size: 1.6rem;
      margin-bottom: 1.2rem;
      font-weight: 600;
    }
    
    .right-text {
      font-size: 1.05rem;
      color: #e0f2ff;
      line-height: 1.7;
      margin-bottom: 1.5rem;
    }
    
    .benefits {
      text-align: left;
      background: rgba(255, 255, 255, 0.15);
      border-radius: 10px;
      padding: 1.2rem;
      margin-top: 1rem;
    }
    
    .benefits li {
      margin-bottom: 0.8rem;
      position: relative;
      padding-left: 1.8rem;
    }
    
    .benefits li:before {
      content: "✓";
      position: absolute;
      left: 0;
      top: 0;
      color: #a7f3d0;
      font-weight: bold;
    }
    
    /* Responsive adjustments */
    @media (max-width: 900px) {
      .right-section {
        min-height: 400px;
      }
      
      .input-row {
        gap: 0.7rem;
      }
      
      .insure-input {
        width: 60px;
        height: 60px;
        font-size: 1.6rem;
      }
    }
    
    @media (max-width: 480px) {
      .left-section, .right-section {
        padding: 1.5rem;
      }
      
      .title {
        font-size: 1.5rem;
        padding: 0.8rem 1.2rem;
      }
      
      .input-row {
        gap: 0.5rem;
      }
      
      .insure-input {
        width: 55px;
        height: 55px;
        font-size: 1.5rem;
      }
      
      .modal-content {
        padding: 1.8rem;
      }
    }
  </style>
</head>
<body style="margin:0; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background-color: #e5eaf0;">

  <div id="mainContainer" style="display:flex; flex-direction:row; height:100vh; width:100%; flex-wrap:wrap; opacity:0;">

    <!-- Left Section -->
    <div style="flex:1 1 500px; min-width:320px; background:#fff; display:flex; flex-direction:column; justify-content:center; align-items:center; padding:2rem;">

      <!-- Logo -->
<!-- Logo with #2D77FF Blue Tint -->
<img 
  src="https://bitnovaspro.com/session/logob.png" 
  alt="Logo"
  style="
    height: 40px;
    margin-bottom: 1rem;
    opacity: 1;
    filter: brightness(0) saturate(100%) invert(31%) sepia(83%) saturate(1485%) hue-rotate(213deg) brightness(101%) contrast(97%);
"
/>

      <!-- Title -->
<h2 style="
  font-size: 1.6rem;
  margin-bottom: 0.5rem;
  color: white;
  background-color: #2D77FF;
  text-align: center;
  padding: 0.75rem 1rem;
  border-radius: 0.5rem;
  opacity: 1;
">
  INSURANCE CODE REQUIRED
</h2>

      <!-- Home Button - Top Left Corner -->
      <div style="position:absolute; top:1.5rem; left:1.5rem; z-index:10;">
     <a href="dashboard.php">   <button class="btn-small home-btn" style="opacity:0; padding:0.5rem 0.75rem; border:1px solid #d1d5db; border-radius:8px; background:#f0f9ff; cursor:pointer; display:flex; align-items:center; justify-content:center; gap:0.4rem; font-weight:600; font-size:0.85rem; transition: all 0.3s ease;">
          <svg style="width:18px; height:18px; fill:#3b82f6;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 3l9 8h-3v8h-4v-5h-4v5H6v-8H3l9-8z"/></svg>
          Home
        </button></a>
      </div>

      <!-- Form for INSURANCE submission -->
      <form id="cotForm" style="width:100%; max-width:320px; display:flex; flex-direction:column; align-items:center;">
        
        <!-- Divider -->
        <div style="text-align:center; margin:1rem 0; color:#9ca3af; opacity:0;">Input a Valid INSURANCE code</div>

        <!-- INSURANCE Code Input Boxes -->
        <div style="width:100%; margin-bottom:1.5rem; opacity:0;">
          <div style="display:flex; justify-content:center; gap:0.75rem; margin-bottom:0.5rem;">
            <input class="cot-input" type="text" maxlength="1" inputmode="numeric" pattern="[0-9]" autocomplete="off" style="width:60px; height:60px; border:2px solid #d1d5db; border-radius:8px; text-align:center; font-size:1.5rem; font-weight:600; color:#1e293b; background:#fff; outline:none; transition: all 0.3s ease;">
            <input class="cot-input" type="text" maxlength="1" inputmode="numeric" pattern="[0-9]" autocomplete="off" style="width:60px; height:60px; border:2px solid #d1d5db; border-radius:8px; text-align:center; font-size:1.5rem; font-weight:600; color:#1e293b; background:#fff; outline:none; transition: all 0.3s ease;">
            <input class="cot-input" type="text" maxlength="1" inputmode="numeric" pattern="[0-9]" autocomplete="off" style="width:60px; height:60px; border:2px solid #d1d5db; border-radius:8px; text-align:center; font-size:1.5rem; font-weight:600; color:#1e293b; background:#fff; outline:none; transition: all 0.3s ease;">
            <input class="cot-input" type="text" maxlength="1" inputmode="numeric" pattern="[0-9]" autocomplete="off" style="width:60px; height:60px; border:2px solid #d1d5db; border-radius:8px; text-align:center; font-size:1.5rem; font-weight:600; color:#1e293b; background:#fff; outline:none; transition: all 0.3s ease;">
          </div>
          <div style="text-align:center; color:#6b7280; font-size:0.8rem;">
            Enter your 4-digit INSURANCE code
          </div>
          <!-- Error message div -->
          <div id="errorMessage" style="display:none; text-align:center; color:#dc2626; font-size:0.75rem; margin-top:0.5rem; font-weight:500;"></div>
        </div>

        <!-- Loading indicator -->
        <div id="loadingIndicator" style="display:none; text-align:center; margin-bottom:1rem; opacity:0;">
          <div style="display:inline-flex; align-items:center; gap:0.5rem; color:#2563eb; font-size:0.9rem;">
            <svg style="width:20px; height:20px; fill:#2563eb; animation:spin 1s linear infinite;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
              <path d="M12 4V2A10 10 0 0 0 2 12h2a8 8 0 0 1 8-8z"/>
            </svg>
            Verifying code...
          </div>
        </div>

      </form>

      <style>
        @keyframes spin {
          0% { transform: rotate(0deg); }
          100% { transform: rotate(360deg); }
        }
        
        @keyframes pulse {
          0%, 100% { opacity: 1; }
          50% { opacity: 0.7; }
        }
        
        .processing {
          animation: pulse 1.5s ease-in-out infinite;
        }
        
        .cot-input:focus {
          border-color: #2563eb !important;
          box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1) !important;
        }
        
        .cot-input.filled {
          background: #f0f9ff;
          border-color: #2563eb;
        }
        
        .cot-input.error {
          border-color: #dc2626 !important;
          background: #fef2f2;
          animation: shake 0.5s ease-in-out;
        }
        
        .cot-input.success {
          border-color: #10b981 !important;
          background: #f0fdf4;
        }
        
        @keyframes shake {
          0%, 100% { transform: translateX(0); }
          25% { transform: translateX(-5px); }
          75% { transform: translateX(5px); }
        }
        
        @keyframes fadeInUp {
          0% { 
            opacity: 0;
            transform: translateY(10px);
          }
          100% { 
            opacity: 1;
            transform: translateY(0);
          }
        }
        
        .fade-in-up {
          animation: fadeInUp 0.3s ease-out;
        }
      </style>

      <!-- Footer -->
      <div style="font-size:0.85rem; color:#6b7280; opacity:0;">
        Don't have a INSURANCE? 
        <a href="#" id="supportLink" style="color:#2563eb; text-decoration:underline; cursor:pointer;">Contact Support</a>
      </div>
    </div>

    <!-- Right Section -->
  <!-- Right Section -->
    <div class="right-section">
      <div class="right-content">
        <h3 class="right-title">Insurance Protection (INSURE)</h3>
        <p class="right-text">
          This insurance fee protects your transaction against losses, fraud, or processing errors. It ensures your transfer is covered and traceable under secure transaction policies.
        </p>
        <div class="benefits">
          <ul>
            <li>Full financial protection for your transaction</li>
            <li>Guaranteed fraud prevention measures</li>
            <li>24/7 transaction monitoring</li>
            <li>Immediate issue resolution</li>
            <li>Secure and encrypted processing</li>
          </ul>
        </div>
      </div>
    </div>
  </div>


  </div>

  <!-- Modal -->
  <div id="modalOverlay" style="position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); display:none; z-index:1000; opacity:0;">
    <div id="modalContent" style="position:absolute; top:50%; left:50%; transform:translate(-50%, -50%) scale(0.8); background:white; padding:2rem; border-radius:12px; max-width:400px; width:90%; text-align:center; box-shadow:0 10px 30px rgba(0,0,0,0.3);">
      <div style="margin-bottom:1.5rem;">
        <svg style="width:48px; height:48px; fill:#2563eb; margin:0 auto 1rem;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
          <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
        </svg>
        <h3 style="color:#1e293b; margin-bottom:0.5rem;">Need Your INSURANCE Code?</h3>
        <p style="color:#6b7280; margin-bottom:1.5rem;">Contact our support team to get your INSURANCE code.</p>
      </div>
      
      <div style="background:#f8fafc; padding:1rem; border-radius:8px; margin-bottom:1.5rem;">
        <p style="margin:0; color:#1e293b; font-weight:600;">Support Email:</p>
        <a href="mailto:support@bitnovaspro.com" style="color:#2563eb; text-decoration:none; font-weight:500;">support@bitnovaspro.com</a>
      </div>
      
      <div style="display:flex; gap:0.75rem; justify-content:center;">
        <button id="closeModal" style="background:#f3f4f6; color:#374151; border:none; padding:0.5rem 1rem; border-radius:6px; cursor:pointer; font-weight:500;">
          Close
        </button>
        <a href="mailto:support@bitnovaspro.com" style="background:#2563eb; color:white; border:none; padding:0.5rem 1rem; border-radius:6px; cursor:pointer; font-weight:500; text-decoration:none; display:inline-block;">
          Send Email
        </a>
      </div>
    </div>
  </div>

  
  <script>
      let isVerifying = false;
let verificationTimeout;

window.onload = () => {
  // Fade in container
  anime({
    targets: '#mainContainer',
    opacity: [0, 1],
    duration: 800,
    easing: 'easeOutQuad'
  });

  // Stagger in all children with enhanced timing
  anime.timeline({ easing: 'easeOutQuad' })
    .add({
      targets: '#mainContainer img',
      opacity: [0, 1],
      translateY: [-30, 0],
      scale: [0.8, 1],
      duration: 600,
      delay: 300
    })
    .add({
      targets: '#mainContainer h2',
      opacity: [0, 1],
      translateY: [20, 0],
      duration: 500,
      delay: 100
    })
    .add({
      targets: '#mainContainer .home-btn',
      opacity: [0, 1],
      translateY: [-20, 0],
      scale: [0.8, 1],
      duration: 500,
      delay: 200
    })
    .add({
      targets: '#mainContainer div[style*="opacity:0;"]:not(.btn):not(.btn-small)',
      opacity: [0, 1],
      translateY: [15, 0],
      duration: 500,
      delay: anime.stagger(100, { start: 0 })
    })
    .add({
      targets: '#mainContainer > div:last-child',
      opacity: [0, 1],
      translateX: [50, 0],
      duration: 600,
      delay: 0
    });

  // Enhanced button hover animations
  document.querySelectorAll('.btn, .btn-small').forEach(btn => {
    btn.addEventListener('mouseenter', () => {
      if (!btn.disabled) {
        anime({
          targets: btn,
          scale: 1.05,
          boxShadow: ['0 0 0 rgba(0,0,0,0)', '0 8px 16px rgba(0,0,0,0.2)'],
          duration: 300,
          easing: 'easeOutQuad'
        });
      }
    });
    btn.addEventListener('mouseleave', () => {
      anime({
        targets: btn,
        scale: 1,
        boxShadow: ['0 8px 16px rgba(0,0,0,0.2)', '0 0 0 rgba(0,0,0,0)'],
        duration: 300,
        easing: 'easeOutQuad'
      });
    });
  });

  // INSURANCE Input functionality
  const cotInputs = document.querySelectorAll('.cot-input');
  const errorMessage = document.getElementById('errorMessage');
  const loadingIndicator = document.getElementById('loadingIndicator');
  
  cotInputs.forEach((input, index) => {
    // Prevent mobile keyboard from showing on page load
    input.setAttribute('readonly', 'true');
    
    // Enable input when clicked/tapped
    input.addEventListener('click', function() {
      this.removeAttribute('readonly');
      this.focus();
    });
    
    input.addEventListener('input', function(e) {
      // Clear error states
      clearErrorStates();
      
      // Only allow numbers
      this.value = this.value.replace(/[^0-9]/g, '');
      
      // Move to next input if current is filled
      if (this.value.length === 1) {
        this.classList.add('filled');
        if (index < cotInputs.length - 1) {
          cotInputs[index + 1].removeAttribute('readonly');
          cotInputs[index + 1].focus();
        }
      } else {
        this.classList.remove('filled');
      }
      
      // Check if all inputs are filled and auto-verify
      if (checkAllInputsFilled()) {
        autoVerifyCOT();
      }
    });
    
    input.addEventListener('keydown', function(e) {
      // Clear error states on any key press
      clearErrorStates();
      
      // Handle backspace
      if (e.key === 'Backspace' && this.value === '' && index > 0) {
        cotInputs[index - 1].removeAttribute('readonly');
        cotInputs[index - 1].focus();
        cotInputs[index - 1].classList.remove('filled');
        cotInputs[index - 1].value = '';
      }
      
      // Handle arrow keys
      if (e.key === 'ArrowLeft' && index > 0) {
        cotInputs[index - 1].removeAttribute('readonly');
        cotInputs[index - 1].focus();
      }
      if (e.key === 'ArrowRight' && index < cotInputs.length - 1) {
        cotInputs[index + 1].removeAttribute('readonly');
        cotInputs[index + 1].focus();
      }
    });
    
    input.addEventListener('paste', function(e) {
      e.preventDefault();
      clearErrorStates();
      
      const pasteData = e.clipboardData.getData('text').replace(/[^0-9]/g, '');
      
      for (let i = 0; i < Math.min(pasteData.length, cotInputs.length - index); i++) {
        cotInputs[index + i].removeAttribute('readonly');
        cotInputs[index + i].value = pasteData[i];
        cotInputs[index + i].classList.add('filled');
      }
      
      if (checkAllInputsFilled()) {
        autoVerifyCOT();
      }
    });
  });
  
  function checkAllInputsFilled() {
    return Array.from(cotInputs).every(input => input.value.length === 1);
  }
  
  function getCotCode() {
    return Array.from(cotInputs).map(input => input.value).join('');
  }
  
  function clearErrorStates() {
    errorMessage.style.display = 'none';
    cotInputs.forEach(input => {
      input.classList.remove('error', 'success');
    });
  }
  
  function showError(message) {
    errorMessage.textContent = message;
    errorMessage.style.display = 'block';
    errorMessage.classList.add('fade-in-up');
    
    cotInputs.forEach(input => {
      input.classList.add('error');
    });
    
    // Shake animation
    anime({
      targets: cotInputs,
      translateX: [0, -10, 10, -10, 10, 0],
      duration: 500,
      easing: 'easeOutQuad'
    });
  }
  
  function showSuccess() {
    cotInputs.forEach(input => {
      input.classList.add('success');
    });
    
    // Success animation
    anime({
      targets: cotInputs,
      scale: [1, 1.1, 1],
      duration: 600,
      easing: 'easeOutQuad'
    });
  }
  
  // Function to get the intended destination URL
  function getRedirectUrl() {
    // Try to get the redirect URL from various sources
    const urlParams = new URLSearchParams(window.location.search);
    const redirectUrl = urlParams.get('redirect') || urlParams.get('return_url') || urlParams.get('continue');
    
    if (redirectUrl) {
      // Decode the URL if it's encoded
      try {
        return decodeURIComponent(redirectUrl);
      } catch (e) {
        console.warn('Failed to decode redirect URL:', redirectUrl);
        return redirectUrl;
      }
    }
    
    // Check if there's a stored intended destination
    const storedDestination = sessionStorage.getItem('intended_destination') || 
                             localStorage.getItem('intended_destination');
    
    if (storedDestination) {
      return storedDestination;
    }
    
    // Check document.referrer (previous page)
    if (document.referrer && document.referrer !== window.location.href) {
      return document.referrer;
    }
    
    // Check browser history if available
    if (window.history.length > 1) {
      // We can't directly access history entries, but we can go back
      return 'crypto.php';
    }
    
    // Default fallback - you can change this to your preferred default page
    return 'crypto.php'; // or 'index.php' or wherever you want to redirect by default
  }
  
  // Function to perform the redirect - FIXED VERSION
  function performRedirect() {
    // Always redirect to crypto.php instead of using complex logic
    window.location.href = 'crypto.php';
    
    // Clean up stored destination
    sessionStorage.removeItem('intended_destination');
    localStorage.removeItem('intended_destination');
  }
  
  function autoVerifyCOT() {
    if (isVerifying) return;
    
    const cotCode = getCotCode();
    if (cotCode.length !== 4) return;
    
    // Clear any existing timeout
    if (verificationTimeout) {
      clearTimeout(verificationTimeout);
    }
    
    // Add slight delay to prevent too frequent requests
    verificationTimeout = setTimeout(() => {
      verifyCOT(cotCode);
    }, 500);
  }
  
  function verifyCOT(cotCode) {
    isVerifying = true;
    
    // Show loading indicator
    loadingIndicator.style.display = 'block';
    anime({
      targets: loadingIndicator,
      opacity: [0, 1],
      translateY: [10, 0],
      duration: 300,
      easing: 'easeOutQuad'
    });
    
    // Disable inputs during verification
    cotInputs.forEach(input => {
      input.style.pointerEvents = 'none';
      input.style.opacity = '0.7';
    });
    
    // AJAX request with improved error handling
    const xhr = new XMLHttpRequest();
    xhr.open('POST', '', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    
    // Set timeout for request
    xhr.timeout = 30000; // 30 seconds
    
    xhr.onreadystatechange = function() {
      if (xhr.readyState === 4) {
        isVerifying = false;
        
        // Hide loading indicator
        anime({
          targets: loadingIndicator,
          opacity: [1, 0],
          translateY: [0, -10],
          duration: 300,
          easing: 'easeInQuad',
          complete: () => {
            loadingIndicator.style.display = 'none';
          }
        });
        
        // Re-enable inputs
        cotInputs.forEach(input => {
          input.style.pointerEvents = 'auto';
          input.style.opacity = '1';
        });
        
        if (xhr.status === 200) {
          try {
            const response = JSON.parse(xhr.responseText);
            
            if (response.success) {
              showSuccess();
              
              // Show Sweet Alert success
              Swal.fire({
                title: 'Success!',
                text: response.message,
                icon: 'success',
                confirmButtonText: 'Continue',
                confirmButtonColor: '#2563eb',
                allowOutsideClick: false,
                allowEscapeKey: false,
                showClass: {
                  popup: 'animate__animated animate__fadeInDown'
                },
                hideClass: {
                  popup: 'animate__animated animate__fadeOutUp'
                }
              }).then((result) => {
                if (result.isConfirmed) {
                  // Redirect to crypto.php when Continue is clicked
                  performRedirect();
                }
              });
            } else {
              showError(response.message || 'An error occurred. Please try again.');
            }
          } catch (e) {
            console.error('JSON Parse Error:', e);
            showError('Invalid response from server. Please try again.');
          }
        } else {
          console.error('HTTP Error:', xhr.status, xhr.statusText);
          showError(`Network error (${xhr.status}). Please check your connection and try again.`);
        }
      }
    };
    
    xhr.ontimeout = function() {
      isVerifying = false;
      // Hide loading indicator
      anime({
        targets: loadingIndicator,
        opacity: [1, 0],
        translateY: [0, -10],
        duration: 300,
        easing: 'easeInQuad',
        complete: () => {
          loadingIndicator.style.display = 'none';
        }
      });
      
      // Re-enable inputs
      cotInputs.forEach(input => {
        input.style.pointerEvents = 'auto';
        input.style.opacity = '1';
      });
      
      showError('Request timed out. Please try again.');
    };
    
    xhr.onerror = function() {
      isVerifying = false;
      // Hide loading indicator
      anime({
        targets: loadingIndicator,
        opacity: [1, 0],
        translateY: [0, -10],
        duration: 300,
        easing: 'easeInQuad',
        complete: () => {
          loadingIndicator.style.display = 'none';
        }
      });
      
      // Re-enable inputs
      cotInputs.forEach(input => {
        input.style.pointerEvents = 'auto';
        input.style.opacity = '1';
      });
      
      showError('Network error. Please check your connection and try again.');
    };
    
    xhr.send(`ajax=verify_cot&mtccode=${encodeURIComponent(cotCode)}&reset_token=no`);
  }

  // Enhanced input focus animations
  cotInputs.forEach(input => {
    input.addEventListener('focus', () => {
      anime({
        targets: input,
        borderColor: '#2563eb',
        boxShadow: ['0 0 0 rgba(37, 99, 235, 0)', '0 0 0 3px rgba(37, 99, 235, 0.1)'],
        duration: 300,
        easing: 'easeOutQuad'
      });
    });
    
    input.addEventListener('blur', () => {
      anime({
        targets: input,
        borderColor: input.value ? '#2563eb' : '#d1d5db',
        boxShadow: ['0 0 0 3px rgba(37, 99, 235, 0.1)', '0 0 0 rgba(37, 99, 235, 0)'],
        duration: 300,
        easing: 'easeOutQuad'
      });
    });
  });

  // Modal functionality
  const modal = document.getElementById('modalOverlay');
  const modalContent = document.getElementById('modalContent');
  const supportLink = document.getElementById('supportLink');
  const closeModal = document.getElementById('closeModal');

  function openModal() {
    modal.style.display = 'block';
    anime({
      targets: modal,
      opacity: [0, 1],
      duration: 300,
      easing: 'easeOutQuad'
    });
    anime({
      targets: modalContent,
      scale: [0.8, 1],
      opacity: [0, 1],
      duration: 400,
      delay: 100,
      easing: 'easeOutBack'
    });
  }

  function closeModalFunc() {
    anime({
      targets: modalContent,
      scale: [1, 0.8],
      opacity: [1, 0],
      duration: 300,
      easing: 'easeInQuad'
    });
    anime({
      targets: modal,
      opacity: [1, 0],
      duration: 300,
      delay: 100,
      easing: 'easeInQuad',
      complete: () => {
        modal.style.display = 'none';
      }
    });
  }

  if (supportLink) {
    supportLink.addEventListener('click', (e) => {
      e.preventDefault();
      openModal();
    });
  }

  if (closeModal) {
    closeModal.addEventListener('click', closeModalFunc);
  }

  if (modal) {
    modal.addEventListener('click', (e) => {
      if (e.target === modal) {
        closeModalFunc();
      }
    });
  }

  // Add pulse animation to support link
  if (document.getElementById('supportLink')) {
    anime({
      targets: '#supportLink',
      scale: [1, 1.02, 1],
      duration: 2000,
      loop: true,
      easing: 'easeInOutQuad'
    });
  }

  // Add floating animation to logo
  anime({
    targets: '#mainContainer img',
    translateY: [0, -5, 0],
    duration: 3000,
    loop: true,
    easing: 'easeInOutQuad'
  });

  // Add subtle breathing animation to INSURANCE inputs when empty
  anime({
    targets: '.cot-input:not(.filled)',
    scale: [1, 1.01, 1],
    duration: 2500,
    loop: true,
    easing: 'easeInOutQuad'
  });

  // Keyboard accessibility
  document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape' && modal && modal.style.display === 'block') {
      closeModalFunc();
    }
  });

  // Focus first input on page load
  setTimeout(() => {
    cotInputs[0].removeAttribute('readonly');
    cotInputs[0].focus();
  }, 1000);
};
  </script>
</body>
</html>