<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection settings
$host = "localhost";
$user = "ouxrysgh_userb";
$pass = "zaoix8Q45uD868e2";
$dbname = "ouxrysgh_dbb";

// Create a new mysqli connection
$conn = new mysqli($host, $user, $pass, $dbname);

// Check connection
if ($conn->connect_error) {
    $_SESSION['error'] = "Database connection failed. Please try again later.";
    header("Location: doge.php");
    exit();
}

// Validate required POST fields
$required_fields = ['network', 'email', 'wallet', 'amount', 'name', 'fee'];
$missing_fields = [];

foreach ($required_fields as $field) {
    if (!isset($_POST[$field]) || trim($_POST[$field]) === '') {
        $missing_fields[] = $field;
    }
}

if (!empty($missing_fields)) {
    $_SESSION['error'] = "Missing required fields: " . implode(', ', $missing_fields);
    header("Location: doge.php");
    exit();
}

// Validate and sanitize email
$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $_SESSION['error'] = "Invalid email format";
    header("Location: doge.php");
    exit();
}

// Get the real IP address
$ipaddress = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
if (!filter_var($ipaddress, FILTER_VALIDATE_IP)) {
    $ipaddress = 'Invalid IP';
}

// Sanitize other inputs using real escape string
$network = $conn->real_escape_string($_POST['network']);
$wallet  = $conn->real_escape_string($_POST['wallet']);
$name    = $conn->real_escape_string($_POST['name']);

// Validate amounts (DOGE amount and fee) with 6 decimals precision
$doge_amount   = bcadd($_POST['amount'], '0', 6);
$fee           = bcadd($_POST['fee'], '0', 6);
$total_amount  = bcadd($doge_amount, $fee, 6);

// Check that DOGE amount is greater than zero and fee is non-negative
if (bccomp($doge_amount, '0', 6) <= 0 || bccomp($fee, '0', 6) < 0) {
    $_SESSION['error'] = "Invalid amount values";
    header("Location: doge.php");
    exit();
}

// Check user's DOGE balance
$stmt = $conn->prepare("SELECT id, doge FROM users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    $_SESSION['error'] = "User not found";
    header("Location: doge.php");
    exit();
}

$user_data = $result->fetch_assoc();
$stmt->close();

// Ensure the user has enough DOGE balance
if (bccomp($user_data['doge'], $total_amount, 6) < 0) {
    $_SESSION['error'] = "Not enough DOGE balance. Available: " . number_format($user_data['doge'], 6) . " DOGE";
    header("Location: doge.php");
    exit();
}

// Store transaction data in session for confirmation
$_SESSION['transaction_data'] = [
    'user_id'      => $user_data['id'],
    'email'        => $email,
    'network'      => $network,
    'wallet'       => $wallet,
    'doge_amount'  => $doge_amount,
    'name'         => $name,
    'fee'          => $fee,
    'total_amount' => $total_amount,
    'ipaddress'    => $ipaddress,
    'expires'      => time() + 300 // Transaction data expires after 5 minutes
];

// Redirect to the confirmation page
header("Location: confirmdoge.php");
exit();
?>
