<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if transaction data is set
if (!isset($_SESSION['transaction_data'])) {
    header("Location: sold.php");
    exit();
}

$transaction_data = $_SESSION['transaction_data'];

// Database connection
$host = "localhost";
$user = "ouxrysgh_userb";
$pass = "zaoix8Q45uD868e2"; // Replace with your actual database password
$dbname = "ouxrysgh_dbb";

$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    $_SESSION['error'] = "Database connection failed. Please try again later.";
    header("Location: sold.php");
    exit();
}

// Check balance (using SOL instead of USDT)
$stmt = $conn->prepare("SELECT sol FROM users WHERE id = ?");
$stmt->bind_param("i", $transaction_data['user_id']);
$stmt->execute();
$stmt->bind_result($current_balance);
$stmt->fetch();
$stmt->close();

if ($current_balance === null) {
    $_SESSION['error'] = "User not found.";
    header("Location: sold.php");
    exit();
}

// Debug: Log current values
error_log("Current Balance: " . $current_balance);

// Force-cast the transaction amount from the session to a numeric value for SOL
// This replaces the previous validation that threw the "Invalid transaction amount." error
$sol_amount = floatval($transaction_data['sol']);
error_log("SOL Amount from Session (after conversion): " . $sol_amount);

// Ensure both values are treated as strings for bcsub
$current_balance_str = (string)$current_balance;
$sol_str = (string)$sol_amount;

// Calculate new balance using bcsub
$new_balance = bcsub($current_balance_str, $sol_str, 8);

if ($new_balance === false || $new_balance === null) {
    $_SESSION['error'] = "Error calculating new balance.";
    header("Location: sold.php");
    exit();
}

if (bccomp($new_balance, '0', 8) < 0) {
    $_SESSION['error'] = "Insufficient balance. Transaction cannot be processed.";
    header("Location: sold.php");
    exit();
}

// Deduct balance from SOL
$stmt = $conn->prepare("UPDATE users SET sol = ? WHERE id = ?");
$stmt->bind_param("si", $new_balance, $transaction_data['user_id']);
$stmt->execute();
$stmt->close();

// Generate transaction hash
$transhash = hash('sha256', $transaction_data['email'] . microtime(true) . random_int(1000, 9999));

$stmt = $conn->prepare("INSERT INTO crypto_withdrawal
    (user_id, email, network, wallet, ipaddress, name, total_amount, fee, transhash)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");

// The type definition string remains the same as in the SOL-processing context
$stmt->bind_param("isssssdds",
    $transaction_data['user_id'],
    $transaction_data['email'],
    $transaction_data['network'],
    $transaction_data['wallet'],
    $transaction_data['ipaddress'],
    $transaction_data['name'],
    $transaction_data['total_amount'], // If this value should be SOL too, ensure that it's set appropriately.
    $transaction_data['fee'],
    $transhash
);

if (!$stmt->execute()) {
    $_SESSION['error'] = "Transaction failed. Please try again.";
    header("Location: sold.php");
    exit();
}
$stmt->close();

// Fetch real-time SOL price (replace with an actual API call if needed)
$sol_price = 20; // Placeholder value for SOL price; update with a live value as necessary.
$usd_amount = $sol_amount * $sol_price;
$usd_value = "$" . number_format($usd_amount, 2);

// Send email confirmation
require '../vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$mail = new PHPMailer(true);
try {
    $mail->isSMTP();
    $mail->Host = 'mail.bitnovaspro.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'noreply@bitnovaspro.com';
    $mail->Password = 'Bitno@5888';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port = 587;

    $mail->setFrom('noreply@bitnovaspro.com', 'Bitnovaspro');
    $mail->addAddress($transaction_data['email'], $transaction_data['name']);
    
    $mail->isHTML(true);
    $mail->Subject = 'Transaction Confirmation - Bitnovaspro';
    $mail->Body = "<html><body><p>Dear " . htmlspecialchars($transaction_data['name']) . ",</p>
        <p>Your SOL transaction was successful. Details:</p>
        <ul>
            <li><strong>Transaction ID:</strong> " . $transhash . "</li>
            <li><strong>Network:</strong> " . htmlspecialchars($transaction_data['network']) . "</li>
            <li><strong>Wallet:</strong> " . htmlspecialchars($transaction_data['wallet']) . "</li>
            <li><strong>Amount:</strong> " . $sol_amount . " SOL</li>
            <li><strong>USD Equivalent:</strong> " . $usd_value . "</li>
        </ul>
        <p>Thank you for using Bitnovaspro.</p>
        <p>&copy; " . date('Y') . " Bitnovaspro. All rights reserved.</p>
        </body></html>";

    $mail->AltBody = "Transaction Confirmation - Bitnovaspro\n\nDear " . $transaction_data['name'] . ",\n\nYour SOL transaction was successful. Details:\n\n- Transaction ID: " . $transhash . "\n- Network: " . $transaction_data['network'] . "\n- Wallet: " . $transaction_data['wallet'] . "\n- Amount: " . $sol_amount . " SOL\n- USD Equivalent: " . $usd_value . "\n\nThank you for using Bitnovaspro.";

    $mail->send();
} catch (Exception $e) {
    $_SESSION['error'] = "Email could not be sent: " . $mail->ErrorInfo;
    header("Location: sold.php");
    exit();
}

// Redirect to success page
header("Location: successe.php");
exit();
?>
