<?php
// upgrade-plan.php
// Define trading plans with their details
$plans = [
    "STARTER" => [
        "price" => "$100",
        "description" => "Ideal for new traders with essential features.",
        "features" => ["2 Crypto Signals Daily", "Email Support", "Weekly Newsletter"]
    ],
    "BASIC" => [
        "price" => "$500",
        "description" => "Perfect for regular traders.",
        "features" => ["3 Crypto Signals Daily", "1 TRADE Signal Daily", "Market Updates"]
    ],
    "SILVER" => [
        "price" => "$5000",
        "description" => "For advanced traders looking for more insights.",
        "features" => ["5 Crypto Signals Daily", "3 TRADE Signals Daily", "24/7 Support", "Basic Analysis", "Trading Webinars"]
    ],
    "GOLD" => [
        "price" => "$25000",
        "description" => "Premium package for serious traders.",
        "features" => ["8 Crypto Signals Daily", "5 TRADE Signals Daily", "VIP Support", "Advanced Analysis"]
    ],
    "PLATINUM" => [
        "price" => "$35000",
        "description" => "High-end plan with one-on-one support.",
        "features" => ["10 Crypto Signals Daily", "8 TRADE Signals Daily", "1-on-1 Support", "Full Analysis"]
    ],
    "DIAMOND" => [
        "price" => "$55000",
        "description" => "Exclusive plan with a personal manager.",
        "features" => ["15 Crypto Signals Daily", "10 TRADE Signals Daily", "Personal Manager", "AI Predictions"]
    ],
    "VIP" => [
        "price" => "$100000",
        "description" => "Ultimate package with unlimited signals.",
        "features" => ["Unlimited Signals", "24/7 Personal Trader", "Institutional Tools", "Custom Strategies"]
    ]
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Bitnovaspro - Upgrade Your Trading Plan</title>
  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            primary: {
              50: '#f0f9ff',
              100: '#e0f2fe',
              200: '#bae6fd',
              300: '#7dd3fc',
              400: '#38bdf8',
              500: '#0ea5e9',
              600: '#0284c7',
              700: '#0369a1',
              800: '#075985',
              900: '#0c4a6e',
            }
          },
          fontFamily: {
            sans: ['Inter', 'sans-serif']
          }
        }
      }
    }
  </script>
  <!-- Animate.css -->
  <link
    rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"
    integrity="sha512-V8lGeK6tVkao8pHpiNCtliT6u6+FYYO3+I4hnwr+8P75euhhN1rwNJl0d/2VtHB+VQ8pTTuX5SIYz2W6z6b1gA=="
    crossorigin="anonymous" referrerpolicy="no-referrer"
  />
  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css"/>
  <!-- Google Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="icon" href="https://bitnovaspro.com/session/faviconb.png" type="image/x-icon">
</head>
<body class="bg-white text-gray-800 font-sans">
  <!-- Navbar -->
  <nav class="bg-white shadow-md sticky top-0 z-50">
    <div class="container mx-auto px-4 py-4">
      <div class="flex items-center justify-between">
        <div class="flex items-center space-x-2">
          <img src="https://bitnovaspro.com/session/faviconb.png" alt="Bitnovaspro Logo" class="h-8 w-8">
          <h1 class="text-2xl font-bold text-primary-600">Bitnovaspro</h1>
        </div>
        <div class="hidden md:flex items-center space-x-8">
          <a href="#" class="text-gray-600 hover:text-primary-600 transition font-medium">Home</a>
          <a href="#plans" class="text-gray-600 hover:text-primary-600 transition font-medium">Plans</a>
          <a href="#testimonials" class="text-gray-600 hover:text-primary-600 transition font-medium">Testimonials</a>
          <a href="#contact" class="text-gray-600 hover:text-primary-600 transition font-medium">Contact</a>
        </div>
        <div class="md:hidden">
          <button id="mobile-menu-button" class="text-gray-600 hover:text-primary-600 focus:outline-none">
            <i class="fas fa-bars text-2xl"></i>
          </button>
        </div>
      </div>
      <!-- Mobile Menu -->
      <div id="mobile-menu" class="hidden md:hidden mt-4 pb-2 animate__animated animate__fadeIn">
        <a href="#" class="block py-2 text-gray-600 hover:text-primary-600">Home</a>
        <a href="#plans" class="block py-2 text-gray-600 hover:text-primary-600">Plans</a>
        <a href="#testimonials" class="block py-2 text-gray-600 hover:text-primary-600">Testimonials</a>
        <a href="#contact" class="block py-2 text-gray-600 hover:text-primary-600">Contact</a>
      </div>
    </div>
  </nav>

  <!-- Hero Section -->
  <section class="bg-gradient-to-r from-primary-50 to-primary-100 py-20">
    <div class="container mx-auto px-4 text-center">
      <h2 class="text-4xl md:text-5xl font-extrabold mb-4 text-gray-800">Elevate Your Trading Experience</h2>
      <p class="text-lg text-gray-600 mb-8 max-w-2xl mx-auto">Access premium trading signals, expert analysis, and personalized support with our tailored subscription plans.</p>
      <button id="jumpToPlans" class="bg-primary-600 text-white font-semibold py-3 px-8 rounded-lg hover:bg-primary-700 transition shadow-md">
        Explore Plans <i class="fas fa-arrow-right ml-2"></i>
      </button>
    </div>
  </section>
  
  <!-- Stats Section -->
  <section class="py-16 bg-white">
    <div class="container mx-auto px-4">
      <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
        <div class="text-center p-6 bg-gray-50 rounded-xl shadow-sm">
          <div class="text-primary-600 text-4xl font-bold mb-2">93%</div>
          <p class="text-gray-600">Success Rate on Our Signals</p>
        </div>
        <div class="text-center p-6 bg-gray-50 rounded-xl shadow-sm">
          <div class="text-primary-600 text-4xl font-bold mb-2">24/7</div>
          <p class="text-gray-600">Expert Support Available</p>
        </div>
        <div class="text-center p-6 bg-gray-50 rounded-xl shadow-sm">
          <div class="text-primary-600 text-4xl font-bold mb-2">10,000+</div>
          <p class="text-gray-600">Active Traders Trust Us</p>
        </div>
      </div>
    </div>
  </section>

  <!-- Plans Grid -->
  <section id="plans" class="container mx-auto px-4 py-16">
    <h3 class="text-3xl font-bold text-center mb-4 text-gray-800">Our Trading Plans</h3>
    <p class="text-gray-600 text-center mb-12 max-w-2xl mx-auto">Choose the perfect plan that aligns with your trading goals and experience level.</p>
    
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-8">
      <?php foreach ($plans as $name => $plan): ?>
        <div class="bg-white rounded-xl shadow-lg overflow-hidden animate__animated animate__fadeInUp hover:shadow-xl transition-all duration-300" style="animation-delay: 0.<?= rand(1,5) ?>s;">
          <div class="<?php echo $name === 'GOLD' || $name === 'PLATINUM' ? 'bg-gradient-to-r from-primary-600 to-primary-500 text-white' : 'bg-gray-50 text-gray-800' ?> p-6">
            <h4 class="text-2xl font-bold mb-2"><?php echo $name ?></h4>
            <p class="<?php echo $name === 'GOLD' || $name === 'PLATINUM' ? 'text-white opacity-90' : 'text-gray-600' ?> mb-4"><?php echo $plan['description'] ?></p>
            <p class="text-3xl font-bold mb-2"><?php echo $plan['price'] ?></p>
            <?php if ($name === 'GOLD' || $name === 'PLATINUM'): ?>
              <span class="inline-block bg-white text-primary-600 text-xs font-semibold px-3 py-1 rounded-full">POPULAR CHOICE</span>
            <?php endif; ?>
          </div>
          <div class="p-6 border-t border-gray-100">
            <ul class="space-y-3 mb-6">
              <?php foreach ($plan['features'] as $feature): ?>
                <li class="flex items-start">
                  <i class="fas fa-check-circle text-primary-500 mt-1 mr-2"></i>
                  <span class="text-gray-700"><?php echo $feature ?></span>
                </li>
              <?php endforeach; ?>
            </ul>
            <button
              class="w-full <?php echo $name === 'GOLD' || $name === 'PLATINUM' ? 'bg-primary-600 hover:bg-primary-700' : 'bg-gray-800 hover:bg-gray-900' ?> text-white font-semibold py-3 rounded-lg transition shadow-sm"
              onclick="openSubscribeModal('<?php echo $name ?>')"
            >
              Subscribe Now
            </button>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </section>

  <!-- Testimonials Section -->
  <section id="testimonials" class="bg-gray-50 py-16">
    <div class="container mx-auto px-4">
      <h3 class="text-3xl font-bold text-center mb-12 text-gray-800">What Our Traders Say</h3>
      <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
        <div class="bg-white p-6 rounded-xl shadow-sm">
          <div class="flex items-center mb-4">
            <div class="text-yellow-400 flex">
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
            </div>
            <span class="ml-2 text-gray-600">5.0</span>
          </div>
          <p class="text-gray-700 mb-4">"The signals have been incredibly accurate. I've seen consistent returns since upgrading to the Gold plan."</p>
          <div class="flex items-center">
            <div class="bg-gray-200 rounded-full h-10 w-10 flex items-center justify-center text-gray-600 font-bold">JD</div>
            <div class="ml-3">
              <p class="font-medium text-gray-800">John D.</p>
              <p class="text-gray-600 text-sm">Gold Member</p>
            </div>
          </div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-sm">
          <div class="flex items-center mb-4">
            <div class="text-yellow-400 flex">
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
            </div>
            <span class="ml-2 text-gray-600">5.0</span>
          </div>
          <p class="text-gray-700 mb-4">"The personalized support has been invaluable. My dedicated manager helped me develop strategies specific to my goals."</p>
          <div class="flex items-center">
            <div class="bg-gray-200 rounded-full h-10 w-10 flex items-center justify-center text-gray-600 font-bold">SM</div>
            <div class="ml-3">
              <p class="font-medium text-gray-800">Sarah M.</p>
              <p class="text-gray-600 text-sm">Diamond Member</p>
            </div>
          </div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-sm">
          <div class="flex items-center mb-4">
            <div class="text-yellow-400 flex">
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star-half-alt"></i>
            </div>
            <span class="ml-2 text-gray-600">4.5</span>
          </div>
          <p class="text-gray-700 mb-4">"Started with the Starter plan and quickly upgraded to Silver. The trading webinars alone are worth the investment."</p>
          <div class="flex items-center">
            <div class="bg-gray-200 rounded-full h-10 w-10 flex items-center justify-center text-gray-600 font-bold">RL</div>
            <div class="ml-3">
              <p class="font-medium text-gray-800">Robert L.</p>
              <p class="text-gray-600 text-sm">Silver Member</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- FAQ Section -->
  <section class="container mx-auto px-4 py-16">
    <h3 class="text-3xl font-bold text-center mb-12 text-gray-800">Frequently Asked Questions</h3>
    <div class="max-w-3xl mx-auto space-y-6">
      <div class="border border-gray-200 rounded-lg overflow-hidden">
        <button class="faq-button w-full flex justify-between items-center p-4 text-left bg-white hover:bg-gray-50">
          <span class="font-medium text-gray-800">How accurate are your trading signals?</span>
          <i class="fas fa-chevron-down text-gray-400 transform transition-transform"></i>
        </button>
        <div class="faq-answer hidden p-4 bg-gray-50 border-t border-gray-200">
          <p class="text-gray-600">Our trading signals have a historical accuracy rate of 93%. We employ advanced algorithms and expert analysis to ensure high-quality signals across all market conditions.</p>
        </div>
      </div>
      <div class="border border-gray-200 rounded-lg overflow-hidden">
        <button class="faq-button w-full flex justify-between items-center p-4 text-left bg-white hover:bg-gray-50">
          <span class="font-medium text-gray-800">Can I upgrade or downgrade my plan later?</span>
          <i class="fas fa-chevron-down text-gray-400 transform transition-transform"></i>
        </button>
        <div class="faq-answer hidden p-4 bg-gray-50 border-t border-gray-200">
          <p class="text-gray-600">Yes, you can upgrade or downgrade your subscription plan at any time. Changes will take effect at the start of your next billing cycle.</p>
        </div>
      </div>
      <div class="border border-gray-200 rounded-lg overflow-hidden">
        <button class="faq-button w-full flex justify-between items-center p-4 text-left bg-white hover:bg-gray-50">
          <span class="font-medium text-gray-800">How do I receive trading signals?</span>
          <i class="fas fa-chevron-down text-gray-400 transform transition-transform"></i>
        </button>
        <div class="faq-answer hidden p-4 bg-gray-50 border-t border-gray-200">
          <p class="text-gray-600">Trading signals are delivered via our secure platform, email, and mobile app notifications in real-time. You'll never miss an opportunity with our multi-channel alert system.</p>
        </div>
      </div>
    </div>
  </section>

  <!-- Contact Section -->
  <section id="contact" class="bg-primary-50 py-16">
    <div class="container mx-auto px-4">
      <h3 class="text-3xl font-bold text-center mb-8 text-gray-800">Get in Touch</h3>
      <p class="text-center text-gray-600 mb-12 max-w-2xl mx-auto">Have questions about our plans or need personalized assistance? Our team is here to help you succeed.</p>
      
      <div class="max-w-4xl mx-auto grid grid-cols-1 md:grid-cols-3 gap-8">
        <div class="bg-white p-6 rounded-xl shadow-sm text-center">
          <div class="inline-block p-3 bg-primary-100 rounded-full mb-4">
            <i class="fas fa-envelope text-primary-600 text-xl"></i>
          </div>
          <h4 class="font-semibold text-gray-800 mb-2">Email Us</h4>
          <p class="text-gray-600 mb-4">We'll respond within 24 hours</p>
          <a href="mailto:support@bitnovaspro.com" class="text-primary-600 hover:text-primary-700 font-medium">support@bitnovaspro.com</a>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-sm text-center">
          <div class="inline-block p-3 bg-primary-100 rounded-full mb-4">
            <i class="fas fa-phone text-primary-600 text-xl"></i>
          </div>
          <h4 class="font-semibold text-gray-800 mb-2">Call Us</h4>
          <p class="text-gray-600 mb-4">Mon-Fri, 9am-5pm EST</p>
          <a href="tel:+1800555BULL" class="text-primary-600 hover:text-primary-700 font-medium">+1 800 555 BULL</a>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-sm text-center">
          <div class="inline-block p-3 bg-primary-100 rounded-full mb-4">
            <i class="fas fa-comment-dots text-primary-600 text-xl"></i>
          </div>
          <h4 class="font-semibold text-gray-800 mb-2">Live Chat</h4>
          <p class="text-gray-600 mb-4">Available 24/7 for assistance</p>
          <button class="text-primary-600 hover:text-primary-700 font-medium">Start Chat</button>
        </div>
      </div>
    </div>
  </section>

  <!-- Footer -->
  <footer class="bg-gray-800 text-white py-12">
    <div class="container mx-auto px-4">
      <div class="grid grid-cols-1 md:grid-cols-4 gap-8 mb-8">
        <div>
          <div class="flex items-center space-x-2 mb-4">
            <img src="https://bitnovaspro.com/session/faviconb.png" alt="Bitnovaspro Logo" class="h-8 w-8 bg-white rounded-full p-1">
            <h1 class="text-xl font-bold">Bitnovaspro</h1>
          </div>
          <p class="text-gray-400">Premium trading signals and market insights for serious traders.</p>
        </div>
        <div>
          <h5 class="font-semibold mb-4">Quick Links</h5>
          <ul class="space-y-2 text-gray-400">
            <li><a href="#" class="hover:text-white transition">Home</a></li>
            <li><a href="#plans" class="hover:text-white transition">Plans</a></li>
            <li><a href="#testimonials" class="hover:text-white transition">Testimonials</a></li>
            <li><a href="#contact" class="hover:text-white transition">Contact</a></li>
          </ul>
        </div>
        <div>
          <h5 class="font-semibold mb-4">Resources</h5>
          <ul class="space-y-2 text-gray-400">
            <li><a href="#" class="hover:text-white transition">Blog</a></li>
            <li><a href="#" class="hover:text-white transition">Market Analysis</a></li>
            <li><a href="#" class="hover:text-white transition">Trading Guides</a></li>
            <li><a href="#" class="hover:text-white transition">FAQ</a></li>
          </ul>
        </div>
        <div>
          <h5 class="font-semibold mb-4">Follow Us</h5>
          <div class="flex space-x-4">
            <a href="#" class="text-gray-400 hover:text-white transition"><i class="fab fa-twitter"></i></a>
            <a href="#" class="text-gray-400 hover:text-white transition"><i class="fab fa-facebook"></i></a>
            <a href="#" class="text-gray-400 hover:text-white transition"><i class="fab fa-instagram"></i></a>
            <a href="#" class="text-gray-400 hover:text-white transition"><i class="fab fa-linkedin"></i></a>
          </div>
        </div>
      </div>
      <div class="border-t border-gray-700 pt-8 text-center text-gray-400">
        <p>&copy; <?php echo date('Y') ?> Bitnovaspro Trading. All rights reserved.</p>
        <div class="mt-2 flex justify-center space-x-4 text-sm">
          <a href="#" class="hover:text-white transition">Privacy Policy</a>
          <a href="#" class="hover:text-white transition">Terms of Service</a>
          <a href="#" class="hover:text-white transition">Risk Disclaimer</a>
        </div>
      </div>
    </div>
  </footer>

  <!-- JavaScript -->
  <script>
    const plans = <?php echo json_encode($plans, JSON_HEX_TAG); ?>;

    // Smooth scrolling for navigation
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
      anchor.addEventListener('click', function(e) {
        e.preventDefault();
        document.querySelector(this.getAttribute('href')).scrollIntoView({
          behavior: 'smooth'
        });
      });
    });

    // Mobile menu toggle
    document.getElementById('mobile-menu-button').addEventListener('click', () => {
      const mobileMenu = document.getElementById('mobile-menu');
      if (mobileMenu.classList.contains('hidden')) {
        mobileMenu.classList.remove('hidden');
        mobileMenu.classList.add('animate__fadeIn');
      } else {
        mobileMenu.classList.add('hidden');
      }
    });

    // Jump to plans button
    document.getElementById('jumpToPlans').addEventListener('click', () => {
      document.getElementById('plans').scrollIntoView({ behavior: 'smooth' });
    });

    // FAQ toggles
    document.querySelectorAll('.faq-button').forEach(button => {
      button.addEventListener('click', () => {
        const answer = button.nextElementSibling;
        const icon = button.querySelector('i');
        
        if (answer.classList.contains('hidden')) {
          answer.classList.remove('hidden');
          icon.classList.add('rotate-180');
        } else {
          answer.classList.add('hidden');
          icon.classList.remove('rotate-180');
        }
      });
    });

    // Subscribe modal
    function openSubscribeModal(planName) {
      const plan = plans[planName];
      const features = plan.features.map(f => `<li class="flex items-center my-2"><i class="fas fa-check text-primary-500 mr-2"></i>${f}</li>`).join('');
      
      Swal.fire({
        title: `Subscribe to ${planName}`,
        html: `
          <div class="space-y-4 text-left">
            <input type="hidden" id="planInput" value="${planName}" />
            <div class="bg-primary-50 p-4 rounded-lg mb-4">
              <p class="text-xl font-semibold text-gray-800">${planName} Plan</p>
              <p class="text-gray-600">${plan.description}</p>
              <p class="text-2xl font-bold text-primary-600 mt-2">${plan.price}</p>
            </div>
            <div class="mb-4">
              <p class="font-medium text-gray-700 mb-2">Features included:</p>
              <ul class="space-y-1 text-gray-600">${features}</ul>
            </div>
            <div class="space-y-3">
              <input id="nameInput" class="w-full border border-gray-300 text-gray-800 p-3 rounded-lg" placeholder="Your Full Name" />
              <input id="emailInput" class="w-full border border-gray-300 text-gray-800 p-3 rounded-lg" placeholder="Your Email Address" />
            </div>
          </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Subscribe Now',
        confirmButtonColor: '#0284c7',
        cancelButtonText: 'Cancel',
        customClass: {
          popup: 'animate__animated animate__fadeInDown'
        },
        preConfirm: () => {
          const name = document.getElementById('nameInput').value.trim();
          const email = document.getElementById('emailInput').value.trim();
          
          if (!name) {
            Swal.showValidationMessage('Please enter your name');
            return false;
          }
          
          if (!email) {
            Swal.showValidationMessage('Please enter your email');
            return false;
          }
          
          if (!/^\S+@\S+\.\S+$/.test(email)) {
            Swal.showValidationMessage('Please enter a valid email address');
            return false;
          }
          
          const form = document.createElement('form');
          form.method = 'POST';
          form.action = 'paidplan.php';
          [['name', name], ['email', email], ['plan', planName], ['amount', plan.price.replace('$','')]]
            .forEach(([k,v]) => {
              const inp = document.createElement('input'); inp.type='hidden'; inp.name=k; inp.value=v; form.appendChild(inp);
            });
          document.body.appendChild(form);
          form.submit();
        }
      });
    }
  </script>
</body>
</html>