<?php
// Include the header and navigation
include_once './includes/header.php';
include_once './includes/nav.php';

// Validate and retrieve the stake id from GET
if (!isset($_GET['id']) || empty($_GET['id'])) {
    $_SESSION['alert'] = [
        'type' => 'error',
        'message' => 'Invalid stake ID provided.'
    ];
    header("Location: dashboard.php");
    exit;
}
$stakeId = intval($_GET['id']);

// Database connection details
$servername = "localhost";
$username = "ouxrysgh_userb";
$password = "zaoix8Q45uD868e2";
$dbname = "itaybvfn_dbcon";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    $_SESSION['alert'] = [
        'type' => 'error',
        'message' => 'Database connection failed. Please try again later.'
    ];
    header("Location: dashboard.php");
    exit;
}

// Prepare and execute query to fetch the stake details
$sql = "SELECT * FROM crypto_stakes WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $stakeId);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows == 0) {
    $_SESSION['alert'] = [
        'type' => 'error',
        'message' => "No stake found with ID $stakeId."
    ];
    $stmt->close();
    $conn->close();
    header("Location: dashboard.php");
    exit;
}
$stake = $result->fetch_assoc();
$stmt->close();
$conn->close();

// Setup language translation (default is English)
$lang = isset($_GET['lang']) && in_array($_GET['lang'], ['en', 'fr']) ? $_GET['lang'] : 'en';
$translations = [
    'en' => [
        'title'            => 'Stake Details',
        'id'               => 'ID',
        'email'            => 'Email',
        'name'             => 'Name',
        'sessionType'      => 'Asset Type',
        'sessionCurrency'  => 'Currency',
        'sessionAmount'    => 'Amount',
        'convertedAmount'  => 'Value',
        'sessionDate'      => 'Date',
        'status'           => 'Status',
        'note'             => 'Note',
        'back'             => 'Back to Portfolio',
        'edit'             => 'Edit',
        'delete'           => 'Delete',
        'confirm_delete'   => 'Are you sure you want to delete this stake?',
        'stake_summary'    => 'Stake Summary',
        'stake_details'    => 'Stake Information',
        'actions'          => 'Actions'
    ],
    'fr' => [
        'title'            => 'Détails du Pari',
        'id'               => 'ID',
        'email'            => 'Email',
        'name'             => 'Nom',
        'sessionType'      => 'Type d\'actif',
        'sessionCurrency'  => 'Devise',
        'sessionAmount'    => 'Montant',
        'convertedAmount'  => 'Valeur',
        'sessionDate'      => 'Date',
        'status'           => 'Statut',
        'note'             => 'Note',
        'back'             => 'Retour au portefeuille',
        'edit'             => 'Modifier',
        'delete'           => 'Supprimer',
        'confirm_delete'   => 'Êtes-vous sûr de vouloir supprimer ce pari?',
        'stake_summary'    => 'Résumé du Pari',
        'stake_details'    => 'Informations du Pari',
        'actions'          => 'Actions'
    ]
];
$trans = $translations[$lang];

// Format values
$sessionAmount = number_format((float)$stake['sessionAmount'], 2, '.', ',');
$convertedAmount = number_format((float)$stake['convertedAmount'], 2, '.', ',');
$sessionDate = date('M d, Y', strtotime($stake['sessionDate']));

// Status mapping to Coinbase-style status indicators
function getStatusInfo($status) {
    $statusLower = strtolower($status);
    if ($statusLower === 'success') {
        return [
            'class' => 'bg-green-100 text-green-800',
            'icon' => 'fa-check-circle',
            'iconClass' => 'text-green-500'
        ];
    } elseif ($statusLower === 'pending') {
        return [
            'class' => 'bg-yellow-100 text-yellow-800',
            'icon' => 'fa-clock',
            'iconClass' => 'text-yellow-500'
        ];
    } elseif (in_array($statusLower, ['warning', 'lost'])) {
        return [
            'class' => 'bg-red-100 text-red-800',
            'icon' => 'fa-exclamation-circle',
            'iconClass' => 'text-red-500'
        ];
    } else {
        return [
            'class' => 'bg-blue-100 text-blue-800',
            'icon' => 'fa-info-circle',
            'iconClass' => 'text-blue-500'
        ];
    }
}

$statusInfo = getStatusInfo($stake['status']);

// Toast alert system
$showAlert = isset($_SESSION['alert']);
$alertType = $showAlert ? $_SESSION['alert']['type'] : '';
$alertMessage = $showAlert ? $_SESSION['alert']['message'] : '';

// Clear the alert after displaying
if ($showAlert) {
    unset($_SESSION['alert']);
}

// Get alert styling based on type
function getAlertStyle($type) {
    switch ($type) {
        case 'win':
            return [
                'bg' => 'bg-green-100',
                'text' => 'text-green-800',
                'icon' => 'fa-check-circle text-green-500'
            ];
        case 'loss':
            return [
                'bg' => 'bg-red-100',
                'text' => 'text-red-800',
                'icon' => 'fa-exclamation-circle text-red-500'
            ];
        case 'pending':
            return [
                'bg' => 'bg-yellow-100',
                'text' => 'text-yellow-800',
                'icon' => 'fa-exclamation-triangle text-yellow-500'
            ];
        default:
            return [
                'bg' => 'bg-blue-100',
                'text' => 'text-blue-800',
                'icon' => 'fa-info-circle text-blue-500'
            ];
    }
}

$alertStyle = $showAlert ? getAlertStyle($alertType) : null;
?>

<!-- Add Font Awesome and custom CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
<style>
    .toast-alert {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 9999;
        animation: slideIn 0.3s, fadeOut 0.5s 5s forwards;
    }
    @keyframes slideIn {
        from { transform: translateX(100%); }
        to { transform: translateX(0); }
    }
    @keyframes fadeOut {
        from { opacity: 1; }
        to { opacity: 0; visibility: hidden; }
    }
    .crypto-card {
        transition: all 0.3s ease;
    }
    .crypto-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
    }
</style>

<!-- Toast Alert -->
<?php if ($showAlert): ?>
<div id="toast-alert" class="toast-alert <?php echo $alertStyle['bg']; ?> <?php echo $alertStyle['text']; ?> px-6 py-4 rounded-lg shadow-lg flex items-center max-w-md">
    <i class="fas <?php echo $alertStyle['icon']; ?> mr-3 text-xl"></i>
    <span><?php echo $alertMessage; ?></span>
    <button type="button" class="ml-auto" onclick="closeToast()">
        <i class="fas fa-times"></i>
    </button>
</div>
<?php endif; ?>

<div class="container mx-auto p-4">
    <!-- Breadcrumb -->
    <div class="flex items-center text-sm mb-6 text-gray-600">
        <a href="dashboard.php" class="hover:text-blue-600">Dashboard</a>
        <i class="fas fa-chevron-right mx-2 text-xs text-gray-400"></i>
        <a href="dashboard.php" class="hover:text-blue-600">Portfolio</a>
        <i class="fas fa-chevron-right mx-2 text-xs text-gray-400"></i>
        <span class="text-gray-800 font-medium">Stake #<?php echo $stake['id']; ?></span>
    </div>
    
    <!-- Main content -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Left Column - Summary Card -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-xl shadow-lg p-6 crypto-card">
                <h2 class="text-xl font-bold text-gray-800 mb-4 border-b pb-2"><?php echo $trans['stake_summary']; ?></h2>
                
                <div class="flex items-start justify-between mb-4">
                    <div>
                        <p class="text-gray-500 text-sm"><?php echo $trans['sessionType']; ?></p>
                        <p class="text-xl font-bold"><?php echo $stake['sessionType']; ?></p>
                    </div>
                    <div class="flex items-center justify-center w-12 h-12 rounded-full bg-blue-100">
                        <i class="fas fa-coins text-blue-500 text-xl"></i>
                    </div>
                </div>
                
                <div class="mb-6">
                    <p class="text-gray-500 text-sm"><?php echo $trans['convertedAmount']; ?></p>
                    <p class="text-2xl font-bold"><?php echo $stake['sessionCurrency'] . ' ' . $convertedAmount; ?></p>
                    <p class="text-gray-500 text-sm"><?php echo $trans['sessionDate']; ?>: <?php echo $sessionDate; ?></p>
                </div>
                
                <div>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium <?php echo $statusInfo['class']; ?>">
                        <i class="fas <?php echo $statusInfo['icon']; ?> mr-2 <?php echo $statusInfo['iconClass']; ?>"></i>
                        <?php echo $stake['status']; ?>
                    </span>
                </div>
            </div>
            
            <!-- Actions card -->
            <div class="bg-white rounded-xl shadow-lg p-6 mt-6 crypto-card">
                <h2 class="text-xl font-bold text-gray-800 mb-4 border-b pb-2"><?php echo $trans['actions']; ?></h2>
                
                <div class="space-y-3">
                    <a href="dashboard.php?lang=<?php echo $lang; ?>" 
                       class="flex items-center justify-between p-3 rounded-lg hover:bg-gray-50 transition w-full">
                        <div class="flex items-center">
                            <div class="bg-blue-100 p-2 rounded-full mr-3">
                                <i class="fas fa-arrow-left text-blue-500"></i>
                            </div>
                            <span><?php echo $trans['back']; ?></span>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </a>
                    
                    <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
                    <a href="edit_stake.php?id=<?php echo $stake['id']; ?>&lang=<?php echo $lang; ?>" 
                       class="flex items-center justify-between p-3 rounded-lg hover:bg-gray-50 transition w-full">
                        <div class="flex items-center">
                            <div class="bg-green-100 p-2 rounded-full mr-3">
                                <i class="fas fa-edit text-green-500"></i>
                            </div>
                            <span><?php echo $trans['edit']; ?></span>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </a>
                    
                    <button onclick="confirmDelete(<?php echo $stake['id']; ?>)" 
                            class="flex items-center justify-between p-3 rounded-lg hover:bg-gray-50 transition w-full text-left">
                        <div class="flex items-center">
                            <div class="bg-red-100 p-2 rounded-full mr-3">
                                <i class="fas fa-trash text-red-500"></i>
                            </div>
                            <span><?php echo $trans['delete']; ?></span>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Right Column - Details -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-xl shadow-lg p-6 crypto-card">
                <h2 class="text-xl font-bold text-gray-800 mb-6 border-b pb-2"><?php echo $trans['stake_details']; ?></h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Column 1 -->
                    <div class="space-y-4">
                        <div>
                            <p class="text-gray-500 text-sm"><?php echo $trans['id']; ?></p>
                            <p class="font-medium"><?php echo $stake['id']; ?></p>
                        </div>
                        
                        <div>
                            <p class="text-gray-500 text-sm"><?php echo $trans['name']; ?></p>
                            <p class="font-medium"><?php echo $stake['name']; ?></p>
                        </div>
                        
                        <div>
                            <p class="text-gray-500 text-sm"><?php echo $trans['email']; ?></p>
                            <p class="font-medium"><?php echo $stake['email']; ?></p>
                        </div>
                    </div>
                    
                    <!-- Column 2 -->
                    <div class="space-y-4">
                        <div>
                            <p class="text-gray-500 text-sm"><?php echo $trans['sessionType']; ?></p>
                            <p class="font-medium"><?php echo $stake['sessionType']; ?></p>
                        </div>
                        
                        <div>
                            <p class="text-gray-500 text-sm"><?php echo $trans['sessionCurrency']; ?></p>
                            <p class="font-medium"><?php echo $stake['sessionCurrency']; ?></p>
                        </div>
                        
                        <div>
                            <p class="text-gray-500 text-sm"><?php echo $trans['sessionAmount']; ?></p>
                            <p class="font-medium">$<?php echo $sessionAmount; ?></p>
                        </div>
                        
                        <div>
                            <p class="text-gray-500 text-sm"><?php echo $trans['convertedAmount']; ?></p>
                            <p class="font-medium"><?php echo $convertedAmount; ?><?php echo $stake['sessionCurrency']; ?></p>
                        </div>
                        
                        <div>
                            <p class="text-gray-500 text-sm"><?php echo $trans['sessionDate']; ?></p>
                            <p class="font-medium"><?php echo $sessionDate; ?></p>
                        </div>
                        
                        <div>
                            <p class="text-gray-500 text-sm"><?php echo $trans['status']; ?></p>
                            <p class="font-medium"><?php echo $stake['status']; ?></p>
                        </div>
                        
                        <?php if (!empty($stake['note'])): ?>
                        <div>
                            <p class="text-gray-500 text-sm"><?php echo $trans['note']; ?></p>
                            <p class="font-medium"><?php echo $stake['note']; ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript functions -->
<script>
    function closeToast() {
        document.getElementById('toast-alert').style.display = 'none';
    }
    
    function confirmDelete(id) {
        if (confirm("<?php echo $trans['confirm_delete']; ?>")) {
            window.location.href = "delete_stake.php?id=" + id + "&lang=<?php echo $lang; ?>";
        }
    }
</script>

<?php
// Include footer if needed
include_once './includes/footer.php';
?>
