<?php
session_start(); // Start the session to retrieve transaction data
error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: application/json');

// Check if transaction data exists in the session
if (isset($_SESSION['transaction_data'])) {
    $transaction_data = $_SESSION['transaction_data'];

    // Optionally, you can unset the session data after processing the transaction
    unset($_SESSION['transaction_data']);

    // Respond with the transaction details
    echo json_encode([
        "success" => true,
        "message" => "Transaction successfully submitted!",
        "transaction" => $transaction_data
    ]);
} else {
    echo json_encode([
        "error" => "Transaction data not found in session.",
        "code" => 400
    ]);
}
?>
