<?php
include 'action/check-login.php';
session_start();

// Handle AJAX request
if (isset($_POST['ajax']) && $_POST['ajax'] == 'verify_cot') {
    header('Content-Type: application/json');
    
    try {
        // Input validation
        if (empty($_POST['mtccode']) || empty($_POST['reset_token'])) {
            throw new Exception('Missing required parameters');
        }
        
        $mtccode = trim($_POST['mtccode']);
        $reset_token = trim($_POST['reset_token']);
        
        // Validate MTC code format (should be 4 digits)
        if (!preg_match('/^\d{4}$/', $mtccode)) {
            throw new Exception('Invalid COT code format. Must be 4 digits.');
        }
        
        // Get user email from session
        $user_email = '';
        if (isset($_SESSION['email']) && !empty($_SESSION['email'])) {
            $user_email = $_SESSION['email'];
        } elseif (isset($_SESSION['user_email']) && !empty($_SESSION['user_email'])) {
            $user_email = $_SESSION['user_email'];
        } else {
            throw new Exception('User email not found in session. Please login again.');
        }
        
        // Validate email format
        if (!filter_var($user_email, FILTER_VALIDATE_EMAIL)) {
            throw new Exception('Invalid email format in session');
        }
        
        // Database connection with error handling
        $servername = 'localhost';
        $dbname = 'ouxrysgh_dbb';
        $username = 'ouxrysgh_userb';
        $password = 'zaoix8Q45uD868e2';
        
        // Create connection with mysqli options
        $conn = new mysqli($servername, $username, $password, $dbname);
        
        // Set charset to prevent encoding issues
        $conn->set_charset("utf8");
        
        // Check connection
        if ($conn->connect_error) {
            throw new Exception('Database connection failed: ' . $conn->connect_error);
        }
        
        // Verify that the user exists and the MTC code matches for this specific user
        $stmt = $conn->prepare("SELECT id, email, mtccode FROM users WHERE email = ? AND mtccode = ? LIMIT 1");
        if (!$stmt) {
            throw new Exception('Prepare statement failed: ' . $conn->error);
        }
        
        $stmt->bind_param("ss", $user_email, $mtccode);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result && $result->num_rows > 0) {
            $user_data = $result->fetch_assoc();
            
            // MTC code is correct, update extra column to 'no' and clear mtccode
            $stmt_update = $conn->prepare("UPDATE users SET extra = 'no', mtccode = NULL WHERE email = ?");
            if (!$stmt_update) {
                throw new Exception('Prepare update statement failed: ' . $conn->error);
            }
            
            $stmt_update->bind_param("s", $user_email);
            
            if ($stmt_update->execute()) {
                // Check if any rows were actually updated
                if ($stmt_update->affected_rows > 0) {
                    echo json_encode([
                        'success' => true, 
                        'message' => ' code verified successfully! Account reactivated.',
                        'user_id' => $user_data['id']
                    ]);
                } else {
                    throw new Exception('No user found with the provided email or update failed');
                }
            } else {
                throw new Exception('Error updating user record: ' . $stmt_update->error);
            }
            
            $stmt_update->close();
        } else {
            // MTC code is incorrect or user doesn't exist
            echo json_encode([
                'success' => false, 
                'message' => 'Incorrect  code. Please check your code and try again.'
            ]);
        }
        
        $stmt->close();
        $conn->close();
        
    } catch (Exception $e) {
        // Log error for debugging (optional)
        error_log("COT Verification Error: " . $e->getMessage());
        
        echo json_encode([
            'success' => false, 
            'message' => 'An error occurred: ' . $e->getMessage()
        ]);
    }
    
    exit;
}

// Check if user is logged in
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] == false) {
    header("Location: logout.php");
    exit;
}
?>
<?php
// Enable error reporting (for development only)
// Remove or disable in production

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in; if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);
if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id      = $userDetails['google_id'];
$name           = $userDetails['name'];
$email          = $userDetails['email'];
$created_at     = $userDetails['created_at'];
$picture        = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin            = $userDetails['pin'];
$status         = $userDetails['status'];
$country        = $userDetails['country'];
$phone          = $userDetails['phone'];
$usd_balance    = isset($userDetails['balance']) ? (float)$userDetails['balance'] : 0.00;
$btc            = isset($userDetails['btc']) ? (float)$userDetails['btc'] : 0.000000;
$eth            = isset($userDetails['eth']) ? (float)$userDetails['eth'] : 0.000000;
$usdt           = isset($userDetails['usdt']) ? (float)$userDetails['usdt'] : 0.000000;
$xrp            = isset($userDetails['xrp']) ? (float)$userDetails['xrp'] : 0.000000;
$doge           = isset($userDetails['doge']) ? (float)$userDetails['doge'] : 0.000000;
$ada            = isset($userDetails['ada']) ? (float)$userDetails['ada'] : 0.000000;
$sol            = isset($userDetails['sol']) ? (float)$userDetails['sol'] : 0.000000;
$extra          = $userDetails['extra'];
$update_time    = $userDetails['update_time'];

// Define cache file and cache duration (2 hours)
$cache_file = "sol_price_cache.json";
$cache_duration = 7200; // 2 hours

// Function to fetch SOL price from CoinGecko API using cURL
function fetch_sol_price() {
    $api_url = "https://api.coingecko.com/api/v3/simple/price?ids=solana&vs_currencies=usd";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Only for development
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Timeout after 10 seconds
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Ensure response is valid and HTTP status code is 200 (OK)
    if ($http_code == 200 && $response) {
        return json_decode($response, true);
    }
    return false;
}

// Use cache if valid
if (file_exists($cache_file) && (time() - filemtime($cache_file)) < $cache_duration) {
    $data = json_decode(file_get_contents($cache_file), true);
} else {
    // Fetch fresh SOL price
    $data = fetch_sol_price();

    // Store new price in cache if valid
    if ($data && isset($data['solana']['usd'])) {
        file_put_contents($cache_file, json_encode($data));
    }
}

// Ensure SOL price is available
$sol_price = $data['solana']['usd'] ?? null;

// Function to generate a new MTC code for a user
function generateMTCCode($email, $conn) {
    // Generate a 4-digit random code
    $mtc_code = str_pad(rand(1000, 9999), 4, '0', STR_PAD_LEFT);
    
    // Update the user's MTC code in the database
    $stmt = $conn->prepare("UPDATE users SET mtccode = ? WHERE email = ?");
    if ($stmt) {
        $stmt->bind_param("ss", $mtc_code, $email);
        if ($stmt->execute()) {
            $stmt->close();
            return $mtc_code;
        }
        $stmt->close();
    }
    return false;
}

// Function to verify MTC code and update extra column
function verifyMTCAndUpdateExtra($email, $mtc_code, $conn) {
    // Verify the MTC code for this specific user
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ? AND mtccode = ? LIMIT 1");
    if (!$stmt) {
        return ['success' => false, 'message' => 'Database error'];
    }
    
    $stmt->bind_param("ss", $email, $mtc_code);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        // MTC code is correct, update extra to 'no' and clear mtccode
        $stmt_update = $conn->prepare("UPDATE users SET extra = 'no', mtccode = NULL WHERE email = ?");
        if (!$stmt_update) {
            $stmt->close();
            return ['success' => false, 'message' => 'Database error'];
        }
        
        $stmt_update->bind_param("s", $email);
        
        if ($stmt_update->execute() && $stmt_update->affected_rows > 0) {
            $stmt->close();
            $stmt_update->close();
            return ['success' => true, 'message' => 'MTC code verified successfully! Account reactivated.'];
        } else {
            $stmt->close();
            $stmt_update->close();
            return ['success' => false, 'message' => 'Failed to update user record'];
        }
    } else {
        $stmt->close();
        return ['success' => false, 'message' => 'Incorrect MTC code. Please check your code and try again.'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Account Suspension - Prime</title>
  <link rel="icon" type="image/png" href="favicon.png">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = 'b185b89eff779bf61a239a91251da652ef9b45cb';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>
  <!-- Sweet Alert -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  
  <!-- Animate.js -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/3.2.1/anime.min.js"></script>
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <style>
    :root {
      --primary: #2D77FF;
      --primary-dark: #1a5feb;
      --secondary: #6c757d;
      --success: #10b981;
      --danger: #dc2626;
      --warning: #f59e0b;
      --light: #f8f9fa;
      --dark: #1e293b;
      --gray: #6b7280;
      --light-gray: #e5e7eb;
    }
    
    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }
    
    @keyframes pulse {
      0%, 100% { opacity: 1; }
      50% { opacity: 0.7; }
    }
    
    @keyframes shake {
      0%, 100% { transform: translateX(0); }
      25% { transform: translateX(-5px); }
      75% { transform: translateX(5px); }
    }
    
    @keyframes fadeInUp {
      0% { 
        opacity: 0;
        transform: translateY(10px);
      }
      100% { 
        opacity: 1;
        transform: translateY(0);
      }
    }
    
    @keyframes float {
      0% { transform: translateY(0); }
      50% { transform: translateY(-10px); }
      100% { transform: translateY(0); }
    }
    
    .processing {
      animation: pulse 1.5s ease-in-out infinite;
    }
    
    .fade-in-up {
      animation: fadeInUp 0.3s ease-out;
    }
    
    .float {
      animation: float 3s ease-in-out infinite;
    }
    
    .faq-item {
      border-radius: 8px;
      background: #fff;
      box-shadow: 0 4px 6px rgba(0,0,0,0.05);
      margin-bottom: 1rem;
      overflow: hidden;
      transition: all 0.3s ease;
    }
    
    .faq-item:hover {
      box-shadow: 0 6px 12px rgba(0,0,0,0.08);
    }
    
    .faq-question {
      padding: 1rem 1.5rem;
      background: #f9fafb;
      cursor: pointer;
      display: flex;
      justify-content: space-between;
      align-items: center;
      font-weight: 600;
      color: var(--dark);
      transition: all 0.3s ease;
    }
    
    .faq-question:hover {
      background: #f0f7ff;
    }
    
    .faq-question i {
      transition: transform 0.3s ease;
    }
    
    .faq-answer {
      max-height: 0;
      overflow: hidden;
      padding: 0 1.5rem;
      background: #fff;
      transition: all 0.3s ease;
    }
    
    .faq-answer p {
      padding: 1rem 0;
      margin: 0;
      color: var(--gray);
      line-height: 1.6;
    }
    
    .faq-item.active .faq-question {
      background: #f0f7ff;
      color: var(--primary);
    }
    
    .faq-item.active .faq-question i {
      transform: rotate(180deg);
    }
    
    .faq-item.active .faq-answer {
      max-height: 500px;
      border-top: 1px solid var(--light-gray);
    }
    
    .account-status {
      display: inline-flex;
      align-items: center;
      gap: 0.5rem;
      padding: 0.5rem 1rem;
      border-radius: 50px;
      font-weight: 600;
      margin-bottom: 1.5rem;
    }
    
    .status-suspended {
      background: #fef2f2;
      color: var(--danger);
    }
    
    .status-inactive {
      background: #fffbeb;
      color: var(--warning);
    }
    
    .user-card {
      background: #fff;
      border-radius: 12px;
      padding: 1.5rem;
      box-shadow: 0 4px 12px rgba(0,0,0,0.05);
      margin-bottom: 1.5rem;
      width: 100%;
      max-width: 500px;
    }
    
    .user-row {
      display: flex;
      padding: 0.75rem 0;
      border-bottom: 1px solid #f3f4f6;
    }
    
    .user-row:last-child {
      border-bottom: none;
    }
    
    .user-label {
      flex: 1;
      color: var(--gray);
      font-weight: 500;
    }
    
    .user-value {
      flex: 1;
      font-weight: 600;
      color: var(--dark);
      text-align: right;
    }
    
    .btn {
      background: var(--primary);
      color: white;
      border: none;
      padding: 0.8rem 1.5rem;
      border-radius: 8px;
      font-weight: 600;
      cursor: pointer;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 0.5rem;
      transition: all 0.3s ease;
    }
    
    .btn:hover {
      background: var(--primary-dark);
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(45, 119, 255, 0.25);
    }
    
    .btn i {
      font-size: 1rem;
    }
    
    .ip-warning {
      background: #fffbeb;
      border-left: 4px solid var(--warning);
      padding: 1rem;
      border-radius: 0 8px 8px 0;
      margin: 1rem 0;
      display: flex;
      gap: 0.75rem;
    }
    
    .ip-warning i {
      color: var(--warning);
      font-size: 1.25rem;
    }
    
    .ip-warning-content h4 {
      margin: 0 0 0.25rem 0;
      color: var(--dark);
    }
    
    .ip-warning-content p {
      margin: 0;
      color: var(--gray);
      font-size: 0.9rem;
    }
  </style>
</head>
<body style="margin:0; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background-color: #e5eaf0;">

  <div id="mainContainer" style="display:flex; flex-direction:row; height:100vh; width:100%; flex-wrap:wrap; opacity:0;">

    <!-- Left Section -->
    <div style="flex:1 1 700px; min-width:320px; background:#fff; display:flex; flex-direction:column; justify-content:center; align-items:center; padding:2rem; overflow-y:auto;">

      <!-- Logo -->
      <img 
        src="https://bitnovaspro.com/session/logob.png" 
        alt="Logo"
        style="
          height: 40px;
          margin-bottom: 1rem;
          opacity: 1;
          filter: brightness(0) saturate(100%) invert(31%) sepia(83%) saturate(1485%) hue-rotate(213deg) brightness(101%) contrast(97%);
      "
      />

      <!-- Title -->
     
      
      <!-- Account Status -->
      <div class="account-status status-suspended">
        <i class="fas fa-exclamation-circle"></i>
        <span>Account Suspended</span>
      </div>

      <!-- Home Button - Top Left Corner -->
     <!-- Font Awesome for power icon -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<!-- SweetAlert2 for modal -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- Logout Button Fixed to Top-Left Corner -->
<div style="position:fixed; top:10px; left:10px; z-index:9999;">
  <button type="button" onclick="confirmLogout()" style="
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 32px;
    height: 32px;
    background-color: #ffffff;
    color: #dc2626;
    border: 1px solid #ef4444;
    border-radius: 9999px;
    transition: all 0.3s ease-in-out;
    transform-origin: center;
  "
    onmouseover="this.style.backgroundColor='#dc2626'; this.style.color='#ffffff'; this.style.transform='rotate(90deg)'"
    onmouseout="this.style.backgroundColor='#ffffff'; this.style.color='#dc2626'; this.style.transform='rotate(0deg)'"
  >
    <i class="fas fa-power-off" style="font-size:10px; transition: transform 0.3s ease-in-out;"></i>
  </button>
</div>

<!-- JavaScript Confirmation Function -->
<script>
  function confirmLogout() {
    Swal.fire({
      title: 'Are you sure you want to logout?',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, Logout',
      cancelButtonText: 'No, Stay Logged In',
      reverseButtons: true,
      buttonsStyling: false,
      customClass: {
        confirmButton: 'swal2-confirm-custom',
        cancelButton: 'swal2-cancel-custom'
      }
    }).then((result) => {
      if (result.isConfirmed) {
        window.location.href = 'logout.php';
      } else if (result.dismiss === Swal.DismissReason.cancel) {
        Swal.fire({
          icon: 'success',
          title: 'Success!',
          text: 'Continue your trade session.',
          timer: 2000,
          showConfirmButton: false
        });
      }
    });
  }
</script>

<!-- SweetAlert2 Custom Button Styles Inline -->
<style>
  .swal2-confirm-custom {
    background-color: #dc2626 !important;
    color: white !important;
    padding: 8px 16px;
    border-radius: 6px;
    font-weight: 500;
  }
  .swal2-confirm-custom:hover {
    background-color: #b91c1c !important;
  }

  .swal2-cancel-custom {
    background-color: #16a34a !important;
    color: white !important;
    padding: 8px 16px;
    border-radius: 6px;
    font-weight: 500;
    margin-left: 8px;
  }
  .swal2-cancel-custom:hover {
    background-color: #15803d !important;
  }
</style>


      <!-- User Information Card -->
      <div class="user-card">
        <div class="user-row">
          <div class="user-label">Name:</div>
          <div class="user-value"><?php echo htmlspecialchars($name); ?></div>
        </div>
        <div class="user-row">
          <div class="user-label">Email:</div>
          <div class="user-value"><?php echo htmlspecialchars($email); ?></div>
        </div>
        <div class="user-row">
          <div class="user-label">Account Status:</div>
          <div class="user-value" style="color: var(--danger);">Suspended</div>
        </div>
        <div class="user-row">
          <div class="user-label">Last Activity:</div>
          <div class="user-value"><?php echo date('M d, Y H:i', strtotime($update_time)); ?></div>
        </div>
      </div>
      
      
   

     <!-- TOKEN Submission Form -->
<form id="cotForm" style="width:100%; max-width:320px; display:flex; flex-direction:column; align-items:center; padding:1rem;">

  <!-- Prompt -->
  <div id="suspendPrompt" style="text-align:center; margin:1rem 0; color:#9ca3af; font-size:0.95rem; opacity:1;">
    Input a Valid Reactivation Code
  </div>

  <!-- TOKEN Input Boxes -->
  <div style="width:100%; margin-bottom:1.5rem;">
    <div style="display:flex; justify-content:center; gap:0.75rem; margin-bottom:0.5rem;">
      <input class="suspend-input" type="text" maxlength="1" inputmode="numeric" pattern="[0-9]" autocomplete="off" style="width:60px; height:60px; border:2px solid #d1d5db; border-radius:8px; text-align:center; font-size:1.5rem; font-weight:600; color:#1e293b; background:#fff; outline:none; transition: all 0.3s ease;">
      <input class="suspend-input" type="text" maxlength="1" inputmode="numeric" pattern="[0-9]" autocomplete="off" style="width:60px; height:60px; border:2px solid #d1d5db; border-radius:8px; text-align:center; font-size:1.5rem; font-weight:600; color:#1e293b; background:#fff; outline:none; transition: all 0.3s ease;">
      <input class="suspend-input" type="text" maxlength="1" inputmode="numeric" pattern="[0-9]" autocomplete="off" style="width:60px; height:60px; border:2px solid #d1d5db; border-radius:8px; text-align:center; font-size:1.5rem; font-weight:600; color:#1e293b; background:#fff; outline:none; transition: all 0.3s ease;">
      <input class="suspend-input" type="text" maxlength="1" inputmode="numeric" pattern="[0-9]" autocomplete="off" style="width:60px; height:60px; border:2px solid #d1d5db; border-radius:8px; text-align:center; font-size:1.5rem; font-weight:600; color:#1e293b; background:#fff; outline:none; transition: all 0.3s ease;">
    </div>
    <div style="text-align:center; color:#6b7280; font-size:0.8rem;">
      Enter your 4-digit Reactivation code
    </div>
    <div id="errorMessage" style="display:none; text-align:center; color:#dc2626; font-size:0.75rem; margin-top:0.5rem; font-weight:500;"></div>
  </div>

  <!-- Loading indicator -->
  <div id="loadingIndicator" style="display:none; text-align:center; margin-bottom:1rem;">
    <div style="display:inline-flex; align-items:center; gap:0.5rem; color:#2563eb; font-size:0.9rem;">
      <svg style="width:20px; height:20px; fill:#2563eb; animation:spin 1s linear infinite;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
        <path d="M12 4V2A10 10 0 0 0 2 12h2a8 8 0 0 1 8-8z"/>
      </svg>
      Verifying code...
    </div>
  </div>

</form>

<!-- Inline CSS animation -->
<style>
@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}
</style>

   <script>
    let isVerifying = false;
    let verificationTimeout;

    window.onload = () => {
      // Fade in container
      anime({
        targets: '#mainContainer',
        opacity: [0, 1],
        duration: 800,
        easing: 'easeOutQuad'
      });

      // Stagger in all children with enhanced timing
      anime.timeline({ easing: 'easeOutQuad' })
        .add({
          targets: '#mainContainer img',
          opacity: [0, 1],
          translateY: [-30, 0],
          scale: [0.8, 1],
          duration: 600,
          delay: 300
        })
        .add({
          targets: '#mainContainer h2',
          opacity: [0, 1],
          translateY: [20, 0],
          duration: 500,
          delay: 100
        })
        .add({
          targets: '#mainContainer .home-btn',
          opacity: [0, 1],
          translateY: [-20, 0],
          scale: [0.8, 1],
          duration: 500,
          delay: 200
        })
        .add({
          targets: '#mainContainer div[style*="opacity:0;"]:not(.btn):not(.btn-small)',
          opacity: [0, 1],
          translateY: [15, 0],
          duration: 500,
          delay: anime.stagger(100, { start: 0 })
        })
        .add({
          targets: '#mainContainer > div:last-child',
          opacity: [0, 1],
          translateX: [50, 0],
          duration: 600,
          delay: 0
        });

      // Enhanced button hover animations
      document.querySelectorAll('.btn, .btn-small').forEach(btn => {
        btn.addEventListener('mouseenter', () => {
          if (!btn.disabled) {
            anime({
              targets: btn,
              scale: 1.05,
              boxShadow: ['0 0 0 rgba(0,0,0,0)', '0 8px 16px rgba(0,0,0,0.2)'],
              duration: 300,
              easing: 'easeOutQuad'
            });
          }
        });
        btn.addEventListener('mouseleave', () => {
          anime({
            targets: btn,
            scale: 1,
            boxShadow: ['0 8px 16px rgba(0,0,0,0.2)', '0 0 0 rgba(0,0,0,0)'],
            duration: 300,
            easing: 'easeOutQuad'
          });
        });
      });

      // COT Input functionality
      const cotInputs = document.querySelectorAll('.suspend-input');
      const errorMessage = document.getElementById('errorMessage');
      const loadingIndicator = document.getElementById('loadingIndicator');
      
      cotInputs.forEach((input, index) => {
        // Prevent mobile keyboard from showing on page load
        input.setAttribute('readonly', 'true');
        
        // Enable input when clicked/tapped
        input.addEventListener('click', function() {
          this.removeAttribute('readonly');
          this.focus();
        });
        
        input.addEventListener('input', function(e) {
          // Clear error states
          clearErrorStates();
          
          // Only allow numbers
          this.value = this.value.replace(/[^0-9]/g, '');
          
          // Move to next input if current is filled
          if (this.value.length === 1) {
            this.classList.add('filled');
            if (index < cotInputs.length - 1) {
              cotInputs[index + 1].removeAttribute('readonly');
              cotInputs[index + 1].focus();
            }
          } else {
            this.classList.remove('filled');
          }
          
          // Check if all inputs are filled and auto-verify
          if (checkAllInputsFilled()) {
            autoVerifyCOT();
          }
        });
        
        input.addEventListener('keydown', function(e) {
          // Clear error states on any key press
          clearErrorStates();
          
          // Handle backspace
          if (e.key === 'Backspace' && this.value === '' && index > 0) {
            cotInputs[index - 1].removeAttribute('readonly');
            cotInputs[index - 1].focus();
            cotInputs[index - 1].classList.remove('filled');
            cotInputs[index - 1].value = '';
          }
          
          // Handle arrow keys
          if (e.key === 'ArrowLeft' && index > 0) {
            cotInputs[index - 1].removeAttribute('readonly');
            cotInputs[index - 1].focus();
          }
          if (e.key === 'ArrowRight' && index < cotInputs.length - 1) {
            cotInputs[index + 1].removeAttribute('readonly');
            cotInputs[index + 1].focus();
          }
        });
        
        input.addEventListener('paste', function(e) {
          e.preventDefault();
          clearErrorStates();
          
          const pasteData = e.clipboardData.getData('text').replace(/[^0-9]/g, '');
          
          for (let i = 0; i < Math.min(pasteData.length, cotInputs.length - index); i++) {
            cotInputs[index + i].removeAttribute('readonly');
            cotInputs[index + i].value = pasteData[i];
            cotInputs[index + i].classList.add('filled');
          }
          
          if (checkAllInputsFilled()) {
            autoVerifyCOT();
          }
        });
      });
      
      function checkAllInputsFilled() {
        return Array.from(cotInputs).every(input => input.value.length === 1);
      }
      
      function getCotCode() {
        return Array.from(cotInputs).map(input => input.value).join('');
      }
      
      function clearErrorStates() {
        errorMessage.style.display = 'none';
        cotInputs.forEach(input => {
          input.classList.remove('error', 'success');
        });
      }
      
      function showError(message) {
        errorMessage.textContent = message;
        errorMessage.style.display = 'block';
        errorMessage.classList.add('fade-in-up');
        
        cotInputs.forEach(input => {
          input.classList.add('error');
        });
        
        // Shake animation
        anime({
          targets: cotInputs,
          translateX: [0, -10, 10, -10, 10, 0],
          duration: 500,
          easing: 'easeOutQuad'
        });
      }
      
      function showSuccess() {
        cotInputs.forEach(input => {
          input.classList.add('success');
        });
        
        // Success animation
        anime({
          targets: cotInputs,
          scale: [1, 1.1, 1],
          duration: 600,
          easing: 'easeOutQuad'
        });
      }
      
      // Function to get the intended destination URL
      function getRedirectUrl() {
        // Try to get the redirect URL from various sources
        const urlParams = new URLSearchParams(window.location.search);
        const redirectUrl = urlParams.get('redirect') || urlParams.get('return_url') || urlParams.get('continue');
        
        if (redirectUrl) {
          // Decode the URL if it's encoded
          try {
            return decodeURIComponent(redirectUrl);
          } catch (e) {
            console.warn('Failed to decode redirect URL:', redirectUrl);
            return redirectUrl;
          }
        }
        
        // Check if there's a stored intended destination
        const storedDestination = sessionStorage.getItem('intended_destination') || 
                                 localStorage.getItem('intended_destination');
        
        if (storedDestination) {
          return storedDestination;
        }
        
        // Check document.referrer (previous page)
        if (document.referrer && document.referrer !== window.location.href) {
          return document.referrer;
        }
        
        // Check browser history if available
        if (window.history.length > 1) {
          // We can't directly access history entries, but we can go back
          return 'HISTORY_BACK';
        }
        
        // Default fallback - you can change this to your preferred default page
        return 'dashboard.php'; // or 'index.php' or wherever you want to redirect by default
      }
      
      // Function to perform the redirect
      function performRedirect() {
        const redirectUrl = getRedirectUrl();
        
        if (redirectUrl === 'HISTORY_BACK') {
          // Go back in history
          window.history.back();
        } else {
          // Redirect to the specified URL
          window.location.href = redirectUrl;
        }
        
        // Clean up stored destination
        sessionStorage.removeItem('intended_destination');
        localStorage.removeItem('intended_destination');
      }
      
      function autoVerifyCOT() {
        if (isVerifying) return;
        
        const cotCode = getCotCode();
        if (cotCode.length !== 4) return;
        
        // Clear any existing timeout
        if (verificationTimeout) {
          clearTimeout(verificationTimeout);
        }
        
        // Add slight delay to prevent too frequent requests
        verificationTimeout = setTimeout(() => {
          verifyCOT(cotCode);
        }, 500);
      }
      
      function verifyCOT(cotCode) {
        isVerifying = true;
        
        // Show loading indicator
        loadingIndicator.style.display = 'block';
        anime({
          targets: loadingIndicator,
          opacity: [0, 1],
          translateY: [10, 0],
          duration: 300,
          easing: 'easeOutQuad'
        });
        
        // Disable inputs during verification
        cotInputs.forEach(input => {
          input.style.pointerEvents = 'none';
          input.style.opacity = '0.7';
        });
        
        // AJAX request with improved error handling
        const xhr = new XMLHttpRequest();
        xhr.open('POST', '', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        
        // Set timeout for request
        xhr.timeout = 30000; // 30 seconds
        
        xhr.onreadystatechange = function() {
          if (xhr.readyState === 4) {
            isVerifying = false;
            
            // Hide loading indicator
            anime({
              targets: loadingIndicator,
              opacity: [1, 0],
              translateY: [0, -10],
              duration: 300,
              easing: 'easeInQuad',
              complete: () => {
                loadingIndicator.style.display = 'none';
              }
            });
            
            // Re-enable inputs
            cotInputs.forEach(input => {
              input.style.pointerEvents = 'auto';
              input.style.opacity = '1';
            });
            
            if (xhr.status === 200) {
              try {
                const response = JSON.parse(xhr.responseText);
                
                if (response.success) {
                  showSuccess();
                  
                  // Show Sweet Alert success
                  Swal.fire({
                    title: 'Success!',
                    text: response.message,
                    icon: 'success',
                    confirmButtonText: 'Continue',
                    confirmButtonColor: '#2563eb',
                    allowOutsideClick: false,
                    allowEscapeKey: false,
                    showClass: {
                      popup: 'animate__animated animate__fadeInDown'
                    },
                    hideClass: {
                      popup: 'animate__animated animate__fadeOutUp'
                    }
                  }).then((result) => {
                    if (result.isConfirmed) {
                      // Redirect to the intended destination instead of crypto.php
                      performRedirect();
                    }
                  });
                } else {
                  showError(response.message || 'An error occurred. Please try again.');
                }
              } catch (e) {
                console.error('JSON Parse Error:', e);
                showError('Invalid response from server. Please try again.');
              }
            } else {
              console.error('HTTP Error:', xhr.status, xhr.statusText);
              showError(`Network error (${xhr.status}). Please check your connection and try again.`);
            }
          }
        };
        
        xhr.ontimeout = function() {
          isVerifying = false;
          // Hide loading indicator
          anime({
            targets: loadingIndicator,
            opacity: [1, 0],
            translateY: [0, -10],
            duration: 300,
            easing: 'easeInQuad',
            complete: () => {
              loadingIndicator.style.display = 'none';
            }
          });
          
          // Re-enable inputs
          cotInputs.forEach(input => {
            input.style.pointerEvents = 'auto';
            input.style.opacity = '1';
          });
          
          showError('Request timed out. Please try again.');
        };
        
        xhr.onerror = function() {
          isVerifying = false;
          // Hide loading indicator
          anime({
            targets: loadingIndicator,
            opacity: [1, 0],
            translateY: [0, -10],
            duration: 300,
            easing: 'easeInQuad',
            complete: () => {
              loadingIndicator.style.display = 'none';
            }
          });
          
          // Re-enable inputs
          cotInputs.forEach(input => {
            input.style.pointerEvents = 'auto';
            input.style.opacity = '1';
          });
          
          showError('Network error. Please check your connection and try again.');
        };
        
        xhr.send(`ajax=verify_cot&mtccode=${encodeURIComponent(cotCode)}&reset_token=no`);
      }

      // Enhanced input focus animations
      cotInputs.forEach(input => {
        input.addEventListener('focus', () => {
          anime({
            targets: input,
            borderColor: '#2563eb',
            boxShadow: ['0 0 0 rgba(37, 99, 235, 0)', '0 0 0 3px rgba(37, 99, 235, 0.1)'],
            duration: 300,
            easing: 'easeOutQuad'
          });
        });
        
        input.addEventListener('blur', () => {
          anime({
            targets: input,
            borderColor: input.value ? '#2563eb' : '#d1d5db',
            boxShadow: ['0 0 0 3px rgba(37, 99, 235, 0.1)', '0 0 0 rgba(37, 99, 235, 0)'],
            duration: 300,
            easing: 'easeOutQuad'
          });
        });
      });

      // Modal functionality
      const modal = document.getElementById('modalOverlay');
      const modalContent = document.getElementById('modalContent');
      const supportLink = document.getElementById('supportLink');
      const closeModal = document.getElementById('closeModal');

      function openModal() {
        modal.style.display = 'block';
        anime({
          targets: modal,
          opacity: [0, 1],
          duration: 300,
          easing: 'easeOutQuad'
        });
        anime({
          targets: modalContent,
          scale: [0.8, 1],
          opacity: [0, 1],
          duration: 400,
          delay: 100,
          easing: 'easeOutBack'
        });
      }

      function closeModalFunc() {
        anime({
          targets: modalContent,
          scale: [1, 0.8],
          opacity: [1, 0],
          duration: 300,
          easing: 'easeInQuad'
        });
        anime({
          targets: modal,
          opacity: [1, 0],
          duration: 300,
          delay: 100,
          easing: 'easeInQuad',
          complete: () => {
            modal.style.display = 'none';
          }
        });
      }

      if (supportLink) {
        supportLink.addEventListener('click', (e) => {
          e.preventDefault();
          openModal();
        });
      }

      if (closeModal) {
        closeModal.addEventListener('click', closeModalFunc);
      }

      if (modal) {
        modal.addEventListener('click', (e) => {
          if (e.target === modal) {
            closeModalFunc();
          }
        });
      }

      // Add pulse animation to support link
      if (document.getElementById('supportLink')) {
        anime({
          targets: '#supportLink',
          scale: [1, 1.02, 1],
          duration: 2000,
          loop: true,
          easing: 'easeInOutQuad'
        });
      }

      // Add floating animation to logo
      anime({
        targets: '#mainContainer img',
        translateY: [0, -5, 0],
        duration: 3000,
        loop: true,
        easing: 'easeInOutQuad'
      });

      // Add subtle breathing animation to COT inputs when empty
      anime({
        targets: '.suspend-input:not(.filled)',
        scale: [1, 1.01, 1],
        duration: 2500,
        loop: true,
        easing: 'easeInOutQuad'
      });

      // Keyboard accessibility
      document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape' && modal && modal.style.display === 'block') {
          closeModalFunc();
        }
      });

      // Focus first input on page load
      setTimeout(() => {
        cotInputs[0].removeAttribute('readonly');
        cotInputs[0].focus();
      }, 1000);
    };
  </script>


<!-- Font Awesome for warning icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<!-- Tailwind CSS (optional) -->
<script src="https://cdn.tailwindcss.com"></script>

<!-- Section Container -->
<div class="max-w-xl mx-auto mt-8 px-4">
  <!-- Static Heading -->
  <h5>
    Popular Reasons for Account Suspension
  </h5>

  <!-- IP Warning Card -->
  <div id="ipWarningCard" class="ip-warning flex items-start space-x-3 bg-yellow-100 border-l-4 border-yellow-500 text-yellow-700 p-4 rounded-md shadow-md transition-colors duration-700 ease-in-out">
    <i id="ipIcon" class="fas fa-exclamation-triangle text-2xl mt-1"></i>
    <div class="ip-warning-content">
      <h5 id="ipWarningHeading" class="font-bold text-lg mb-1 transition-opacity duration-500 ease-in-out opacity-100">
        IP Discrepancy Detected
      </h5>
      <p id="ipWarningMessage" class="transition-opacity duration-500 ease-in-out opacity-100">
        Your account was accessed from an unusual location. This may be the reason for suspension.
      </p>
    </div>
  </div>
</div>

<!-- Sliding Script -->
<script>
  const warningContent = [
    {
      heading: "IP Discrepancy Detected",
      message: "Your account was accessed from an unusual location. This may be the reason for suspension.",
      bg: "bg-yellow-100",
      border: "border-yellow-500",
      text: "text-yellow-700",
      icon: "fa-exclamation-triangle"
    },
    {
      heading: "Policy Violation Alert",
      message: "Suspension may result from activities that violate government-imposed internet usage restrictions.",
      bg: "bg-red-100",
      border: "border-red-500",
      text: "text-red-700",
      icon: "fa-shield-alt"
    },
    {
      heading: "Country Privacy Breach",
      message: "Access attempts from regions with strict country-specific privacy laws may trigger automatic review.",
      bg: "bg-purple-100",
      border: "border-purple-500",
      text: "text-purple-700",
      icon: "fa-user-secret"
    },
    {
      heading: "Anonymous Access Detected",
      message: "Violating our terms through the use of VPNs or anonymizers from blacklisted countries may cause flagging.",
      bg: "bg-blue-100",
      border: "border-blue-500",
      text: "text-blue-700",
      icon: "fa-mask"
    }
  ];

  let index = 0;

  const cardEl = document.getElementById("ipWarningCard");
  const headingEl = document.getElementById("ipWarningHeading");
  const messageEl = document.getElementById("ipWarningMessage");
  const iconEl = document.getElementById("ipIcon");

  function updateCard() {
    headingEl.classList.remove("opacity-100");
    messageEl.classList.remove("opacity-100");
    headingEl.classList.add("opacity-0");
    messageEl.classList.add("opacity-0");

    setTimeout(() => {
      index = (index + 1) % warningContent.length;
      const item = warningContent[index];

      headingEl.textContent = item.heading;
      messageEl.textContent = item.message;
      iconEl.className = `fas ${item.icon} text-2xl mt-1`;

      cardEl.className = `ip-warning flex items-start space-x-3 p-4 rounded-md shadow-md transition-colors duration-700 ease-in-out ${item.bg} ${item.border} ${item.text}`;

      headingEl.classList.remove("opacity-0");
      messageEl.classList.remove("opacity-0");
      headingEl.classList.add("opacity-100");
      messageEl.classList.add("opacity-100");
    }, 500);
  }

  setInterval(updateCard, 4000);
</script>

      <!-- FAQ Section -->
      <div style="width:100%; max-width:500px; margin-bottom:1.5rem;">
        <h3 style="text-align:center; color:var(--dark); margin-bottom:1.5rem;">Frequently Asked Questions</h3>
        
        <div class="faq-container">
          <!-- FAQ 1 -->
          <div class="faq-item">
            <div class="faq-question">
              Why is my Forex/Crypto account suspended?
              <i class="fas fa-chevron-down"></i>
            </div>
            <div class="faq-answer">
              <p>Your account may have been suspended for several reasons, including but not limited to: suspicious activity, violation of terms, security concerns, or prolonged inactivity. This is a protective measure to safeguard your funds and personal information.</p>
            </div>
          </div>
          
          <!-- FAQ 2 -->
          <div class="faq-item">
            <div class="faq-question">
              What is IP discrepancy?
              <i class="fas fa-chevron-down"></i>
            </div>
            <div class="faq-answer">
              <p>IP discrepancy occurs when our system detects that your account is being accessed from an unusual location or multiple locations in a short timeframe. This security measure protects your account from unauthorized access and potential fraud.</p>
            </div>
          </div>
          
          <!-- FAQ 3 -->
          <div class="faq-item">
            <div class="faq-question">
              How long does account suspension last?
              <i class="fas fa-chevron-down"></i>
            </div>
            <div class="faq-answer">
              <p>Suspension duration varies based on the reason for suspension. Most suspensions are temporary and last between 24-72 hours. For security-related suspensions, we require identity verification before reactivation.</p>
            </div>
          </div>
          
          <!-- FAQ 4 -->
          <div class="faq-item">
            <div class="faq-question">
              How can I reactivate my account?
              <i class="fas fa-chevron-down"></i>
            </div>
            <div class="faq-answer">
              <p>To reactivate your account, please contact our support team with the required activation code.</p>
            </div>
          </div>
          
          <!-- FAQ 5 -->
          <div class="faq-item">
            <div class="faq-question">
              What happens to my funds during suspension?
              <i class="fas fa-chevron-down"></i>
            </div>
            <div class="faq-answer">
              <p>All funds remain secure during suspension. You cannot trade or withdraw during this period, but your portfolio value is preserved. Upon reactivation, you'll regain full access to your funds.</p>
            </div>
          </div>
          
          <!-- FAQ 6 -->
          <div class="faq-item">
            <div class="faq-question">
              How can I prevent future suspensions?
              <i class="fas fa-chevron-down"></i>
            </div>
            <div class="faq-answer">
              <p>Avoid Violating platform policies, keep your contact information updated, avoid accessing your account from multiple locations simultaneously, and maintain regular activity on your account.</p>
            </div>
          </div>
          
          <!-- FAQ 7 -->
          <div class="faq-item">
            <div class="faq-question">
              Can I access my transaction history during suspension?
              <i class="fas fa-chevron-down"></i>
            </div>
            <div class="faq-answer">
              <p>While you can't perform transactions during suspension, you cannot still view your account history, portfolio, and past transactions. This information remains inaccessible .</p>
            </div>
          </div>
        </div>
      </div>

      <!-- Contact Support Button -->
      <button id="contactSupport" class="btn">
        <i class="fas fa-headset"></i>
        Contact Support
      </button>

      <!-- Footer -->
      <div style="font-size:0.85rem; color:#6b7280; opacity:0; margin-top:1.5rem;">
        Need immediate assistance? 
        <a id="" style="color:#2563eb; text-decoration:; cursor:pointer;">Open Live Chat</a>
      </div>
    </div>

    <!-- Right Section -->
    <div style="flex:1 1 500px; min-width:320px; background:#2563eb; color:white; display:flex; align-items:center; justify-content:center; flex-direction:column; padding:2rem; position:relative; opacity:0;">
      <div style="text-align:center; max-width:400px;">
        <h3 style="font-size:1.5rem; margin-bottom:1rem;">Account Security</h3>
        <p style="font-size:1rem; color:#e0e7ff; line-height:1.6;">We take security seriously to protect your assets and personal information. Account suspensions are precautionary measures to prevent unauthorized access and ensure regulatory compliance.</p>
      </div>
      
      <!-- Security Illustration -->
      <div style="margin-top:2rem; text-align:center;" class="float">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" style="width:120px; height:120px; fill:white; opacity:0.9;">
          <path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z"/>
          <path d="M11 7h2v6h-2zm0 8h2v2h-2z" fill="#e0e7ff"/>
        </svg>
      </div>
      
      <!-- Security Tips -->
      <div style="position:absolute; bottom:2rem; left:0; right:0; text-align:center;">
        <p style="font-size:0.9rem; color:#a5b4fc;">
          <i class="fas fa-shield-alt"></i> Security Tip: Always log out from public computers
        </p>
      </div>
    </div>

  </div>

  <!-- Modal -->
  <div id="modalOverlay" style="position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); display:none; z-index:1000; opacity:0;">
    <div id="modalContent" style="position:absolute; top:50%; left:50%; transform:translate(-50%, -50%) scale(0.8); background:white; padding:2rem; border-radius:12px; max-width:400px; width:90%; text-align:center; box-shadow:0 10px 30px rgba(0,0,0,0.3);">
      <div style="margin-bottom:1.5rem;">
        <svg style="width:48px; height:48px; fill:#2563eb; margin:0 auto 1rem;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
          <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
        </svg>
        <h3 style="color:#1e293b; margin-bottom:0.5rem;">Contact Support</h3>
        <p style="color:#6b7280; margin-bottom:1.5rem;">Our support team will help you resolve the account suspension issue.</p>
      </div>
      
      <div style="background:#f8fafc; padding:1rem; border-radius:8px; margin-bottom:1.5rem;">
        <p style="margin:0; color:#1e293b; font-weight:600;">Support Email:</p>
        <a href="mailto:support@bitnovaspro.com" style="color:#2563eb; text-decoration:none; font-weight:500;">support@bitnovaspro.com</a>
        <p style="margin:1rem 0 0; color:#1e293b; font-weight:600;">Live Chat:</p>
        <p style="margin:0; color:#2563eb; font-weight:500;">Available 24/7</p>
      </div>
      
      <div style="display:flex; gap:0.75rem; justify-content:center;">
        <button id="closeModal" style="background:#f3f4f6; color:#374151; border:none; padding:0.5rem 1rem; border-radius:6px; cursor:pointer; font-weight:500;">
          Close
        </button>
        <a href="mailto:support@bitnovaspro.com" style="background:#2563eb; color:white; border:none; padding:0.5rem 1rem; border-radius:6px; cursor:pointer; font-weight:500; text-decoration:none; display:inline-block;">
          Send Email
        </a>
      </div>
    </div>
  </div>

  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // Fade in container
      anime({
        targets: '#mainContainer',
        opacity: [0, 1],
        duration: 800,
        easing: 'easeOutQuad'
      });

      // Stagger animations for page elements
      anime.timeline({ easing: 'easeOutQuad' })
        .add({
          targets: '#mainContainer img',
          opacity: [0, 1],
          translateY: [-30, 0],
          scale: [0.8, 1],
          duration: 600,
          delay: 300
        })
        .add({
          targets: '#mainContainer h2',
          opacity: [0, 1],
          translateY: [20, 0],
          duration: 500,
          delay: 100
        })
        .add({
          targets: '#mainContainer .home-btn',
          opacity: [0, 1],
          translateY: [-20, 0],
          scale: [0.8, 1],
          duration: 500,
          delay: 200
        })
        .add({
          targets: '.account-status, .user-card, .ip-warning, .faq-container, #contactSupport, #mainContainer > div:last-child div',
          opacity: [0, 1],
          translateY: [15, 0],
          duration: 500,
          delay: anime.stagger(100, { start: 0 })
        })
        .add({
          targets: '#mainContainer > div:last-child',
          opacity: [0, 1],
          translateX: [50, 0],
          duration: 600,
          delay: 0
        });

      // FAQ toggle functionality
      const faqItems = document.querySelectorAll('.faq-item');
      faqItems.forEach(item => {
        const question = item.querySelector('.faq-question');
        question.addEventListener('click', () => {
          const isActive = item.classList.contains('active');
          
          // Close all items first
          faqItems.forEach(faq => {
            faq.classList.remove('active');
          });
          
          // Open current item if it wasn't active
          if (!isActive) {
            item.classList.add('active');
          }
        });
      });

      // Modal functionality
      const modal = document.getElementById('modalOverlay');
      const modalContent = document.getElementById('modalContent');
      const supportLink = document.getElementById('supportLink');
      const contactSupport = document.getElementById('contactSupport');
      const closeModal = document.getElementById('closeModal');

      function openModal() {
        modal.style.display = 'block';
        anime({
          targets: modal,
          opacity: [0, 1],
          duration: 300,
          easing: 'easeOutQuad'
        });
        anime({
          targets: modalContent,
          scale: [0.8, 1],
          opacity: [0, 1],
          duration: 400,
          delay: 100,
          easing: 'easeOutBack'
        });
      }

      function closeModalFunc() {
        anime({
          targets: modalContent,
          scale: [1, 0.8],
          opacity: [1, 0],
          duration: 300,
          easing: 'easeInQuad'
        });
        anime({
          targets: modal,
          opacity: [1, 0],
          duration: 300,
          delay: 100,
          easing: 'easeInQuad',
          complete: () => {
            modal.style.display = 'none';
          }
        });
      }

      // Support link event listeners
      if (supportLink) {
        supportLink.addEventListener('click', (e) => {
          e.preventDefault();
          openModal();
        });
      }

      if (contactSupport) {
        contactSupport.addEventListener('click', (e) => {
          e.preventDefault();
          openModal();
        });
      }

      if (closeModal) {
        closeModal.addEventListener('click', closeModalFunc);
      }

      if (modal) {
        modal.addEventListener('click', (e) => {
          if (e.target === modal) {
            closeModalFunc();
          }
        });
      }

      // Add pulse animation to contact button
      if (contactSupport) {
        anime({
          targets: contactSupport,
          scale: [1, 1.02, 1],
          duration: 2000,
          loop: true,
          easing: 'easeInOutQuad'
        });
      }

      // Add floating animation to security icon
      anime({
        targets: '.float',
        translateY: [0, -10, 0],
        duration: 3000,
        loop: true,
        easing: 'easeInOutQuad'
      });

      // Keyboard accessibility
      document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape' && modal && modal.style.display === 'block') {
          closeModalFunc();
        }
      });
    });
  </script>
</body>
</html>