<?php
// Enable full error reporting (for development only, remove or disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../session.php'; // Include session.php to manage session and database

// Ensure the user is logged in, if not, redirect to login page
if (!isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

// Fetch user details from the session and database
$userDetails = getUserDetails($conn);

if ($userDetails === null) {
    die('User not found or session expired.');
}

// Extract user data into variables
$google_id     = $userDetails['google_id'];
$name          = $userDetails['name'];
$email         = $userDetails['email'];
$created_at    = $userDetails['created_at'];
$picture       = $userDetails['picture'];
$email_verified = $userDetails['email_verified'];
$pin           = $userDetails['pin'];
$status        = $userDetails['status'];
$country       = $userDetails['country'];
$phone         = $userDetails['phone'];
$balance       = $userDetails['balance'];
$btc           = $userDetails['btc'];
$eth           = $userDetails['eth'];
$usdt          = $userDetails['usdt'];
$xrp           = $userDetails['xrp'];
$extra         = $userDetails['extra'];
$update_time   = $userDetails['update_time'];
?>

<?php include './includes/header.php'; ?>



<body onload="initialize()">
    
 <?php include './includes/nav.php'; ?>
    <div class="w-full min-h-screen flex flex-col">
        <!-- Header -->
        <div class="blue-gradient text-white px-6 py-4 text-center">
            <h1 class="text-2xl font-bold">Secure Verification Portal</h1>
            <p class="text-blue-100">Complete your verification to unlock full platform access</p>
        </div>
        
        <!-- Navigation Tabs -->
        <div class="flex gap-2 border-b border-blue-200 bg-white overflow-x-auto sticky top-0 z-10 shadow-sm">
            <button type="button" class="tab-active px-6 py-3 text-sm">Verification</button>
            <button type="button" class="tab-inactive px-6 py-3 text-sm">2FA</button>
          
            <button type="button" class="tab-inactive px-6 py-3 text-sm">Account Deletion</button>
        </div>

        <!-- Main Content -->
        <div class="w-full flex p-6 flex-col h-full">
            <div class="mx-auto">
                            <div class="bg-white rounded-lg p-8 text-center card-shadow">
                                <div class="flex flex-col justify-center items-center">
                                    <div class="bg-blue-100 text-blue-600 p-5 rounded-full">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-14 w-14" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                        </svg>
                                    </div>
                                    <h3 class="text-blue-800 text-2xl font-bold my-5">Verification Required</h3>
                                    <p class="text-lg text-blue-700 mb-4">You haven't submitted your necessary documents to verify your identity yet.</p>
                                    <p class="text-md text-blue-600 mb-6">Complete verification now to gain full access to our platform's features and benefits.</p>
                                    
                                    <a href="verification.php">
    <button class="flex items-center bg-blue-400 text-white font-semibold py-2 px-4 rounded-lg shadow-md hover:bg-blue-500 active:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-400 focus:ring-opacity-50 transition-all duration-300">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
            <path fill-rule="evenodd" d="M4 4a2 2 0 012-2h4.586A2 2 0 0112 2.586L15.414 6A2 2 0 0116 7.414V16a2 2 0 01-2 2H6a2 2 0 01-2-2V4z" clip-rule="evenodd" />
        </svg>
        Click here to complete your KYC
    </button>
</a>
                                </div>
                            </div>
                        </div>
            <div class="mx-auto text-blue-900 max-w-6xl">
                
                <div class="grid gap-6 xs:grid-cols-1 md:grid-cols-3">
                    <!-- Left Column -->
                    <div class="xs:col-span-1 md:col-span-2">
                        <div class="bg-blue-50 p-6 rounded-lg card-shadow mb-6">
                            <h2 class="text-2xl font-bold text-blue-800 mb-4">Why Verification Matters</h2>
                            <p class="text-lg leading-relaxed">
                                To ensure the security of our platform and comply with international regulations, all participants must complete identity verification (KYC/AML). This helps prevent fraud, money laundering, and other prohibited activities.
                            </p>
                            <p class="text-lg leading-relaxed mt-4">
                                Our verification process is <span class="font-bold text-blue-700">fast, secure, and straightforward</span> - typically taking less than 5 minutes to complete.
                            </p>
                        </div>
                        
                    </div>

                    <!-- Right Column -->
                    <div class="bg-blue-50 rounded-lg p-6 card-shadow">
                        <h4 class="mb-4 text-xl font-bold text-blue-800 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                            </svg>
                            Verification Levels
                        </h4>
                        <ul class="space-y-4">
                            <li>
                                <div class="bg-white rounded-lg p-5 card-shadow">
                                    <div class="flex items-center justify-between">
                                        <h3 class="font-bold text-blue-800">1. Verified</h3>
                                        <span class="bg-blue-100 text-blue-600 px-3 py-1 rounded-full text-sm">Basic</span>
                                    </div>
                                    <p class="mt-2 text-blue-700">Basic account access and limited trading capabilities</p>
                                </div>
                            </li>
                            <li>
                                <div class="bg-white rounded-lg p-5 card-shadow">
                                    <div class="flex items-center justify-between">
                                        <h3 class="font-bold text-blue-800">2. Verified Plus</h3>
                                        <span class="bg-blue-100 text-blue-600 px-3 py-1 rounded-full text-sm">Standard</span>
                                    </div>
                                    <p class="mt-2 text-blue-700">Enhanced trading limits and additional features</p>
                                </div>
                            </li>
                            <li>
                                <div class="bg-white rounded-lg p-5 card-shadow">
                                    <div class="flex items-center justify-between">
                                        <h3 class="font-bold text-blue-800">3. Verified Pro</h3>
                                        <span class="bg-blue-100 text-blue-600 px-3 py-1 rounded-full text-sm">Premium</span>
                                    </div>
                                    <p class="mt-2 text-blue-700">Maximum limits and access to all platform features</p>
                                </div>
                            </li>
                        </ul>
                        <div class="mt-6 bg-blue-100 rounded-lg p-4 border-l-4 border-blue-500">
                            <p class="text-blue-700 font-medium">Completing verification is a one-time process that ensures long-term access to our platform.</p>
                        </div>
                        
               </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // JavaScript for handling dark mode toggle
        const toggleDarkMode = () => {
            document.documentElement.classList.toggle('dark');
            localStorage.setItem('darkMode', document.documentElement.classList.contains('dark'));
            
            // Update button text
            const darkModeButton = document.getElementById('darkModeToggle');
            if (document.documentElement.classList.contains('dark')) {
                darkModeButton.textContent = 'Switch to Light Mode';
                document.body.style.background = 'linear-gradient(135deg, #1E3A8A, #1E40AF)';
            } else {
                darkModeButton.textContent = 'Switch to Dark Mode';
                document.body.style.background = 'linear-gradient(135deg, #EFF6FF, #DBEAFE)';
            }
        };

        // Check for dark mode preference
        if (localStorage.getItem('darkMode') === 'true') {
            document.documentElement.classList.add('dark');
            document.body.style.background = 'linear-gradient(135deg, #1E3A8A, #1E40AF)';
        }

        // Add a button to toggle dark mode
        const darkModeButton = document.createElement('button');
        darkModeButton.id = 'darkModeToggle';
        darkModeButton.textContent = document.documentElement.classList.contains('dark') ? 'Switch to Light Mode' : 'Switch to Dark Mode';
        darkModeButton.className = 'fixed bottom-4 right-4 p-3 bg-blue-600 hover:bg-blue-700 text-white rounded-lg shadow-lg transition-all duration-300';
        darkModeButton.onclick = toggleDarkMode;
        document.body.appendChild(darkModeButton);
    </script>
    
    
     <?php include './includes/footer.php'; ?>

</body>
</html>